﻿
/* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/
import { SuperMap } from '../../SuperMap';
/**
 * Namespace: SuperMap.Lang["en"]
 * Dictionary for English.  Keys for entries are used in calls to
 *     <SuperMap.Lang.translate>.  Entry bodies are normal strings or
 *     strings formatted for use with <SuperMap.String.format> calls.
 */
let en = {
    'title_dataFlowService': 'Data Flow Service',
    'title_distributedAnalysis': 'Distributed Analysis',
    'title_clientComputing': 'Client Computing',
    'title_dataServiceQuery': 'Data Service Query',
    'title_searchCity':'Search city',
    'title_searchLayer':' Search layer',

    'text_input_value_inputDataFlowUrl': 'Please enter the data stream service address such as: ws://{serviceRoot}/{dataFlowName}/dataflow/subscribe',
    'text_displayFeaturesInfo': 'Display feature information',
    'text_subscribe': 'subscribe',
    'text_cancelSubscribe': 'unsubscribe',

    'text_densityAnalysis': 'Density Analysis',
    'text_CalculateTheValuePerUnitArea': 'Calculate the value per unit area within the neighborhood shape',
    'text_option_selectDataset':'Please select a dataset',
    'text_label_dataset': 'Dataset',
    'text_option_simplePointDensityAnalysis': 'Simple point density analysis',
    'text_option_nuclearDensityAnalysis': 'Nuclear density analysis',
    'text_label_analyticalMethod': 'Analytical method',
    'text_option_quadrilateral': 'Quadrilateral',
    'text_option_hexagon': 'hexagon',
    'text_label_meshType': 'Mesh type',
    'text_option_notSet': 'Not set',
    'text_label_weightField': 'Weight field',
    'text_label_gridSizeInMeters': 'Grid size',
    'text_label_searchRadius': 'Search radius',
    'text_label_queryRange': 'Scope of analysis',
    'text_label_areaUnit': 'Area unit',
    'text_option_equidistantSegmentation': 'Equidistant segmentation',
    'text_option_logarithm': 'Logarithm',
    'text_option_equalCountingSegment': 'Equal counting segment',
    'text_option_squareRootSegmentation': 'Square root segmentation',
    'text_label_thematicMapSegmentationMode': 'Thematic map segmentation mode',
    'text_label_thematicMapSegmentationParameters': 'Thematic map segmentation parameters',
    'text_option_greenOrangePurpleGradient': 'Green orange purple gradient',
    'text_option_greenOrangeRedGradient': 'Green orange red gradient',
    'text_option_rainbowGradient': 'Rainbow gradient',
    'text_option_spectralGradient': 'Spectral gradient',
    'text_option_terrainGradient': 'Terrain gradient',
    'text_label_thematicMapColorGradientMode': 'Thematic map color gradient mode',
    'text_label_resultLayerName': 'Result layer name',
    'text_chooseFile': 'Open File',
    'text_isoline': 'Isoline',
    'text_extractDiscreteValue': 'Extract discrete value generation curve',
    'text_buffer': 'Buffer',
    'text_specifyTheDistance': 'Specify the distance to create the surrounding area',
    'text_label_analysisLayer': 'Analysis layer',
    'text_label_extractField': 'Extract field',
    'text_label_extractedValue': 'Extracted value',
    'text_label_distanceAttenuation': 'Distance attenuation',
    'text_label_gridSize': 'gridSize',
    'text_label_bufferRadius': 'Buffer radius',
    'text_label_defaultkilometers': 'Default 10 kilometers',
    'text_label_kilometer': 'kilometer',
    'text_label_unit': 'unit',
    'text_retainOriginal': 'Retain original object field',
    'text_mergeBuffer': 'Merge buffer',
    'text_label_color': 'Color',
    'text_label_buffer': '[Buffer]',
    'text_label_isolines': '[Isolines]',
    'text_label_queryRangeTips': 'The default is the full range of input data. Example: -74.050, 40.650, -73.850, 40.850',
    'text_label_queryModel': 'Query mode',
    'text_label_IDArrayOfFeatures': 'ID array of features',
    'text_label_maxFeatures': 'The maximum number of features that can be returned',
    'text_label_bufferDistance': 'Buffer distance',
    'text_label_queryRange1': 'Query range',
    'text_label_spatialQueryMode': 'Spatial query mode',
    'text_label_featureFilter': 'Feature filter',
    'text_label_geometricObject': 'Geometric object',
    'text_label_queryMode': 'Query mode',
    'text_label_searchTips': 'Search for city locations or layer features',
    'text_label_chooseSearchLayers': 'Select a query layer',
    'text_loadSearchCriteria': 'Load search criteria',
    'text_saveSearchCriteria': 'Save search criteria',

    "btn_analyze": "Analyze",
    "btn_analyzing": "Analyzing",
    "btn_emptyTheAnalysisLayer": "Empty the analysis layer",
    "btn_cancelAnalysis": "Cancel",
    "btn_query": "Query",
    "btn_querying": "Querying",
    "btn_emptyTheRresultLayer": "Clear all result layers",

    'msg_dataReturnedIsEmpty.': 'The request is successful and the data returned by the query is empty.',
    'msg_dataFlowServiceHasBeenSubscribed': 'The data stream service has been subscribed to.',
    'msg_inputDataFlowUrlFirst': 'Please enter the data stream service address first.',
    'msg_datasetOrMethodUnsupport': 'This dataset does not support this analysis type. Please reselect the dataset.',
    'msg_selectDataset': 'Please select a data set!',
    'msg_setTheWeightField': 'Please set the weight field!',
    'msg_theFieldNotSupportAnalysis': 'The field you currently select does not support analysis!',
    'msg_resultIsEmpty': 'The result of the analysis is empty!',
    'msg_openFileFail': 'Failed to open file!',
    'msg_fileTypeUnsupported': 'File format is not supported!',
    'msg_fileSizeExceeded': 'File size exceeded! The file size should not exceed 10M!',
    'msg_dataInWrongGeoJSONFormat': 'Wrong data format! Non standard GEOJSON format data!',
    'msg_dataInWrongFormat': 'Wrong data format! Non standard EXCEL, CSV or GEOJSON format data!',
    'msg_searchKeywords': "Search keywords cannot be empty. Please enter your search criteria.",
    'msg_searchGeocodeField':"Did not match the address matching service data!",
    'msg_cityGeocodeField':"The address matching service of the current city is not configured.",
    'msg_getFeatureField':"No related vector features found!",
    'msg_dataflowservicesubscribed':'The data stream service has been subscribed to.',
    'msg_subscribesucceeded':'The data stream service subscription was successful.',
    'msg_crsunsupport':'Does not support the coordinate system of the current map',
    'msg_tilematrixsetunsupport':'Incoming TileMatrixSet is not supported',
    'msg_jsonResolveFiled': 'JSON format parsing failure！',
    'msg_requestContentFiled': 'Failed to request data through iportal!',
    'msg_getdatafailed': 'Failed to get data!'

};
export { en };
SuperMap.Lang['en-US'] = en;
