/* Copyright© 2000 - 2019 SuperMap Software Co.Ltd. All rights reserved.
 * This program are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at http://www.apache.org/licenses/LICENSE-2.0.html.*/
import {SuperMap} from './SuperMap';
import {
    DataFormat,
    ServerType,
    GeometryType,
    QueryOption,
    JoinType,
    EngineType,
    MeasureMode,
    SpatialRelationType,
    DataReturnMode,
    Unit,
    BufferRadiusUnit,
    SpatialQueryMode,
    ThemeGraphTextFormat,
    ThemeGraphType,
    GraphAxesTextDisplayMode,
    GraduatedMode,
    RangeMode,
    ThemeType,
    ColorGradientType,
    TextAlignment,
    FillGradientMode,
    SideType,
    AlongLineDirection,
    LabelBackShape,
    LabelOverLengthMode,
    DirectionType,
    OverlayOperationType,
    SupplyCenterType,
    TurnType,
    BufferEndType,
    SmoothMethod,
    SurfaceAnalystMethod,
    ColorSpaceType,
    ChartType,
    EditType,
    TransferTactic,
    TransferPreference,
    GridType,
    ClientType,
    LayerType,
    UGCLayerType,
    StatisticMode,
    PixelFormat,
    SearchMode,
    SummaryType,
    InterpolationAlgorithmType,
    VariogramMode,
    Exponent,
    ClipAnalystMode,
    AnalystAreaUnit,
    AnalystSizeUnit,
    StatisticAnalystMode,
    TopologyValidatorRule,
    OutputType,
    AggregationQueryBuilderType,
    AggregationType,
    GetFeatureMode
} from './REST';
import {
    Collection,
    Curve,
    GeoText,
    LinearRing,
    LineString,
    MultiLineString,
    MultiPoint,
    MultiPolygon,
    GeometryPoint,
    Polygon,
    Rectangle,
    StringExt,
    NumberExt,
    FunctionExt,
    ArrayExt,
    Bounds,
    Credential,
    DateExt,
    Event,
    Events,
    Feature,
    Geometry,
    LonLat,
    Pixel,
    Size,
    CommonUtil,
    GeometryVector
} from './commontypes';
import {
    Format,
    GeoJSON,
    JSONFormat,
    WKT
} from './format';

import {
    TimeControlBase,
    TimeFlowControl
} from './control';
import {
    IManager,
    IManagerCreateNodeParam,
    IManagerServiceBase
} from './iManager';
import {
    IPortal,
    IPortalMap,
    IPortalMapsQueryParam,
    IPortalService,
    IPortalServiceBase,
    IPortalServicesQueryParam
} from './iPortal';
import {
    AddressMatchService,
    AggregationParameter,
    AggQueryBuilderParameter,
    AreaSolarRadiationParameters,
    AreaSolarRadiationService,
    BufferAnalystParameters,
    BufferAnalystService,
    BufferDistance,
    BufferSetting,
    BuffersAnalystJobsParameter,
    BuffersAnalystJobsService,
    BurstPipelineAnalystParameters,
    BurstPipelineAnalystService,
    ChartFeatureInfoSpecsService,
    ChartQueryFilterParameter,
    ChartQueryParameters,
    ChartQueryService,
    ClipParameter,
    ColorDictionary,
    CommonServiceBase,
    ComputeWeightMatrixParameters,
    ComputeWeightMatrixService,
    DataFlowService,
    DataReturnOption,
    DatasetBufferAnalystParameters,
    DatasetInfo,
    DatasetOverlayAnalystParameters,
    DatasetSurfaceAnalystParameters,
    DatasetThiessenAnalystParameters,
    DatasourceConnectionInfo,
    DensityAnalystService,
    DensityKernelAnalystParameters,
    EditFeaturesParameters,
    EditFeaturesService,
    FacilityAnalyst3DParameters,
    FacilityAnalystSinks3DParameters,
    FacilityAnalystSinks3DService,
    FacilityAnalystSources3DParameters,
    FacilityAnalystSources3DService,
    FacilityAnalystStreamParameters,
    FacilityAnalystStreamService,
    FacilityAnalystTracedown3DParameters,
    FacilityAnalystTracedown3DService,
    FacilityAnalystTraceup3DParameters,
    FacilityAnalystTraceup3DService,
    FacilityAnalystUpstream3DParameters,
    FacilityAnalystUpstream3DService,
    FieldParameters,
    FieldStatisticService,
    FieldStatisticsParameters,
    FilterAggParameter,
    FilterParameter,
    FindClosestFacilitiesParameters,
    FindClosestFacilitiesService,
    FindLocationParameters,
    FindLocationService,
    FindMTSPPathsParameters,
    FindMTSPPathsService,
    FindPathParameters,
    FindPathService,
    FindServiceAreasParameters,
    FindServiceAreasService,
    FindTSPPathsParameters,
    FindTSPPathsService,
    GenerateSpatialDataParameters,
    GenerateSpatialDataService,
    GeoBoundingBoxQueryBuilderParameter,
    GeoCodingParameter,
    GeoDecodingParameter,
    GeoHashGridAggParameter,
    GeometryBufferAnalystParameters,
    GeometryOverlayAnalystParameters,
    GeometrySurfaceAnalystParameters,
    GeometryThiessenAnalystParameters,
    GeoRelationAnalystParameters,
    GeoRelationAnalystService,
    GetFeaturesByBoundsParameters,
    GetFeaturesByBoundsService,
    GetFeaturesByBufferParameters,
    GetFeaturesByBufferService,
    GetFeaturesByGeometryParameters,
    GetFeaturesByGeometryService,
    GetFeaturesByIDsParameters,
    GetFeaturesByIDsService,
    GetFeaturesBySQLParameters,
    GetFeaturesBySQLService,
    GetFeaturesParametersBase,
    GetFeaturesServiceBase,
    GetFieldsService,
    GetGridCellInfosParameters,
    GetGridCellInfosService,
    GetLayersInfoService,
    Grid,
    UGCImage,
    InterpolationAnalystParameters,
    InterpolationAnalystService,
    InterpolationIDWAnalystParameters,
    InterpolationKrigingAnalystParameters,
    InterpolationRBFAnalystParameters,
    JoinItem,
    KernelDensityJobParameter,
    KernelDensityJobsService,
    LabelImageCell,
    LabelMatrixCell,
    LabelMixedTextStyle,
    LabelSymbolCell,
    LabelThemeCell,
    LayerStatus,
    LinkItem,
    MapService,
    MathExpressionAnalysisParameters,
    MathExpressionAnalysisService,
    MeasureParameters,
    MeasureService,
    NetworkAnalystServiceBase,
    OutputSetting,
    MappingParameters,
    OverlapDisplayedOptions,
    OverlayAnalystParameters,
    OverlayAnalystService,
    OverlayGeoJobParameter,
    OverlayGeoJobsService,
    PointWithMeasure,
    ProcessingServiceBase,
    QueryByBoundsParameters,
    QueryByBoundsService,
    QueryByDistanceParameters,
    QueryByDistanceService,
    QueryByGeometryParameters,
    QueryByGeometryService,
    QueryBySQLParameters,
    QueryBySQLService,
    QueryParameters,
    QueryService,
    Route,
    RouteCalculateMeasureParameters,
    RouteCalculateMeasureService,
    RouteLocatorParameters,
    RouteLocatorService,
    ServerColor,
    ServerFeature,
    ServerGeometry,
    ServerStyle,
    ServerTextStyle,
    ServerTheme,
    SetLayerInfoParameters,
    SetLayerInfoService,
    SetLayersInfoParameters,
    SetLayersInfoService,
    SetLayerStatusParameters,
    SetLayerStatusService,
    SingleObjectQueryJobsParameter,
    SingleObjectQueryJobsService,
    SpatialAnalystBase,
    StopQueryParameters,
    StopQueryService,
    SummaryAttributesJobsParameter,
    SummaryAttributesJobsService,
    SummaryMeshJobParameter,
    SummaryMeshJobsService,
    SummaryRegionJobParameter,
    SummaryRegionJobsService,
    SupplyCenter,
    SurfaceAnalystParameters,
    SurfaceAnalystParametersSetting,
    SurfaceAnalystService,
    TerrainCurvatureCalculationParameters,
    TerrainCurvatureCalculationService,
    Theme,
    ThemeDotDensity,
    ThemeFlow,
    ThemeGraduatedSymbol,
    ThemeGraduatedSymbolStyle,
    ThemeGraph,
    ThemeGraphAxes,
    ThemeGraphItem,
    ThemeGraphSize,
    ThemeGraphText,
    ThemeGridRange,
    ThemeGridRangeItem,
    ThemeGridUnique,
    ThemeGridUniqueItem,
    ThemeLabel,
    ThemeLabelAlongLine,
    ThemeLabelBackground,
    ThemeLabelItem,
    ThemeLabelText,
    ThemeLabelUniqueItem,
    ThemeMemoryData,
    ThemeOffset,
    ThemeParameters,
    ThemeRange,
    ThemeRangeItem,
    ThemeService,
    ThemeUnique,
    ThemeUniqueItem,
    ThiessenAnalystParameters,
    ThiessenAnalystService,
    GeometryBatchAnalystService,
    TilesetsService,
    TopologyValidatorJobsParameter,
    TopologyValidatorJobsService,
    TransferLine,
    TransferPathParameters,
    TransferPathService,
    TransferSolutionService,
    TransportationAnalystParameter,
    TransportationAnalystResultSetting,
    TransferSolutionParameters,
    UGCLayer,
    UGCMapLayer,
    UGCSubLayer,
    UpdateEdgeWeightParameters,
    UpdateEdgeWeightService,
    UpdateTurnNodeWeightParameters,
    UpdateTurnNodeWeightService,
    Vector,
    VectorClipJobsParameter,
    VectorClipJobsService
} from './iServer';
import {
    Online,
    OnlineData,
    OnlineQueryDatasParameter,
    ServiceStatus,
    DataItemType,
    DataItemOrderBy,
    FilterField,
    OnlineServiceBase
} from './online';
import {
    KeyServiceParameter,
    SecurityManager,
    ServerInfo,
    TokenServiceParameter
} from './security';
import {
    ElasticSearch
} from './thirdparty';
import {
    setCORS,
    isCORS,
    setRequestTimeout,
    getRequestTimeout,
    FetchRequest,
    ColorsPickerUtil,
    ArrayStatistic
} from './util';
import {
    CartoCSS,
    ThemeStyle
} from './style';
import {
    Bar,
    Bar3D,
    Circle,
    Graph,
    Line,
    Pie,
    OverlayPoint,
    RankSymbol,
    Ring,
    ThemeVector,
    ShapeFactory,
    ShapeParameters,
    FeatureCircle,
    Image,
    Label,
    FeatureLine,
    Point,
    FeaturePolygon,
    FeatureRectangle,
    Sector,
    FeatureTheme,
    LevelRenderer,
    Render,
    Animation, Animator,
    Area,
    Clip,
    Color,
    ComputeBoundingBox,
    Config,
    LevelRendererCurve,
    Easing,
    Env,
    LevelRendererEvent,
    Eventful,
    Group,
    Handler,
    Http,
    Log,
    Math,
    Matrix,
    Painter, PaintLayer,
    Shape,
    SmicBrokenLine,
    SmicCircle,
    SmicEllipse,
    SmicImage,
    SmicIsogon,
    SmicPoint,
    SmicPolygon,
    SmicRectangle,
    SmicRing,
    SmicSector,
    SmicStar,
    SmicText,
    Storage,
    Transformable,
    Util,
    LevelRendererVector,
    SUtil

} from './overlay';
import {
    FileTypes,
    FileConfig,
    FileModel, 
    MessageBox,
    CommonContainer,
    DropDownBox,
    Select,
    AttributesPopContainer,
    PopContainer,
    IndexTabsPageContainer,
    CityTabsPage,
    NavTabsPage,
    PaginationContainer,
    widgetsUtil,
    FileReaderUtil,
    ChartView,
    ChartViewModel
} from './widgets';
import {
    Lang,
    en,
    zh
} from './lang';

export {
    FileTypes,
    FileConfig,
    FileModel,
    MessageBox,
    CommonContainer,
    DropDownBox,
    Select,
    AttributesPopContainer,
    PopContainer,
    IndexTabsPageContainer,
    CityTabsPage,
    NavTabsPage,
    PaginationContainer,
    widgetsUtil,
    FileReaderUtil,
    ChartView,
    ChartViewModel
}
export {SuperMap};
export {
    DataFormat,
    ServerType,
    GeometryType,
    QueryOption,
    JoinType,
    EngineType,
    MeasureMode,
    SpatialRelationType,
    DataReturnMode,
    Unit,
    BufferRadiusUnit,
    SpatialQueryMode,
    ThemeGraphTextFormat,
    ThemeGraphType,
    GraphAxesTextDisplayMode,
    GraduatedMode,
    RangeMode,
    ThemeType,
    ColorGradientType,
    TextAlignment,
    FillGradientMode,
    SideType,
    AlongLineDirection,
    LabelBackShape,
    LabelOverLengthMode,
    DirectionType,
    OverlayOperationType,
    SupplyCenterType,
    TurnType,
    BufferEndType,
    SmoothMethod,
    SurfaceAnalystMethod,
    ColorSpaceType,
    ChartType,
    EditType,
    TransferTactic,
    TransferPreference,
    GridType,
    ClientType,
    LayerType,
    UGCLayerType,
    StatisticMode,
    PixelFormat,
    SearchMode,
    SummaryType,
    InterpolationAlgorithmType,
    VariogramMode,
    Exponent,
    ClipAnalystMode,
    AnalystAreaUnit,
    AnalystSizeUnit,
    StatisticAnalystMode,
    TopologyValidatorRule,
    OutputType,
    AggregationQueryBuilderType,
    AggregationType,
    GetFeatureMode
};
export {
    Collection,
    Curve,
    GeoText,
    LinearRing,
    LineString,
    MultiLineString,
    MultiPoint,
    MultiPolygon,
    GeometryPoint,
    Polygon,
    Rectangle,
    StringExt,
    NumberExt,
    FunctionExt,
    ArrayExt,
    Bounds,
    Credential,
    DateExt,
    Event,
    Events,
    Feature,
    Geometry,
    LonLat,
    Pixel,
    Size,
    CommonUtil,
    GeometryVector
};
export {
    TimeControlBase,
    TimeFlowControl
};
export {
    Format,
    GeoJSON,
    JSONFormat,
    WKT
};
export {
    setCORS,
    isCORS,
    setRequestTimeout,
    getRequestTimeout,
    FetchRequest,
    ColorsPickerUtil,
    ArrayStatistic
};
export {
    IManager,
    IManagerCreateNodeParam,
    IManagerServiceBase
};
export {
    IPortal,
    IPortalMap,
    IPortalMapsQueryParam,
    IPortalService,
    IPortalServiceBase,
    IPortalServicesQueryParam
};
export {
    AddressMatchService,
    AggregationParameter,
    AggQueryBuilderParameter,
    AreaSolarRadiationParameters,
    AreaSolarRadiationService,
    BufferAnalystParameters,
    BufferAnalystService,
    BufferDistance,
    BufferSetting,
    BuffersAnalystJobsParameter,
    BuffersAnalystJobsService,
    BurstPipelineAnalystParameters,
    BurstPipelineAnalystService,
    ChartFeatureInfoSpecsService,
    ChartQueryFilterParameter,
    ChartQueryParameters,
    ChartQueryService,
    ClipParameter,
    ColorDictionary,
    CommonServiceBase,
    ComputeWeightMatrixParameters,
    ComputeWeightMatrixService,
    DataFlowService,
    DataReturnOption,
    DatasetBufferAnalystParameters,
    DatasetInfo,
    DatasetOverlayAnalystParameters,
    DatasetSurfaceAnalystParameters,
    DatasetThiessenAnalystParameters,
    DatasourceConnectionInfo,
    DensityAnalystService,
    DensityKernelAnalystParameters,
    EditFeaturesParameters,
    EditFeaturesService,
    FacilityAnalyst3DParameters,
    FacilityAnalystSinks3DParameters,
    FacilityAnalystSinks3DService,
    FacilityAnalystSources3DParameters,
    FacilityAnalystSources3DService,
    FacilityAnalystStreamParameters,
    FacilityAnalystStreamService,
    FacilityAnalystTracedown3DParameters,
    FacilityAnalystTracedown3DService,
    FacilityAnalystTraceup3DParameters,
    FacilityAnalystTraceup3DService,
    FacilityAnalystUpstream3DParameters,
    FacilityAnalystUpstream3DService,
    FieldParameters,
    FieldStatisticService,
    FieldStatisticsParameters,
    FilterAggParameter,
    FilterParameter,
    FindClosestFacilitiesParameters,
    FindClosestFacilitiesService,
    FindLocationParameters,
    FindLocationService,
    FindMTSPPathsParameters,
    FindMTSPPathsService,
    FindPathParameters,
    FindPathService,
    FindServiceAreasParameters,
    FindServiceAreasService,
    FindTSPPathsParameters,
    FindTSPPathsService,
    GenerateSpatialDataParameters,
    GenerateSpatialDataService,
    GeoBoundingBoxQueryBuilderParameter,
    GeoCodingParameter,
    GeoDecodingParameter,
    GeoHashGridAggParameter,
    GeometryBufferAnalystParameters,
    GeometryOverlayAnalystParameters,
    GeometrySurfaceAnalystParameters,
    GeometryThiessenAnalystParameters,
    GeoRelationAnalystParameters,
    GeoRelationAnalystService,
    GetFeaturesByBoundsParameters,
    GetFeaturesByBoundsService,
    GetFeaturesByBufferParameters,
    GetFeaturesByBufferService,
    GetFeaturesByGeometryParameters,
    GetFeaturesByGeometryService,
    GetFeaturesByIDsParameters,
    GetFeaturesByIDsService,
    GetFeaturesBySQLParameters,
    GetFeaturesBySQLService,
    GetFeaturesParametersBase,
    GetFeaturesServiceBase,
    GetFieldsService,
    GetGridCellInfosParameters,
    GetGridCellInfosService,
    GetLayersInfoService,
    Grid,
    UGCImage,
    InterpolationAnalystParameters,
    InterpolationAnalystService,
    InterpolationIDWAnalystParameters,
    InterpolationKrigingAnalystParameters,
    InterpolationRBFAnalystParameters,
    JoinItem,
    KernelDensityJobParameter,
    KernelDensityJobsService,
    LabelImageCell,
    LabelMatrixCell,
    LabelMixedTextStyle,
    LabelSymbolCell,
    LabelThemeCell,
    LayerStatus,
    LinkItem,
    MapService,
    MathExpressionAnalysisParameters,
    MathExpressionAnalysisService,
    MeasureParameters,
    MeasureService,
    NetworkAnalystServiceBase,
    OutputSetting,
    MappingParameters,
    OverlapDisplayedOptions,
    OverlayAnalystParameters,
    OverlayAnalystService,
    OverlayGeoJobParameter,
    OverlayGeoJobsService,
    PointWithMeasure,
    ProcessingServiceBase,
    QueryByBoundsParameters,
    QueryByBoundsService,
    QueryByDistanceParameters,
    QueryByDistanceService,
    QueryByGeometryParameters,
    QueryByGeometryService,
    QueryBySQLParameters,
    QueryBySQLService,
    QueryParameters,
    QueryService,
    Route,
    RouteCalculateMeasureParameters,
    RouteCalculateMeasureService,
    RouteLocatorParameters,
    RouteLocatorService,
    ServerColor,
    ServerFeature,
    ServerGeometry,
    ServerStyle,
    ServerTextStyle,
    ServerTheme,
    SetLayerInfoParameters,
    SetLayerInfoService,
    SetLayersInfoParameters,
    SetLayersInfoService,
    SetLayerStatusParameters,
    SetLayerStatusService,
    SingleObjectQueryJobsParameter,
    SingleObjectQueryJobsService,
    SpatialAnalystBase,
    StopQueryParameters,
    StopQueryService,
    SummaryAttributesJobsParameter,
    SummaryAttributesJobsService,
    SummaryMeshJobParameter,
    SummaryMeshJobsService,
    SummaryRegionJobParameter,
    SummaryRegionJobsService,
    SupplyCenter,
    SurfaceAnalystParameters,
    SurfaceAnalystParametersSetting,
    SurfaceAnalystService,
    TerrainCurvatureCalculationParameters,
    TerrainCurvatureCalculationService,
    Theme,
    ThemeDotDensity,
    ThemeFlow,
    ThemeGraduatedSymbol,
    ThemeGraduatedSymbolStyle,
    ThemeGraph,
    ThemeGraphAxes,
    ThemeGraphItem,
    ThemeGraphSize,
    ThemeGraphText,
    ThemeGridRange,
    ThemeGridRangeItem,
    ThemeGridUnique,
    ThemeGridUniqueItem,
    ThemeLabel,
    ThemeLabelAlongLine,
    ThemeLabelBackground,
    ThemeLabelItem,
    ThemeLabelText,
    ThemeLabelUniqueItem,
    ThemeMemoryData,
    ThemeOffset,
    ThemeParameters,
    ThemeRange,
    ThemeRangeItem,
    ThemeService,
    ThemeUnique,
    ThemeUniqueItem,
    ThiessenAnalystParameters,
    ThiessenAnalystService,
    GeometryBatchAnalystService,
    TilesetsService,
    TopologyValidatorJobsParameter,
    TopologyValidatorJobsService,
    TransferLine,
    TransferPathParameters,
    TransferPathService,
    TransferSolutionService,
    TransportationAnalystParameter,
    TransportationAnalystResultSetting,
    TransferSolutionParameters,
    UGCLayer,
    UGCMapLayer,
    UGCSubLayer,
    UpdateEdgeWeightParameters,
    UpdateEdgeWeightService,
    UpdateTurnNodeWeightParameters,
    UpdateTurnNodeWeightService,
    Vector,
    VectorClipJobsParameter,
    VectorClipJobsService
};
export {
    Online,
    OnlineData,
    OnlineQueryDatasParameter,
    ServiceStatus,
    DataItemType,
    DataItemOrderBy,
    FilterField,
    OnlineServiceBase
};
export {
    Bar,
    Bar3D,
    Circle,
    Graph,
    Line,
    Pie,
    OverlayPoint,
    RankSymbol,
    Ring,
    ThemeVector,
    ShapeFactory,
    ShapeParameters,
    FeatureCircle,
    Image,
    Label,
    FeatureLine,
    Point,
    FeaturePolygon,
    FeatureRectangle,
    Sector,
    FeatureTheme,
    LevelRenderer,
    Render,
    Animation, Animator,
    Area,
    Clip,
    Color,
    ComputeBoundingBox,
    Config,
    LevelRendererCurve,
    Easing,
    Env,
    LevelRendererEvent,
    Eventful,
    Group,
    Handler,
    Http,
    Log,
    Math,
    Matrix,
    Painter, PaintLayer,
    Shape,
    SmicBrokenLine,
    SmicCircle,
    SmicEllipse,
    SmicImage,
    SmicIsogon,
    SmicPoint,
    SmicPolygon,
    SmicRectangle,
    SmicRing,
    SmicSector,
    SmicStar,
    SmicText,
    Storage,
    Transformable,
    Util,
    LevelRendererVector,
    SUtil
};
export {
    KeyServiceParameter,
    SecurityManager,
    ServerInfo,
    TokenServiceParameter
};
export {
    CartoCSS,
    ThemeStyle
};
export {
    ElasticSearch
};
export {
    Lang,
    en,
    zh
}