/*
 * Decompiled with CFR 0.152.
 */
package com.supermap;

import android.os.Environment;
import android.webkit.WebView;
import com.supermap.DatabaseConfig;
import com.supermap.GetImgThread;
import com.supermap.RequestControl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.cordova.api.CallbackContext;
import org.apache.cordova.api.CordovaPlugin;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LocalStoragePlugin
extends CordovaPlugin {
    public boolean execute(String action, JSONArray data, CallbackContext callbackContext) {
        Object result = null;
        if ("getImg".equals(action)) {
            try {
                String fileurl = data.getString(0);
                String strLayer = data.getString(1);
                String x = data.getString(2);
                String y = data.getString(3);
                String z = data.getString(4);
                String methodName = data.getString(5);
                JSONObject fileInfo = this.getImg(fileurl, strLayer, x, y, z, methodName);
                callbackContext.success(fileInfo);
                return true;
            }
            catch (JSONException jsonEx) {
                callbackContext.error("error on LocalStoragePlugin.getImg");
                return false;
            }
        }
        if ("saveurl".equals(action)) {
            try {
                String fileurl = data.getString(0);
                String strLayer = data.getString(1);
                String x = data.getString(2);
                String y = data.getString(3);
                String z = data.getString(4);
                String methodName = data.getString(5);
                JSONObject fileInfo = this.saveurl(fileurl, strLayer, x, y, z, methodName);
                callbackContext.success(fileInfo);
                return true;
            }
            catch (JSONException jsonEx) {
                callbackContext.error("error on LocalStoragePlugin.saveurl");
                return false;
            }
        }
        if ("savedb".equals(action)) {
            try {
                String fileurl = data.getString(0);
                String strLayer = data.getString(1);
                String x = data.getString(2);
                String y = data.getString(3);
                String z = data.getString(4);
                String methodName = data.getString(5);
                JSONObject fileInfo = this.savedb(fileurl, strLayer, x, y, z, methodName);
                callbackContext.success(fileInfo);
                return true;
            }
            catch (JSONException jsonEx) {
                callbackContext.error("error on LocalStoragePlugin.savedb");
                return false;
            }
        }
        if ("isexist".equals(action)) {
            try {
                String strLayer = data.getString(0);
                String x = data.getString(1);
                String y = data.getString(2);
                String z = data.getString(3);
                JSONObject fileInfo = new JSONObject();
                fileInfo.put("filename", (Object)this.isFileExist(strLayer, x, y, z));
                callbackContext.success(fileInfo);
                return true;
            }
            catch (JSONException jsonEx) {
                callbackContext.error("error on LocalStoragePlugin.isexist");
                return false;
            }
        }
        if ("getsdcard".equals(action)) {
            try {
                JSONObject fileInfo = new JSONObject();
                fileInfo.put("sdcard", (Object)this.getSDCARDPath());
                callbackContext.success(fileInfo);
                return true;
            }
            catch (JSONException jsonEx) {
                callbackContext.error("error on LocalStoragePlugin.getsdcard");
                return false;
            }
        }
        if ("savaconfig".equals(action)) {
            try {
                JSONObject fileInfo = new JSONObject();
                String strLayer = data.getString(0);
                String strResult = data.getString(1);
                fileInfo.put("json", (Object)this.saveConfig(strLayer, strResult));
                callbackContext.success(fileInfo);
                return true;
            }
            catch (JSONException jsonEx) {
                callbackContext.error("error on LocalStoragePlugin.savaconfig");
                return false;
            }
        }
        if ("getconfig".equals(action)) {
            try {
                JSONObject fileInfo = new JSONObject();
                String strLayer = data.getString(0);
                String storageType = data.getString(1);
                fileInfo.put("json", (Object)this.getConfig(strLayer, storageType));
                callbackContext.success(fileInfo);
                return true;
            }
            catch (JSONException jsonEx) {
                callbackContext.error("error on LocalStoragePlugin.getconfig");
                return false;
            }
        }
        callbackContext.error("Invalid action:" + action);
        return false;
    }

    private JSONObject saveurl(String fileurl, String strLayerName, String x, String y, String z, String methodName) {
        return new JSONObject();
    }

    private JSONObject savedb(String fileurl, String strLayerName, String x, String y, String z, String methodName) {
        return new JSONObject();
    }

    private JSONObject getImg(String fileurl, String strLayerName, String x, String y, String z, String methodName) {
        GetImgThread t = new GetImgThread(fileurl, strLayerName, x, y, z, methodName, (WebView)this.webView);
        ExecutorService pool = RequestControl.getPool();
        pool.execute(t);
        return new JSONObject();
    }

    public String isFileExist(String strLayerName, String x, String y, String z) {
        File SDCardRoot = Environment.getExternalStorageDirectory();
        String strDir = SDCardRoot.getAbsolutePath();
        String filename = String.valueOf(strDir = String.valueOf(strDir) + "/SuperMap/" + strLayerName + "/" + z) + "/" + x + "_" + y + ".png";
        File file3 = new File(filename);
        if (file3.exists()) {
            return "true";
        }
        return "false";
    }

    public String getSDCARDPath() {
        File SDCardRoot = Environment.getExternalStorageDirectory();
        String strDir = SDCardRoot.getAbsolutePath();
        return strDir;
    }

    public boolean isSynch(String action) {
        return action.equals("getsdcard") || action.equals("saveconfig") || action.equals("isexist") || action.equals("saveurl") || action.equals("savedb") || action.equals("getImg");
    }

    public String saveConfig(String strName, String strResult) {
        try {
            File SDCardRoot = Environment.getExternalStorageDirectory();
            String strDir = String.valueOf(SDCardRoot.getAbsolutePath()) + "/SuperMap";
            File dirFile = new File(strDir);
            if (!dirFile.exists()) {
                dirFile.mkdirs();
            }
            strDir = String.valueOf(SDCardRoot.getAbsolutePath()) + "/SuperMap/" + strName + ".config";
            File file = new File(strDir);
            FileOutputStream fos = null;
            if (!file.exists()) {
                file.createNewFile();
            }
            fos = new FileOutputStream(file);
            byte[] bytes = new byte[1024];
            bytes = strResult.getBytes();
            int b = strResult.length();
            fos.write(bytes, 0, b);
            fos.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return "ok";
    }

    public String getConfig(String fileName, String storageType) throws JSONException {
        String jsonString = "false";
        RequestControl.storageType = storageType;
        RequestControl.initdb(this.webView.getContext(), fileName, storageType);
        if (storageType.equals("db")) {
            try {
                jsonString = DatabaseConfig.getConfig(this.webView.getContext()).toString();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        } else {
            File file;
            BufferedReader reader = null;
            File SDCardRoot = Environment.getExternalStorageDirectory();
            String strDir = String.valueOf(SDCardRoot.getAbsolutePath()) + "/SuperMap";
            File dirFile = new File(strDir);
            if (!dirFile.exists()) {
                dirFile.mkdirs();
            }
            if (!(file = new File(strDir = String.valueOf(SDCardRoot.getAbsolutePath()) + "/SuperMap/" + fileName + ".config")).exists()) {
                reader = null;
            }
            try {
                reader = new BufferedReader(new FileReader(file));
                int line = 1;
                jsonString = "";
                String tempString = null;
                while ((tempString = reader.readLine()) != null) {
                    jsonString = String.valueOf(jsonString) + tempString;
                    ++line;
                }
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return jsonString;
    }
}

