/*
 * Decompiled with CFR 0.152.
 */
package com.supermap;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.supermap.DBOpenHelp;
import com.supermap.RequestControl;
import java.util.Arrays;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DatabaseConfig {
    public static JSONObject getConfig(Context ctx) throws JSONException {
        JSONObject config = new JSONObject();
        try {
            HashMap<String, Object> map = DatabaseConfig.queryConfig(ctx);
            config = DatabaseConfig.prepareConfig(map);
        }
        catch (Exception e) {
            System.out.println("there is a error in DatabaseConfig.getConfig :" + e.getMessage());
        }
        RequestControl.metaconfig = config;
        return config;
    }

    public static HashMap<String, Object> queryConfig(Context ctx) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            DBOpenHelp dbOpenHelper = new DBOpenHelp(ctx, String.valueOf(RequestControl.dir) + RequestControl.dbName);
            SQLiteDatabase db = dbOpenHelper.getWritableDatabase();
            String sql = "select name,value from metadata";
            Cursor cursor = db.rawQuery(sql, new String[0]);
            if (cursor.moveToFirst()) {
                do {
                    String name = cursor.getString(0);
                    String value = cursor.getString(1);
                    map.put(name, value);
                } while (cursor.moveToNext());
            }
            cursor.close();
            db.close();
            dbOpenHelper.close();
        }
        catch (Exception e) {
            System.out.println("there is a error in DatabaseConfig.getConfig :" + e.getMessage());
        }
        return map;
    }

    public static JSONObject prepareConfig(HashMap<String, Object> map) throws JSONException {
        JSONObject config = new JSONObject();
        JSONArray resolutions = DatabaseConfig.StringToArray((String)map.get("resolutions"));
        JSONArray scales = DatabaseConfig.StringToArray((String)map.get("scales"));
        int i = 0;
        while (i < scales.length()) {
            double temp = scales.getDouble(i);
            scales.put(i, 1.0 / temp);
            ++i;
        }
        String referResolution = resolutions.getString(0);
        String referScale = scales.getString(0);
        String crs_wkt = (String)map.get("crs_wkt");
        String unit = DatabaseConfig.comfirmUnit(crs_wkt);
        String dpi = DatabaseConfig.getDPI(referScale, referResolution, unit);
        JSONObject bounds = DatabaseConfig.getBounds((String)map.get("bounds"));
        String compatible = (String)map.get("compatible");
        config.put("scales", (Object)scales);
        config.put("dpi", (Object)dpi);
        config.put("unit", (Object)unit);
        config.put("bounds", (Object)bounds);
        config.put("resolutions", (Object)resolutions);
        config.put("compatible", (Object)compatible);
        return config;
    }

    private static String comfirmUnit(String unitStr) {
        String unit = "";
        if (unitStr.indexOf("METER") > 0) {
            unit = "meter";
        } else if (unitStr.indexOf("DEGREE") > 0) {
            unit = "degree";
        } else if (unitStr.indexOf("DECIMAL_DEGREE") > 0) {
            unit = "dd";
        } else if (unitStr.indexOf("CENTIMETER") > 0) {
            unit = "centimeter";
        } else if (unitStr.indexOf("DECIMETER") > 0) {
            unit = "decimeter";
        } else if (unitStr.indexOf("FOOT") > 0) {
            unit = "foot";
        } else if (unitStr.indexOf("INCH") > 0) {
            unit = "inch";
        } else if (unitStr.indexOf("KILOMETER") > 0) {
            unit = "kilometer";
        } else if (unitStr.indexOf("MILE") > 0) {
            unit = "mile";
        } else if (unitStr.indexOf("MILIMETER") > 0) {
            unit = "milimeter";
        } else if (unitStr.indexOf("MINUTE") > 0) {
            unit = "minute";
        } else if (unitStr.indexOf("RADIAN") > 0) {
            unit = "radian";
        } else if (unitStr.indexOf("SECOND") > 0) {
            unit = "second";
        } else if (unitStr.indexOf("YARD") > 0) {
            unit = "yard";
        }
        return unit;
    }

    public static JSONArray StringToArray(String str) throws JSONException {
        JSONArray arr = new JSONArray();
        String[] strs = str.split(",");
        int length = strs.length;
        double[] doubleArray = new double[length];
        int i = 0;
        while (i < length) {
            double b;
            doubleArray[i] = b = Double.parseDouble(strs[i]);
            ++i;
        }
        Arrays.sort(doubleArray);
        int j = length - 1;
        while (j >= 0) {
            arr.put(doubleArray[j]);
            --j;
        }
        return arr;
    }

    public static JSONObject getBounds(String str) throws JSONException {
        JSONObject bounds = new JSONObject();
        String[] strs = str.split(",");
        bounds.put("left", Double.parseDouble(strs[0]));
        bounds.put("bottom", Double.parseDouble(strs[1]));
        bounds.put("right", Double.parseDouble(strs[2]));
        bounds.put("top", Double.parseDouble(strs[3]));
        return bounds;
    }

    public static String getDPI(String scale, String resolution, String unit) {
        int ratio = 10000;
        int datumAxis = 6378137;
        if (unit.equals("degree") || unit.equals("degrees") || unit.equals("dd")) {
            return Double.toString(0.0254 * (double)ratio / Double.parseDouble(resolution) / Double.parseDouble(scale) / (Math.PI * 2 * (double)datumAxis / 360.0) / (double)ratio);
        }
        return Double.toString(0.0254 / Double.parseDouble(scale) / Double.parseDouble(resolution));
    }

    public static void main(String[] args) {
    }
}

