/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.Looper;
import java.util.List;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.api.CallbackContext;
import org.apache.cordova.api.CordovaInterface;
import org.apache.cordova.api.CordovaPlugin;
import org.apache.cordova.api.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CompassListener
extends CordovaPlugin
implements SensorEventListener {
    public static int STOPPED = 0;
    public static int STARTING = 1;
    public static int RUNNING = 2;
    public static int ERROR_FAILED_TO_START = 3;
    public long TIMEOUT = 30000L;
    int status;
    float heading = 0.0f;
    long timeStamp = 0L;
    long lastAccessTime;
    int accuracy;
    private SensorManager sensorManager;
    Sensor mSensor;
    private CallbackContext callbackContext;

    public CompassListener() {
        this.setStatus(STOPPED);
    }

    public void initialize(CordovaInterface cordova, CordovaWebView webView) {
        super.initialize(cordova, webView);
        this.sensorManager = (SensorManager)cordova.getActivity().getSystemService("sensor");
    }

    public boolean execute(String action, JSONArray args, CallbackContext callbackContext) throws JSONException {
        if (action.equals("start")) {
            this.start();
        } else if (action.equals("stop")) {
            this.stop();
        } else if (action.equals("getStatus")) {
            int i = this.getStatus();
            callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, i));
        } else if (action.equals("getHeading")) {
            if (this.status != RUNNING) {
                int r = this.start();
                if (r == ERROR_FAILED_TO_START) {
                    callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.IO_EXCEPTION, ERROR_FAILED_TO_START));
                    return true;
                }
                Handler handler = new Handler(Looper.getMainLooper());
                handler.postDelayed(new Runnable(){

                    public void run() {
                        CompassListener.this.timeout();
                    }
                }, 2000L);
            }
            callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, this.getCompassHeading()));
        } else if (action.equals("setTimeout")) {
            this.setTimeout(args.getLong(0));
        } else if (action.equals("getTimeout")) {
            long l = this.getTimeout();
            callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, l));
        } else {
            return false;
        }
        return true;
    }

    public void onDestroy() {
        this.stop();
    }

    public void onReset() {
        this.stop();
    }

    public int start() {
        if (this.status == RUNNING || this.status == STARTING) {
            return this.status;
        }
        List list = this.sensorManager.getSensorList(3);
        if (list != null && list.size() > 0) {
            this.mSensor = (Sensor)list.get(0);
            this.sensorManager.registerListener((SensorEventListener)this, this.mSensor, 3);
            this.lastAccessTime = System.currentTimeMillis();
            this.setStatus(STARTING);
        } else {
            this.setStatus(ERROR_FAILED_TO_START);
        }
        return this.status;
    }

    public void stop() {
        if (this.status != STOPPED) {
            this.sensorManager.unregisterListener((SensorEventListener)this);
        }
        this.setStatus(STOPPED);
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    private void timeout() {
        if (this.status == STARTING) {
            this.setStatus(ERROR_FAILED_TO_START);
            if (this.callbackContext != null) {
                this.callbackContext.error("Compass listener failed to start.");
            }
        }
    }

    public void onSensorChanged(SensorEvent event) {
        float heading = event.values[0];
        this.timeStamp = System.currentTimeMillis();
        this.heading = heading;
        this.setStatus(RUNNING);
        if (this.timeStamp - this.lastAccessTime > this.TIMEOUT) {
            this.stop();
        }
    }

    public int getStatus() {
        return this.status;
    }

    public float getHeading() {
        this.lastAccessTime = System.currentTimeMillis();
        return this.heading;
    }

    public void setTimeout(long timeout) {
        this.TIMEOUT = timeout;
    }

    public long getTimeout() {
        return this.TIMEOUT;
    }

    private void setStatus(int status) {
        this.status = status;
    }

    private JSONObject getCompassHeading() throws JSONException {
        JSONObject obj = new JSONObject();
        obj.put("magneticHeading", (double)this.getHeading());
        obj.put("trueHeading", (double)this.getHeading());
        obj.put("headingAccuracy", 0);
        obj.put("timestamp", this.timeStamp);
        return obj;
    }
}

