/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report;

import com.vladium.emma.report.IItem;
import com.vladium.emma.report.IItemAttribute;
import com.vladium.emma.report.IItemMetadata;
import com.vladium.emma.report.ItemComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

abstract class Item
implements IItem {
    protected final IItem m_parent;
    protected final int[] m_aggregates;
    private final List m_children;

    public final int getChildCount() {
        return this.m_children.size();
    }

    public final IItem getParent() {
        return this.m_parent;
    }

    public final Iterator getChildren() {
        return this.m_children.iterator();
    }

    public final Iterator getChildren(ItemComparator order) {
        if (order == null) {
            return this.getChildren();
        }
        IItem[] items = new IItem[this.m_children.size()];
        this.m_children.toArray(items);
        Arrays.sort(items, order);
        return Arrays.asList(items).iterator();
    }

    public final IItemAttribute getAttribute(int attributeID, int unitsID) {
        if ((this.getMetadata().getAttributeIDs() & (long)(1 << attributeID)) == 0L) {
            return null;
        }
        return IItemAttribute.Factory.getAttribute(attributeID, unitsID);
    }

    public int getAggregate(int type) {
        int[] aggregates = this.m_aggregates;
        int value = aggregates[type];
        if (value < 0) {
            value = 0;
            Iterator children = this.m_children.iterator();
            while (children.hasNext()) {
                value += ((IItem)children.next()).getAggregate(type);
            }
            aggregates[type] = value;
            return value;
        }
        return value;
    }

    protected void addChild(IItem item) {
        if (item == null) {
            throw new IllegalArgumentException("null input: item");
        }
        this.m_children.add(item);
    }

    Item(IItem parent) {
        this.m_parent = parent;
        this.m_children = new ArrayList();
        this.m_aggregates = new int[13];
        for (int i = 0; i < this.m_aggregates.length; ++i) {
            this.m_aggregates[i] = -1;
        }
    }

    protected static final class ItemMetadata
    implements IItemMetadata {
        private final int m_typeID;
        private final String m_typeName;
        private final long m_attributeIDs;

        public int getTypeID() {
            return this.m_typeID;
        }

        public String getTypeName() {
            return this.m_typeName;
        }

        public long getAttributeIDs() {
            return this.m_attributeIDs;
        }

        ItemMetadata(int typeID, String typeName, long attributeIDs) {
            this.m_typeID = typeID;
            this.m_typeName = typeName;
            this.m_attributeIDs = attributeIDs;
        }
    }
}

