//
//  FileKit.swift
//  FileKit
//
//  The MIT License (MIT)
//
//  Copyright (c) 2015-2016 Nikolai Vazquez
//
//  Permission is hereby granted, free of charge, to any person obtaining a copy
//  of this software and associated documentation files (the "Software"), to deal
//  in the Software without restriction, including without limitation the rights
//  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//  copies of the Software, and to permit persons to whom the Software is
//  furnished to do so, subject to the following conditions:
//
//  The above copyright notice and this permission notice shall be included in
//  all copies or substantial portions of the Software.
//
//  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//  THE SOFTWARE.
//
//  swiftlint:disable line_length
//

/// Information regarding [FileKit](https://github.com/nvzqz/FileKit).
///
/// - Author: [Nikolai Vazquez](https://github.com/nvzqz)
///
/// - Copyright: [MIT License](https://opensource.org/licenses/MIT)
///
/// - Version: [v4.0.0](https://github.com/nvzqz/FileKit/releases/tag/v4.0.0)
///
/// - Requires: Xcode 8, Swift 3.0
///
public enum FileKitInfo {

    /// The current version.
    ///
    /// FileKit follows [Semantic Versioning v2.0.0](http://semver.org/).
    public static let version = "v4.0.0"

    /// The current release.
    public static let release = 11

    /// FileKit is licensed under the [MIT License](https://opensource.org/licenses/MIT).
    public static let license = "MIT"

    /// A brief description of FileKit.
    public static let description = "A Swift framework that allows for simple and expressive file management."

    /// Where the project can be found.
    public static let projectURL = "https://github.com/nvzqz/FileKit"

}
