﻿# Syncfusion® WinForms examples

This repository contains the demos of [Syncfusion WinForms UI controls](https://www.syncfusion.com/products/winforms?utm_source=github&utm_medium=listing). This is the best place to check our controls to get more insight about the usage of APIs.

This section guides you to use the Syncfusion WinForms examples in your applications.

* [Requirements to run the demo](#requirements-to-run-the-demo)
* [Documentation](#documentation)
* [License](#license)
* [Using the examples](#using-the-examples)
* [Controls Catalog](#controls-catalog)
* [Support and Feedback](#support-and-feedback)

## <a name="requirements-to-run-the-demo"></a>Requirements to run the demo ##

The samples requires Visual Studio 2010 or higher to build, test and deploy. 

## <a name="documentation"></a>Documentation ##

All controls documentation for the Syncfusion Windows Forms controls can be found on [Syncfusion Help](https://help.syncfusion.com/windowsforms/overview?utm_source=github&utm_medium=listing). All API documentation can be found at the [API Reference](https://help.syncfusion.com/cr/windowsforms?utm_source=github&utm_medium=listing).


## <a name="license"></a>License ##

Syncfusion has no liability for any damage or consequence that may arise by the use or viewing of the samples. The samples are for demonstrative purposes and if you choose to use or access the samples you agree to not hold Syncfusion liable, in any form, for any damage that is related to use, accessing or otherwise viewing the samples. By accessing, viewing, or otherwise seeing the samples you acknowledge and agree Syncfusion’s samples will not allow you to seek injunctive relief in any form for any claim related to the sample. If you do not agree to this, do not view, access, utilize or otherwise do anything with Syncfusion’s samples.

## <a name="using-the-samples"></a>Using the examples ##

The easiest way to use these samples without using Git is to download the zip file containing the current version (using the following link or by clicking the "Download ZIP" button on the repo page). You can then unzip the entire archive and use the samples.

   [Download the samples ZIP](../../archive/master.zip)

   **Notes:** 
   * Before you unzip the archive, right-click it, select **Properties**, and then select **Unblock**.
   * Be sure to unzip the entire archive, and not just individual samples. The samples all depend on the SharedContent folder in the archive.  

**To use the Syncfusion Windows Forms samples, Syncfusion license key should be registered in SyncfusionLicense.txt file. Refer [this](https://www.syncfusion.com/kb/9002?utm_source=github&utm_medium=listing) link for more information.**



**Reminder:** If you unzip individual samples, they will not build due to references to other portions of the ZIP file that were not unzipped. You must unzip the entire archive if you intend to build the samples.


## <a name="controls-catalog"></a>Controls Catalog ## 

<table>
<tr>
<td colspan="3" rowspan="1">
<b>GRIDS<b>
</td>
</tr>    
<tr>
<td>
<a href="datagrid">DataGrid</a>
</td>
<td>
<a href="gridcontrol">GridControl</a>
</td>
<td>
<a href="pivotgrid">PivotGrid</a>
</td>
</tr>
<tr>
<td>
<a href="gridgroupingcontrol">GridGroupingControl</a>
</td>
<td>
<a href="gridcontrol/Grid%20List%20Control">GridListControl</a>
</td>
<td/>
</tr>
<tr>
<td colspan="3" rowspan="1">
<b>DATA VISUALIZATION</b>
</td>
</tr>    
<tr>
<td>
<a href="chart">Chart</a>
</td>
<td>
<a href="diagram">Diagram</a>
</td>
<td>
<a href="barcode">Barcode</a>
</td>
</tr>
<tr>
<td>
<a href="bulletgraph">BulletGraph</a>
</td>
<td>
<a href="gauge/DigitalGauge/DigitalGauge">Digital Gauge</a>
</td>
<td>
<a href="gauge/LinearGauge">Linear Gauge</a>
</td>
</tr>
<tr>
<td>
<a href="map">Maps</a>
</td>
<td>
<a href="pivotchart">PivotChart</a>
</td>
<td>
<a href="gauge/RadialGauge">Radial Gauge</a>
</td>

</tr>
<tr>
<td>
<a href="smithchart">SmithChart</a>
</td>
<td>
<a href="chart/SparklineChart">Sparkline</a>
</td>
<td>
<a href="treemap">TreeMap</a>
</td>
</tr>
<tr>
<td>
<a href="skinmanager">SkinManager</a>
</td>
<td/>
<td/>
</tr>
<tr>
<td colspan="3" rowspan="1">
<b>DATA SCIENCE</b>
</td>
</tr>    
<tr>
<td colspan="3" rowspan="1">
<a href="pmml">Predictive Analytics</a>
</td>
</tr>
<tr>
<td colspan="3" rowspan="1">
<b>FILE FORMAT FRAMEWORKS</b>
</td>
</tr>    
<tr>
<td>
<a href="xlsio">Excel</a>
</td>
<td>
<a href="pdf">PDF</a>
</td>
<td>
<a href="presentation">Presentation</a>
</td>
</tr>
<tr>
<td>
<a href="docio">Word</a>
</td>
<td/>
<td/>
</tr>
<tr>
<td colspan="3" rowspan="1">
<b>FILE VIEWERS AND EDITORS
</tr>
<tr>
<td >
<a href="pdfviewer">PDFViewer</a>
</td>
<td>
<a href="spreadsheet">Spreadsheet</a>
</td>
<td>
<a href="editor">SyntaxEditor</a>
</td>
</tr>
<tr>
<td>
<a href="htmlui">HTML Viewer</a>
</td>
<td/>
<td/>
</tr>
<tr>
<td colspan="3" rowspan="1">
<b>DIALOGS AND NOTIFICATION</b>
</td>
</tr>    
<tr>
<td>
<a href="dialogs/SfForm">Form</a>
</td>
<td>
<a href="navigation/TabbedMdi%20manager/Tabbed%20MDI">TabbedMDI</a>
</td>
<td>
<a href="notification/HubTile">HubTile</a>
</td>

</tr>
<tr>
<td>
<a href="layout/Tile%20layout/TileLayout">Image Streamer</a>
</td>
<td>
<a href="notification/MessageBoxAdv">MessageBox</a>
</td>
<td>
<a href="dialogs/Metro%20Style">MetroForm</a>
</td>
</tr>
<tr>
<td>
<a href="dialogs/Office%20Style%20Form/Office2010Form">Office2010Form</a>
</td>
<td>
<a href="notification/Progressbar">ProgressBarAdv</a>
</td>
<td>
<a href="notification/Splash/Splash%20Control">Splash</a>
</td>
</tr>

<tr>
<td>
<a href="notification/Splash/SplashPanel">SplashPanel</a>
</td>
<td>
<a href="notification/StatusBar/StatusBarAdv">StatusBarAdv</a>
</td>
<td>
<a href="notification/StatusBar/StatusBarAdv%20Panel">StatusBarAdvPanel</a>
</td>
</tr>
<tr>
<td>
<a href="notification/SfToolTip/GettingStarted">Tooltip</a>
</td>
<td>
<a href="notification/Super%20Tooltip/SuperTooltip">SuperToolTip</a>
</td>
<td/>
</tr>

<tr>
<td colspan="3" rowspan="1">
<b>NAVIGATION</b>
</td>
</tr>    
<tr>
<td>
<a href="ribbon">Ribbon</a>
</td>
<td>
<a href="ribbon/RibbonMerge">RibbonPanelMergeContainer</a>
</td>
<td>
<a href="navigation/TabControl">TabControl</a>
</td>
<tr>
<td>
<a href="menu">Menu</a>
</td>
<td>
<a href="contextmenustripext">Context Menu</a>
</td>
<td>
<a href="navigationview">NavigationView</a>
</td>
<tr>
<td>
<a href="multicolumntreeview">MulticolumnTreeView</a>
</td>
<td>
<a href="navigation/NavigationDrawer">NavigationDrawer</a>
</td>
<td>
<a href="radialmenu">RadialMenu</a>
</td>
</tr>
<tr>
<td>
<a href="navigation/SfScrollFrame/GettingStarted">ScrollFrame</a>
</td>
<td>
<a href="containercontrols/TabBarSplitter">TabSplitter Container</a>
</td>
<td>
<a href="toolbars/Toolbars">Toolbar</a>
</td>
<tr>
<td>
<a href="navigation/TreeNavigator">TreeNavigator</a>
</td>
<td>
<a href="treeview">TreeView</a>
</td>
<td>
<a href="navigation/Wizard/Wizard%20Control">Wizard</a>
</td>
</tr>
<tr>
<td>
<a href="navigation/GroupBar">GroupBar</a>
</td>
<td>
<a href="navigation/Wizard/Task%20Pane">XPTaskPane</a>
</td>
<td>
<a href="navigation/GroupBar/GroupView">GroupView</a>
</td>
</tr>
<tr>
<td>
<a href="dialogs/SfForm/MDIForm">MDIChildForms</a>
</td>
<td>
<a href="navigation/TaskBar/XpTaskbar">XPTaskbar</a>
</td>
</tr>
<tr>
<td>
<a href="toolbars/Command%20Bars">CommandBars</a>
</td>
<td/>
</tr>

<tr>
<td colspan="3" rowspan="1">
<b>MISCELLANEOUS</b>
</td>
</tr>    
<tr>
<td>
<a href="calculate">Calculate</a>
</td>
<td>
<a href="inputcontrols/Calculator">Calculator</a>
</td>
<td>
<a href="editor/Clock">Clock</a>
</td>
</tr>
<tr>
<td>
<a href="grouping">Grouping</a>
</td>
<td>
<a href="editor/Clock/Digital%20Clock">DigitalClock</a>
</td>
<td>
<a href="localization">Localization</a>
</td>
</tr>

<tr>
<td colspan="3" rowspan="1">
<b>BUTTONS</b>
</td>
</tr>    
<tr>
<td>
<a href="sfbutton">Button</a>
</td>
<td>
<a href="sfbutton/Buttons">SplitButton</a>
</td>
</tr>
<tr>
<td>
<a href="togglebutton">ToggleButton</a>
</td>
<td/>
<td/>
</tr>

<tr>
<td colspan="3" rowspan="1">
<b>LISTS AND DROPDOWN</b>
</td>
</tr>
<tr>
<td>
<a href="sfcombobox">ComboBox</a>
</td>
<td>
<a href="listcontrols/ComboBox%20Autocomplete">ComboBoxAutocomplete</a>
</td>
<td>
<a href="dropdown/SfListView">ListView</a>
</td>
</tr>
<tr>
<td>
<a href="listcontrols/Multi%20Column%20ComboBox">MultiColumnComboBox</a>
</td>
<td>
<a href="sfcombobox/MultiSelection">MultiSelectionComboBox</a>
</td>
<td>
<a href="dropdown/FontListBox">FontListBox</a>
</td>
</tr>
<tr>
<td>
<a href="listcontrols/Combo%20DropDown">ComboDropDown</a>
</td>
<td>
<a href="fontcombobox">FontComboBox</a>
</td>
</tr>

<tr>
<td colspan="3" rowspan="1">
<b>CALENDAR</b>
</td>
</tr>
<tr>
<td>
<a href="editor/SfCalendar">Calender</a>
</td>
<td>
<a href="schedulecontrol">Schedule</a>
</td>
<td/>
</tr>

<tr>
<td colspan="3" rowspan="1">
<b>LAYOUT</b>
</td>
</tr>    
<tr>
<td>
<a href="dockingmanager">DockingManager</a>
</td>
<td>
<a href="layout/BorderLayout">Border Layout</a>
</td>
<td>
<a href="layout/CardLayout">Card Layout</a>
</td>
</tr>

<tr>
<td>
<a href="layout/Carousel">Carousel</a>
</td>
<td>
<a href="layout/FlowLayout">Flow Layout</a>
</td>
<td>
<a href="layout/Gradient%20Panel">GradientPanel</a>
</td>
</tr>

<tr>
<td>
<a href="layout/GridLayout">Grid Layout</a>
</td>
<td>
<a href="popupmenu">PopupMenu</a>
</td>
<td>
<a href="containercontrols/PopupContainer">PopupControlContainer</a>
</td>
</tr>
<tr>
<td>
<a href="layout/Split%20ContainerAdv">SplitContainerAdv</a>
</td>
<td>
<a href="layout/Tile%20layout/TileLayout">TileLayout</a>
</td>
</tr>

<tr>
<td colspan="3" rowspan="1">
<b>INPUT CONTROLS</b>
</td>
</tr>                               
<tr>
<td>
<a href="editor/SfNumericTextBox">Numeric TextBox</a>
</td>
<td>
<a href="autocomplete">Autocomplete</a>
</td>
<td>
<a href="editor/CheckBoxAdv">CheckBoxAdv</a>
</td>
</tr>
<tr>
<td>
<a href="editor/Color%20UI%20Control">ColorUI</a>
</td>
<td>
<a href="editor/ColorPickerUI">ColorPickerUIAdv</a>
</td>
<td>
<a href="editor/ColorPickerButton">ColorPicker Button</a>
</td>
</tr>
<tr>
<td>
<a href="editor/FolderBrowser">FolderBrowser</a>
</td>
<td>
<a href="editor/MaskedEditBox">MaskedEditBox</a>
</td>
<td>
<a href="editor/UpDown">NumericUpdownExt</a>
</td>
</tr>
<tr>
<td>
<a href="editor/RadialSlider">RadialSlider</a>
</td>
<td>
<a href="inputcontrols/RadioButtonAdv">RadioButtonAdv</a>
</td>
<td>
<a href="editor/RangeSlider">RangeSlider</a>
</td>
</tr>
<tr>
<td>
<a href="editor/RatingControl">Rating</a>
</td>
<td>
<a href="editor/Editors">TextBoxExt</a>
</td>
<td>
<a href="editor/Editors">BannerText</a>
</td>
</tr>

<tr>
<td>
<a href="editor/Editors">CurrencyEdit</a>
</td>
<td>
<a href="editor/UnitConverter">CurrencyTextBox</a>
</td>
<td>
<a href="editor/UpDown">DomainUpdownExt</a>
</td>
</tr>

<tr>
<td>
<a href="editor/UnitConverter">DoubleTextBox</a>
</td>
<td>
<a href="editor/UnitConverter">IntegerTextBox</a>
</td>
<td>
<a href="editor/Editors">PercentTextBox</a>
</td>
</tr>
<tr>
<td>
<a href="editor/SfDateTimeEdit">DateTimeEdit</a>
</td>
</tr>
</table>

## <a name="support-and-feedback"></a>Support and Feedback ##

* For any other queries, reach our [Syncfusion support team](https://www.syncfusion.com/support/directtrac/incidents/newincident?utm_source=github&utm_medium=listing) or post the queries through the [community forums](https://www.syncfusion.com/forums?utm_source=github&utm_medium=listing).

* To renew the subscription, click [here](https://www.syncfusion.com/sales/products?utm_source=github&utm_medium=listing) or contact our sales team at <salessupport@syncfusion.com>.
  
<p>Copyright © 2001-2025 Syncfusion®, Inc. Updated on 2025-12-17 at precisely 05:11:07 EST.</p>
