# Swup Progress Bar Plugin

A [swup](https://swup.js.org) plugin for displaying a progress bar.

Shows a loading indicator for requests taking longer than ~300ms.


## Installation

Install the plugin from npm and import it into your bundle.

```bash
npm install @swup/progress-plugin
```

```js
import SwupProgressPlugin from '@swup/progress-plugin';
```

Or include the minified production file from a CDN:

```html
<script src="https://unpkg.com/@swup/progress-plugin@3"></script>
```

## Usage

To run this plugin, include an instance in the swup options.

```javascript
const swup = new Swup({
  plugins: [new SwupProgressPlugin()]
});
```

## Styling

The progress bar has a class name of `swup-progress-bar` you can use for styling.

```css
.swup-progress-bar {
  height: 4px;
  background-color: blue;
}
```

## Options

```javascript
{
  className: 'swup-progress-bar',
  transition: 300,
  delay: 300,
  initialValue: 0.25,
  finishAnimation: true
}
```

### className

Class name to use for the container div.

### transition

Length of the CSS transition between loading states, in milliseconds.

### delay

How long to wait before showing the progress bar, in milliseconds.

Set to `0` to always display the progress bar, even on fast requests.

### initialValue

To create a slightly more "realistic" appearance, the progress bar will start
out at a random position beteen 0 and the value of this option. Set to `0` to
always start from the left.

### finishAnimation

Whether the progress bar will complete the transition to 100% before hiding.
