/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.api;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.sina.weibo.sdk.api.BaseMediaObject;
import org.json.JSONException;
import org.json.JSONObject;

public class VoiceObject
extends BaseMediaObject {
    public static final String EXTRA_KEY_DEFAULTTEXT = "extra_key_defaulttext";
    public String defaultText;
    public String h5Url;
    public String dataUrl;
    public String dataHdUrl;
    public int duration;
    public static final Parcelable.Creator<VoiceObject> CREATOR = new Parcelable.Creator(){

        public VoiceObject createFromParcel(Parcel parcel) {
            return new VoiceObject(parcel);
        }

        public VoiceObject[] newArray(int n) {
            return new VoiceObject[n];
        }
    };

    public VoiceObject() {
    }

    public VoiceObject(Parcel parcel) {
        super(parcel);
        this.h5Url = parcel.readString();
        this.dataUrl = parcel.readString();
        this.dataHdUrl = parcel.readString();
        this.duration = parcel.readInt();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        super.writeToParcel(parcel, n);
        parcel.writeString(this.h5Url);
        parcel.writeString(this.dataUrl);
        parcel.writeString(this.dataHdUrl);
        parcel.writeInt(this.duration);
    }

    @Override
    public boolean checkArgs() {
        if (!super.checkArgs()) {
            return false;
        }
        if (this.dataUrl != null && this.dataUrl.length() > 512) {
            return false;
        }
        if (this.dataHdUrl != null && this.dataHdUrl.length() > 512) {
            return false;
        }
        return this.duration > 0;
    }

    @Override
    public int getObjType() {
        return 6;
    }

    @Override
    protected BaseMediaObject toExtraMediaObject(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            try {
                JSONObject jSONObject = new JSONObject(string);
                this.defaultText = jSONObject.optString(EXTRA_KEY_DEFAULTTEXT);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return this;
    }

    @Override
    protected String toExtraMediaString() {
        try {
            JSONObject jSONObject = new JSONObject();
            if (!TextUtils.isEmpty((CharSequence)this.defaultText)) {
                jSONObject.put(EXTRA_KEY_DEFAULTTEXT, (Object)this.defaultText);
            }
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            return "";
        }
    }
}

