---
name: Bug report
about: If something doesn't work as it should
title: ''
labels: bug
assignees: ''

---

**Describe the bug**
A clear and concise description of what the bug is.

**To Reproduce**
Steps to reproduce the behavior. If you can attach or link to your project to this issue that would help us a lot. Even better if you can create a minimal project for reproducing the bug.

1. Modify the file ...
2. Run the build ...
3. See error

**Expected behavior**
A clear and concise description of what you expected to happen.

**Environment information**
 - Operating System: [e.g. Windows, macOS, ...]
 - Build system full version: [e.g. 1.0.0]
 - Java runtime version: [See `java -version`]
 - IDE: [e.g. Eclipse, or command line]
    - IDE plug-in version (if applicable): [e.g. 1.0.0]

**Bug nature**
 - What component is the bug related to? [build execution, configuration, daemons, build clusters, repository actions, command line, scripting, IDE plugins, file management, incremental builds, other...]
 - When does it happen: [Clean builds only, incremental builds only, or both.]
 - How often does the bug happen: [always, sometimes]

**Build configuration**
(Delete the section if not modified. Include full command line if not building in IDE. May also upload full `.saker.build.ide.project.config` configuration file if used in an IDE.)
 - Environment parameters: [...]
 - Execution parameters: [...]
 - Path configuration: [...]
 - Script configuration: [...]
 - Build clusters: [...]
 - Daemon connection: [...]
 - Task repositories: [...]

**Related information**
What related information have you found when you searched the internet about the issue?

**Solution (optional)**
If you've made any efforts to debug the problem, or may be able to pinpoint the cause of the problem, please describe it here.

**Additional context**
Add any other context about the problem here.
