/*
 * Decompiled with CFR 0.152.
 */
package bence.sipka.cmd.runtime;

import bence.sipka.cmd.runtime.ArgumentsIterator;
import bence.sipka.cmd.runtime.CommandFileArgumentsIterator;
import bence.sipka.cmd.runtime.ParsingIterator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;

public class ParseUtil {
    private ParseUtil() {
        throw new UnsupportedOperationException();
    }

    public static <T extends Enum<T>> T parseEnumUpperCaseArgument(Class<T> enumclass, String arg, Iterator<? extends String> it) {
        ParseUtil.requireHasNextArgument(arg, it);
        return Enum.valueOf(enumclass, it.next().toUpperCase(Locale.ENGLISH));
    }

    public static <T extends Enum<T>> T parseEnumArgument(Class<T> enumclass, String arg, Iterator<? extends String> it) {
        ParseUtil.requireHasNextArgument(arg, it);
        return Enum.valueOf(enumclass, it.next());
    }

    public static String parseStringArgument(String arg, Iterator<? extends String> it) {
        ParseUtil.requireHasNextArgument(arg, it);
        return it.next();
    }

    public static byte parseByteArgument(String arg, Iterator<? extends String> it) {
        ParseUtil.requireHasNextArgument(arg, it);
        return Byte.parseByte(it.next());
    }

    public static short parseShortArgument(String arg, Iterator<? extends String> it) {
        ParseUtil.requireHasNextArgument(arg, it);
        return Short.parseShort(it.next());
    }

    public static int parseIntegerArgument(String arg, Iterator<? extends String> it) {
        ParseUtil.requireHasNextArgument(arg, it);
        return Integer.parseInt(it.next());
    }

    public static long parseLongArgument(String arg, Iterator<? extends String> it) {
        ParseUtil.requireHasNextArgument(arg, it);
        return Long.parseLong(it.next());
    }

    public static float parseFloatArgument(String arg, Iterator<? extends String> it) {
        ParseUtil.requireHasNextArgument(arg, it);
        return Float.parseFloat(it.next());
    }

    public static double parseDoubleArgument(String arg, Iterator<? extends String> it) {
        ParseUtil.requireHasNextArgument(arg, it);
        return Double.parseDouble(it.next());
    }

    public static boolean parseBooleanArgument(String arg, Iterator<? extends String> it) {
        ParseUtil.requireHasNextArgument(arg, it);
        return Boolean.parseBoolean(it.next());
    }

    public static char parseCharacterArgument(String arg, Iterator<? extends String> it) {
        ParseUtil.requireHasNextArgument(arg, it);
        String a = it.next();
        if (a.length() == 1) {
            return a.charAt(0);
        }
        throw new IllegalArgumentException("Failed to parse character: " + arg);
    }

    private static int moveIndexUntilCloseQuote(String arg, int idx) {
        char c;
        int len = arg.length();
        do {
            if (idx >= len) {
                throw new IllegalArgumentException("No closing quote found in: " + arg);
            }
            c = arg.charAt(idx);
            if (c == '\"') {
                return idx;
            }
            ++idx;
        } while (c != '\\' || ++idx != len);
        throw new IllegalArgumentException("No closing quote found in: " + arg);
    }

    public static String toKeyValueArgument(String prefix, String key, String value) {
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix);
        }
        if (key != null && !key.isEmpty()) {
            if (key.indexOf(34) >= 0) {
                sb.append('\"');
                sb.append(key.replace("\"", "\\\""));
                sb.append('\"');
            } else {
                sb.append(key);
            }
        }
        if (value != null) {
            sb.append('=');
            if (value.indexOf(34) >= 0) {
                sb.append('\"');
                sb.append(value.replace("\"", "\\\""));
                sb.append('\"');
            } else {
                sb.append(key);
            }
        }
        return sb.toString();
    }

    public static void parseEqualsFormatArgument(int prefixlen, String arg, String[] result) {
        int valuestartidx;
        String key;
        int closingidx;
        int len = arg.length();
        if (len == prefixlen) {
            result[0] = "";
            result[1] = null;
            return;
        }
        if (arg.charAt(prefixlen) == '\"') {
            closingidx = ParseUtil.moveIndexUntilCloseQuote(arg, prefixlen + 1);
            key = arg.substring(prefixlen + 1, closingidx);
            int eqidx = closingidx + 1;
            if (eqidx >= len) {
                result[0] = key;
                result[1] = null;
                return;
            }
            if (arg.charAt(eqidx) != '=') {
                throw new IllegalArgumentException("No separator '=' character found: " + arg);
            }
            valuestartidx = eqidx + 1;
        } else {
            int eqidx = arg.indexOf(61, prefixlen);
            if (eqidx < 0) {
                String key2;
                result[0] = key2 = arg.substring(prefixlen);
                result[1] = null;
                return;
            }
            key = arg.substring(prefixlen, eqidx);
            valuestartidx = eqidx + 1;
            if (valuestartidx == len) {
                result[0] = key;
                result[1] = "";
                return;
            }
        }
        if (arg.charAt(valuestartidx) == '\"') {
            closingidx = ParseUtil.moveIndexUntilCloseQuote(arg, prefixlen + 1);
            if (closingidx != len - 1) {
                throw new IllegalArgumentException("There are more data after value closing quote: " + arg);
            }
            String value = arg.substring(valuestartidx + 1, closingidx);
            result[0] = key;
            result[1] = value;
            return;
        }
        result[0] = key;
        result[1] = arg.substring(valuestartidx);
    }

    public static ParsingIterator createCommandFileArgumentIterator(Iterator<? extends String> args) {
        Objects.requireNonNull(args, "args");
        return new CommandFileArgumentsIterator(args);
    }

    public static ParsingIterator createSimpleArgumentIterator(Iterator<? extends String> args) {
        Objects.requireNonNull(args, "args");
        return new ArgumentsIterator(args);
    }

    public static String requireNextArgument(String arg, Iterator<? extends String> it) {
        Objects.requireNonNull(it, "iterator");
        if (!it.hasNext()) {
            throw new IllegalArgumentException("Argument missing for: " + arg);
        }
        return it.next();
    }

    public static void requireHasNextArgument(String arg, Iterator<? extends String> it) {
        Objects.requireNonNull(it, "iterator");
        if (!it.hasNext()) {
            throw new IllegalArgumentException("Argument missing for: " + arg);
        }
    }
}

