/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.server;

import com.sun.tools.sjavac.server.CompilerThread;
import com.sun.tools.sjavac.server.JavacServer;
import java.util.Stack;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;

public class CompilerPool {
    private JavacServer javacServer;
    private Semaphore available;
    private Stack<CompilerThread> compilers = new Stack();
    private final ExecutorService executorPool;
    private int concurrentRequests = 0;
    private long lastRequestFinished = 0L;
    private int numRequests = 0;
    private static final Object conc = new Object();

    public JavacServer getJavacServer() {
        return this.javacServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numActiveRequests() {
        Object object = conc;
        synchronized (object) {
            return this.concurrentRequests;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long lastRequestFinished() {
        Object object = conc;
        synchronized (object) {
            return this.lastRequestFinished;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startRequest() {
        int n;
        Object object = conc;
        synchronized (object) {
            ++this.concurrentRequests;
            ++this.numRequests;
            n = this.numRequests;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long stopRequest() {
        Object object = conc;
        synchronized (object) {
            --this.concurrentRequests;
            this.lastRequestFinished = System.currentTimeMillis();
        }
        return this.lastRequestFinished;
    }

    CompilerPool(int n, JavacServer javacServer) {
        this.available = new Semaphore(n, true);
        this.javacServer = javacServer;
        this.executorPool = Executors.newFixedThreadPool(n);
        this.lastRequestFinished = System.currentTimeMillis();
    }

    public void execute(CompilerThread compilerThread) {
        this.executorPool.execute(compilerThread);
    }

    public Future<?> executeSubtask(CompilerThread compilerThread, Runnable runnable) {
        return this.executorPool.submit(runnable);
    }

    public void shutdown() {
        this.executorPool.shutdown();
    }

    public CompilerThread grabCompilerThread() throws InterruptedException {
        this.available.acquire();
        if (this.compilers.empty()) {
            return new CompilerThread(this);
        }
        return this.compilers.pop();
    }

    public void returnCompilerThread(CompilerThread compilerThread) {
        this.compilers.push(compilerThread);
        this.available.release();
    }
}

