/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.comp;

import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.sjavac.comp.SmartFileObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class SmartFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    Set<URI> visibleSources = new HashSet<URI>();
    Map<String, Set<URI>> packageArtifacts = new HashMap<String, Set<URI>>();
    PrintWriter stdout;

    public SmartFileManager(JavaFileManager javaFileManager) {
        super(javaFileManager);
    }

    public void setVisibleSources(Set<URI> set) {
        this.visibleSources = set;
    }

    public void cleanArtifacts() {
        this.packageArtifacts = new HashMap<String, Set<URI>>();
    }

    public void setLog(PrintWriter printWriter) {
        this.stdout = printWriter;
    }

    public Map<String, Set<URI>> getPackageArtifacts() {
        return this.packageArtifacts;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String string, Set<JavaFileObject.Kind> set, boolean bl) throws IOException {
        Iterable<JavaFileObject> iterable = super.list(location, string, set, bl);
        if (this.visibleSources.isEmpty()) {
            return iterable;
        }
        ListBuffer<JavaFileObject> listBuffer = new ListBuffer<JavaFileObject>();
        for (JavaFileObject javaFileObject : iterable) {
            URI uRI = javaFileObject.toUri();
            String string2 = uRI.toString();
            if (!string2.startsWith("jar:") && !string2.endsWith(".class") && !this.visibleSources.contains(uRI)) continue;
            listBuffer.add(javaFileObject);
        }
        return listBuffer;
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return super.hasLocation(location);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind) throws IOException {
        JavaFileObject javaFileObject = super.getJavaFileForInput(location, string, kind);
        if (javaFileObject == null || this.visibleSources.isEmpty()) {
            return javaFileObject;
        }
        if (this.visibleSources.contains(javaFileObject.toUri())) {
            return javaFileObject;
        }
        return null;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind, FileObject fileObject) throws IOException {
        JavaFileObject javaFileObject = super.getJavaFileForOutput(location, string, kind, fileObject);
        if (javaFileObject == null) {
            return javaFileObject;
        }
        int n = string.lastIndexOf(46);
        String string2 = "";
        if (n != -1) {
            string2 = string.substring(0, n);
        }
        String string3 = "";
        this.addArtifact(string3 + ":" + string2, javaFileObject.toUri());
        return javaFileObject;
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String string, String string2) throws IOException {
        FileObject fileObject = super.getFileForInput(location, string, string2);
        if (fileObject == null || this.visibleSources.isEmpty()) {
            return fileObject;
        }
        if (this.visibleSources.contains(fileObject.toUri())) {
            return fileObject;
        }
        return null;
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String string, String string2, FileObject fileObject) throws IOException {
        FileObject fileObject2 = super.getFileForOutput(location, string, string2, fileObject);
        if (fileObject2 == null) {
            return fileObject2;
        }
        if (location.equals(StandardLocation.NATIVE_HEADER_OUTPUT) && fileObject2 instanceof JavaFileObject) {
            fileObject2 = new SmartFileObject((JavaFileObject)fileObject2, this.stdout);
            string = ":" + this.packageNameFromFileName(string2);
        }
        if (string.equals("")) {
            string = ":";
        }
        this.addArtifact(string, fileObject2.toUri());
        return fileObject2;
    }

    private String packageNameFromFileName(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.indexOf(95);
        int n2 = 0;
        while (n != -1) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('.');
            }
            stringBuilder.append(string.substring(n2, n));
            if (n == string.length() - 1) break;
            n2 = n + 1;
            n = string.indexOf(95, n2);
        }
        return stringBuilder.toString();
    }

    @Override
    public void flush() throws IOException {
        super.flush();
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    void addArtifact(String string, URI uRI) {
        Set<URI> set = this.packageArtifacts.get(string);
        if (set == null) {
            set = new HashSet<URI>();
            this.packageArtifacts.put(string, set);
        }
        set.add(uRI);
    }
}

