/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.comp;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.sjavac.comp.PubapiVisitor;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;

public class Dependencies {
    protected static final Context.Key<Dependencies> dependenciesKey = new Context.Key();
    protected Log log;
    protected Map<Name, Set<Name>> deps;
    protected Set<Name> explicitPackages;
    protected Map<Name, StringBuffer> publicApiPerClass;

    public static Dependencies instance(Context context) {
        Dependencies dependencies = context.get(dependenciesKey);
        if (dependencies == null) {
            dependencies = new Dependencies(context);
        }
        return dependencies;
    }

    private Dependencies(Context context) {
        context.put(dependenciesKey, this);
        this.log = Log.instance(context);
    }

    public void reset() {
        this.deps = new HashMap<Name, Set<Name>>();
        this.explicitPackages = new HashSet<Name>();
        this.publicApiPerClass = new HashMap<Name, StringBuffer>();
    }

    public Map<String, Set<String>> getDependencies() {
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
        if (this.explicitPackages == null) {
            return hashMap;
        }
        for (Name name : this.explicitPackages) {
            Set<Name> set = this.deps.get(name);
            if (set == null) continue;
            HashSet<String> hashSet = (HashSet<String>)hashMap.get(name.toString());
            if (hashSet == null) {
                hashSet = new HashSet<String>();
                hashMap.put(":" + name.toString(), hashSet);
            }
            for (Name name2 : set) {
                hashSet.add(":" + name2.toString());
            }
        }
        return hashMap;
    }

    public Map<String, String> getPubapis() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.publicApiPerClass == null) {
            return hashMap;
        }
        Name[] nameArray = this.publicApiPerClass.keySet().toArray(new Name[0]);
        Arrays.sort(nameArray, new CompareNames());
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        String string = "";
        for (Name name : nameArray) {
            String string2 = name.toString();
            String string3 = "";
            int n2 = string2.lastIndexOf(46);
            if (n2 != -1) {
                string3 = string2.substring(0, n2);
            }
            if (!string3.equals(string)) {
                if (!string.equals("")) {
                    hashMap.put(":" + string, stringBuffer.toString());
                }
                stringBuffer = new StringBuffer();
                string = string3;
            }
            stringBuffer.append(this.publicApiPerClass.get(name));
            ++n;
        }
        if (!string.equals("")) {
            hashMap.put(":" + string, stringBuffer.toString());
        }
        return hashMap;
    }

    public void visitPubapi(Element element) {
        Name name = ((Symbol.ClassSymbol)element).fullname;
        Name name2 = ((Symbol.ClassSymbol)element).packge().fullname;
        StringBuffer stringBuffer = this.publicApiPerClass.get(name);
        assert (stringBuffer == null);
        stringBuffer = new StringBuffer();
        PubapiVisitor pubapiVisitor = new PubapiVisitor(stringBuffer);
        pubapiVisitor.visit(element);
        if (stringBuffer.length() > 0) {
            this.publicApiPerClass.put(name, stringBuffer);
        }
        this.explicitPackages.add(name2);
    }

    public void collect(Name name, Name name2) {
        if (!name.equals(name2)) {
            Set<Name> set = this.deps.get(name);
            if (set == null) {
                set = new HashSet<Name>();
                this.deps.put(name, set);
            }
            set.add(name2);
        }
    }

    static class CompareNames
    implements Comparator<Name> {
        CompareNames() {
        }

        @Override
        public int compare(Name name, Name name2) {
            return name.toString().compareTo(name2.toString());
        }
    }
}

