/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac;

import com.sun.tools.sjavac.Module;
import com.sun.tools.sjavac.Package;
import com.sun.tools.sjavac.ProblemException;
import com.sun.tools.sjavac.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Source
implements Comparable<Source> {
    private Package pkg;
    private String name;
    private String suffix;
    private long lastModified;
    private File file;
    private File root;
    private boolean isGenerated;
    private boolean linkedOnly;
    private static boolean gurka = false;

    public boolean equals(Object object) {
        return object instanceof Source && this.name.equals(((Source)object).name);
    }

    @Override
    public int compareTo(Source source) {
        return this.name.compareTo(source.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public Source(Module module, String string, File file, File file2) {
        this.name = string;
        int n = string.lastIndexOf(".");
        this.suffix = n != -1 ? string.substring(n) : "";
        this.file = file;
        this.root = file2;
        this.lastModified = file.lastModified();
        this.linkedOnly = false;
    }

    public Source(Package package_, String string, long l) {
        this.pkg = package_;
        this.name = string;
        int n = string.lastIndexOf(".");
        this.suffix = n != -1 ? string.substring(n) : "";
        this.file = null;
        this.root = null;
        this.lastModified = l;
        this.linkedOnly = false;
        int n2 = string.lastIndexOf(47);
    }

    public String name() {
        return this.name;
    }

    public String suffix() {
        return this.suffix;
    }

    public Package pkg() {
        return this.pkg;
    }

    public File file() {
        return this.file;
    }

    public File root() {
        return this.root;
    }

    public long lastModified() {
        return this.lastModified;
    }

    public void setPackage(Package package_) {
        this.pkg = package_;
    }

    public void markAsGenerated() {
        this.isGenerated = true;
    }

    public boolean isGenerated() {
        return this.isGenerated;
    }

    public void markAsLinkedOnly() {
        this.linkedOnly = true;
    }

    public boolean isLinkedOnly() {
        return this.linkedOnly;
    }

    private void save(StringBuilder stringBuilder) {
        String string = this.linkedOnly ? "L" : "C";
        String string2 = this.isGenerated ? "G" : "S";
        stringBuilder.append(string2 + " " + string + " " + this.name + " " + this.file.lastModified() + "\n");
    }

    public static Source load(Package package_, String string, boolean bl) {
        int n = string.indexOf(32, 4);
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(4, n);
        long l = Long.parseLong(string.substring(n + 1));
        boolean bl2 = false;
        if (string.charAt(2) == 'L') {
            bl2 = true;
        } else if (string.charAt(2) == 'C') {
            bl2 = false;
        } else {
            return null;
        }
        Source source = new Source(package_, string2, l);
        source.file = new File(string2);
        if (bl) {
            source.markAsGenerated();
        }
        if (bl2) {
            source.markAsLinkedOnly();
        }
        return source;
    }

    public static void saveSources(Map<String, Source> map, StringBuilder stringBuilder) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : map.keySet()) {
            arrayList.add(string);
        }
        Collections.sort(arrayList);
        for (String string : arrayList) {
            Source source = map.get(string);
            source.save(stringBuilder);
        }
    }

    public static void scanRoot(File file, Set<String> set, List<String> list, List<String> list2, List<String> list3, List<String> list4, Map<String, Source> map, Map<String, Module> map2, Module module, boolean bl, boolean bl2, boolean bl3) throws ProblemException {
        File[] fileArray;
        if (file == null) {
            return;
        }
        int n = file.getPath().length() + 1;
        module = Source.addFilesInDir(file, n, file, set, bl, list3, list4, false, map, map2, module, bl2, bl3);
        for (File file2 : fileArray = file.listFiles()) {
            if (!file2.isDirectory()) continue;
            Source.scanDirectory(file2, n, file, set, list, list2, list3, list4, false, map, map2, module, bl2, bl3);
        }
    }

    private static boolean hasMatch(String string, List<String> list) {
        for (String string2 : list) {
            String string3;
            if (string2.equals(string)) {
                return true;
            }
            if (!string2.endsWith(".*") || !string.startsWith(string3 = string2.substring(0, string2.length() - 2)) || string.length() != string3.length() && string.charAt(string3.length()) != '.') continue;
            return true;
        }
        return false;
    }

    private static boolean hasFileMatch(String string, List<String> list) {
        string = Util.normalizeDriveLetter(string);
        for (String string2 : list) {
            String string3;
            if (string2.equals(string)) {
                return true;
            }
            if (!string2.startsWith("*") || !string.endsWith(string3 = string2.substring(1))) continue;
            return true;
        }
        return false;
    }

    private static Module addFilesInDir(File file, int n, File file2, Set<String> set, boolean bl, List<String> list, List<String> list2, boolean bl2, Map<String, Source> map, Map<String, Module> map2, Module module, boolean bl3, boolean bl4) throws ProblemException {
        for (File file3 : file.listFiles()) {
            boolean bl5;
            if (!file3.isFile()) continue;
            boolean bl6 = bl5 = !(list != null && !list.isEmpty() && Source.hasFileMatch(file3.getPath(), list) || list2 != null && !list2.isEmpty() && !Source.hasFileMatch(file3.getPath(), list2));
            if (!bl5) continue;
            if (!bl && file3.getName().endsWith(".java")) {
                throw new ProblemException("No .java files are allowed in the source root " + file.getPath() + ", please remove " + file3.getName());
            }
            String string = file3.getPath().substring(n);
            int n2 = string.lastIndexOf(File.separatorChar);
            String string2 = "";
            if (n2 != -1) {
                string2 = string.substring(0, n2).replace(File.separatorChar, '.');
            }
            if (string.endsWith("module-info.java")) {
                if (!module.name().equals("")) {
                    throw new ProblemException("You have an extra module-info.java inside a module! Please remove " + string);
                }
                String string3 = string.substring(0, string.length() - 16);
                module = new Module(string3, file3.getPath());
                map2.put(string3, module);
            }
            int n3 = string.lastIndexOf(".");
            String string4 = "";
            if (n3 > 0) {
                string4 = string.substring(n3);
            }
            if (!bl2 && !set.contains(string4)) continue;
            Source source = map.get(file3.getPath());
            if (source != null) {
                throw new ProblemException("You have already added the file " + string + " from " + source.file().getPath());
            }
            source = module.lookupSource(file3.getPath());
            if (source != null) {
                if (bl4) {
                    if (source.isLinkedOnly()) {
                        throw new ProblemException("You have already added the link only file " + string + " from " + source.file().getPath());
                    }
                    map.put(file3.getPath(), source);
                    continue;
                }
                throw new ProblemException("Internal error: Double add of file " + string + " from " + source.file().getPath());
            }
            Source source2 = new Source(module, file3.getPath(), file3, file2);
            if (bl3) {
                source2.markAsGenerated();
            }
            if (bl4) {
                source2.markAsLinkedOnly();
            }
            string2 = module.name() + ":" + string2;
            map.put(file3.getPath(), source2);
            module.addSource(string2, source2);
        }
        return module;
    }

    private static void scanDirectory(File file, int n, File file2, Set<String> set, List<String> list, List<String> list2, List<String> list3, List<String> list4, boolean bl, Map<String, Source> map, Map<String, Module> map2, Module module, boolean bl2, boolean bl3) throws ProblemException {
        String string = "";
        if (file.getPath().length() > n) {
            string = file.getPath().substring(n).replace(File.separatorChar, '.');
        }
        if (bl || (list2 == null || list2.isEmpty() || Source.hasMatch(string, list2)) && (list == null || list.isEmpty() || !Source.hasMatch(string, list))) {
            module = Source.addFilesInDir(file, n, file2, set, true, list3, list4, bl, map, map2, module, bl2, bl3);
        }
        for (File file3 : file.listFiles()) {
            if (!file3.isDirectory()) continue;
            Source.scanDirectory(file3, n, file2, set, list, list2, list3, list4, bl, map, map2, module, bl2, bl3);
        }
    }
}

