/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac;

import com.sun.tools.sjavac.CompileChunk;
import com.sun.tools.sjavac.Log;
import com.sun.tools.sjavac.Main;
import com.sun.tools.sjavac.Transformer;
import com.sun.tools.sjavac.Util;
import com.sun.tools.sjavac.server.JavacServer;
import com.sun.tools.sjavac.server.SysInfo;
import java.io.PrintStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class CompileJavaPackages
implements Transformer {
    static final int limitOnConcurrency = 3;
    String serverSettings;
    String[] args;

    @Override
    public void setExtra(String string) {
        this.serverSettings = string;
    }

    @Override
    public void setExtra(String[] stringArray) {
        this.args = stringArray;
    }

    @Override
    public boolean transform(Map<String, Set<URI>> map, Set<URI> set, Map<URI, Set<String>> map2, Map<String, Set<String>> map3, URI uRI, final Map<String, Set<URI>> map4, final Map<String, Set<String>> map5, final Map<String, String> map6, int n, boolean bl, int n2, PrintStream printStream, PrintStream printStream2) {
        int n3;
        int n4;
        Object object;
        boolean bl2 = true;
        boolean bl3 = true;
        String string = Util.extractStringOption("id", this.serverSettings);
        if (string == null || string.equals("")) {
            string = "id" + (new Random().nextLong() & Long.MAX_VALUE);
        }
        String string2 = Util.cleanSubOptions("--server:", Util.set("portfile", "sjavac", "background", "keepalive"), this.serverSettings);
        SysInfo sysInfo = JavacServer.connectGetSysInfo(string2, printStream, printStream2);
        if (sysInfo.numCores == -1) {
            Log.error("Could not query server for sysinfo!");
            return false;
        }
        int n5 = (int)(sysInfo.maxMemory / 0x100000L);
        Log.debug("Server reports " + n5 + "MiB of memory and " + sysInfo.numCores + " cores");
        if (n2 <= 0) {
            n2 = sysInfo.numCores;
            Log.debug("Number of jobs not explicitly set, defaulting to " + sysInfo.numCores);
        } else if (sysInfo.numCores < n2) {
            Log.debug("Limiting jobs from explicitly set " + n2 + " to cores available on server: " + sysInfo.numCores);
            n2 = sysInfo.numCores;
        } else {
            Log.debug("Number of jobs explicitly set to " + n2);
        }
        int n6 = n2;
        if (n2 > 3) {
            n6 = 3;
        }
        int n7 = 0;
        for (String string3 : map.keySet()) {
            object = map.get(string3);
            n7 += object.size();
        }
        int n8 = n7 / n6;
        int n9 = 175;
        object = System.getProperty("os.arch");
        String string4 = System.getProperty("sun.arch.data.model");
        if ("32".equals(string4)) {
            n9 = 119;
        }
        int n10 = n9 * n7 / 1024;
        Log.debug("For os.arch " + (String)object + " the empirically determined heap required per file is " + n9 + "KiB");
        Log.debug("Server has " + n5 + "MiB of heap.");
        Log.debug("Heuristics say that we need " + n10 + "MiB of heap for all source files.");
        if (n5 < n10) {
            bl3 = false;
            if (n7 < 500) {
                n6 = 1;
                n8 = n7;
                Log.debug("Compiling as a single source code chunk to stay within heap size limitations!");
            } else if (n8 > 500) {
                n6 = n7 / 500;
                n8 = n7 / n6;
                Log.debug("Compiling source as " + n6 + " code chunks serially to stay within heap size limitations!");
            }
        } else if (n6 > 1) {
            float f = (float)n10 / ((float)n6 * 0.7f);
            n4 = (int)(f * (float)n6);
            Log.debug("Heuristics say that for " + n6 + " concurrent compiles we need " + n4 + "MiB");
            if (n4 > n5) {
                n6 = 1;
                n8 = n7;
                Log.debug("Limiting compile to a single thread to stay within heap size limitations!");
            }
        }
        Log.debug("Compiling sources in " + n6 + " chunk(s)");
        CompileChunk[] compileChunkArray = this.createCompileChunks(map, map3, n6, n8);
        if (Log.isDebugging()) {
            n4 = 1;
            for (CompileChunk compileChunk : compileChunkArray) {
                Log.debug("Chunk " + n4 + " for " + string + " ---------------");
                ++n4;
                for (URI uRI2 : compileChunk.srcs) {
                    Log.debug("" + uRI2);
                }
            }
        }
        final int[] nArray = new int[n6];
        Object[] objectArray = new Thread[n6];
        final Set<URI> set2 = set;
        final Map<URI, Set<String>> map7 = map2;
        long l = System.currentTimeMillis();
        for (n3 = 0; n3 < n6; ++n3) {
            final int n11 = n3;
            final CompileChunk compileChunk = compileChunkArray[n3];
            final String string5 = string2 + ",poolsize=" + n2 + ",id=" + string + "-" + n11;
            final PrintStream printStream3 = printStream;
            final PrintStream printStream4 = printStream2;
            objectArray[n11] = new Thread(){

                @Override
                public void run() {
                    nArray[n11] = JavacServer.useServer(string5, Main.removeWrapperArgs(CompileJavaPackages.this.args), compileChunk.srcs, set2, map7, map4, map5, map6, null, printStream3, printStream4);
                }
            };
            if (compileChunk.srcs.size() <= 0) continue;
            String string6 = "";
            if (compileChunk.numDependents > 0) {
                string6 = "(with " + compileChunk.numDependents + " dependents) ";
            }
            if (!bl || compileChunk.numPackages > 16) {
                String string7 = "(" + compileChunk.pkgFromTos + ")";
                if (string7.equals("( to )")) {
                    string7 = "";
                }
                Log.info("Compiling " + compileChunk.srcs.size() + " files " + string6 + "in " + compileChunk.numPackages + " packages " + string7);
            } else {
                Log.info("Compiling " + compileChunk.pkgNames + string6);
            }
            if (bl3) {
                ((Thread)objectArray[n11]).start();
                continue;
            }
            ((Thread)objectArray[n11]).run();
            if (nArray[n3] == 0) continue;
            return false;
        }
        if (bl3) {
            for (n3 = 0; n3 < n6; ++n3) {
                try {
                    ((Thread)objectArray[n3]).join();
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        for (n3 = 0; n3 < n6; ++n3) {
            if (compileChunkArray[n3].srcs.size() <= 0 || nArray[n3] == 0) continue;
            bl2 = false;
        }
        long l2 = System.currentTimeMillis() - l;
        long l3 = l2 / 60000L;
        long l4 = (l2 - l3 * 60000L) / 1000L;
        Log.debug("Compilation of " + n7 + " source files took " + l3 + "m " + l4 + "s");
        return bl2;
    }

    CompileChunk[] createCompileChunks(Map<String, Set<URI>> map, Map<String, Set<String>> map2, int n, int n2) {
        int n3;
        Object[] objectArray = new CompileChunk[n];
        for (n3 = 0; n3 < objectArray.length; ++n3) {
            objectArray[n3] = new CompileChunk();
        }
        n3 = 0;
        Object[] objectArray2 = map.keySet().toArray(new String[0]);
        Arrays.sort(objectArray2);
        String string = null;
        for (Object object : objectArray2) {
            Object object2 = objectArray[n3];
            Set<URI> set = map.get(object);
            if (((CompileChunk)object2).srcs.size() + set.size() > n2 && n3 < n - 1) {
                string = null;
                object2 = objectArray[++n3];
            }
            ++((CompileChunk)object2).numPackages;
            ((CompileChunk)object2).srcs.addAll(set);
            String string2 = Util.justPackageName((String)object);
            Set<String> set2 = map2.get(object);
            if (set2 != null) {
                ((CompileChunk)object2).numDependents += set2.size();
            }
            if (string == null || string.trim().equals("")) {
                string = string2;
            }
            ((CompileChunk)object2).pkgNames.append(string2 + "(" + set.size() + ") ");
            ((CompileChunk)object2).pkgFromTos = string + " to " + string2;
        }
        Arrays.sort(objectArray);
        return objectArray;
    }
}

