/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdeps;

import com.sun.tools.classfile.Annotation;
import com.sun.tools.classfile.ClassFile;
import com.sun.tools.classfile.ConstantPool;
import com.sun.tools.classfile.ConstantPoolException;
import com.sun.tools.classfile.Dependencies;
import com.sun.tools.classfile.RuntimeAnnotations_attribute;
import com.sun.tools.jdeps.Archive;
import com.sun.tools.jdeps.ClassFileReader;
import com.sun.tools.jdeps.Profile;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class PlatformClassPath {
    private static final List<String> NON_PLATFORM_JARFILES = Arrays.asList("alt-rt.jar", "ant-javafx.jar", "javafx-mx.jar");
    private static final List<Archive> javaHomeArchives = PlatformClassPath.init();

    PlatformClassPath() {
    }

    static List<Archive> getArchives() {
        return javaHomeArchives;
    }

    private static List<Archive> init() {
        ArrayList<Archive> arrayList = new ArrayList<Archive>();
        Path path = Paths.get(System.getProperty("java.home"), new String[0]);
        try {
            if (path.endsWith("jre")) {
                Path path2;
                arrayList.addAll(PlatformClassPath.addJarFiles(path.resolve("lib")));
                if (path.getParent() != null && Files.exists(path2 = path.getParent().resolve("lib"), new LinkOption[0])) {
                    arrayList.addAll(PlatformClassPath.addJarFiles(path2));
                }
            } else if (Files.exists(path.resolve("lib"), new LinkOption[0])) {
                Path path3 = path.resolve("classes");
                if (Files.isDirectory(path3, new LinkOption[0])) {
                    arrayList.add(new JDKArchive(path3));
                }
                arrayList.addAll(PlatformClassPath.addJarFiles(path.resolve("lib")));
            } else {
                throw new RuntimeException("\"" + path + "\" not a JDK home");
            }
            return arrayList;
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
    }

    private static List<Archive> addJarFiles(final Path path) throws IOException {
        final ArrayList<Archive> arrayList = new ArrayList<Archive>();
        final Path path2 = path.resolve("ext");
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path path3, BasicFileAttributes basicFileAttributes) throws IOException {
                if (path3.equals(path) || path3.equals(path2)) {
                    return FileVisitResult.CONTINUE;
                }
                return FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult visitFile(Path path3, BasicFileAttributes basicFileAttributes) throws IOException {
                String string = path3.getFileName().toString();
                if (string.endsWith(".jar")) {
                    arrayList.add(NON_PLATFORM_JARFILES.contains(string) ? Archive.getInstance(path3) : new JDKArchive(path3));
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return arrayList;
    }

    static class JDKArchive
    extends Archive {
        private static List<String> PROFILE_JARS = Arrays.asList("rt.jar", "jce.jar");
        private static List<String> EXPORTED_PACKAGES = Arrays.asList("javax.jnlp", "org.w3c.dom.css", "org.w3c.dom.html", "org.w3c.dom.stylesheets", "org.w3c.dom.xpath");
        private final Map<String, Boolean> exportedPackages = new HashMap<String, Boolean>();
        private final Map<String, Boolean> exportedTypes = new HashMap<String, Boolean>();
        private static final String JDK_EXPORTED_ANNOTATION = "Ljdk/Exported;";

        public static boolean isProfileArchive(Archive archive) {
            if (archive instanceof JDKArchive) {
                return PROFILE_JARS.contains(archive.getName());
            }
            return false;
        }

        JDKArchive(Path path) throws IOException {
            super(path, ClassFileReader.newInstance(path));
        }

        public boolean isExported(String string) {
            int n = string.lastIndexOf(46);
            String string2 = n > 0 ? string.substring(0, n) : "";
            boolean bl = this.isExportedPackage(string2);
            if (this.exportedTypes.containsKey(string)) {
                return this.exportedTypes.get(string);
            }
            return bl;
        }

        public boolean isExportedPackage(String string) {
            if (Profile.getProfile(string) != null) {
                return true;
            }
            if (EXPORTED_PACKAGES.contains(string) || string.startsWith("javafx.")) {
                return true;
            }
            return this.exportedPackages.containsKey(string) ? this.exportedPackages.get(string) : false;
        }

        private Boolean isJdkExported(ClassFile classFile) throws ConstantPoolException {
            RuntimeAnnotations_attribute runtimeAnnotations_attribute = (RuntimeAnnotations_attribute)classFile.attributes.get("RuntimeVisibleAnnotations");
            if (runtimeAnnotations_attribute != null) {
                for (int i = 0; i < runtimeAnnotations_attribute.annotations.length; ++i) {
                    Annotation annotation = runtimeAnnotations_attribute.annotations[i];
                    String string = classFile.constant_pool.getUTF8Value(annotation.type_index);
                    if (!JDK_EXPORTED_ANNOTATION.equals(string)) continue;
                    boolean bl = true;
                    for (int j = 0; j < annotation.num_element_value_pairs; ++j) {
                        Annotation.element_value_pair element_value_pair2 = annotation.element_value_pairs[j];
                        Annotation.Primitive_element_value primitive_element_value = (Annotation.Primitive_element_value)element_value_pair2.value;
                        ConstantPool.CONSTANT_Integer_info cONSTANT_Integer_info = (ConstantPool.CONSTANT_Integer_info)classFile.constant_pool.get(primitive_element_value.const_value_index);
                        bl = cONSTANT_Integer_info.value != 0;
                    }
                    return bl;
                }
            }
            return null;
        }

        void processJdkExported(ClassFile classFile) throws IOException {
            try {
                String string = classFile.getName();
                String string2 = string.substring(0, string.lastIndexOf(47)).replace('/', '.');
                Boolean bl = this.isJdkExported(classFile);
                if (bl != null) {
                    this.exportedTypes.put(string.replace('/', '.'), bl);
                }
                if (!this.exportedPackages.containsKey(string2)) {
                    Boolean bl2 = null;
                    ClassFile classFile2 = this.reader().getClassFile(string.substring(0, string.lastIndexOf(47) + 1) + "package-info");
                    if (classFile2 != null) {
                        bl2 = this.isJdkExported(classFile2);
                    }
                    if (bl2 != null) {
                        this.exportedPackages.put(string2, bl2);
                    }
                }
            }
            catch (ConstantPoolException constantPoolException) {
                throw new Dependencies.ClassFileError(constantPoolException);
            }
        }
    }
}

