/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdeps;

import com.sun.tools.classfile.AccessFlags;
import com.sun.tools.classfile.ClassFile;
import com.sun.tools.classfile.ConstantPoolException;
import com.sun.tools.classfile.Dependencies;
import com.sun.tools.classfile.Dependency;
import com.sun.tools.jdeps.Analyzer;
import com.sun.tools.jdeps.Archive;
import com.sun.tools.jdeps.PlatformClassPath;
import com.sun.tools.jdeps.Profile;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;

class JdepsTask {
    static Option[] recognizedOptions = new Option[]{new Option(false, new String[]{"-h", "-?", "-help"}){

        @Override
        void process(JdepsTask jdepsTask, String string, String string2) {
            ((JdepsTask)jdepsTask).options.help = true;
        }
    }, new Option(true, new String[]{"-dotoutput"}){

        @Override
        void process(JdepsTask jdepsTask, String string, String string2) throws BadArgs {
            Path path = Paths.get(string2, new String[0]);
            if (!(!Files.exists(path, new LinkOption[0]) || Files.isDirectory(path, new LinkOption[0]) && Files.isWritable(path))) {
                throw new BadArgs("err.invalid.path", string2);
            }
            ((JdepsTask)jdepsTask).options.dotOutputDir = string2;
        }
    }, new Option(false, new String[]{"-s", "-summary"}){

        @Override
        void process(JdepsTask jdepsTask, String string, String string2) {
            ((JdepsTask)jdepsTask).options.showSummary = true;
            ((JdepsTask)jdepsTask).options.verbose = Analyzer.Type.SUMMARY;
        }
    }, new Option(false, new String[]{"-v", "-verbose", "-verbose:package", "-verbose:class"}){

        @Override
        void process(JdepsTask jdepsTask, String string, String string2) throws BadArgs {
            switch (string) {
                case "-v": 
                case "-verbose": {
                    ((JdepsTask)jdepsTask).options.verbose = Analyzer.Type.VERBOSE;
                    ((JdepsTask)jdepsTask).options.filterSameArchive = false;
                    ((JdepsTask)jdepsTask).options.filterSamePackage = false;
                    break;
                }
                case "-verbose:package": {
                    ((JdepsTask)jdepsTask).options.verbose = Analyzer.Type.PACKAGE;
                    break;
                }
                case "-verbose:class": {
                    ((JdepsTask)jdepsTask).options.verbose = Analyzer.Type.CLASS;
                    break;
                }
                default: {
                    throw new BadArgs("err.invalid.arg.for.option", string);
                }
            }
        }
    }, new Option(true, new String[]{"-cp", "-classpath"}){

        @Override
        void process(JdepsTask jdepsTask, String string, String string2) {
            ((JdepsTask)jdepsTask).options.classpath = string2;
        }
    }, new Option(true, new String[]{"-p", "-package"}){

        @Override
        void process(JdepsTask jdepsTask, String string, String string2) {
            ((JdepsTask)jdepsTask).options.packageNames.add(string2);
        }
    }, new Option(true, new String[]{"-e", "-regex"}){

        @Override
        void process(JdepsTask jdepsTask, String string, String string2) {
            ((JdepsTask)jdepsTask).options.regex = string2;
        }
    }, new Option(true, new String[]{"-f", "-filter"}){

        @Override
        void process(JdepsTask jdepsTask, String string, String string2) {
            ((JdepsTask)jdepsTask).options.filterRegex = string2;
        }
    }, new Option(false, new String[]{"-filter:package", "-filter:archive", "-filter:none"}){

        @Override
        void process(JdepsTask jdepsTask, String string, String string2) {
            switch (string) {
                case "-filter:package": {
                    ((JdepsTask)jdepsTask).options.filterSamePackage = true;
                    ((JdepsTask)jdepsTask).options.filterSameArchive = false;
                    break;
                }
                case "-filter:archive": {
                    ((JdepsTask)jdepsTask).options.filterSameArchive = true;
                    ((JdepsTask)jdepsTask).options.filterSamePackage = false;
                    break;
                }
                case "-filter:none": {
                    ((JdepsTask)jdepsTask).options.filterSameArchive = false;
                    ((JdepsTask)jdepsTask).options.filterSamePackage = false;
                }
            }
        }
    }, new Option(true, new String[]{"-include"}){

        @Override
        void process(JdepsTask jdepsTask, String string, String string2) throws BadArgs {
            ((JdepsTask)jdepsTask).options.includePattern = Pattern.compile(string2);
        }
    }, new Option(false, new String[]{"-P", "-profile"}){

        @Override
        void process(JdepsTask jdepsTask, String string, String string2) throws BadArgs {
            ((JdepsTask)jdepsTask).options.showProfile = true;
            if (Profile.getProfileCount() == 0) {
                throw new BadArgs("err.option.unsupported", string, JdepsTask.getMessage("err.profiles.msg", new Object[0]));
            }
        }
    }, new Option(false, new String[]{"-apionly"}){

        @Override
        void process(JdepsTask jdepsTask, String string, String string2) {
            ((JdepsTask)jdepsTask).options.apiOnly = true;
        }
    }, new Option(false, new String[]{"-R", "-recursive"}){

        @Override
        void process(JdepsTask jdepsTask, String string, String string2) {
            ((JdepsTask)jdepsTask).options.depth = 0;
            ((JdepsTask)jdepsTask).options.filterSameArchive = false;
            ((JdepsTask)jdepsTask).options.filterSamePackage = false;
        }
    }, new Option(false, new String[]{"-jdkinternals"}){

        @Override
        void process(JdepsTask jdepsTask, String string, String string2) {
            ((JdepsTask)jdepsTask).options.findJDKInternals = true;
            ((JdepsTask)jdepsTask).options.verbose = Analyzer.Type.CLASS;
            if (((JdepsTask)jdepsTask).options.includePattern == null) {
                ((JdepsTask)jdepsTask).options.includePattern = Pattern.compile(".*");
            }
        }
    }, new Option(false, new String[]{"-version"}){

        @Override
        void process(JdepsTask jdepsTask, String string, String string2) {
            ((JdepsTask)jdepsTask).options.version = true;
        }
    }, new HiddenOption(false, new String[]{"-fullversion"}){

        @Override
        void process(JdepsTask jdepsTask, String string, String string2) {
            ((JdepsTask)jdepsTask).options.fullVersion = true;
        }
    }, new HiddenOption(false, new String[]{"-showlabel"}){

        @Override
        void process(JdepsTask jdepsTask, String string, String string2) {
            ((JdepsTask)jdepsTask).options.showLabel = true;
        }
    }, new HiddenOption(false, new String[]{"-q", "-quiet"}){

        @Override
        void process(JdepsTask jdepsTask, String string, String string2) {
            ((JdepsTask)jdepsTask).options.nowarning = true;
        }
    }, new HiddenOption(true, new String[]{"-depth"}){

        @Override
        void process(JdepsTask jdepsTask, String string, String string2) throws BadArgs {
            try {
                ((JdepsTask)jdepsTask).options.depth = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new BadArgs("err.invalid.arg.for.option", string);
            }
        }
    }};
    private static final String PROGNAME = "jdeps";
    private final Options options = new Options();
    private final List<String> classes = new ArrayList<String>();
    private PrintWriter log;
    static final int EXIT_OK = 0;
    static final int EXIT_ERROR = 1;
    static final int EXIT_CMDERR = 2;
    static final int EXIT_SYSERR = 3;
    static final int EXIT_ABNORMAL = 4;
    private final List<Archive> sourceLocations = new ArrayList<Archive>();

    JdepsTask() {
    }

    void setLog(PrintWriter printWriter) {
        this.log = printWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int run(String[] stringArray) {
        if (this.log == null) {
            this.log = new PrintWriter(System.out);
        }
        try {
            this.handleOptions(stringArray);
            if (this.options.help) {
                this.showHelp();
            }
            if (this.options.version || this.options.fullVersion) {
                this.showVersion(this.options.fullVersion);
            }
            if (this.classes.isEmpty() && this.options.includePattern == null) {
                if (this.options.help || this.options.version || this.options.fullVersion) {
                    int n = 0;
                    return n;
                }
                this.showHelp();
                int n = 2;
                return n;
            }
            if (this.options.regex != null && this.options.packageNames.size() > 0) {
                this.showHelp();
                int n = 2;
                return n;
            }
            if (this.options.findJDKInternals && (this.options.regex != null || this.options.packageNames.size() > 0 || this.options.showSummary)) {
                this.showHelp();
                int n = 2;
                return n;
            }
            if (this.options.showSummary && this.options.verbose != Analyzer.Type.SUMMARY) {
                this.showHelp();
                int n = 2;
                return n;
            }
            boolean bl = this.run();
            int n = bl ? 0 : 1;
            return n;
        }
        catch (BadArgs badArgs) {
            this.reportError(badArgs.key, badArgs.args);
            if (badArgs.showUsage) {
                this.log.println(JdepsTask.getMessage("main.usage.summary", PROGNAME));
            }
            int n = 2;
            return n;
        }
        catch (IOException iOException) {
            int n = 4;
            return n;
        }
        finally {
            this.log.flush();
        }
    }

    private boolean run() throws IOException {
        this.findDependencies();
        Analyzer analyzer = new Analyzer(this.options.verbose, new Analyzer.Filter(){

            @Override
            public boolean accepts(Dependency.Location location, Archive archive, Dependency.Location location2, Archive archive2) {
                if (((JdepsTask)JdepsTask.this).options.findJDKInternals) {
                    return JdepsTask.this.isJDKArchive(archive2) && !((PlatformClassPath.JDKArchive)archive2).isExported(location2.getClassName());
                }
                if (((JdepsTask)JdepsTask.this).options.filterSameArchive) {
                    return archive != archive2;
                }
                return true;
            }
        });
        analyzer.run(this.sourceLocations);
        if (this.options.dotOutputDir != null) {
            Path path = Paths.get(this.options.dotOutputDir, new String[0]);
            Files.createDirectories(path, new FileAttribute[0]);
            this.generateDotFiles(path, analyzer);
        } else {
            this.printRawOutput(this.log, analyzer);
        }
        if (this.options.findJDKInternals && !this.options.nowarning) {
            this.showReplacements(analyzer);
        }
        return true;
    }

    private void generateSummaryDotFile(Path path, Analyzer analyzer) throws IOException {
        Analyzer.Type type = this.options.verbose == Analyzer.Type.PACKAGE || this.options.verbose == Analyzer.Type.SUMMARY ? Analyzer.Type.SUMMARY : Analyzer.Type.PACKAGE;
        Path path2 = path.resolve("summary.dot");
        try (PrintWriter printWriter = new PrintWriter(Files.newOutputStream(path2, new OpenOption[0]));
             SummaryDotFile summaryDotFile = new SummaryDotFile(printWriter, type);){
            for (Archive archive : this.sourceLocations) {
                if (archive.isEmpty()) continue;
                if ((this.options.verbose == Analyzer.Type.PACKAGE || this.options.verbose == Analyzer.Type.SUMMARY) && this.options.showLabel) {
                    analyzer.visitDependences(archive, summaryDotFile.labelBuilder(), Analyzer.Type.PACKAGE);
                }
                analyzer.visitDependences(archive, summaryDotFile, type);
            }
        }
    }

    private void generateDotFiles(Path path, Analyzer analyzer) throws IOException {
        if (this.options.verbose != Analyzer.Type.SUMMARY) {
            for (Archive archive : this.sourceLocations) {
                if (!analyzer.hasDependences(archive)) continue;
                Path path2 = path.resolve(archive.getName() + ".dot");
                PrintWriter printWriter = new PrintWriter(Files.newOutputStream(path2, new OpenOption[0]));
                Throwable throwable = null;
                try {
                    DotFileFormatter dotFileFormatter = new DotFileFormatter(printWriter, archive);
                    Throwable throwable2 = null;
                    try {
                        analyzer.visitDependences(archive, dotFileFormatter);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (dotFileFormatter == null) continue;
                        if (throwable2 != null) {
                            try {
                                dotFileFormatter.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        dotFileFormatter.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (printWriter == null) continue;
                    if (throwable != null) {
                        try {
                            printWriter.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    printWriter.close();
                }
            }
        }
        this.generateSummaryDotFile(path, analyzer);
    }

    private void printRawOutput(PrintWriter printWriter, Analyzer analyzer) {
        RawOutputFormatter rawOutputFormatter = new RawOutputFormatter(printWriter);
        RawSummaryFormatter rawSummaryFormatter = new RawSummaryFormatter(printWriter);
        for (Archive archive : this.sourceLocations) {
            if (archive.isEmpty()) continue;
            analyzer.visitDependences(archive, rawSummaryFormatter, Analyzer.Type.SUMMARY);
            if (!analyzer.hasDependences(archive) || this.options.verbose == Analyzer.Type.SUMMARY) continue;
            analyzer.visitDependences(archive, rawOutputFormatter);
        }
    }

    private boolean isValidClassName(String string) {
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '.' || Character.isJavaIdentifierPart(c)) continue;
            return false;
        }
        return true;
    }

    private boolean matches(String string, AccessFlags accessFlags) {
        if (this.options.apiOnly && !accessFlags.is(1)) {
            return false;
        }
        if (this.options.includePattern != null) {
            return this.options.includePattern.matcher(string.replace('/', '.')).matches();
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void findDependencies() throws IOException {
        int n;
        Object object;
        ClassFile classFile;
        Object object2;
        Dependency.Finder finder = this.options.apiOnly ? Dependencies.getAPIFinder(4) : Dependencies.getClassDependencyFinder();
        DependencyFilter dependencyFilter = new DependencyFilter();
        ArrayList<Archive> arrayList = new ArrayList<Archive>();
        LinkedList<String> linkedList = new LinkedList<String>();
        ArrayList<Path> arrayList2 = new ArrayList<Path>();
        for (String object42 : this.classes) {
            Path path = Paths.get(object42, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                arrayList2.add(path);
                arrayList.add(Archive.getInstance(path));
                continue;
            }
            if (this.isValidClassName(object42)) {
                linkedList.add(object42);
                continue;
            }
            this.warning("warn.invalid.arg", object42);
        }
        this.sourceLocations.addAll(arrayList);
        ArrayList arrayList3 = new ArrayList();
        arrayList3.addAll(this.getClassPathArchives(this.options.classpath, arrayList2));
        if (this.options.includePattern != null) {
            arrayList.addAll(arrayList3);
        }
        arrayList3.addAll(PlatformClassPath.getArchives());
        this.sourceLocations.addAll(arrayList3);
        for (Archive archive : this.sourceLocations) {
            if (!archive.reader().isMultiReleaseJar()) continue;
            this.warning("warn.mrjar.usejdk9", archive.getPathName());
        }
        LinkedList<Object> linkedList2 = new LinkedList<Object>();
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Archive archive : arrayList) {
            object2 = archive.reader().getClassFiles().iterator();
            while (object2.hasNext()) {
                classFile = object2.next();
                try {
                    object = classFile.getName();
                }
                catch (ConstantPoolException constantPoolException) {
                    throw new Dependencies.ClassFileError(constantPoolException);
                }
                if (!this.matches((String)object, classFile.access_flags)) continue;
                if (!hashSet.contains(object)) {
                    hashSet.add(object);
                }
                for (Dependency dependency : finder.findDependencies(classFile)) {
                    if (dependencyFilter.accepts(dependency)) {
                        String string = dependency.getTarget().getName();
                        if (!hashSet.contains(string) && !linkedList2.contains(string)) {
                            linkedList2.add(string);
                        }
                        archive.addClass(dependency.getOrigin(), dependency.getTarget());
                        continue;
                    }
                    archive.addClass(dependency.getOrigin());
                }
                for (String string : archive.reader().skippedEntries()) {
                    this.warning("warn.skipped.entry", string, archive.getPathName());
                }
            }
        }
        Object object3 = linkedList;
        int n2 = n = this.options.depth > 0 ? this.options.depth : Integer.MAX_VALUE;
        while (true) {
            void var7_10;
            if ((object2 = (String)object3.poll()) != null) {
                if (hashSet.contains(object2)) continue;
                classFile = null;
                object = arrayList3.iterator();
                block11: while (object.hasNext()) {
                    String string;
                    Archive archive = (Archive)object.next();
                    classFile = archive.reader().getClassFile((String)object2);
                    if (classFile == null) continue;
                    try {
                        string = classFile.getName();
                    }
                    catch (ConstantPoolException constantPoolException) {
                        throw new Dependencies.ClassFileError(constantPoolException);
                    }
                    if (hashSet.contains(string)) break;
                    hashSet.add(string);
                    if (this.isJDKArchive(archive)) {
                        ((PlatformClassPath.JDKArchive)archive).processJdkExported(classFile);
                    }
                    for (Dependency dependency : finder.findDependencies(classFile)) {
                        if (n == 0) {
                            archive.addClass(dependency.getOrigin());
                            break block11;
                        }
                        if (dependencyFilter.accepts(dependency)) {
                            archive.addClass(dependency.getOrigin(), dependency.getTarget());
                            String string2 = dependency.getTarget().getName();
                            if (hashSet.contains(string2) || var7_10.contains(string2)) continue;
                            var7_10.add(string2);
                            continue;
                        }
                        archive.addClass(dependency.getOrigin());
                    }
                }
                if (classFile != null) continue;
                hashSet.add(object2);
                continue;
            }
            object3 = var7_10;
            LinkedList linkedList3 = new LinkedList();
            if (object3.isEmpty() || n-- <= 0) break;
        }
    }

    public void handleOptions(String[] stringArray) throws BadArgs {
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            if (stringArray[i].charAt(0) == '-') {
                string = stringArray[i];
                Option option = this.getOption(string);
                String string2 = null;
                if (option.hasArg) {
                    if (string.startsWith("-") && string.indexOf(61) > 0) {
                        string2 = string.substring(string.indexOf(61) + 1, string.length());
                    } else if (i + 1 < stringArray.length) {
                        string2 = stringArray[++i];
                    }
                    if (string2 == null || string2.isEmpty() || string2.charAt(0) == '-') {
                        throw new BadArgs("err.missing.arg", string).showUsage(true);
                    }
                }
                option.process(this, string, string2);
                if (!option.ignoreRest()) continue;
                i = stringArray.length;
                continue;
            }
            while (i < stringArray.length) {
                string = stringArray[i];
                if (string.charAt(0) == '-') {
                    throw new BadArgs("err.option.after.class", string).showUsage(true);
                }
                this.classes.add(string);
                ++i;
            }
        }
    }

    private Option getOption(String string) throws BadArgs {
        for (Option option : recognizedOptions) {
            if (!option.matches(string)) continue;
            return option;
        }
        throw new BadArgs("err.unknown.option", string).showUsage(true);
    }

    private void reportError(String string, Object ... objectArray) {
        this.log.println(JdepsTask.getMessage("error.prefix", new Object[0]) + " " + JdepsTask.getMessage(string, objectArray));
    }

    private void warning(String string, Object ... objectArray) {
        this.log.println(JdepsTask.getMessage("warn.prefix", new Object[0]) + " " + JdepsTask.getMessage(string, objectArray));
    }

    private void showHelp() {
        this.log.println(JdepsTask.getMessage("main.usage", PROGNAME));
        for (Option option : recognizedOptions) {
            String string = option.aliases[0].substring(1);
            String string2 = string = string.charAt(0) == '-' ? string.substring(1) : string;
            if (option.isHidden() || string.equals("h") || string.startsWith("filter:")) continue;
            this.log.println(JdepsTask.getMessage("main.opt." + string, new Object[0]));
        }
    }

    private void showVersion(boolean bl) {
        this.log.println(this.version(bl ? "full" : "release"));
    }

    private String version(String string) {
        if (ResourceBundleHelper.versionRB == null) {
            return System.getProperty("java.version");
        }
        try {
            return ResourceBundleHelper.versionRB.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return JdepsTask.getMessage("version.unknown", System.getProperty("java.version"));
        }
    }

    static String getMessage(String string, Object ... objectArray) {
        try {
            return MessageFormat.format(ResourceBundleHelper.bundle.getString(string), objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            throw new InternalError("Missing message: " + string);
        }
    }

    private List<Archive> getClassPathArchives(String string, List<Path> list) throws IOException {
        ArrayList<Archive> arrayList = new ArrayList<Archive>();
        if (string.isEmpty()) {
            return arrayList;
        }
        ArrayList<Path> arrayList2 = new ArrayList<Path>();
        for (String string2 : string.split(File.pathSeparator)) {
            if (string2.length() <= 0) continue;
            int n = string2.lastIndexOf(".*");
            if (n > 0) {
                Path path = Paths.get(string2.substring(0, n), new String[0]);
                try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path, "*.jar");){
                    for (Path path2 : directoryStream) {
                        arrayList2.add(path2);
                    }
                    continue;
                }
            }
            arrayList2.add(Paths.get(string2, new String[0]));
        }
        for (Path path : arrayList2) {
            if (!Files.exists(path, new LinkOption[0]) || this.hasSameFile(list, path)) continue;
            arrayList.add(Archive.getInstance(path));
        }
        return arrayList;
    }

    private boolean hasSameFile(List<Path> list, Path path) throws IOException {
        for (Path path2 : list) {
            if (!Files.isSameFile(path2, path)) continue;
            return true;
        }
        return false;
    }

    private boolean isJDKArchive(Archive archive) {
        return PlatformClassPath.JDKArchive.class.isInstance(archive);
    }

    private String toTag(String string, Archive archive, Analyzer.Type type) {
        if (!this.isJDKArchive(archive)) {
            return archive.getName();
        }
        PlatformClassPath.JDKArchive jDKArchive = (PlatformClassPath.JDKArchive)archive;
        boolean bl = false;
        bl = type == Analyzer.Type.CLASS || type == Analyzer.Type.VERBOSE ? jDKArchive.isExported(string) : jDKArchive.isExportedPackage(string);
        Profile profile = this.getProfile(string, type);
        if (bl) {
            return this.options.showProfile && profile != null ? profile.profileName() : "";
        }
        return "JDK internal API (" + archive.getName() + ")";
    }

    private String toTag(String string, Archive archive) {
        return this.toTag(string, archive, this.options.verbose);
    }

    private Profile getProfile(String string, Analyzer.Type type) {
        String string2 = string;
        if (type == Analyzer.Type.CLASS || type == Analyzer.Type.VERBOSE) {
            int n = string.lastIndexOf(46);
            string2 = n > 0 ? string.substring(0, n) : "";
        }
        return Profile.getProfile(string2);
    }

    private String replacementFor(String string) {
        String string2 = string;
        String string3 = null;
        while (string3 == null && string2 != null) {
            try {
                string3 = ResourceBundleHelper.jdkinternals.getString(string2);
            }
            catch (MissingResourceException missingResourceException) {
                int n = string2.lastIndexOf(46);
                string2 = n > 0 ? string2.substring(0, n) : null;
            }
        }
        return string3;
    }

    private void showReplacements(Analyzer analyzer) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        boolean bl = false;
        for (Archive object : this.sourceLocations) {
            bl = bl || analyzer.hasDependences(object);
            for (String string : analyzer.dependences(object)) {
                String string2 = this.replacementFor(string);
                if (string2 == null || treeMap.containsKey(string)) continue;
                treeMap.put(string, string2);
            }
        }
        if (bl) {
            this.log.println();
            this.warning("warn.replace.useJDKInternals", JdepsTask.getMessage("jdeps.wiki.url", new Object[0]));
        }
        if (!treeMap.isEmpty()) {
            this.log.println();
            this.log.format("%-40s %s%n", "JDK Internal API", "Suggested Replacement");
            this.log.format("%-40s %s%n", "----------------", "---------------------");
            for (Map.Entry entry : treeMap.entrySet()) {
                this.log.format("%-40s %s%n", entry.getKey(), entry.getValue());
            }
        }
    }

    class SummaryDotFile
    implements Analyzer.Visitor,
    AutoCloseable {
        private final PrintWriter writer;
        private final Analyzer.Type type;
        private final Map<Archive, Map<Archive, StringBuilder>> edges = new HashMap<Archive, Map<Archive, StringBuilder>>();

        SummaryDotFile(PrintWriter printWriter, Analyzer.Type type) {
            this.writer = printWriter;
            this.type = type;
            printWriter.format("digraph \"summary\" {%n", new Object[0]);
        }

        @Override
        public void close() {
            this.writer.println("}");
        }

        @Override
        public void visitDependence(String string, Archive archive, String string2, Archive archive2) {
            String string3;
            String string4;
            String string5 = string4 = this.type == Analyzer.Type.PACKAGE ? string2 : archive2.getName();
            if (this.type == Analyzer.Type.PACKAGE) {
                string3 = JdepsTask.this.toTag(string2, archive2, this.type);
                if (!string3.isEmpty()) {
                    string4 = string4 + " (" + string3 + ")";
                }
            } else if (((JdepsTask)JdepsTask.this).options.showProfile && PlatformClassPath.JDKArchive.isProfileArchive(archive2)) {
                string4 = string4 + " (" + string2 + ")";
            }
            string3 = this.getLabel(archive, archive2);
            this.writer.format("  %-50s -> \"%s\"%s;%n", String.format("\"%s\"", string), string4, string3);
        }

        String getLabel(Archive archive, Archive archive2) {
            if (this.edges.isEmpty()) {
                return "";
            }
            StringBuilder stringBuilder = this.edges.get(archive).get(archive2);
            return stringBuilder == null ? "" : String.format(" [label=\"%s\",fontsize=9]", stringBuilder.toString());
        }

        Analyzer.Visitor labelBuilder() {
            return new Analyzer.Visitor(){

                @Override
                public void visitDependence(String string, Archive archive, String string2, Archive archive2) {
                    StringBuilder stringBuilder;
                    HashMap<Archive, StringBuilder> hashMap = (HashMap<Archive, StringBuilder>)SummaryDotFile.this.edges.get(archive);
                    if (!SummaryDotFile.this.edges.containsKey(archive)) {
                        hashMap = new HashMap<Archive, StringBuilder>();
                        SummaryDotFile.this.edges.put(archive, hashMap);
                    }
                    if ((stringBuilder = (StringBuilder)hashMap.get(archive2)) == null) {
                        stringBuilder = new StringBuilder();
                        hashMap.put(archive2, stringBuilder);
                    }
                    String string3 = JdepsTask.this.toTag(string2, archive2, Analyzer.Type.PACKAGE);
                    this.addLabel(stringBuilder, string, string2, string3);
                }

                void addLabel(StringBuilder stringBuilder, String string, String string2, String string3) {
                    stringBuilder.append(string).append(" -> ").append(string2);
                    if (!string3.isEmpty()) {
                        stringBuilder.append(" (" + string3 + ")");
                    }
                    stringBuilder.append("\\n");
                }
            };
        }
    }

    class DotFileFormatter
    implements Analyzer.Visitor,
    AutoCloseable {
        private final PrintWriter writer;
        private final String name;

        DotFileFormatter(PrintWriter printWriter, Archive archive) {
            this.writer = printWriter;
            this.name = archive.getName();
            printWriter.format("digraph \"%s\" {%n", this.name);
            printWriter.format("    // Path: %s%n", archive.getPathName());
        }

        @Override
        public void close() {
            this.writer.println("}");
        }

        @Override
        public void visitDependence(String string, Archive archive, String string2, Archive archive2) {
            String string3 = JdepsTask.this.toTag(string2, archive2);
            this.writer.format("   %-50s -> \"%s\";%n", String.format("\"%s\"", string), string3.isEmpty() ? string2 : String.format("%s (%s)", string2, string3));
        }
    }

    class RawSummaryFormatter
    implements Analyzer.Visitor {
        private final PrintWriter writer;

        RawSummaryFormatter(PrintWriter printWriter) {
            this.writer = printWriter;
        }

        @Override
        public void visitDependence(String string, Archive archive, String string2, Archive archive2) {
            this.writer.format("%s -> %s", archive.getName(), archive2.getPathName());
            if (((JdepsTask)JdepsTask.this).options.showProfile && PlatformClassPath.JDKArchive.isProfileArchive(archive2)) {
                this.writer.format(" (%s)", string2);
            }
            this.writer.format("%n", new Object[0]);
        }
    }

    class RawOutputFormatter
    implements Analyzer.Visitor {
        private final PrintWriter writer;
        private String pkg = "";

        RawOutputFormatter(PrintWriter printWriter) {
            this.writer = printWriter;
        }

        @Override
        public void visitDependence(String string, Archive archive, String string2, Archive archive2) {
            String string3 = JdepsTask.this.toTag(string2, archive2);
            if (((JdepsTask)JdepsTask.this).options.verbose == Analyzer.Type.VERBOSE) {
                this.writer.format("   %-50s -> %-50s %s%n", string, string2, string3);
            } else {
                if (!string.equals(this.pkg)) {
                    this.pkg = string;
                    this.writer.format("   %s (%s)%n", string, archive.getName());
                }
                this.writer.format("      -> %-50s %s%n", string2, string3);
            }
        }
    }

    private static class ResourceBundleHelper {
        static final ResourceBundle versionRB;
        static final ResourceBundle bundle;
        static final ResourceBundle jdkinternals;

        private ResourceBundleHelper() {
        }

        static {
            Locale locale = Locale.getDefault();
            try {
                bundle = ResourceBundle.getBundle("com.sun.tools.jdeps.resources.jdeps", locale);
            }
            catch (MissingResourceException missingResourceException) {
                throw new InternalError("Cannot find jdeps resource bundle for locale " + locale);
            }
            try {
                versionRB = ResourceBundle.getBundle("com.sun.tools.jdeps.resources.version");
            }
            catch (MissingResourceException missingResourceException) {
                throw new InternalError("version.resource.missing");
            }
            try {
                jdkinternals = ResourceBundle.getBundle("com.sun.tools.jdeps.resources.jdkinternals");
            }
            catch (MissingResourceException missingResourceException) {
                throw new InternalError("Cannot find jdkinternals resource bundle");
            }
        }
    }

    private static class Options {
        boolean help;
        boolean version;
        boolean fullVersion;
        boolean showProfile;
        boolean showSummary;
        boolean apiOnly;
        boolean showLabel;
        boolean findJDKInternals;
        boolean nowarning;
        Analyzer.Type verbose = Analyzer.Type.PACKAGE;
        boolean filterSamePackage = true;
        boolean filterSameArchive = false;
        String filterRegex;
        String dotOutputDir;
        String classpath = "";
        int depth = 1;
        Set<String> packageNames = new HashSet<String>();
        String regex;
        Pattern includePattern;

        private Options() {
        }
    }

    class DependencyFilter
    implements Dependency.Filter {
        final Dependency.Filter filter;
        final Pattern filterPattern;

        DependencyFilter() {
            this.filter = ((JdepsTask)JdepsTask.this).options.regex != null ? Dependencies.getRegexFilter(Pattern.compile(((JdepsTask)JdepsTask.this).options.regex)) : (((JdepsTask)JdepsTask.this).options.packageNames.size() > 0 ? Dependencies.getPackageFilter(((JdepsTask)JdepsTask.this).options.packageNames, false) : null);
            this.filterPattern = ((JdepsTask)JdepsTask.this).options.filterRegex != null ? Pattern.compile(((JdepsTask)JdepsTask.this).options.filterRegex) : null;
        }

        @Override
        public boolean accepts(Dependency dependency) {
            if (dependency.getOrigin().equals(dependency.getTarget())) {
                return false;
            }
            String string = dependency.getTarget().getPackageName();
            if (((JdepsTask)JdepsTask.this).options.filterSamePackage && dependency.getOrigin().getPackageName().equals(string)) {
                return false;
            }
            if (this.filterPattern != null && this.filterPattern.matcher(string).matches()) {
                return false;
            }
            return this.filter != null ? this.filter.accepts(dependency) : true;
        }
    }

    static abstract class HiddenOption
    extends Option {
        HiddenOption(boolean bl, String ... stringArray) {
            super(bl, stringArray);
        }

        @Override
        boolean isHidden() {
            return true;
        }
    }

    static abstract class Option {
        final boolean hasArg;
        final String[] aliases;

        Option(boolean bl, String ... stringArray) {
            this.hasArg = bl;
            this.aliases = stringArray;
        }

        boolean isHidden() {
            return false;
        }

        boolean matches(String string) {
            for (String string2 : this.aliases) {
                if (string2.equals(string)) {
                    return true;
                }
                if (!this.hasArg || !string.startsWith(string2 + "=")) continue;
                return true;
            }
            return false;
        }

        boolean ignoreRest() {
            return false;
        }

        abstract void process(JdepsTask var1, String var2, String var3) throws BadArgs;
    }

    static class BadArgs
    extends Exception {
        static final long serialVersionUID = 8765093759964640721L;
        final String key;
        final Object[] args;
        boolean showUsage;

        BadArgs(String string, Object ... objectArray) {
            super(JdepsTask.getMessage(string, objectArray));
            this.key = string;
            this.args = objectArray;
        }

        BadArgs showUsage(boolean bl) {
            this.showUsage = bl;
            return this;
        }
    }
}

