/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdeps;

import com.sun.tools.classfile.Dependency;
import com.sun.tools.jdeps.ClassFileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class Archive {
    private final Path path;
    private final String filename;
    private final ClassFileReader reader;
    protected Map<Dependency.Location, Set<Dependency.Location>> deps = new ConcurrentHashMap<Dependency.Location, Set<Dependency.Location>>();

    public static Archive getInstance(Path path) throws IOException {
        return new Archive(path, ClassFileReader.newInstance(path));
    }

    protected Archive(String string) {
        this.path = null;
        this.filename = string;
        this.reader = null;
    }

    protected Archive(Path path, ClassFileReader classFileReader) {
        this.path = path;
        this.filename = this.path.getFileName().toString();
        this.reader = classFileReader;
    }

    public ClassFileReader reader() {
        return this.reader;
    }

    public String getName() {
        return this.filename;
    }

    public void addClass(Dependency.Location location) {
        Set<Dependency.Location> set = this.deps.get(location);
        if (set == null) {
            set = new HashSet<Dependency.Location>();
            this.deps.put(location, set);
        }
    }

    public void addClass(Dependency.Location location, Dependency.Location location2) {
        Set<Dependency.Location> set = this.deps.get(location);
        if (set == null) {
            set = new HashSet<Dependency.Location>();
            this.deps.put(location, set);
        }
        set.add(location2);
    }

    public Set<Dependency.Location> getClasses() {
        return this.deps.keySet();
    }

    public void visitDependences(Visitor visitor) {
        for (Map.Entry<Dependency.Location, Set<Dependency.Location>> entry : this.deps.entrySet()) {
            for (Dependency.Location location : entry.getValue()) {
                visitor.visit(entry.getKey(), location);
            }
        }
    }

    public boolean isEmpty() {
        return this.getClasses().isEmpty();
    }

    public String getPathName() {
        return this.path != null ? this.path.toString() : this.filename;
    }

    public String toString() {
        return this.filename;
    }

    static interface Visitor {
        public void visit(Dependency.Location var1, Dependency.Location var2);
    }
}

