/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdeps;

import com.sun.tools.classfile.Dependency;
import com.sun.tools.jdeps.Archive;
import com.sun.tools.jdeps.JdepsTask;
import com.sun.tools.jdeps.PlatformClassPath;
import com.sun.tools.jdeps.Profile;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class Analyzer {
    private final Type type;
    private final Filter filter;
    private final Map<Archive, ArchiveDeps> results = new HashMap<Archive, ArchiveDeps>();
    private final Map<Dependency.Location, Archive> map = new HashMap<Dependency.Location, Archive>();
    private final Archive NOT_FOUND = new Archive(JdepsTask.getMessage("artifact.not.found", new Object[0]));

    public Analyzer(Type type, Filter filter) {
        this.type = type;
        this.filter = filter;
    }

    public void run(List<Archive> list) {
        this.buildLocationArchiveMap(list);
        for (Archive archive : list) {
            ArchiveDeps archiveDeps = new ArchiveDeps(archive, this.type);
            archive.visitDependences(archiveDeps);
            this.results.put(archive, archiveDeps);
        }
    }

    private void buildLocationArchiveMap(List<Archive> list) {
        for (Archive archive : list) {
            for (Dependency.Location location : archive.getClasses()) {
                if (this.map.containsKey(location)) continue;
                this.map.put(location, archive);
            }
        }
    }

    public boolean hasDependences(Archive archive) {
        if (this.results.containsKey(archive)) {
            return this.results.get(archive).dependencies().size() > 0;
        }
        return false;
    }

    public Set<String> dependences(Archive archive) {
        ArchiveDeps archiveDeps = this.results.get(archive);
        return archiveDeps.targetDependences();
    }

    public void visitDependences(Archive archive, Visitor visitor, Type type) {
        if (type == Type.SUMMARY) {
            ArchiveDeps archiveDeps = this.results.get(archive);
            TreeMap<String, Archive> treeMap = new TreeMap<String, Archive>();
            for (Archive archive2 : archiveDeps.requires()) {
                treeMap.put(archive2.getName(), archive2);
            }
            for (Archive archive2 : treeMap.values()) {
                Profile profile = archiveDeps.getTargetProfile(archive2);
                visitor.visitDependence(archive.getName(), archive, profile != null ? profile.profileName() : archive2.getName(), archive2);
            }
        } else {
            ArchiveDeps archiveDeps = this.results.get(archive);
            if (type != this.type) {
                archiveDeps = new ArchiveDeps(archive, type);
                archive.visitDependences(archiveDeps);
            }
            TreeSet<Dep> treeSet = new TreeSet<Dep>(archiveDeps.dependencies());
            for (Dep dep : treeSet) {
                visitor.visitDependence(dep.origin(), dep.originArchive(), dep.target(), dep.targetArchive());
            }
        }
    }

    public void visitDependences(Archive archive, Visitor visitor) {
        this.visitDependences(archive, visitor, this.type);
    }

    class Dep
    implements Comparable<Dep> {
        final String origin;
        final Archive originArchive;
        final String target;
        final Archive targetArchive;

        Dep(String string, Archive archive, String string2, Archive archive2) {
            this.origin = string;
            this.originArchive = archive;
            this.target = string2;
            this.targetArchive = archive2;
        }

        String origin() {
            return this.origin;
        }

        Archive originArchive() {
            return this.originArchive;
        }

        String target() {
            return this.target;
        }

        Archive targetArchive() {
            return this.targetArchive;
        }

        public boolean equals(Object object) {
            if (object instanceof Dep) {
                Dep dep = (Dep)object;
                return this.origin.equals(dep.origin) && this.originArchive == dep.originArchive && this.target.equals(dep.target) && this.targetArchive == dep.targetArchive;
            }
            return false;
        }

        public int hashCode() {
            int n = 7;
            n = 67 * n + Objects.hashCode(this.origin) + Objects.hashCode(this.originArchive) + Objects.hashCode(this.target) + Objects.hashCode(this.targetArchive);
            return n;
        }

        @Override
        public int compareTo(Dep dep) {
            if (this.origin.equals(dep.origin)) {
                if (this.target.equals(dep.target)) {
                    if (this.originArchive == dep.originArchive && this.targetArchive == dep.targetArchive) {
                        return 0;
                    }
                    if (this.originArchive == dep.originArchive) {
                        return this.targetArchive.getPathName().compareTo(dep.targetArchive.getPathName());
                    }
                    return this.originArchive.getPathName().compareTo(dep.originArchive.getPathName());
                }
                return this.target.compareTo(dep.target);
            }
            return this.origin.compareTo(dep.origin);
        }
    }

    class ArchiveDeps
    implements Archive.Visitor {
        protected final Archive archive;
        protected final Set<Archive> requires;
        protected final Set<Dep> deps;
        protected final Type level;
        private Profile profile;
        private Dep curDep;

        ArchiveDeps(Archive archive, Type type) {
            this.archive = archive;
            this.deps = new HashSet<Dep>();
            this.requires = new HashSet<Archive>();
            this.level = type;
        }

        Set<Dep> dependencies() {
            return this.deps;
        }

        Set<String> targetDependences() {
            HashSet<String> hashSet = new HashSet<String>();
            for (Dep dep : this.deps) {
                hashSet.add(dep.target());
            }
            return hashSet;
        }

        Set<Archive> requires() {
            return this.requires;
        }

        Profile getTargetProfile(Archive archive) {
            return PlatformClassPath.JDKArchive.isProfileArchive(archive) ? this.profile : null;
        }

        Archive findArchive(Dependency.Location location) {
            Archive archive;
            Archive archive2 = archive = this.archive.getClasses().contains(location) ? this.archive : (Archive)Analyzer.this.map.get(location);
            if (archive == null) {
                archive = Analyzer.this.NOT_FOUND;
                Analyzer.this.map.put(location, archive);
            }
            return archive;
        }

        private String getLocationName(Dependency.Location location) {
            if (this.level == Type.CLASS || this.level == Type.VERBOSE) {
                return location.getClassName();
            }
            String string = location.getPackageName();
            return string.isEmpty() ? "<unnamed>" : string;
        }

        @Override
        public void visit(Dependency.Location location, Dependency.Location location2) {
            Archive archive = this.findArchive(location2);
            if (Analyzer.this.filter.accepts(location, this.archive, location2, archive)) {
                this.addDep(location, location2);
                if (this.archive != archive && !this.requires.contains(archive)) {
                    this.requires.add(archive);
                }
            }
            if (archive instanceof PlatformClassPath.JDKArchive) {
                Profile profile = Profile.getProfile(location2.getPackageName());
                if (this.profile == null || profile != null && profile.compareTo(this.profile) > 0) {
                    this.profile = profile;
                }
            }
        }

        protected Dep addDep(Dependency.Location location, Dependency.Location location2) {
            String string = this.getLocationName(location);
            String string2 = this.getLocationName(location2);
            Archive archive = this.findArchive(location2);
            if (this.curDep != null && this.curDep.origin().equals(string) && this.curDep.originArchive() == this.archive && this.curDep.target().equals(string2) && this.curDep.targetArchive() == archive) {
                return this.curDep;
            }
            Dep dep = new Dep(string, this.archive, string2, archive);
            if (this.deps.contains(dep)) {
                for (Dep dep2 : this.deps) {
                    if (!dep.equals(dep2)) continue;
                    this.curDep = dep2;
                }
            } else {
                this.deps.add(dep);
                this.curDep = dep;
            }
            return this.curDep;
        }
    }

    public static interface Visitor {
        public void visitDependence(String var1, Archive var2, String var3, Archive var4);
    }

    static interface Filter {
        public boolean accepts(Dependency.Location var1, Archive var2, Dependency.Location var3, Archive var4);
    }

    public static enum Type {
        SUMMARY,
        PACKAGE,
        CLASS,
        VERBOSE;

    }
}

