/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javap;

import com.sun.tools.classfile.Code_attribute;
import com.sun.tools.classfile.Instruction;
import com.sun.tools.classfile.Method;
import com.sun.tools.classfile.RuntimeInvisibleTypeAnnotations_attribute;
import com.sun.tools.classfile.RuntimeTypeAnnotations_attribute;
import com.sun.tools.classfile.RuntimeVisibleTypeAnnotations_attribute;
import com.sun.tools.classfile.TypeAnnotation;
import com.sun.tools.javac.util.StringUtils;
import com.sun.tools.javap.AnnotationWriter;
import com.sun.tools.javap.ClassWriter;
import com.sun.tools.javap.Context;
import com.sun.tools.javap.InstructionDetailWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TypeAnnotationWriter
extends InstructionDetailWriter {
    private AnnotationWriter annotationWriter;
    private ClassWriter classWriter;
    private Map<Integer, List<Note>> pcMap;

    static TypeAnnotationWriter instance(Context context) {
        TypeAnnotationWriter typeAnnotationWriter = context.get(TypeAnnotationWriter.class);
        if (typeAnnotationWriter == null) {
            typeAnnotationWriter = new TypeAnnotationWriter(context);
        }
        return typeAnnotationWriter;
    }

    protected TypeAnnotationWriter(Context context) {
        super(context);
        context.put(TypeAnnotationWriter.class, this);
        this.annotationWriter = AnnotationWriter.instance(context);
        this.classWriter = ClassWriter.instance(context);
    }

    public void reset(Code_attribute code_attribute) {
        Method method = this.classWriter.getMethod();
        this.pcMap = new HashMap<Integer, List<Note>>();
        this.check(NoteKind.VISIBLE, (RuntimeVisibleTypeAnnotations_attribute)method.attributes.get("RuntimeVisibleTypeAnnotations"));
        this.check(NoteKind.INVISIBLE, (RuntimeInvisibleTypeAnnotations_attribute)method.attributes.get("RuntimeInvisibleTypeAnnotations"));
    }

    private void check(NoteKind noteKind, RuntimeTypeAnnotations_attribute runtimeTypeAnnotations_attribute) {
        if (runtimeTypeAnnotations_attribute == null) {
            return;
        }
        for (TypeAnnotation typeAnnotation : runtimeTypeAnnotations_attribute.annotations) {
            TypeAnnotation.Position position = typeAnnotation.position;
            Note note = null;
            if (position.offset != -1) {
                note = new Note(noteKind, typeAnnotation);
                this.addNote(position.offset, note);
            }
            if (position.lvarOffset == null) continue;
            for (int i = 0; i < position.lvarOffset.length; ++i) {
                if (note == null) {
                    note = new Note(noteKind, typeAnnotation);
                }
                this.addNote(position.lvarOffset[i], note);
            }
        }
    }

    private void addNote(int n, Note note) {
        List<Note> list = this.pcMap.get(n);
        if (list == null) {
            list = new ArrayList<Note>();
            this.pcMap.put(n, list);
        }
        list.add(note);
    }

    @Override
    void writeDetails(Instruction instruction) {
        String string = this.space(2);
        int n = instruction.getPC();
        List<Note> list = this.pcMap.get(n);
        if (list != null) {
            for (Note note : list) {
                this.print(string);
                this.print("@");
                this.annotationWriter.write(note.anno, false, true);
                this.print(", ");
                this.println(StringUtils.toLowerCase(note.kind.toString()));
            }
        }
    }

    public static class Note {
        public final NoteKind kind;
        public final TypeAnnotation anno;

        Note(NoteKind noteKind, TypeAnnotation typeAnnotation) {
            this.kind = noteKind;
            this.anno = typeAnnotation;
        }
    }

    public static enum NoteKind {
        VISIBLE,
        INVISIBLE;

    }
}

