/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javap;

import com.sun.tools.classfile.Code_attribute;
import com.sun.tools.classfile.ConstantPool;
import com.sun.tools.classfile.ConstantPoolException;
import com.sun.tools.classfile.Descriptor;
import com.sun.tools.classfile.Instruction;
import com.sun.tools.classfile.Method;
import com.sun.tools.classfile.StackMapTable_attribute;
import com.sun.tools.javap.ClassWriter;
import com.sun.tools.javap.Context;
import com.sun.tools.javap.InstructionDetailWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class StackMapWriter
extends InstructionDetailWriter {
    private Map<Integer, StackMap> map;
    private ClassWriter classWriter;
    private final StackMapTable_attribute.verification_type_info[] empty = new StackMapTable_attribute.verification_type_info[0];

    static StackMapWriter instance(Context context) {
        StackMapWriter stackMapWriter = context.get(StackMapWriter.class);
        if (stackMapWriter == null) {
            stackMapWriter = new StackMapWriter(context);
        }
        return stackMapWriter;
    }

    protected StackMapWriter(Context context) {
        super(context);
        context.put(StackMapWriter.class, this);
        this.classWriter = ClassWriter.instance(context);
    }

    public void reset(Code_attribute code_attribute) {
        this.setStackMap((StackMapTable_attribute)code_attribute.attributes.get("StackMapTable"));
    }

    void setStackMap(StackMapTable_attribute stackMapTable_attribute) {
        String[] stringArray;
        StackMapTable_attribute.verification_type_info[] verification_type_infoArray;
        if (stackMapTable_attribute == null) {
            this.map = null;
            return;
        }
        Method method = this.classWriter.getMethod();
        Descriptor descriptor = method.descriptor;
        try {
            ConstantPool constantPool = this.classWriter.getClassFile().constant_pool;
            verification_type_infoArray = descriptor.getParameterTypes(constantPool);
            stringArray = verification_type_infoArray.substring(1, verification_type_infoArray.length() - 1).split("[, ]+");
        }
        catch (ConstantPoolException constantPoolException) {
            return;
        }
        catch (Descriptor.InvalidDescriptor invalidDescriptor) {
            return;
        }
        boolean bl = method.access_flags.is(8);
        verification_type_infoArray = new StackMapTable_attribute.verification_type_info[(bl ? 0 : 1) + stringArray.length];
        if (!bl) {
            verification_type_infoArray[0] = new CustomVerificationTypeInfo("this");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            verification_type_infoArray[(bl ? 0 : 1) + i] = new CustomVerificationTypeInfo(stringArray[i].replace(".", "/"));
        }
        this.map = new HashMap<Integer, StackMap>();
        StackMapBuilder stackMapBuilder = new StackMapBuilder();
        int n = -1;
        this.map.put(n, new StackMap(verification_type_infoArray, this.empty));
        for (int i = 0; i < stackMapTable_attribute.entries.length; ++i) {
            n = stackMapTable_attribute.entries[i].accept(stackMapBuilder, n);
        }
    }

    public void writeInitialDetails() {
        this.writeDetails(-1);
    }

    @Override
    public void writeDetails(Instruction instruction) {
        this.writeDetails(instruction.getPC());
    }

    private void writeDetails(int n) {
        if (this.map == null) {
            return;
        }
        StackMap stackMap = this.map.get(n);
        if (stackMap != null) {
            this.print("StackMap locals: ", stackMap.locals);
            this.print("StackMap stack: ", stackMap.stack);
        }
    }

    void print(String string, StackMapTable_attribute.verification_type_info[] verification_type_infoArray) {
        this.print(string);
        for (int i = 0; i < verification_type_infoArray.length; ++i) {
            this.print(" ");
            this.print(verification_type_infoArray[i]);
        }
        this.println();
    }

    void print(StackMapTable_attribute.verification_type_info verification_type_info2) {
        if (verification_type_info2 == null) {
            this.print("ERROR");
            return;
        }
        switch (verification_type_info2.tag) {
            case -1: {
                this.print(((CustomVerificationTypeInfo)verification_type_info2).text);
                break;
            }
            case 0: {
                this.print("top");
                break;
            }
            case 1: {
                this.print("int");
                break;
            }
            case 2: {
                this.print("float");
                break;
            }
            case 4: {
                this.print("long");
                break;
            }
            case 3: {
                this.print("double");
                break;
            }
            case 5: {
                this.print("null");
                break;
            }
            case 6: {
                this.print("uninit_this");
                break;
            }
            case 7: {
                try {
                    ConstantPool constantPool = this.classWriter.getClassFile().constant_pool;
                    ConstantPool.CONSTANT_Class_info cONSTANT_Class_info = constantPool.getClassInfo(((StackMapTable_attribute.Object_variable_info)verification_type_info2).cpool_index);
                    this.print(constantPool.getUTF8Value(cONSTANT_Class_info.name_index));
                }
                catch (ConstantPoolException constantPoolException) {
                    this.print("??");
                }
                break;
            }
            case 8: {
                this.print(((StackMapTable_attribute.Uninitialized_variable_info)verification_type_info2).offset);
            }
        }
    }

    static class CustomVerificationTypeInfo
    extends StackMapTable_attribute.verification_type_info {
        private String text;

        public CustomVerificationTypeInfo(String string) {
            super(-1);
            this.text = string;
        }
    }

    static class StackMap {
        private final StackMapTable_attribute.verification_type_info[] locals;
        private final StackMapTable_attribute.verification_type_info[] stack;

        StackMap(StackMapTable_attribute.verification_type_info[] verification_type_infoArray, StackMapTable_attribute.verification_type_info[] verification_type_infoArray2) {
            this.locals = verification_type_infoArray;
            this.stack = verification_type_infoArray2;
        }
    }

    class StackMapBuilder
    implements StackMapTable_attribute.stack_map_frame.Visitor<Integer, Integer> {
        StackMapBuilder() {
        }

        @Override
        public Integer visit_same_frame(StackMapTable_attribute.same_frame same_frame2, Integer n) {
            int n2 = n + same_frame2.getOffsetDelta() + 1;
            StackMap stackMap = (StackMap)StackMapWriter.this.map.get(n);
            assert (stackMap != null);
            StackMapWriter.this.map.put(n2, stackMap);
            return n2;
        }

        @Override
        public Integer visit_same_locals_1_stack_item_frame(StackMapTable_attribute.same_locals_1_stack_item_frame same_locals_1_stack_item_frame2, Integer n) {
            int n2 = n + same_locals_1_stack_item_frame2.getOffsetDelta() + 1;
            StackMap stackMap = (StackMap)StackMapWriter.this.map.get(n);
            assert (stackMap != null);
            StackMap stackMap2 = new StackMap(stackMap.locals, same_locals_1_stack_item_frame2.stack);
            StackMapWriter.this.map.put(n2, stackMap2);
            return n2;
        }

        @Override
        public Integer visit_same_locals_1_stack_item_frame_extended(StackMapTable_attribute.same_locals_1_stack_item_frame_extended same_locals_1_stack_item_frame_extended2, Integer n) {
            int n2 = n + same_locals_1_stack_item_frame_extended2.getOffsetDelta() + 1;
            StackMap stackMap = (StackMap)StackMapWriter.this.map.get(n);
            assert (stackMap != null);
            StackMap stackMap2 = new StackMap(stackMap.locals, same_locals_1_stack_item_frame_extended2.stack);
            StackMapWriter.this.map.put(n2, stackMap2);
            return n2;
        }

        @Override
        public Integer visit_chop_frame(StackMapTable_attribute.chop_frame chop_frame2, Integer n) {
            int n2 = n + chop_frame2.getOffsetDelta() + 1;
            StackMap stackMap = (StackMap)StackMapWriter.this.map.get(n);
            assert (stackMap != null);
            int n3 = 251 - chop_frame2.frame_type;
            StackMapTable_attribute.verification_type_info[] verification_type_infoArray = Arrays.copyOf(stackMap.locals, stackMap.locals.length - n3);
            StackMap stackMap2 = new StackMap(verification_type_infoArray, StackMapWriter.this.empty);
            StackMapWriter.this.map.put(n2, stackMap2);
            return n2;
        }

        @Override
        public Integer visit_same_frame_extended(StackMapTable_attribute.same_frame_extended same_frame_extended2, Integer n) {
            int n2 = n + same_frame_extended2.getOffsetDelta();
            StackMap stackMap = (StackMap)StackMapWriter.this.map.get(n);
            assert (stackMap != null);
            StackMapWriter.this.map.put(n2, stackMap);
            return n2;
        }

        @Override
        public Integer visit_append_frame(StackMapTable_attribute.append_frame append_frame2, Integer n) {
            int n2 = n + append_frame2.getOffsetDelta() + 1;
            StackMap stackMap = (StackMap)StackMapWriter.this.map.get(n);
            assert (stackMap != null);
            StackMapTable_attribute.verification_type_info[] verification_type_infoArray = new StackMapTable_attribute.verification_type_info[stackMap.locals.length + append_frame2.locals.length];
            System.arraycopy(stackMap.locals, 0, verification_type_infoArray, 0, stackMap.locals.length);
            System.arraycopy(append_frame2.locals, 0, verification_type_infoArray, stackMap.locals.length, append_frame2.locals.length);
            StackMap stackMap2 = new StackMap(verification_type_infoArray, StackMapWriter.this.empty);
            StackMapWriter.this.map.put(n2, stackMap2);
            return n2;
        }

        @Override
        public Integer visit_full_frame(StackMapTable_attribute.full_frame full_frame2, Integer n) {
            int n2 = n + full_frame2.getOffsetDelta() + 1;
            StackMap stackMap = new StackMap(full_frame2.locals, full_frame2.stack);
            StackMapWriter.this.map.put(n2, stackMap);
            return n2;
        }
    }
}

