/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javap;

import com.sun.tools.classfile.Attribute;
import com.sun.tools.classfile.Attributes;
import com.sun.tools.classfile.ClassFile;
import com.sun.tools.classfile.ConstantPool;
import com.sun.tools.classfile.ConstantPoolException;
import com.sun.tools.classfile.Field;
import com.sun.tools.classfile.InnerClasses_attribute;
import com.sun.tools.classfile.Method;
import com.sun.tools.javap.AttributeWriter;
import com.sun.tools.javap.ClassWriter;
import com.sun.tools.javap.ConstantWriter;
import com.sun.tools.javap.Context;
import com.sun.tools.javap.DisassemblerTool;
import com.sun.tools.javap.InstructionDetailWriter;
import com.sun.tools.javap.InternalError;
import com.sun.tools.javap.JavapFileManager;
import com.sun.tools.javap.Messages;
import com.sun.tools.javap.Options;
import com.sun.tools.javap.SourceWriter;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;

public class JavapTask
implements DisassemblerTool.DisassemblerTask,
Messages {
    static final Option[] recognizedOptions = new Option[]{new Option(false, new String[]{"-help", "--help", "-?"}){

        @Override
        void process(JavapTask javapTask, String string, String string2) {
            javapTask.options.help = true;
        }
    }, new Option(false, new String[]{"-version"}){

        @Override
        void process(JavapTask javapTask, String string, String string2) {
            javapTask.options.version = true;
        }
    }, new Option(false, new String[]{"-fullversion"}){

        @Override
        void process(JavapTask javapTask, String string, String string2) {
            javapTask.options.fullVersion = true;
        }
    }, new Option(false, new String[]{"-v", "-verbose", "-all"}){

        @Override
        void process(JavapTask javapTask, String string, String string2) {
            javapTask.options.verbose = true;
            javapTask.options.showDescriptors = true;
            javapTask.options.showFlags = true;
            javapTask.options.showAllAttrs = true;
        }
    }, new Option(false, new String[]{"-l"}){

        @Override
        void process(JavapTask javapTask, String string, String string2) {
            javapTask.options.showLineAndLocalVariableTables = true;
        }
    }, new Option(false, new String[]{"-public"}){

        @Override
        void process(JavapTask javapTask, String string, String string2) {
            javapTask.options.accessOptions.add(string);
            javapTask.options.showAccess = 1;
        }
    }, new Option(false, new String[]{"-protected"}){

        @Override
        void process(JavapTask javapTask, String string, String string2) {
            javapTask.options.accessOptions.add(string);
            javapTask.options.showAccess = 4;
        }
    }, new Option(false, new String[]{"-package"}){

        @Override
        void process(JavapTask javapTask, String string, String string2) {
            javapTask.options.accessOptions.add(string);
            javapTask.options.showAccess = 0;
        }
    }, new Option(false, new String[]{"-p", "-private"}){

        @Override
        void process(JavapTask javapTask, String string, String string2) {
            if (!javapTask.options.accessOptions.contains("-p") && !javapTask.options.accessOptions.contains("-private")) {
                javapTask.options.accessOptions.add(string);
            }
            javapTask.options.showAccess = 2;
        }
    }, new Option(false, new String[]{"-c"}){

        @Override
        void process(JavapTask javapTask, String string, String string2) {
            javapTask.options.showDisassembled = true;
        }
    }, new Option(false, new String[]{"-s"}){

        @Override
        void process(JavapTask javapTask, String string, String string2) {
            javapTask.options.showDescriptors = true;
        }
    }, new Option(false, new String[]{"-sysinfo"}){

        @Override
        void process(JavapTask javapTask, String string, String string2) {
            javapTask.options.sysInfo = true;
        }
    }, new Option(false, new String[]{"-XDdetails"}){

        @Override
        void process(JavapTask javapTask, String string, String string2) {
            javapTask.options.details = EnumSet.allOf(InstructionDetailWriter.Kind.class);
        }
    }, new Option(false, new String[]{"-XDdetails:"}){

        @Override
        boolean matches(String string) {
            int n = string.indexOf(":");
            return n != -1 && super.matches(string.substring(0, n + 1));
        }

        @Override
        void process(JavapTask javapTask, String string, String string2) throws BadArgs {
            int n = string.indexOf(":");
            for (String string3 : string.substring(n + 1).split("[,: ]+")) {
                if (this.handleArg(javapTask, string3)) continue;
                JavapTask javapTask2 = javapTask;
                javapTask2.getClass();
                throw javapTask2.new BadArgs("err.invalid.arg.for.option", string3);
            }
        }

        boolean handleArg(JavapTask javapTask, String string) {
            if (string.length() == 0) {
                return true;
            }
            if (string.equals("all")) {
                javapTask.options.details = EnumSet.allOf(InstructionDetailWriter.Kind.class);
                return true;
            }
            boolean bl = true;
            if (string.startsWith("-")) {
                bl = false;
                string = string.substring(1);
            }
            for (InstructionDetailWriter.Kind kind : InstructionDetailWriter.Kind.values()) {
                if (!string.equalsIgnoreCase(kind.option)) continue;
                if (bl) {
                    javapTask.options.details.add(kind);
                } else {
                    javapTask.options.details.remove((Object)kind);
                }
                return true;
            }
            return false;
        }
    }, new Option(false, new String[]{"-constants"}){

        @Override
        void process(JavapTask javapTask, String string, String string2) {
            javapTask.options.showConstants = true;
        }
    }, new Option(false, new String[]{"-XDinner"}){

        @Override
        void process(JavapTask javapTask, String string, String string2) {
            javapTask.options.showInnerClasses = true;
        }
    }, new Option(false, new String[]{"-XDindent:"}){

        @Override
        boolean matches(String string) {
            int n = string.indexOf(":");
            return n != -1 && super.matches(string.substring(0, n + 1));
        }

        @Override
        void process(JavapTask javapTask, String string, String string2) throws BadArgs {
            int n = string.indexOf(":");
            try {
                int n2 = Integer.valueOf(string.substring(n + 1));
                if (n2 > 0) {
                    javapTask.options.indentWidth = n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }, new Option(false, new String[]{"-XDtab:"}){

        @Override
        boolean matches(String string) {
            int n = string.indexOf(":");
            return n != -1 && super.matches(string.substring(0, n + 1));
        }

        @Override
        void process(JavapTask javapTask, String string, String string2) throws BadArgs {
            int n = string.indexOf(":");
            try {
                int n2 = Integer.valueOf(string.substring(n + 1));
                if (n2 > 0) {
                    javapTask.options.tabColumn = n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }};
    static final int EXIT_OK = 0;
    static final int EXIT_ERROR = 1;
    static final int EXIT_CMDERR = 2;
    static final int EXIT_SYSERR = 3;
    static final int EXIT_ABNORMAL = 4;
    private static final String nl = System.getProperty("line.separator");
    private static final String versionRBName = "com.sun.tools.javap.resources.version";
    private static ResourceBundle versionRB;
    protected Context context = new Context();
    JavaFileManager fileManager;
    JavaFileManager defaultFileManager;
    PrintWriter log;
    DiagnosticListener<? super JavaFileObject> diagnosticListener;
    List<String> classes;
    Options options;
    Locale task_locale;
    Map<Locale, ResourceBundle> bundles;
    protected Attribute.Factory attributeFactory;
    private static final String progname = "javap";

    public JavapTask() {
        this.context.put(Messages.class, this);
        this.options = Options.instance(this.context);
        this.attributeFactory = new Attribute.Factory();
    }

    public JavapTask(Writer writer, JavaFileManager javaFileManager, DiagnosticListener<? super JavaFileObject> diagnosticListener) {
        this();
        this.log = JavapTask.getPrintWriterForWriter(writer);
        this.fileManager = javaFileManager;
        this.diagnosticListener = diagnosticListener;
    }

    public JavapTask(Writer writer, JavaFileManager javaFileManager, DiagnosticListener<? super JavaFileObject> diagnosticListener, Iterable<String> iterable, Iterable<String> iterable2) {
        this(writer, javaFileManager, diagnosticListener);
        this.classes = new ArrayList<String>();
        for (String string : iterable2) {
            string.getClass();
            this.classes.add(string);
        }
        try {
            if (iterable != null) {
                this.handleOptions(iterable, false);
            }
        }
        catch (BadArgs badArgs) {
            throw new IllegalArgumentException(badArgs.getMessage());
        }
    }

    @Override
    public void setLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.task_locale = locale;
    }

    public void setLog(Writer writer) {
        this.log = JavapTask.getPrintWriterForWriter(writer);
    }

    public void setLog(OutputStream outputStream) {
        this.setLog(JavapTask.getPrintWriterForStream(outputStream));
    }

    private static PrintWriter getPrintWriterForStream(OutputStream outputStream) {
        return new PrintWriter(outputStream == null ? System.err : outputStream, true);
    }

    private static PrintWriter getPrintWriterForWriter(Writer writer) {
        if (writer == null) {
            return JavapTask.getPrintWriterForStream(null);
        }
        if (writer instanceof PrintWriter) {
            return (PrintWriter)writer;
        }
        return new PrintWriter(writer, true);
    }

    public void setDiagnosticListener(DiagnosticListener<? super JavaFileObject> diagnosticListener) {
        this.diagnosticListener = diagnosticListener;
    }

    public void setDiagnosticListener(OutputStream outputStream) {
        this.setDiagnosticListener(this.getDiagnosticListenerForStream(outputStream));
    }

    private DiagnosticListener<JavaFileObject> getDiagnosticListenerForStream(OutputStream outputStream) {
        return this.getDiagnosticListenerForWriter(JavapTask.getPrintWriterForStream(outputStream));
    }

    private DiagnosticListener<JavaFileObject> getDiagnosticListenerForWriter(Writer writer) {
        final PrintWriter printWriter = JavapTask.getPrintWriterForWriter(writer);
        return new DiagnosticListener<JavaFileObject>(){

            @Override
            public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                switch (diagnostic.getKind()) {
                    case ERROR: {
                        printWriter.print(JavapTask.this.getMessage("err.prefix", new Object[0]));
                        break;
                    }
                    case WARNING: {
                        printWriter.print(JavapTask.this.getMessage("warn.prefix", new Object[0]));
                        break;
                    }
                    case NOTE: {
                        printWriter.print(JavapTask.this.getMessage("note.prefix", new Object[0]));
                    }
                }
                printWriter.print(" ");
                printWriter.println(diagnostic.getMessage(null));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int run(String[] stringArray) {
        try {
            int n;
            block22: {
                this.handleOptions(stringArray);
                if (this.classes == null || this.classes.size() == 0) {
                    if (this.options.help || this.options.version || this.options.fullVersion) {
                        int n2 = 0;
                        return n2;
                    }
                    int n3 = 2;
                    return n3;
                }
                try {
                    n = this.run();
                    if (this.defaultFileManager == null) break block22;
                }
                catch (Throwable throwable) {
                    try {
                        if (this.defaultFileManager != null) {
                            try {
                                this.defaultFileManager.close();
                                this.defaultFileManager = null;
                            }
                            catch (IOException iOException) {
                                throw new InternalError(iOException, new Object[0]);
                            }
                        }
                        throw throwable;
                    }
                    catch (BadArgs badArgs) {
                        this.reportError(badArgs.key, badArgs.args);
                        if (badArgs.showUsage) {
                            this.printLines(this.getMessage("main.usage.summary", progname));
                        }
                        int n4 = 2;
                        return n4;
                    }
                    catch (InternalError internalError) {
                        Object[] objectArray;
                        if (internalError.getCause() == null) {
                            objectArray = internalError.args;
                        } else {
                            objectArray = new Object[internalError.args.length + 1];
                            objectArray[0] = internalError.getCause();
                            System.arraycopy(internalError.args, 0, objectArray, 1, internalError.args.length);
                        }
                        this.reportError("err.internal.error", objectArray);
                        int n5 = 4;
                        return n5;
                    }
                }
                try {
                    this.defaultFileManager.close();
                    this.defaultFileManager = null;
                }
                catch (IOException iOException) {
                    throw new InternalError(iOException, new Object[0]);
                }
            }
            return n;
        }
        finally {
            this.log.flush();
        }
    }

    public void handleOptions(String[] stringArray) throws BadArgs {
        this.handleOptions(Arrays.asList(stringArray), true);
    }

    private void handleOptions(Iterable<String> iterable, boolean bl) throws BadArgs {
        CharSequence charSequence;
        Iterator<String> iterator;
        boolean bl2;
        if (this.log == null) {
            this.log = JavapTask.getPrintWriterForStream(System.out);
            if (this.diagnosticListener == null) {
                this.diagnosticListener = this.getDiagnosticListenerForStream(System.err);
            }
        } else if (this.diagnosticListener == null) {
            this.diagnosticListener = this.getDiagnosticListenerForWriter(this.log);
        }
        if (this.fileManager == null) {
            this.fileManager = this.getDefaultFileManager(this.diagnosticListener, this.log);
        }
        boolean bl3 = bl2 = !(iterator = iterable.iterator()).hasNext();
        while (iterator.hasNext()) {
            charSequence = iterator.next();
            if (((String)charSequence).startsWith("-")) {
                this.handleOption((String)charSequence, iterator);
                continue;
            }
            if (bl) {
                if (this.classes == null) {
                    this.classes = new ArrayList<String>();
                }
                this.classes.add((String)charSequence);
                while (iterator.hasNext()) {
                    this.classes.add(iterator.next());
                }
                continue;
            }
            throw new BadArgs("err.unknown.option", charSequence).showUsage(true);
        }
        if (this.options.accessOptions.size() > 1) {
            charSequence = new StringBuilder();
            for (String string : this.options.accessOptions) {
                if (((StringBuilder)charSequence).length() > 0) {
                    ((StringBuilder)charSequence).append(" ");
                }
                ((StringBuilder)charSequence).append(string);
            }
            throw new BadArgs("err.incompatible.options", charSequence);
        }
        if (!(this.classes != null && this.classes.size() != 0 || bl2 || this.options.help || this.options.version || this.options.fullVersion)) {
            throw new BadArgs("err.no.classes.specified", new Object[0]);
        }
        if (bl2 || this.options.help) {
            this.showHelp();
        }
        if (this.options.version || this.options.fullVersion) {
            this.showVersion(this.options.fullVersion);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleOption(String string, Iterator<String> iterator) throws BadArgs {
        for (Option option : recognizedOptions) {
            if (!option.matches(string)) continue;
            if (option.hasArg) {
                if (!iterator.hasNext()) throw new BadArgs("err.missing.arg", string).showUsage(true);
                option.process(this, string, iterator.next());
            } else {
                option.process(this, string, null);
            }
            if (!option.ignoreRest()) return;
            while (iterator.hasNext()) {
                iterator.next();
            }
            return;
        }
        try {
            if (!this.fileManager.handleOption(string, iterator)) throw new BadArgs("err.unknown.option", string).showUsage(true);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new BadArgs("err.invalid.use.of.option", string).showUsage(true);
        }
    }

    @Override
    public Boolean call() {
        return this.run() == 0;
    }

    public int run() {
        if (this.classes == null || this.classes.isEmpty()) {
            return 1;
        }
        this.context.put(PrintWriter.class, this.log);
        ClassWriter classWriter = ClassWriter.instance(this.context);
        SourceWriter sourceWriter = SourceWriter.instance(this.context);
        sourceWriter.setFileManager(this.fileManager);
        int n = 0;
        for (String string : this.classes) {
            Object object;
            try {
                n = this.writeClass(classWriter, string);
            }
            catch (ConstantPoolException constantPoolException) {
                this.reportError("err.bad.constant.pool", string, constantPoolException.getLocalizedMessage());
                n = 1;
            }
            catch (EOFException eOFException) {
                this.reportError("err.end.of.file", string);
                n = 1;
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.reportError("err.file.not.found", fileNotFoundException.getLocalizedMessage());
                n = 1;
            }
            catch (IOException iOException) {
                object = iOException.getLocalizedMessage();
                if (object == null) {
                    object = iOException;
                }
                this.reportError("err.ioerror", string, object);
                n = 1;
            }
            catch (Throwable throwable) {
                object = new StringWriter();
                PrintWriter printWriter = new PrintWriter((Writer)object);
                throwable.printStackTrace(printWriter);
                printWriter.close();
                this.reportError("err.crash", throwable.toString(), ((StringWriter)object).toString());
                n = 4;
            }
        }
        return n;
    }

    protected int writeClass(ClassWriter classWriter, String string) throws IOException, ConstantPoolException {
        Object object;
        JavaFileObject javaFileObject = this.open(string);
        if (javaFileObject == null) {
            this.reportError("err.class.not.found", string);
            return 1;
        }
        ClassFileInfo classFileInfo = this.read(javaFileObject);
        if (!string.endsWith(".class") && !((String)(object = classFileInfo.cf.getName())).replaceAll("[/$]", ".").equals(string.replaceAll("[/$]", "."))) {
            this.reportWarning("warn.unexpected.class", string, ((String)object).replace('/', '.'));
        }
        this.write(classFileInfo);
        if (this.options.showInnerClasses) {
            object = classFileInfo.cf;
            Attribute attribute = ((ClassFile)object).getAttribute("InnerClasses");
            if (attribute instanceof InnerClasses_attribute) {
                InnerClasses_attribute innerClasses_attribute = (InnerClasses_attribute)attribute;
                try {
                    int n = 0;
                    for (int i = 0; i < innerClasses_attribute.classes.length; ++i) {
                        int n2 = innerClasses_attribute.classes[i].outer_class_info_index;
                        ConstantPool.CONSTANT_Class_info cONSTANT_Class_info = ((ClassFile)object).constant_pool.getClassInfo(n2);
                        String string2 = cONSTANT_Class_info.getName();
                        if (!string2.equals(((ClassFile)object).getName())) continue;
                        int n3 = innerClasses_attribute.classes[i].inner_class_info_index;
                        ConstantPool.CONSTANT_Class_info cONSTANT_Class_info2 = ((ClassFile)object).constant_pool.getClassInfo(n3);
                        String string3 = cONSTANT_Class_info2.getName();
                        classWriter.println("// inner class " + string3.replaceAll("[/$]", "."));
                        classWriter.println();
                        n = this.writeClass(classWriter, string3);
                        if (n == 0) continue;
                        return n;
                    }
                    return n;
                }
                catch (ConstantPoolException constantPoolException) {
                    this.reportError("err.bad.innerclasses.attribute", string);
                    return 1;
                }
            }
            if (attribute != null) {
                this.reportError("err.bad.innerclasses.attribute", string);
                return 1;
            }
        }
        return 0;
    }

    protected JavaFileObject open(String string) throws IOException {
        Object object;
        int n;
        JavaFileObject javaFileObject = this.getClassFileObject(string);
        if (javaFileObject != null) {
            return javaFileObject;
        }
        String string2 = string;
        while ((n = string2.lastIndexOf(".")) != -1) {
            javaFileObject = this.getClassFileObject(string2 = string2.substring(0, n) + "$" + string2.substring(n + 1));
            if (javaFileObject == null) continue;
            return javaFileObject;
        }
        if (!string.endsWith(".class")) {
            return null;
        }
        if (this.fileManager instanceof StandardJavaFileManager && (javaFileObject = (object = (StandardJavaFileManager)this.fileManager).getJavaFileObjects(string).iterator().next()) != null && javaFileObject.getLastModified() != 0L) {
            return javaFileObject;
        }
        if (string.matches("^[A-Za-z]+:.*")) {
            try {
                object = new URI(string);
                URL uRL = ((URI)object).toURL();
                URLConnection uRLConnection = uRL.openConnection();
                return new JavaFileObject((URI)object, uRL, uRLConnection){
                    final /* synthetic */ URI val$uri;
                    final /* synthetic */ URL val$url;
                    final /* synthetic */ URLConnection val$conn;
                    {
                        this.val$uri = uRI;
                        this.val$url = uRL;
                        this.val$conn = uRLConnection;
                    }

                    @Override
                    public JavaFileObject.Kind getKind() {
                        return JavaFileObject.Kind.CLASS;
                    }

                    @Override
                    public boolean isNameCompatible(String string, JavaFileObject.Kind kind) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public NestingKind getNestingKind() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Modifier getAccessLevel() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public URI toUri() {
                        return this.val$uri;
                    }

                    @Override
                    public String getName() {
                        return this.val$url.toString();
                    }

                    @Override
                    public InputStream openInputStream() throws IOException {
                        return this.val$conn.getInputStream();
                    }

                    @Override
                    public OutputStream openOutputStream() throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Reader openReader(boolean bl) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public CharSequence getCharContent(boolean bl) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Writer openWriter() throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public long getLastModified() {
                        return this.val$conn.getLastModified();
                    }

                    @Override
                    public boolean delete() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassFileInfo read(JavaFileObject javaFileObject) throws IOException, ConstantPoolException {
        try (InputStream inputStream = javaFileObject.openInputStream();){
            SizeInputStream sizeInputStream = null;
            MessageDigest messageDigest = null;
            if (this.options.sysInfo || this.options.verbose) {
                try {
                    messageDigest = MessageDigest.getInstance("MD5");
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    // empty catch block
                }
                inputStream = new DigestInputStream(inputStream, messageDigest);
                sizeInputStream = new SizeInputStream(inputStream);
                inputStream = sizeInputStream;
            }
            ClassFile classFile = ClassFile.read(inputStream, this.attributeFactory);
            byte[] byArray = messageDigest == null ? null : messageDigest.digest();
            int n = sizeInputStream == null ? -1 : sizeInputStream.size();
            ClassFileInfo classFileInfo = new ClassFileInfo(javaFileObject, classFile, byArray, n);
            return classFileInfo;
        }
    }

    public void write(ClassFileInfo classFileInfo) {
        ClassWriter classWriter = ClassWriter.instance(this.context);
        if (this.options.sysInfo || this.options.verbose) {
            classWriter.setFile(classFileInfo.fo.toUri());
            classWriter.setLastModified(classFileInfo.fo.getLastModified());
            classWriter.setDigest("MD5", classFileInfo.digest);
            classWriter.setFileSize(classFileInfo.size);
        }
        classWriter.write(classFileInfo.cf);
    }

    protected void setClassFile(ClassFile classFile) {
        ClassWriter classWriter = ClassWriter.instance(this.context);
        classWriter.setClassFile(classFile);
    }

    protected void setMethod(Method method) {
        ClassWriter classWriter = ClassWriter.instance(this.context);
        classWriter.setMethod(method);
    }

    protected void write(Attribute attribute) {
        AttributeWriter attributeWriter = AttributeWriter.instance(this.context);
        ClassWriter classWriter = ClassWriter.instance(this.context);
        ClassFile classFile = classWriter.getClassFile();
        attributeWriter.write((Object)classFile, attribute, classFile.constant_pool);
    }

    protected void write(Attributes attributes) {
        AttributeWriter attributeWriter = AttributeWriter.instance(this.context);
        ClassWriter classWriter = ClassWriter.instance(this.context);
        ClassFile classFile = classWriter.getClassFile();
        attributeWriter.write((Object)classFile, attributes, classFile.constant_pool);
    }

    protected void write(ConstantPool constantPool) {
        ConstantWriter constantWriter = ConstantWriter.instance(this.context);
        constantWriter.writeConstantPool(constantPool);
    }

    protected void write(ConstantPool constantPool, int n) {
        ConstantWriter constantWriter = ConstantWriter.instance(this.context);
        constantWriter.write(n);
    }

    protected void write(ConstantPool.CPInfo cPInfo) {
        ConstantWriter constantWriter = ConstantWriter.instance(this.context);
        constantWriter.println(cPInfo);
    }

    protected void write(Field field) {
        ClassWriter classWriter = ClassWriter.instance(this.context);
        classWriter.writeField(field);
    }

    protected void write(Method method) {
        ClassWriter classWriter = ClassWriter.instance(this.context);
        classWriter.writeMethod(method);
    }

    private JavaFileManager getDefaultFileManager(DiagnosticListener<? super JavaFileObject> diagnosticListener, PrintWriter printWriter) {
        if (this.defaultFileManager == null) {
            this.defaultFileManager = JavapFileManager.create(diagnosticListener, printWriter);
        }
        return this.defaultFileManager;
    }

    private JavaFileObject getClassFileObject(String string) throws IOException {
        JavaFileObject javaFileObject = this.fileManager.getJavaFileForInput(StandardLocation.PLATFORM_CLASS_PATH, string, JavaFileObject.Kind.CLASS);
        if (javaFileObject == null) {
            javaFileObject = this.fileManager.getJavaFileForInput(StandardLocation.CLASS_PATH, string, JavaFileObject.Kind.CLASS);
        }
        return javaFileObject;
    }

    private void showHelp() {
        this.printLines(this.getMessage("main.usage", progname));
        Object[] objectArray = recognizedOptions;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Option option = objectArray[i];
            Object object = option.aliases[0].substring(1);
            if (((String)object).startsWith("X") || ((String)object).equals("fullversion") || ((String)object).equals("h") || ((String)object).equals("verify")) continue;
            this.printLines(this.getMessage("main.opt." + (String)object, new Object[0]));
        }
        for (Object object : objectArray = new String[]{"-classpath", "-cp", "-bootclasspath"}) {
            if (this.fileManager.isSupportedOption((String)object) == -1) continue;
            String string = ((String)object).substring(1);
            this.printLines(this.getMessage("main.opt." + string, new Object[0]));
        }
    }

    private void showVersion(boolean bl) {
        this.printLines(this.version(bl ? "full" : "release"));
    }

    private void printLines(String string) {
        this.log.println(string.replace("\n", nl));
    }

    private String version(String string) {
        if (versionRB == null) {
            try {
                versionRB = ResourceBundle.getBundle(versionRBName);
            }
            catch (MissingResourceException missingResourceException) {
                return this.getMessage("version.resource.missing", System.getProperty("java.version"));
            }
        }
        try {
            return versionRB.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return this.getMessage("version.unknown", System.getProperty("java.version"));
        }
    }

    private void reportError(String string, Object ... objectArray) {
        this.diagnosticListener.report(this.createDiagnostic(Diagnostic.Kind.ERROR, string, objectArray));
    }

    private void reportNote(String string, Object ... objectArray) {
        this.diagnosticListener.report(this.createDiagnostic(Diagnostic.Kind.NOTE, string, objectArray));
    }

    private void reportWarning(String string, Object ... objectArray) {
        this.diagnosticListener.report(this.createDiagnostic(Diagnostic.Kind.WARNING, string, objectArray));
    }

    private Diagnostic<JavaFileObject> createDiagnostic(final Diagnostic.Kind kind, final String string, final Object ... objectArray) {
        return new Diagnostic<JavaFileObject>(){

            @Override
            public Diagnostic.Kind getKind() {
                return kind;
            }

            @Override
            public JavaFileObject getSource() {
                return null;
            }

            @Override
            public long getPosition() {
                return -1L;
            }

            @Override
            public long getStartPosition() {
                return -1L;
            }

            @Override
            public long getEndPosition() {
                return -1L;
            }

            @Override
            public long getLineNumber() {
                return -1L;
            }

            @Override
            public long getColumnNumber() {
                return -1L;
            }

            @Override
            public String getCode() {
                return string;
            }

            @Override
            public String getMessage(Locale locale) {
                return JavapTask.this.getMessage(locale, string, objectArray);
            }

            public String toString() {
                return this.getClass().getName() + "[key=" + string + ",args=" + Arrays.asList(objectArray) + "]";
            }
        };
    }

    @Override
    public String getMessage(String string, Object ... objectArray) {
        return this.getMessage(this.task_locale, string, objectArray);
    }

    @Override
    public String getMessage(Locale locale, String string, Object ... objectArray) {
        ResourceBundle resourceBundle;
        if (this.bundles == null) {
            this.bundles = new HashMap<Locale, ResourceBundle>();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((resourceBundle = this.bundles.get(locale)) == null) {
            try {
                resourceBundle = ResourceBundle.getBundle("com.sun.tools.javap.resources.javap", locale);
                this.bundles.put(locale, resourceBundle);
            }
            catch (MissingResourceException missingResourceException) {
                throw new InternalError(new Object[]{"Cannot find javap resource bundle for locale " + locale});
            }
        }
        try {
            return MessageFormat.format(resourceBundle.getString(string), objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            throw new InternalError(missingResourceException, string);
        }
    }

    private static class SizeInputStream
    extends FilterInputStream {
        private int size;

        SizeInputStream(InputStream inputStream) {
            super(inputStream);
        }

        int size() {
            return this.size;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = super.read(byArray, n, n2);
            if (n3 > 0) {
                this.size += n3;
            }
            return n3;
        }

        @Override
        public int read() throws IOException {
            int n = super.read();
            ++this.size;
            return n;
        }
    }

    public static class ClassFileInfo {
        public final JavaFileObject fo;
        public final ClassFile cf;
        public final byte[] digest;
        public final int size;

        ClassFileInfo(JavaFileObject javaFileObject, ClassFile classFile, byte[] byArray, int n) {
            this.fo = javaFileObject;
            this.cf = classFile;
            this.digest = byArray;
            this.size = n;
        }
    }

    static abstract class Option {
        final boolean hasArg;
        final String[] aliases;

        Option(boolean bl, String ... stringArray) {
            this.hasArg = bl;
            this.aliases = stringArray;
        }

        boolean matches(String string) {
            for (String string2 : this.aliases) {
                if (!string2.equals(string)) continue;
                return true;
            }
            return false;
        }

        boolean ignoreRest() {
            return false;
        }

        abstract void process(JavapTask var1, String var2, String var3) throws BadArgs;
    }

    public class BadArgs
    extends Exception {
        static final long serialVersionUID = 8765093759964640721L;
        final String key;
        final Object[] args;
        boolean showUsage;

        BadArgs(String string, Object ... objectArray) {
            super(JavapTask.this.getMessage(string, objectArray));
            this.key = string;
            this.args = objectArray;
        }

        BadArgs showUsage(boolean bl) {
            this.showUsage = bl;
            return this;
        }
    }
}

