/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javap;

import com.sun.tools.classfile.AttributeException;
import com.sun.tools.classfile.ConstantPoolException;
import com.sun.tools.classfile.DescriptorException;
import com.sun.tools.javap.Context;
import com.sun.tools.javap.Messages;
import com.sun.tools.javap.Options;
import java.io.PrintWriter;

public class BasicWriter {
    private String[] spaces = new String[80];
    private LineWriter lineWriter;
    private PrintWriter out;
    protected Messages messages;

    protected BasicWriter(Context context) {
        this.lineWriter = LineWriter.instance(context);
        this.out = context.get(PrintWriter.class);
        this.messages = context.get(Messages.class);
        if (this.messages == null) {
            throw new AssertionError();
        }
    }

    protected void print(String string) {
        this.lineWriter.print(string);
    }

    protected void print(Object object) {
        this.lineWriter.print(object == null ? null : object.toString());
    }

    protected void println() {
        this.lineWriter.println();
    }

    protected void println(String string) {
        this.lineWriter.print(string);
        this.lineWriter.println();
    }

    protected void println(Object object) {
        this.lineWriter.print(object == null ? null : object.toString());
        this.lineWriter.println();
    }

    protected void indent(int n) {
        this.lineWriter.indent(n);
    }

    protected void tab() {
        this.lineWriter.tab();
    }

    protected void setPendingNewline(boolean bl) {
        this.lineWriter.pendingNewline = bl;
    }

    protected String report(AttributeException attributeException) {
        this.out.println("Error: " + attributeException.getMessage());
        return "???";
    }

    protected String report(ConstantPoolException constantPoolException) {
        this.out.println("Error: " + constantPoolException.getMessage());
        return "???";
    }

    protected String report(DescriptorException descriptorException) {
        this.out.println("Error: " + descriptorException.getMessage());
        return "???";
    }

    protected String report(String string) {
        this.out.println("Error: " + string);
        return "???";
    }

    protected String space(int n) {
        if (n < this.spaces.length && this.spaces[n] != null) {
            return this.spaces[n];
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(" ");
        }
        String string = stringBuilder.toString();
        if (n < this.spaces.length) {
            this.spaces[n] = string;
        }
        return string;
    }

    private static class LineWriter {
        private final PrintWriter out;
        private final StringBuilder buffer;
        private int indentCount;
        private final int indentWidth;
        private final int tabColumn;
        private boolean pendingNewline;
        private int pendingSpaces;

        static LineWriter instance(Context context) {
            LineWriter lineWriter = context.get(LineWriter.class);
            if (lineWriter == null) {
                lineWriter = new LineWriter(context);
            }
            return lineWriter;
        }

        protected LineWriter(Context context) {
            context.put(LineWriter.class, this);
            Options options = Options.instance(context);
            this.indentWidth = options.indentWidth;
            this.tabColumn = options.tabColumn;
            this.out = context.get(PrintWriter.class);
            this.buffer = new StringBuilder();
        }

        protected void print(String string) {
            if (this.pendingNewline) {
                this.println();
                this.pendingNewline = false;
            }
            if (string == null) {
                string = "null";
            }
            block4: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case ' ': {
                        ++this.pendingSpaces;
                        continue block4;
                    }
                    case '\n': {
                        this.println();
                        continue block4;
                    }
                    default: {
                        if (this.buffer.length() == 0) {
                            this.indent();
                        }
                        if (this.pendingSpaces > 0) {
                            for (int j = 0; j < this.pendingSpaces; ++j) {
                                this.buffer.append(' ');
                            }
                            this.pendingSpaces = 0;
                        }
                        this.buffer.append(c);
                    }
                }
            }
        }

        protected void println() {
            this.pendingSpaces = 0;
            this.out.println(this.buffer);
            this.buffer.setLength(0);
        }

        protected void indent(int n) {
            this.indentCount += n;
        }

        protected void tab() {
            int n = this.indentCount * this.indentWidth + this.tabColumn;
            this.pendingSpaces += n <= this.buffer.length() ? 1 : n - this.buffer.length();
        }

        private void indent() {
            this.pendingSpaces += this.indentCount * this.indentWidth;
        }
    }
}

