/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.javadoc.AnnotatedType;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ParameterizedType;
import com.sun.javadoc.TypeVariable;
import com.sun.javadoc.WildcardType;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.util.List;
import com.sun.tools.javadoc.AnnotatedTypeImpl;
import com.sun.tools.javadoc.ClassDocImpl;
import com.sun.tools.javadoc.DocEnv;
import com.sun.tools.javadoc.ParameterizedTypeImpl;
import com.sun.tools.javadoc.PrimitiveType;
import com.sun.tools.javadoc.TypeVariableImpl;
import com.sun.tools.javadoc.WildcardTypeImpl;

public class TypeMaker {
    public static com.sun.javadoc.Type getType(DocEnv docEnv, Type type) {
        return TypeMaker.getType(docEnv, type, true);
    }

    public static com.sun.javadoc.Type getType(DocEnv docEnv, Type type, boolean bl) {
        return TypeMaker.getType(docEnv, type, bl, true);
    }

    public static com.sun.javadoc.Type getType(DocEnv docEnv, Type type, boolean bl, boolean bl2) {
        try {
            return TypeMaker.getTypeImpl(docEnv, type, bl, bl2);
        }
        catch (Symbol.CompletionFailure completionFailure) {
            return TypeMaker.getType(docEnv, type, bl, bl2);
        }
    }

    private static com.sun.javadoc.Type getTypeImpl(DocEnv docEnv, Type type, boolean bl, boolean bl2) {
        if (docEnv.legacyDoclet) {
            type = docEnv.types.erasure(type);
        }
        if (bl2 && type.isAnnotated()) {
            return new AnnotatedTypeImpl(docEnv, type);
        }
        switch (type.getTag()) {
            case CLASS: {
                if (ClassDocImpl.isGeneric((Symbol.ClassSymbol)type.tsym)) {
                    return docEnv.getParameterizedType((Type.ClassType)type);
                }
                return docEnv.getClassDoc((Symbol.ClassSymbol)type.tsym);
            }
            case WILDCARD: {
                Type.WildcardType wildcardType = (Type.WildcardType)type;
                return new WildcardTypeImpl(docEnv, wildcardType);
            }
            case TYPEVAR: {
                return new TypeVariableImpl(docEnv, (Type.TypeVar)type);
            }
            case ARRAY: {
                return new ArrayTypeImpl(docEnv, type);
            }
            case BYTE: {
                return PrimitiveType.byteType;
            }
            case CHAR: {
                return PrimitiveType.charType;
            }
            case SHORT: {
                return PrimitiveType.shortType;
            }
            case INT: {
                return PrimitiveType.intType;
            }
            case LONG: {
                return PrimitiveType.longType;
            }
            case FLOAT: {
                return PrimitiveType.floatType;
            }
            case DOUBLE: {
                return PrimitiveType.doubleType;
            }
            case BOOLEAN: {
                return PrimitiveType.booleanType;
            }
            case VOID: {
                return PrimitiveType.voidType;
            }
            case ERROR: {
                if (!bl) break;
                return docEnv.getClassDoc((Symbol.ClassSymbol)type.tsym);
            }
        }
        return new PrimitiveType(type.tsym.getQualifiedName().toString());
    }

    public static com.sun.javadoc.Type[] getTypes(DocEnv docEnv, List<Type> list) {
        return TypeMaker.getTypes(docEnv, list, new com.sun.javadoc.Type[list.length()]);
    }

    public static com.sun.javadoc.Type[] getTypes(DocEnv docEnv, List<Type> list, com.sun.javadoc.Type[] typeArray) {
        int n = 0;
        for (Type type : list) {
            typeArray[n++] = TypeMaker.getType(docEnv, type);
        }
        return typeArray;
    }

    public static String getTypeName(Type type, boolean bl) {
        switch (type.getTag()) {
            case ARRAY: {
                StringBuilder stringBuilder = new StringBuilder();
                while (type.hasTag(TypeTag.ARRAY)) {
                    stringBuilder.append("[]");
                    type = ((Type.ArrayType)type).elemtype;
                }
                stringBuilder.insert(0, TypeMaker.getTypeName(type, bl));
                return stringBuilder.toString();
            }
            case CLASS: {
                return ClassDocImpl.getClassName((Symbol.ClassSymbol)type.tsym, bl);
            }
        }
        return type.tsym.getQualifiedName().toString();
    }

    static String getTypeString(DocEnv docEnv, Type type, boolean bl) {
        if (type.isAnnotated()) {
            type = type.unannotatedType();
        }
        switch (type.getTag()) {
            case ARRAY: {
                StringBuilder stringBuilder = new StringBuilder();
                while (type.hasTag(TypeTag.ARRAY)) {
                    stringBuilder.append("[]");
                    type = docEnv.types.elemtype(type);
                }
                stringBuilder.insert(0, TypeMaker.getTypeString(docEnv, type, bl));
                return stringBuilder.toString();
            }
            case CLASS: {
                return ParameterizedTypeImpl.parameterizedTypeToString(docEnv, (Type.ClassType)type, bl);
            }
            case WILDCARD: {
                Type.WildcardType wildcardType = (Type.WildcardType)type;
                return WildcardTypeImpl.wildcardTypeToString(docEnv, wildcardType, bl);
            }
        }
        return type.tsym.getQualifiedName().toString();
    }

    static String typeParametersString(DocEnv docEnv, Symbol symbol, boolean bl) {
        if (docEnv.legacyDoclet || symbol.type.getTypeArguments().isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Type type : symbol.type.getTypeArguments()) {
            stringBuilder.append(stringBuilder.length() == 0 ? "<" : ", ");
            stringBuilder.append(TypeVariableImpl.typeVarToString(docEnv, (Type.TypeVar)type, bl));
        }
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    static String typeArgumentsString(DocEnv docEnv, Type.ClassType classType, boolean bl) {
        if (docEnv.legacyDoclet || ((List)classType.getTypeArguments()).isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Type type : classType.getTypeArguments()) {
            stringBuilder.append(stringBuilder.length() == 0 ? "<" : ", ");
            stringBuilder.append(TypeMaker.getTypeString(docEnv, type, bl));
        }
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    private static class ArrayTypeImpl
    implements com.sun.javadoc.Type {
        Type arrayType;
        DocEnv env;
        private com.sun.javadoc.Type skipArraysCache = null;

        ArrayTypeImpl(DocEnv docEnv, Type type) {
            this.env = docEnv;
            this.arrayType = type;
        }

        @Override
        public com.sun.javadoc.Type getElementType() {
            return TypeMaker.getType(this.env, this.env.types.elemtype(this.arrayType));
        }

        private com.sun.javadoc.Type skipArrays() {
            if (this.skipArraysCache == null) {
                Type type = this.arrayType;
                while (type.hasTag(TypeTag.ARRAY)) {
                    type = this.env.types.elemtype(type);
                }
                this.skipArraysCache = TypeMaker.getType(this.env, type);
            }
            return this.skipArraysCache;
        }

        @Override
        public String dimension() {
            StringBuilder stringBuilder = new StringBuilder();
            Type type = this.arrayType;
            while (type.hasTag(TypeTag.ARRAY)) {
                stringBuilder.append("[]");
                type = this.env.types.elemtype(type);
            }
            return stringBuilder.toString();
        }

        @Override
        public String typeName() {
            return this.skipArrays().typeName();
        }

        @Override
        public String qualifiedTypeName() {
            return this.skipArrays().qualifiedTypeName();
        }

        @Override
        public String simpleTypeName() {
            return this.skipArrays().simpleTypeName();
        }

        @Override
        public ClassDoc asClassDoc() {
            return this.skipArrays().asClassDoc();
        }

        @Override
        public ParameterizedType asParameterizedType() {
            return this.skipArrays().asParameterizedType();
        }

        @Override
        public TypeVariable asTypeVariable() {
            return this.skipArrays().asTypeVariable();
        }

        @Override
        public WildcardType asWildcardType() {
            return null;
        }

        @Override
        public AnnotatedType asAnnotatedType() {
            return null;
        }

        @Override
        public AnnotationTypeDoc asAnnotationTypeDoc() {
            return this.skipArrays().asAnnotationTypeDoc();
        }

        @Override
        public boolean isPrimitive() {
            return this.skipArrays().isPrimitive();
        }

        @Override
        public String toString() {
            return this.qualifiedTypeName() + this.dimension();
        }
    }
}

