/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.SeeTag;
import com.sun.tools.javac.code.Printer;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.LayoutCharacters;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javadoc.ClassDocImpl;
import com.sun.tools.javadoc.ConstructorDocImpl;
import com.sun.tools.javadoc.DocImpl;
import com.sun.tools.javadoc.FieldDocImpl;
import com.sun.tools.javadoc.MethodDocImpl;
import com.sun.tools.javadoc.PackageDocImpl;
import com.sun.tools.javadoc.TagImpl;
import java.io.File;
import java.util.Locale;

class SeeTagImpl
extends TagImpl
implements SeeTag,
LayoutCharacters {
    private String where;
    private String what;
    private PackageDoc referencedPackage;
    private ClassDoc referencedClass;
    private MemberDoc referencedMember;
    String label = "";
    private static final boolean showRef = false;

    SeeTagImpl(DocImpl docImpl, String string, String string2) {
        super(docImpl, string, string2);
        this.parseSeeString();
        if (this.where != null) {
            ClassDocImpl classDocImpl = null;
            if (docImpl instanceof MemberDoc) {
                classDocImpl = (ClassDocImpl)((ProgramElementDoc)((Object)docImpl)).containingClass();
            } else if (docImpl instanceof ClassDoc) {
                classDocImpl = (ClassDocImpl)docImpl;
            }
            this.findReferenced(classDocImpl);
        }
    }

    private void showRef() {
        Symbol symbol;
        if (this.referencedMember != null) {
            symbol = this.referencedMember instanceof MethodDocImpl ? ((MethodDocImpl)this.referencedMember).sym : (this.referencedMember instanceof FieldDocImpl ? ((FieldDocImpl)this.referencedMember).sym : ((ConstructorDocImpl)this.referencedMember).sym);
        } else if (this.referencedClass != null) {
            symbol = ((ClassDocImpl)this.referencedClass).tsym;
        } else if (this.referencedPackage != null) {
            symbol = ((PackageDocImpl)this.referencedPackage).sym;
        } else {
            return;
        }
        final JavacMessages javacMessages = JavacMessages.instance(this.docenv().context);
        Locale locale = Locale.getDefault();
        Printer printer = new Printer(){
            int count;

            @Override
            protected String localize(Locale locale, String string, Object ... objectArray) {
                return javacMessages.getLocalizedString(locale, string, objectArray);
            }

            @Override
            protected String capturedVarId(Type.CapturedType capturedType, Locale locale) {
                return "CAP#" + ++this.count;
            }
        };
        String string = this.text.replaceAll("\\s+", " ");
        int n = string.indexOf(" ");
        int n2 = string.indexOf("(");
        int n3 = string.indexOf(")");
        String string2 = n == -1 ? string : (n2 == -1 || n < n2 ? string.substring(0, n) : string.substring(0, n3 + 1));
        File file = new File(this.holder.position().file().getAbsoluteFile().toURI().normalize());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("+++ ").append(file).append(": ").append(this.name()).append(" ").append(string2).append(": ");
        stringBuilder.append((Object)symbol.getKind()).append(" ");
        if (symbol.kind == 16 || symbol.kind == 4) {
            stringBuilder.append(printer.visit(symbol.owner, locale)).append(".");
        }
        stringBuilder.append(printer.visit(symbol, locale));
        System.err.println(stringBuilder);
    }

    @Override
    public String referencedClassName() {
        return this.where;
    }

    @Override
    public PackageDoc referencedPackage() {
        return this.referencedPackage;
    }

    @Override
    public ClassDoc referencedClass() {
        return this.referencedClass;
    }

    @Override
    public String referencedMemberName() {
        return this.what;
    }

    @Override
    public MemberDoc referencedMember() {
        return this.referencedMember;
    }

    private void parseSeeString() {
        int n;
        int n2;
        int n3;
        int n4 = this.text.length();
        if (n4 == 0) {
            return;
        }
        switch (this.text.charAt(0)) {
            case '<': {
                if (this.text.charAt(n4 - 1) != '>') {
                    this.docenv().warning(this.holder, "tag.see.no_close_bracket_on_url", this.name, this.text);
                }
                return;
            }
            case '\"': {
                if (n4 == 1 || this.text.charAt(n4 - 1) != '\"') {
                    this.docenv().warning(this.holder, "tag.see.no_close_quote", this.name, this.text);
                }
                return;
            }
        }
        int n5 = 0;
        int n6 = 0;
        block11: for (int i = n2 = 0; i < n4; i += Character.charCount(n3)) {
            n3 = this.text.codePointAt(i);
            switch (n3) {
                case 40: {
                    ++n5;
                    continue block11;
                }
                case 41: {
                    --n5;
                    continue block11;
                }
                case 35: 
                case 46: 
                case 91: 
                case 93: {
                    continue block11;
                }
                case 44: {
                    if (n5 > 0) continue block11;
                    this.docenv().warning(this.holder, "tag.see.malformed_see_tag", this.name, this.text);
                    return;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    if (n5 != 0) continue block11;
                    n6 = i;
                    i = n4;
                    continue block11;
                }
                default: {
                    if (Character.isJavaIdentifierPart(n3)) continue block11;
                    this.docenv().warning(this.holder, "tag.see.illegal_character", this.name, "" + n3, this.text);
                }
            }
        }
        if (n5 != 0) {
            this.docenv().warning(this.holder, "tag.see.malformed_see_tag", this.name, this.text);
            return;
        }
        String string = "";
        String string2 = "";
        if (n6 > 0) {
            string = this.text.substring(n2, n6);
            string2 = this.text.substring(n6 + 1);
            for (n = 0; n < string2.length(); ++n) {
                char c = string2.charAt(n);
                if (c == ' ' || c == '\t' || c == '\n') continue;
                this.label = string2.substring(n);
                break;
            }
        } else {
            string = this.text;
            this.label = "";
        }
        if ((n = string.indexOf(35)) >= 0) {
            this.where = string.substring(0, n);
            this.what = string.substring(n + 1);
        } else if (string.indexOf(40) >= 0) {
            this.docenv().warning(this.holder, "tag.see.missing_sharp", this.name, this.text);
            this.where = "";
            this.what = string;
        } else {
            this.where = string;
            this.what = null;
        }
    }

    private void findReferenced(ClassDocImpl classDocImpl) {
        String string;
        if (this.where.length() > 0) {
            this.referencedClass = classDocImpl != null ? classDocImpl.findClass(this.where) : this.docenv().lookupClass(this.where);
            if (this.referencedClass == null && this.holder() instanceof ProgramElementDoc) {
                this.referencedClass = this.docenv().lookupClass(((ProgramElementDoc)this.holder()).containingPackage().name() + "." + this.where);
            }
            if (this.referencedClass == null) {
                this.referencedPackage = this.docenv().lookupPackage(this.where);
                return;
            }
        } else {
            if (classDocImpl == null) {
                this.docenv().warning(this.holder, "tag.see.class_not_specified", this.name, this.text);
                return;
            }
            this.referencedClass = classDocImpl;
        }
        this.where = this.referencedClass.qualifiedName();
        if (this.what == null) {
            return;
        }
        int n = this.what.indexOf(40);
        String string2 = string = n >= 0 ? this.what.substring(0, n) : this.what;
        if (n > 0) {
            String[] stringArray = new ParameterParseMachine(this.what.substring(n, this.what.length())).parseParameters();
            this.referencedMember = stringArray != null ? this.findExecutableMember(string, stringArray, this.referencedClass) : null;
        } else {
            this.referencedMember = this.findExecutableMember(string, null, this.referencedClass);
            FieldDoc fieldDoc = ((ClassDocImpl)this.referencedClass).findField(string);
            if (this.referencedMember == null || fieldDoc != null && fieldDoc.containingClass().subclassOf(this.referencedMember.containingClass())) {
                this.referencedMember = fieldDoc;
            }
        }
        if (this.referencedMember == null) {
            this.docenv().warning(this.holder, "tag.see.can_not_find_member", this.name, this.what, this.where);
        }
    }

    private MemberDoc findReferencedMethod(String string, String[] stringArray, ClassDoc classDoc) {
        MemberDoc memberDoc = this.findExecutableMember(string, stringArray, classDoc);
        ClassDoc[] classDocArray = classDoc.innerClasses();
        if (memberDoc == null) {
            for (int i = 0; i < classDocArray.length; ++i) {
                memberDoc = this.findReferencedMethod(string, stringArray, classDocArray[i]);
                if (memberDoc == null) continue;
                return memberDoc;
            }
        }
        return null;
    }

    private MemberDoc findExecutableMember(String string, String[] stringArray, ClassDoc classDoc) {
        if (string.equals(classDoc.name())) {
            return ((ClassDocImpl)classDoc).findConstructor(string, stringArray);
        }
        return ((ClassDocImpl)classDoc).findMethod(string, stringArray);
    }

    @Override
    public String kind() {
        return "@see";
    }

    @Override
    public String label() {
        return this.label;
    }

    class ParameterParseMachine {
        static final int START = 0;
        static final int TYPE = 1;
        static final int NAME = 2;
        static final int TNSPACE = 3;
        static final int ARRAYDECORATION = 4;
        static final int ARRAYSPACE = 5;
        String parameters;
        StringBuilder typeId;
        ListBuffer<String> paramList;

        ParameterParseMachine(String string) {
            this.parameters = string;
            this.paramList = new ListBuffer();
            this.typeId = new StringBuilder();
        }

        public String[] parseParameters() {
            int n;
            if (this.parameters.equals("()")) {
                return new String[0];
            }
            int n2 = 0;
            int n3 = 0;
            this.parameters = this.parameters.substring(1, this.parameters.length() - 1);
            block7: for (int i = 0; i < this.parameters.length(); i += Character.charCount(n)) {
                n = this.parameters.codePointAt(i);
                switch (n2) {
                    case 0: {
                        if (Character.isJavaIdentifierStart(n)) {
                            this.typeId.append(Character.toChars(n));
                            n2 = 1;
                        }
                        n3 = 0;
                        continue block7;
                    }
                    case 1: {
                        if (Character.isJavaIdentifierPart(n) || n == 46) {
                            this.typeId.append(Character.toChars(n));
                        } else if (n == 91) {
                            this.typeId.append('[');
                            n2 = 4;
                        } else if (Character.isWhitespace(n)) {
                            n2 = 3;
                        } else if (n == 44) {
                            this.addTypeToParamList();
                            n2 = 0;
                        }
                        n3 = 1;
                        continue block7;
                    }
                    case 3: {
                        if (Character.isJavaIdentifierStart(n)) {
                            if (n3 == 4) {
                                SeeTagImpl.this.docenv().warning(SeeTagImpl.this.holder, "tag.missing_comma_space", SeeTagImpl.this.name, "(" + this.parameters + ")");
                                return null;
                            }
                            this.addTypeToParamList();
                            n2 = 2;
                        } else if (n == 91) {
                            this.typeId.append('[');
                            n2 = 4;
                        } else if (n == 44) {
                            this.addTypeToParamList();
                            n2 = 0;
                        }
                        n3 = 3;
                        continue block7;
                    }
                    case 4: {
                        if (n == 93) {
                            this.typeId.append(']');
                            n2 = 3;
                        } else if (!Character.isWhitespace(n)) {
                            SeeTagImpl.this.docenv().warning(SeeTagImpl.this.holder, "tag.illegal_char_in_arr_dim", SeeTagImpl.this.name, "(" + this.parameters + ")");
                            return null;
                        }
                        n3 = 4;
                        continue block7;
                    }
                    case 2: {
                        if (n == 44) {
                            n2 = 0;
                        }
                        n3 = 2;
                    }
                }
            }
            if (n2 == 4 || n2 == 0 && n3 == 3) {
                SeeTagImpl.this.docenv().warning(SeeTagImpl.this.holder, "tag.illegal_see_tag", "(" + this.parameters + ")");
            }
            if (this.typeId.length() > 0) {
                this.paramList.append(this.typeId.toString());
            }
            return this.paramList.toArray(new String[this.paramList.length()]);
        }

        void addTypeToParamList() {
            if (this.typeId.length() > 0) {
                this.paramList.append(this.typeId.toString());
                this.typeId.setLength(0);
            }
        }
    }
}

