/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javadoc.ClassDocImpl;
import com.sun.tools.javadoc.DocEnv;
import com.sun.tools.javadoc.DocImpl;
import com.sun.tools.javadoc.JavaScriptScanner;
import com.sun.tools.javadoc.PackageDocImpl;
import com.sun.tools.javadoc.SourcePositionImpl;
import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;

public class RootDocImpl
extends DocImpl
implements RootDoc {
    private List<ClassDocImpl> cmdLineClasses;
    private List<PackageDocImpl> cmdLinePackages;
    private List<String[]> options;

    public RootDocImpl(DocEnv docEnv, List<JCTree.JCClassDecl> list, List<String> list2, List<String[]> list3) {
        super(docEnv, null);
        this.options = list3;
        this.setPackages(docEnv, list2);
        this.setClasses(docEnv, list);
    }

    public RootDocImpl(DocEnv docEnv, List<String> list, List<String[]> list2) {
        super(docEnv, null);
        this.options = list2;
        this.cmdLinePackages = List.nil();
        ListBuffer<ClassDocImpl> listBuffer = new ListBuffer<ClassDocImpl>();
        for (String string : list) {
            ClassDocImpl classDocImpl = docEnv.loadClass(string);
            if (classDocImpl == null) {
                docEnv.error(null, "javadoc.class_not_found", string);
                continue;
            }
            listBuffer = listBuffer.append(classDocImpl);
        }
        this.cmdLineClasses = listBuffer.toList();
    }

    private void setClasses(DocEnv docEnv, List<JCTree.JCClassDecl> list) {
        ListBuffer<ClassDocImpl> listBuffer = new ListBuffer<ClassDocImpl>();
        for (JCTree.JCClassDecl jCClassDecl : list) {
            ClassDocImpl classDocImpl;
            if (!docEnv.shouldDocument(jCClassDecl.sym) || (classDocImpl = docEnv.getClassDoc(jCClassDecl.sym)) == null) continue;
            classDocImpl.isIncluded = true;
            listBuffer.append(classDocImpl);
        }
        this.cmdLineClasses = listBuffer.toList();
    }

    private void setPackages(DocEnv docEnv, List<String> list) {
        ListBuffer<PackageDocImpl> listBuffer = new ListBuffer<PackageDocImpl>();
        for (String string : list) {
            PackageDocImpl packageDocImpl = docEnv.lookupPackage(string);
            if (packageDocImpl != null) {
                packageDocImpl.isIncluded = true;
                listBuffer.append(packageDocImpl);
                continue;
            }
            docEnv.warning(null, "main.no_source_files_for_package", string);
        }
        this.cmdLinePackages = listBuffer.toList();
    }

    @Override
    public String[][] options() {
        return (String[][])this.options.toArray((T[])new String[this.options.length()][]);
    }

    @Override
    public PackageDoc[] specifiedPackages() {
        return this.cmdLinePackages.toArray(new PackageDocImpl[this.cmdLinePackages.length()]);
    }

    @Override
    public ClassDoc[] specifiedClasses() {
        ListBuffer<ClassDocImpl> listBuffer = new ListBuffer<ClassDocImpl>();
        for (ClassDocImpl classDocImpl : this.cmdLineClasses) {
            classDocImpl.addAllClasses(listBuffer, true);
        }
        return listBuffer.toArray(new ClassDocImpl[listBuffer.length()]);
    }

    @Override
    public ClassDoc[] classes() {
        ListBuffer<ClassDocImpl> listBuffer = new ListBuffer<ClassDocImpl>();
        for (ClassDocImpl docImpl : this.cmdLineClasses) {
            docImpl.addAllClasses(listBuffer, true);
        }
        for (PackageDocImpl packageDocImpl : this.cmdLinePackages) {
            packageDocImpl.addAllClassesTo(listBuffer);
        }
        return listBuffer.toArray(new ClassDocImpl[listBuffer.length()]);
    }

    @Override
    public ClassDoc classNamed(String string) {
        return this.env.lookupClass(string);
    }

    @Override
    public PackageDoc packageNamed(String string) {
        return this.env.lookupPackage(string);
    }

    @Override
    public String name() {
        return "*RootDocImpl*";
    }

    @Override
    public String qualifiedName() {
        return "*RootDocImpl*";
    }

    @Override
    public boolean isIncluded() {
        return false;
    }

    @Override
    public void printError(String string) {
        this.env.printError(string);
    }

    @Override
    public void printError(SourcePosition sourcePosition, String string) {
        this.env.printError(sourcePosition, string);
    }

    @Override
    public void printWarning(String string) {
        this.env.printWarning(string);
    }

    @Override
    public void printWarning(SourcePosition sourcePosition, String string) {
        this.env.printWarning(sourcePosition, string);
    }

    @Override
    public void printNotice(String string) {
        this.env.printNotice(string);
    }

    @Override
    public void printNotice(SourcePosition sourcePosition, String string) {
        this.env.printNotice(sourcePosition, string);
    }

    private JavaFileObject getOverviewPath() {
        for (String[] stringArray : this.options) {
            if (!stringArray[0].equals("-overview") || !(this.env.fileManager instanceof StandardJavaFileManager)) continue;
            StandardJavaFileManager standardJavaFileManager = (StandardJavaFileManager)this.env.fileManager;
            return standardJavaFileManager.getJavaFileObjects(stringArray[1]).iterator().next();
        }
        return null;
    }

    @Override
    protected String documentation() {
        if (this.documentation == null) {
            JavaFileObject javaFileObject = this.getOverviewPath();
            if (javaFileObject == null) {
                this.documentation = "";
            } else {
                try {
                    this.documentation = this.readHTMLDocumentation(javaFileObject.openInputStream(), javaFileObject);
                }
                catch (IOException iOException) {
                    this.documentation = "";
                    this.env.error(null, "javadoc.File_Read_Error", javaFileObject.getName());
                }
            }
        }
        return this.documentation;
    }

    @Override
    public SourcePosition position() {
        JavaFileObject javaFileObject = this.getOverviewPath();
        return javaFileObject == null ? null : SourcePositionImpl.make(javaFileObject, -1, null);
    }

    public Locale getLocale() {
        return this.env.doclocale.locale;
    }

    public JavaFileManager getFileManager() {
        return this.env.fileManager;
    }

    public void initDocLint(Collection<String> collection, Collection<String> collection2) {
        this.env.initDoclint(collection, collection2);
    }

    public JavaScriptScanner initJavaScriptScanner(boolean bl) {
        return this.env.initJavaScriptScanner(bl);
    }

    public boolean isFunctionalInterface(AnnotationDesc annotationDesc) {
        return annotationDesc.annotationType().qualifiedName().equals(this.env.syms.functionalInterfaceType.toString()) && this.env.source.allowLambda();
    }

    public boolean showTagMessages() {
        return this.env.showTagMessages();
    }
}

