/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.comp.MemberEnter;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javadoc.ClassDocImpl;
import com.sun.tools.javadoc.DocEnv;

public class JavadocMemberEnter
extends MemberEnter {
    final DocEnv docenv;

    public static JavadocMemberEnter instance0(Context context) {
        MemberEnter memberEnter = (MemberEnter)context.get(memberEnterKey);
        if (memberEnter == null) {
            memberEnter = new JavadocMemberEnter(context);
        }
        return (JavadocMemberEnter)memberEnter;
    }

    public static void preRegister(Context context) {
        context.put(memberEnterKey, new Context.Factory<MemberEnter>(){

            @Override
            public MemberEnter make(Context context) {
                return new JavadocMemberEnter(context);
            }
        });
    }

    protected JavadocMemberEnter(Context context) {
        super(context);
        this.docenv = DocEnv.instance(context);
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
        super.visitMethodDef(jCMethodDecl);
        Symbol.MethodSymbol methodSymbol = jCMethodDecl.sym;
        if (methodSymbol == null || methodSymbol.kind != 16) {
            return;
        }
        TreePath treePath = this.docenv.getTreePath(this.env.toplevel, this.env.enclClass, jCMethodDecl);
        if (methodSymbol.isConstructor()) {
            this.docenv.makeConstructorDoc(methodSymbol, treePath);
        } else if (JavadocMemberEnter.isAnnotationTypeElement(methodSymbol)) {
            this.docenv.makeAnnotationTypeElementDoc(methodSymbol, treePath);
        } else {
            this.docenv.makeMethodDoc(methodSymbol, treePath);
        }
        jCMethodDecl.body = null;
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
        if (jCVariableDecl.init != null) {
            boolean bl;
            boolean bl2 = bl = (jCVariableDecl.mods.flags & 0x10L) != 0L || (this.env.enclClass.mods.flags & 0x200L) != 0L;
            if (!bl || JavadocMemberEnter.containsNonConstantExpression(jCVariableDecl.init)) {
                jCVariableDecl.init = null;
            }
        }
        super.visitVarDef(jCVariableDecl);
        if (jCVariableDecl.sym != null && jCVariableDecl.sym.kind == 4 && !JavadocMemberEnter.isParameter(jCVariableDecl.sym)) {
            this.docenv.makeFieldDoc(jCVariableDecl.sym, this.docenv.getTreePath(this.env.toplevel, this.env.enclClass, jCVariableDecl));
        }
    }

    private static boolean isAnnotationTypeElement(Symbol.MethodSymbol methodSymbol) {
        return ClassDocImpl.isAnnotationType(methodSymbol.enclClass());
    }

    private static boolean isParameter(Symbol.VarSymbol varSymbol) {
        return (varSymbol.flags() & 0x200000000L) != 0L;
    }

    private static boolean containsNonConstantExpression(JCTree.JCExpression jCExpression) {
        return new MaybeConstantExpressionScanner().containsNonConstantExpression(jCExpression);
    }

    private static class MaybeConstantExpressionScanner
    extends JCTree.Visitor {
        boolean maybeConstantExpr = true;

        private MaybeConstantExpressionScanner() {
        }

        public boolean containsNonConstantExpression(JCTree.JCExpression jCExpression) {
            this.scan(jCExpression);
            return !this.maybeConstantExpr;
        }

        public void scan(JCTree jCTree) {
            if (this.maybeConstantExpr && jCTree != null) {
                jCTree.accept(this);
            }
        }

        @Override
        public void visitTree(JCTree jCTree) {
            this.maybeConstantExpr = false;
        }

        @Override
        public void visitBinary(JCTree.JCBinary jCBinary) {
            switch (jCBinary.getTag()) {
                case MUL: 
                case DIV: 
                case MOD: 
                case PLUS: 
                case MINUS: 
                case SL: 
                case SR: 
                case USR: 
                case LT: 
                case LE: 
                case GT: 
                case GE: 
                case EQ: 
                case NE: 
                case BITAND: 
                case BITXOR: 
                case BITOR: 
                case AND: 
                case OR: {
                    break;
                }
                default: {
                    this.maybeConstantExpr = false;
                }
            }
        }

        @Override
        public void visitConditional(JCTree.JCConditional jCConditional) {
            this.scan(jCConditional.cond);
            this.scan(jCConditional.truepart);
            this.scan(jCConditional.falsepart);
        }

        @Override
        public void visitIdent(JCTree.JCIdent jCIdent) {
        }

        @Override
        public void visitLiteral(JCTree.JCLiteral jCLiteral) {
        }

        @Override
        public void visitParens(JCTree.JCParens jCParens) {
            this.scan(jCParens.expr);
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
            this.scan(jCFieldAccess.selected);
        }

        @Override
        public void visitTypeCast(JCTree.JCTypeCast jCTypeCast) {
            this.scan(jCTypeCast.clazz);
            this.scan(jCTypeCast.expr);
        }

        @Override
        public void visitTypeIdent(JCTree.JCPrimitiveTypeTree jCPrimitiveTypeTree) {
        }

        @Override
        public void visitUnary(JCTree.JCUnary jCUnary) {
            switch (jCUnary.getTag()) {
                case POS: 
                case NEG: 
                case COMPL: 
                case NOT: {
                    break;
                }
                default: {
                    this.maybeConstantExpr = false;
                }
            }
        }
    }
}

