/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

@Deprecated
public class JavaScriptScanner {
    private Reporter reporter;
    protected char[] buf;
    protected int bp;
    protected int buflen;
    protected char ch;
    private boolean newline = true;
    Map<String, TagParser> tagParsers;
    Set<String> eventAttrs;
    Set<String> uriAttrs;

    public JavaScriptScanner() {
        this.initTagParsers();
        this.initEventAttrs();
        this.initURIAttrs();
    }

    public void parse(String string, Reporter reporter) {
        this.reporter = reporter;
        String string2 = string;
        this.buf = new char[string2.length() + 1];
        string2.getChars(0, string2.length(), this.buf, 0);
        this.buf[this.buf.length - 1] = 26;
        this.buflen = this.buf.length - 1;
        this.bp = -1;
        this.newline = true;
        this.nextChar();
        this.blockContent();
        this.blockTags();
    }

    private void checkHtmlTag(String string) {
        if (string.equalsIgnoreCase("script")) {
            this.reporter.report();
        }
    }

    private void checkHtmlAttr(String string, String string2) {
        String string3 = string.toLowerCase(Locale.ENGLISH);
        if (this.eventAttrs.contains(string3) || this.uriAttrs.contains(string3) && string2 != null && string2.toLowerCase(Locale.ENGLISH).trim().startsWith("javascript:")) {
            this.reporter.report();
        }
    }

    void nextChar() {
        this.ch = this.buf[this.bp < this.buflen ? (this.bp = this.bp + 1) : this.buflen];
        switch (this.ch) {
            case '\n': 
            case '\f': 
            case '\r': {
                this.newline = true;
            }
        }
    }

    protected void blockContent() {
        block9: while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                }
                case '\t': 
                case ' ': {
                    this.nextChar();
                    continue block9;
                }
                case '&': {
                    this.entity(null);
                    continue block9;
                }
                case '<': {
                    this.html();
                    continue block9;
                }
                case '>': {
                    this.newline = false;
                    this.nextChar();
                    continue block9;
                }
                case '{': {
                    this.inlineTag(null);
                    continue block9;
                }
                case '@': {
                    if (this.newline) break block9;
                }
                default: {
                    this.newline = false;
                    this.nextChar();
                    continue block9;
                }
            }
        }
    }

    protected void blockTags() {
        while (this.ch == '@') {
            this.blockTag();
        }
    }

    protected void blockTag() {
        int n = this.bp;
        try {
            this.nextChar();
            if (this.isIdentifierStart(this.ch)) {
                String string = this.readTagName();
                TagParser tagParser = this.tagParsers.get(string);
                if (tagParser == null) {
                    this.blockContent();
                } else {
                    switch (tagParser.getKind()) {
                        case BLOCK: {
                            tagParser.parse(n);
                            return;
                        }
                        case INLINE: {
                            return;
                        }
                    }
                }
            }
            this.blockContent();
        }
        catch (ParseException parseException) {
            this.blockContent();
        }
    }

    protected void inlineTag(Void void_) {
        this.newline = false;
        this.nextChar();
        if (this.ch == '@') {
            this.inlineTag();
        }
    }

    protected void inlineTag() {
        int n = this.bp - 1;
        try {
            this.nextChar();
            if (this.isIdentifierStart(this.ch)) {
                String string = this.readTagName();
                TagParser tagParser = this.tagParsers.get(string);
                if (tagParser == null) {
                    this.skipWhitespace();
                    this.inlineText(WhitespaceRetentionPolicy.REMOVE_ALL);
                    this.nextChar();
                } else {
                    this.skipWhitespace();
                    if (tagParser.getKind() == TagParser.Kind.INLINE) {
                        tagParser.parse(n);
                    } else {
                        this.inlineText(WhitespaceRetentionPolicy.REMOVE_ALL);
                        this.nextChar();
                    }
                }
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private void inlineText(WhitespaceRetentionPolicy whitespaceRetentionPolicy) throws ParseException {
        switch (whitespaceRetentionPolicy) {
            case REMOVE_ALL: {
                this.skipWhitespace();
                break;
            }
            case REMOVE_FIRST_SPACE: {
                if (this.ch != ' ') break;
                this.nextChar();
                break;
            }
        }
        int n = this.bp;
        int n2 = 1;
        block11: while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                    break;
                }
                case '\t': 
                case ' ': {
                    break;
                }
                case '{': {
                    this.newline = false;
                    ++n2;
                    break;
                }
                case '}': {
                    if (--n2 == 0) {
                        return;
                    }
                    this.newline = false;
                    break;
                }
                case '@': {
                    if (this.newline) break block11;
                    this.newline = false;
                    break;
                }
                default: {
                    this.newline = false;
                }
            }
            this.nextChar();
        }
        throw new ParseException("dc.unterminated.inline.tag");
    }

    protected void reference(boolean bl) throws ParseException {
        int n = this.bp;
        int n2 = 0;
        block8: while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                }
                case '\t': 
                case ' ': {
                    if (n2 != 0) break;
                    break block8;
                }
                case '(': 
                case '<': {
                    this.newline = false;
                    ++n2;
                    break;
                }
                case ')': 
                case '>': {
                    this.newline = false;
                    --n2;
                    break;
                }
                case '}': {
                    if (this.bp == n) {
                        return;
                    }
                    this.newline = false;
                    break block8;
                }
                case '@': {
                    if (this.newline) break block8;
                }
                default: {
                    this.newline = false;
                }
            }
            this.nextChar();
        }
        if (n2 != 0) {
            throw new ParseException("dc.unterminated.signature");
        }
    }

    protected void identifier() throws ParseException {
        this.skipWhitespace();
        int n = this.bp;
        if (this.isJavaIdentifierStart(this.ch)) {
            this.readJavaIdentifier();
            return;
        }
        throw new ParseException("dc.identifier.expected");
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void quotedString() {
        int n = this.bp;
        this.nextChar();
        while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                    break;
                }
                case '\t': 
                case ' ': {
                    break;
                }
                case '\"': {
                    this.nextChar();
                    return;
                }
                case '@': {
                    if (!this.newline) break;
                    return;
                }
            }
            this.nextChar();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void inlineWord() {
        int n = this.bp;
        int n2 = 0;
        while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': {
                    this.newline = true;
                }
                case '\t': 
                case '\f': 
                case '\r': 
                case ' ': {
                    return;
                }
                case '@': {
                    if (this.newline) {
                        return;
                    }
                }
                case '{': {
                    ++n2;
                    break;
                }
                case '}': {
                    if (n2 == 0) return;
                    if (--n2 != 0) break;
                    return;
                }
            }
            this.newline = false;
            this.nextChar();
        }
    }

    private void inlineContent() {
        this.skipWhitespace();
        int n = this.bp;
        int n2 = 1;
        block9: while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                }
                case '\t': 
                case ' ': {
                    this.nextChar();
                    continue block9;
                }
                case '&': {
                    this.entity(null);
                    continue block9;
                }
                case '<': {
                    this.newline = false;
                    this.html();
                    continue block9;
                }
                case '{': {
                    this.newline = false;
                    ++n2;
                    this.nextChar();
                    continue block9;
                }
                case '}': {
                    this.newline = false;
                    if (--n2 == 0) {
                        this.nextChar();
                        return;
                    }
                    this.nextChar();
                    continue block9;
                }
                case '@': {
                    if (this.newline) break block9;
                }
                default: {
                    this.nextChar();
                    continue block9;
                }
            }
        }
    }

    protected void entity(Void void_) {
        this.newline = false;
        this.entity();
    }

    protected void entity() {
        this.nextChar();
        String string = null;
        if (this.ch == '#') {
            int n = this.bp;
            this.nextChar();
            if (this.isDecimalDigit(this.ch)) {
                this.nextChar();
                while (this.isDecimalDigit(this.ch)) {
                    this.nextChar();
                }
                string = new String(this.buf, n, this.bp - n);
            } else if (this.ch == 'x' || this.ch == 'X') {
                this.nextChar();
                if (this.isHexDigit(this.ch)) {
                    this.nextChar();
                    while (this.isHexDigit(this.ch)) {
                        this.nextChar();
                    }
                    string = new String(this.buf, n, this.bp - n);
                }
            }
        } else if (this.isIdentifierStart(this.ch)) {
            string = this.readIdentifier();
        }
        if (string != null) {
            if (this.ch != ';') {
                return;
            }
            this.nextChar();
        }
    }

    protected void html() {
        int n = this.bp;
        this.nextChar();
        if (this.isIdentifierStart(this.ch)) {
            String string = this.readIdentifier();
            this.checkHtmlTag(string);
            this.htmlAttrs();
            if (this.ch == '/') {
                this.nextChar();
            }
            if (this.ch == '>') {
                this.nextChar();
                return;
            }
        } else if (this.ch == '/') {
            this.nextChar();
            if (this.isIdentifierStart(this.ch)) {
                this.readIdentifier();
                this.skipWhitespace();
                if (this.ch == '>') {
                    this.nextChar();
                    return;
                }
            }
        } else if (this.ch == '!') {
            this.nextChar();
            if (this.ch == '-') {
                this.nextChar();
                if (this.ch == '-') {
                    this.nextChar();
                    while (this.bp < this.buflen) {
                        int n2 = 0;
                        while (this.ch == '-') {
                            ++n2;
                            this.nextChar();
                        }
                        if (n2 >= 2 && this.ch == '>') {
                            this.nextChar();
                            return;
                        }
                        this.nextChar();
                    }
                }
            }
        }
        this.bp = n + 1;
        this.ch = this.buf[this.bp];
    }

    protected void htmlAttrs() {
        this.skipWhitespace();
        block0: while (this.isIdentifierStart(this.ch)) {
            int n = this.bp;
            String string = this.readAttributeName();
            this.skipWhitespace();
            StringBuilder stringBuilder = new StringBuilder();
            if (this.ch == '=') {
                this.nextChar();
                this.skipWhitespace();
                if (this.ch == '\'' || this.ch == '\"') {
                    char c = this.ch;
                    this.nextChar();
                    while (this.bp < this.buflen && this.ch != c) {
                        if (this.newline && this.ch == '@') break block0;
                        stringBuilder.append(this.ch);
                        this.nextChar();
                    }
                    this.nextChar();
                } else {
                    while (this.bp < this.buflen && !this.isUnquotedAttrValueTerminator(this.ch)) {
                        stringBuilder.append(this.ch);
                        this.nextChar();
                    }
                }
                this.skipWhitespace();
            }
            this.checkHtmlAttr(string, stringBuilder.toString());
        }
    }

    protected void attrValueChar(Void void_) {
        switch (this.ch) {
            case '&': {
                this.entity(void_);
                break;
            }
            case '{': {
                this.inlineTag(void_);
                break;
            }
            default: {
                this.nextChar();
            }
        }
    }

    protected boolean isIdentifierStart(char c) {
        return Character.isUnicodeIdentifierStart(c);
    }

    protected String readIdentifier() {
        int n = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && Character.isUnicodeIdentifierPart(this.ch)) {
            this.nextChar();
        }
        return new String(this.buf, n, this.bp - n);
    }

    protected String readAttributeName() {
        int n = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && (Character.isUnicodeIdentifierPart(this.ch) || this.ch == '-')) {
            this.nextChar();
        }
        return new String(this.buf, n, this.bp - n);
    }

    protected String readTagName() {
        int n = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && (Character.isUnicodeIdentifierPart(this.ch) || this.ch == '.' || this.ch == '-' || this.ch == ':')) {
            this.nextChar();
        }
        return new String(this.buf, n, this.bp - n);
    }

    protected boolean isJavaIdentifierStart(char c) {
        return Character.isJavaIdentifierStart(c);
    }

    protected String readJavaIdentifier() {
        int n = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && Character.isJavaIdentifierPart(this.ch)) {
            this.nextChar();
        }
        return new String(this.buf, n, this.bp - n);
    }

    protected boolean isDecimalDigit(char c) {
        return '0' <= c && c <= '9';
    }

    protected boolean isHexDigit(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    protected boolean isUnquotedAttrValueTerminator(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': 
            case '\"': 
            case '\'': 
            case '<': 
            case '=': 
            case '>': 
            case '`': {
                return true;
            }
        }
        return false;
    }

    protected boolean isWhitespace(char c) {
        return Character.isWhitespace(c);
    }

    protected void skipWhitespace() {
        while (this.isWhitespace(this.ch)) {
            this.nextChar();
        }
    }

    String newString(int n, int n2) {
        return new String(this.buf, n, n2 - n);
    }

    private void initTagParsers() {
        TagParser[] tagParserArray = new TagParser[]{new TagParser(TagParser.Kind.BLOCK, "author"){

            @Override
            public void parse(int n) {
                JavaScriptScanner.this.blockContent();
            }
        }, new TagParser(TagParser.Kind.INLINE, "code", true){

            @Override
            public void parse(int n) throws ParseException {
                JavaScriptScanner.this.inlineText(WhitespaceRetentionPolicy.REMOVE_FIRST_SPACE);
                JavaScriptScanner.this.nextChar();
            }
        }, new TagParser(TagParser.Kind.BLOCK, "deprecated"){

            @Override
            public void parse(int n) {
                JavaScriptScanner.this.blockContent();
            }
        }, new TagParser(TagParser.Kind.INLINE, "docRoot"){

            @Override
            public void parse(int n) throws ParseException {
                if (JavaScriptScanner.this.ch == '}') {
                    JavaScriptScanner.this.nextChar();
                    return;
                }
                JavaScriptScanner.this.inlineText(WhitespaceRetentionPolicy.REMOVE_ALL);
                JavaScriptScanner.this.nextChar();
                throw new ParseException("dc.unexpected.content");
            }
        }, new TagParser(TagParser.Kind.BLOCK, "exception"){

            @Override
            public void parse(int n) throws ParseException {
                JavaScriptScanner.this.skipWhitespace();
                JavaScriptScanner.this.reference(false);
                JavaScriptScanner.this.blockContent();
            }
        }, new TagParser(TagParser.Kind.BLOCK, "hidden"){

            @Override
            public void parse(int n) {
                JavaScriptScanner.this.blockContent();
            }
        }, new TagParser(TagParser.Kind.INLINE, "index"){

            @Override
            public void parse(int n) throws ParseException {
                JavaScriptScanner.this.skipWhitespace();
                if (JavaScriptScanner.this.ch == '}') {
                    throw new ParseException("dc.no.content");
                }
                if (JavaScriptScanner.this.ch == '\"') {
                    JavaScriptScanner.this.quotedString();
                } else {
                    JavaScriptScanner.this.inlineWord();
                }
                JavaScriptScanner.this.skipWhitespace();
                if (JavaScriptScanner.this.ch != '}') {
                    JavaScriptScanner.this.inlineContent();
                } else {
                    JavaScriptScanner.this.nextChar();
                }
            }
        }, new TagParser(TagParser.Kind.INLINE, "inheritDoc"){

            @Override
            public void parse(int n) throws ParseException {
                if (JavaScriptScanner.this.ch == '}') {
                    JavaScriptScanner.this.nextChar();
                    return;
                }
                JavaScriptScanner.this.inlineText(WhitespaceRetentionPolicy.REMOVE_ALL);
                JavaScriptScanner.this.nextChar();
                throw new ParseException("dc.unexpected.content");
            }
        }, new TagParser(TagParser.Kind.INLINE, "link"){

            @Override
            public void parse(int n) throws ParseException {
                JavaScriptScanner.this.reference(true);
                JavaScriptScanner.this.inlineContent();
            }
        }, new TagParser(TagParser.Kind.INLINE, "linkplain"){

            @Override
            public void parse(int n) throws ParseException {
                JavaScriptScanner.this.reference(true);
                JavaScriptScanner.this.inlineContent();
            }
        }, new TagParser(TagParser.Kind.INLINE, "literal", true){

            @Override
            public void parse(int n) throws ParseException {
                JavaScriptScanner.this.inlineText(WhitespaceRetentionPolicy.REMOVE_FIRST_SPACE);
                JavaScriptScanner.this.nextChar();
            }
        }, new TagParser(TagParser.Kind.BLOCK, "param"){

            @Override
            public void parse(int n) throws ParseException {
                JavaScriptScanner.this.skipWhitespace();
                boolean bl = false;
                if (JavaScriptScanner.this.ch == '<') {
                    bl = true;
                    JavaScriptScanner.this.nextChar();
                }
                JavaScriptScanner.this.identifier();
                if (bl) {
                    if (JavaScriptScanner.this.ch != '>') {
                        throw new ParseException("dc.gt.expected");
                    }
                    JavaScriptScanner.this.nextChar();
                }
                JavaScriptScanner.this.skipWhitespace();
                JavaScriptScanner.this.blockContent();
            }
        }, new TagParser(TagParser.Kind.BLOCK, "return"){

            @Override
            public void parse(int n) {
                JavaScriptScanner.this.blockContent();
            }
        }, new TagParser(TagParser.Kind.BLOCK, "see"){

            @Override
            public void parse(int n) throws ParseException {
                JavaScriptScanner.this.skipWhitespace();
                switch (JavaScriptScanner.this.ch) {
                    case '\"': {
                        JavaScriptScanner.this.quotedString();
                        JavaScriptScanner.this.skipWhitespace();
                        if (JavaScriptScanner.this.ch != '@' && (JavaScriptScanner.this.ch != '\u001a' || JavaScriptScanner.this.bp != JavaScriptScanner.this.buf.length - 1)) break;
                        return;
                    }
                    case '<': {
                        JavaScriptScanner.this.blockContent();
                        return;
                    }
                    case '@': {
                        if (!JavaScriptScanner.this.newline) break;
                        throw new ParseException("dc.no.content");
                    }
                    case '\u001a': {
                        if (JavaScriptScanner.this.bp != JavaScriptScanner.this.buf.length - 1) break;
                        throw new ParseException("dc.no.content");
                    }
                    default: {
                        if (!JavaScriptScanner.this.isJavaIdentifierStart(JavaScriptScanner.this.ch) && JavaScriptScanner.this.ch != '#') break;
                        JavaScriptScanner.this.reference(true);
                        JavaScriptScanner.this.blockContent();
                    }
                }
                throw new ParseException("dc.unexpected.content");
            }
        }, new TagParser(TagParser.Kind.BLOCK, "@serialData"){

            @Override
            public void parse(int n) {
                JavaScriptScanner.this.blockContent();
            }
        }, new TagParser(TagParser.Kind.BLOCK, "serialField"){

            @Override
            public void parse(int n) throws ParseException {
                JavaScriptScanner.this.skipWhitespace();
                JavaScriptScanner.this.identifier();
                JavaScriptScanner.this.skipWhitespace();
                JavaScriptScanner.this.reference(false);
                if (JavaScriptScanner.this.isWhitespace(JavaScriptScanner.this.ch)) {
                    JavaScriptScanner.this.skipWhitespace();
                    JavaScriptScanner.this.blockContent();
                }
            }
        }, new TagParser(TagParser.Kind.BLOCK, "serial"){

            @Override
            public void parse(int n) {
                JavaScriptScanner.this.blockContent();
            }
        }, new TagParser(TagParser.Kind.BLOCK, "since"){

            @Override
            public void parse(int n) {
                JavaScriptScanner.this.blockContent();
            }
        }, new TagParser(TagParser.Kind.BLOCK, "throws"){

            @Override
            public void parse(int n) throws ParseException {
                JavaScriptScanner.this.skipWhitespace();
                JavaScriptScanner.this.reference(false);
                JavaScriptScanner.this.blockContent();
            }
        }, new TagParser(TagParser.Kind.INLINE, "value"){

            @Override
            public void parse(int n) throws ParseException {
                JavaScriptScanner.this.reference(true);
                JavaScriptScanner.this.skipWhitespace();
                if (JavaScriptScanner.this.ch == '}') {
                    JavaScriptScanner.this.nextChar();
                    return;
                }
                JavaScriptScanner.this.nextChar();
                throw new ParseException("dc.unexpected.content");
            }
        }, new TagParser(TagParser.Kind.BLOCK, "version"){

            @Override
            public void parse(int n) {
                JavaScriptScanner.this.blockContent();
            }
        }};
        this.tagParsers = new HashMap<String, TagParser>();
        for (TagParser tagParser : tagParserArray) {
            this.tagParsers.put(tagParser.getName(), tagParser);
        }
    }

    private void initEventAttrs() {
        this.eventAttrs = new HashSet<String>(Arrays.asList("onabort", "onblur", "oncanplay", "oncanplaythrough", "onchange", "onclick", "oncontextmenu", "ondblclick", "ondrag", "ondragend", "ondragenter", "ondragleave", "ondragover", "ondragstart", "ondrop", "ondurationchange", "onemptied", "onended", "onerror", "onfocus", "oninput", "oninvalid", "onkeydown", "onkeypress", "onkeyup", "onload", "onloadeddata", "onloadedmetadata", "onloadstart", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "onmousewheel", "onpause", "onplay", "onplaying", "onprogress", "onratechange", "onreadystatechange", "onreset", "onscroll", "onseeked", "onseeking", "onselect", "onshow", "onstalled", "onsubmit", "onsuspend", "ontimeupdate", "onvolumechange", "onwaiting", "onunload"));
    }

    private void initURIAttrs() {
        this.uriAttrs = new HashSet<String>(Arrays.asList("action", "cite", "classid", "codebase", "data", "datasrc", "for", "href", "longdesc", "profile", "src", "usemap"));
    }

    static abstract class TagParser {
        final Kind kind;
        final String name;

        TagParser(Kind kind, String string) {
            this.kind = kind;
            this.name = string;
        }

        TagParser(Kind kind, String string, boolean bl) {
            this(kind, string);
        }

        Kind getKind() {
            return this.kind;
        }

        String getName() {
            return this.name;
        }

        abstract void parse(int var1) throws ParseException;

        static enum Kind {
            INLINE,
            BLOCK;

        }
    }

    private static enum WhitespaceRetentionPolicy {
        RETAIN_ALL,
        REMOVE_FIRST_SPACE,
        REMOVE_ALL;

    }

    static class ParseException
    extends Exception {
        private static final long serialVersionUID = 0L;

        ParseException(String string) {
            super(string);
        }
    }

    public static interface Reporter {
        public void report();
    }
}

