/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.javadoc.AnnotationValue;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javadoc.AnnotationDescImpl;
import com.sun.tools.javadoc.DocEnv;
import com.sun.tools.javadoc.FieldDocImpl;
import com.sun.tools.javadoc.TypeMaker;

public class AnnotationValueImpl
implements AnnotationValue {
    private final DocEnv env;
    private final Attribute attr;

    AnnotationValueImpl(DocEnv docEnv, Attribute attribute) {
        this.env = docEnv;
        this.attr = attribute;
    }

    @Override
    public Object value() {
        ValueVisitor valueVisitor = new ValueVisitor();
        this.attr.accept(valueVisitor);
        return valueVisitor.value;
    }

    @Override
    public String toString() {
        ToStringVisitor toStringVisitor = new ToStringVisitor();
        this.attr.accept(toStringVisitor);
        return toStringVisitor.toString();
    }

    private class ToStringVisitor
    implements Attribute.Visitor {
        private final StringBuilder sb = new StringBuilder();

        private ToStringVisitor() {
        }

        public String toString() {
            return this.sb.toString();
        }

        @Override
        public void visitConstant(Attribute.Constant constant) {
            if (constant.type.hasTag(TypeTag.BOOLEAN)) {
                this.sb.append((Integer)constant.value != 0);
            } else {
                this.sb.append(FieldDocImpl.constantValueExpression(constant.value));
            }
        }

        @Override
        public void visitClass(Attribute.Class clazz) {
            this.sb.append(clazz);
        }

        @Override
        public void visitEnum(Attribute.Enum enum_) {
            this.sb.append(enum_);
        }

        @Override
        public void visitCompound(Attribute.Compound compound) {
            this.sb.append(new AnnotationDescImpl(AnnotationValueImpl.this.env, compound));
        }

        @Override
        public void visitArray(Attribute.Array array) {
            if (array.values.length != 1) {
                this.sb.append('{');
            }
            boolean bl = true;
            for (Attribute attribute : array.values) {
                if (bl) {
                    bl = false;
                } else {
                    this.sb.append(", ");
                }
                attribute.accept(this);
            }
            if (array.values.length != 1) {
                this.sb.append('}');
            }
        }

        @Override
        public void visitError(Attribute.Error error) {
            this.sb.append("<error>");
        }
    }

    private class ValueVisitor
    implements Attribute.Visitor {
        public Object value;

        private ValueVisitor() {
        }

        @Override
        public void visitConstant(Attribute.Constant constant) {
            this.value = constant.type.hasTag(TypeTag.BOOLEAN) ? Boolean.valueOf((Integer)constant.value != 0) : constant.value;
        }

        @Override
        public void visitClass(Attribute.Class clazz) {
            this.value = TypeMaker.getType(AnnotationValueImpl.this.env, ((AnnotationValueImpl)AnnotationValueImpl.this).env.types.erasure(clazz.classType));
        }

        @Override
        public void visitEnum(Attribute.Enum enum_) {
            this.value = AnnotationValueImpl.this.env.getFieldDoc(enum_.value);
        }

        @Override
        public void visitCompound(Attribute.Compound compound) {
            this.value = new AnnotationDescImpl(AnnotationValueImpl.this.env, compound);
        }

        @Override
        public void visitArray(Attribute.Array array) {
            AnnotationValue[] annotationValueArray = new AnnotationValue[array.values.length];
            for (int i = 0; i < annotationValueArray.length; ++i) {
                annotationValueArray[i] = new AnnotationValueImpl(AnnotationValueImpl.this.env, array.values[i]);
            }
            this.value = annotationValueArray;
        }

        @Override
        public void visitError(Attribute.Error error) {
            this.value = "<error>";
        }
    }
}

