/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.parser.ScannerFactory;
import com.sun.tools.javac.util.ArrayUtils;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.nio.CharBuffer;
import java.util.Arrays;

public class UnicodeReader {
    protected char[] buf;
    protected int bp;
    protected final int buflen;
    protected char ch;
    protected int unicodeConversionBp = -1;
    protected Log log;
    protected Names names;
    protected char[] sbuf = new char[128];
    protected int sp;
    static final boolean surrogatesSupported = UnicodeReader.surrogatesSupported();

    protected UnicodeReader(ScannerFactory scannerFactory, CharBuffer charBuffer) {
        this(scannerFactory, JavacFileManager.toArray(charBuffer), charBuffer.limit());
    }

    protected UnicodeReader(ScannerFactory scannerFactory, char[] cArray, int n) {
        this.log = scannerFactory.log;
        this.names = scannerFactory.names;
        if (n == cArray.length) {
            if (cArray.length > 0 && Character.isWhitespace(cArray[cArray.length - 1])) {
                --n;
            } else {
                cArray = Arrays.copyOf(cArray, n + 1);
            }
        }
        this.buf = cArray;
        this.buflen = n;
        this.buf[this.buflen] = 26;
        this.bp = -1;
        this.scanChar();
    }

    protected void scanChar() {
        if (this.bp < this.buflen) {
            this.ch = this.buf[++this.bp];
            if (this.ch == '\\') {
                this.convertUnicode();
            }
        }
    }

    protected void scanCommentChar() {
        this.scanChar();
        if (this.ch == '\\') {
            if (this.peekChar() == '\\' && !this.isUnicode()) {
                this.skipChar();
            } else {
                this.convertUnicode();
            }
        }
    }

    protected void putChar(char c, boolean bl) {
        this.sbuf = ArrayUtils.ensureCapacity(this.sbuf, this.sp);
        this.sbuf[this.sp++] = c;
        if (bl) {
            this.scanChar();
        }
    }

    protected void putChar(char c) {
        this.putChar(c, false);
    }

    protected void putChar(boolean bl) {
        this.putChar(this.ch, bl);
    }

    Name name() {
        return this.names.fromChars(this.sbuf, 0, this.sp);
    }

    String chars() {
        return new String(this.sbuf, 0, this.sp);
    }

    protected void convertUnicode() {
        if (this.ch == '\\' && this.unicodeConversionBp != this.bp) {
            ++this.bp;
            this.ch = this.buf[this.bp];
            if (this.ch == 'u') {
                do {
                    ++this.bp;
                    this.ch = this.buf[this.bp];
                } while (this.ch == 'u');
                int n = this.bp + 3;
                if (n < this.buflen) {
                    int n2;
                    int n3 = n2 = this.digit(this.bp, 16);
                    while (this.bp < n && n2 >= 0) {
                        ++this.bp;
                        this.ch = this.buf[this.bp];
                        n2 = this.digit(this.bp, 16);
                        n3 = (n3 << 4) + n2;
                    }
                    if (n2 >= 0) {
                        this.ch = (char)n3;
                        this.unicodeConversionBp = this.bp;
                        return;
                    }
                }
                this.log.error(this.bp, "illegal.unicode.esc", new Object[0]);
            } else {
                --this.bp;
                this.ch = (char)92;
            }
        }
    }

    private static boolean surrogatesSupported() {
        try {
            Character.isHighSurrogate('a');
            return true;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return false;
        }
    }

    protected char scanSurrogates() {
        if (surrogatesSupported && Character.isHighSurrogate(this.ch)) {
            char c = this.ch;
            this.scanChar();
            if (Character.isLowSurrogate(this.ch)) {
                return c;
            }
            this.ch = c;
        }
        return '\u0000';
    }

    protected int digit(int n, int n2) {
        char c = this.ch;
        int n3 = Character.digit(c, n2);
        if (n3 >= 0 && c > '\u007f') {
            this.log.error(n + 1, "illegal.nonascii.digit", new Object[0]);
            this.ch = "0123456789abcdef".charAt(n3);
        }
        return n3;
    }

    protected boolean isUnicode() {
        return this.unicodeConversionBp == this.bp;
    }

    protected void skipChar() {
        ++this.bp;
    }

    protected char peekChar() {
        return this.buf[this.bp + 1];
    }

    public char[] getRawCharacters() {
        char[] cArray = new char[this.buflen];
        System.arraycopy(this.buf, 0, cArray, 0, this.buflen);
        return cArray;
    }

    public char[] getRawCharacters(int n, int n2) {
        int n3 = n2 - n;
        char[] cArray = new char[n3];
        System.arraycopy(this.buf, n, cArray, 0, n3);
        return cArray;
    }
}

