/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.file.BaseFileObject;
import com.sun.tools.javac.file.FSInfo;
import com.sun.tools.javac.file.RegularFileObject;
import com.sun.tools.javac.file.RelativePath;
import com.sun.tools.javac.file.SymbolArchive;
import com.sun.tools.javac.file.ZipArchive;
import com.sun.tools.javac.file.ZipFileIndex;
import com.sun.tools.javac.file.ZipFileIndexArchive;
import com.sun.tools.javac.file.ZipFileIndexCache;
import com.sun.tools.javac.util.BaseFileManager;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipFile;
import javax.lang.model.SourceVersion;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;

public class JavacFileManager
extends BaseFileManager
implements StandardJavaFileManager {
    private FSInfo fsInfo;
    private boolean contextUseOptimizedZip;
    private ZipFileIndexCache zipFileIndexCache;
    private final Set<JavaFileObject.Kind> sourceOrClass = EnumSet.of(JavaFileObject.Kind.SOURCE, JavaFileObject.Kind.CLASS);
    protected boolean mmappedIO;
    protected boolean symbolFileEnabled;
    protected SortFiles sortFiles;
    private static final boolean fileSystemIsCaseSensitive = File.separatorChar == '/';
    Map<File, Archive> archives = new HashMap<File, Archive>();
    private static final String[] symbolFileLocation = new String[]{"lib", "ct.sym"};
    private static final RelativePath.RelativeDirectory symbolFilePrefix = new RelativePath.RelativeDirectory("META-INF/sym/rt.jar/");
    private String defaultEncodingName;

    public static char[] toArray(CharBuffer charBuffer) {
        if (charBuffer.hasArray()) {
            return ((CharBuffer)charBuffer.compact().flip()).array();
        }
        return charBuffer.toString().toCharArray();
    }

    public static void preRegister(Context context) {
        context.put(JavaFileManager.class, new Context.Factory<JavaFileManager>(){

            @Override
            public JavaFileManager make(Context context) {
                return new JavacFileManager(context, true, null);
            }
        });
    }

    public JavacFileManager(Context context, boolean bl, Charset charset) {
        super(charset);
        if (bl) {
            context.put(JavaFileManager.class, this);
        }
        this.setContext(context);
    }

    @Override
    public void setContext(Context context) {
        super.setContext(context);
        this.fsInfo = FSInfo.instance(context);
        this.contextUseOptimizedZip = this.options.getBoolean("useOptimizedZip", true);
        if (this.contextUseOptimizedZip) {
            this.zipFileIndexCache = ZipFileIndexCache.getSharedInstance();
        }
        this.mmappedIO = this.options.isSet("mmappedIO");
        this.symbolFileEnabled = !this.options.isSet("ignore.symbol.file");
        String string = this.options.get("sortFiles");
        if (string != null) {
            this.sortFiles = string.equals("reverse") ? SortFiles.REVERSE : SortFiles.FORWARD;
        }
    }

    public void setSymbolFileEnabled(boolean bl) {
        this.symbolFileEnabled = bl;
    }

    @Override
    public boolean isDefaultBootClassPath() {
        return this.locations.isDefaultBootClassPath();
    }

    public JavaFileObject getFileForInput(String string) {
        return this.getRegularFile(new File(string));
    }

    public JavaFileObject getRegularFile(File file) {
        return new RegularFileObject(this, file);
    }

    public JavaFileObject getFileForOutput(String string, JavaFileObject.Kind kind, JavaFileObject javaFileObject) throws IOException {
        return this.getJavaFileForOutput(StandardLocation.CLASS_OUTPUT, string, kind, javaFileObject);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromStrings(Iterable<String> iterable) {
        ListBuffer<File> listBuffer = new ListBuffer<File>();
        for (String string : iterable) {
            listBuffer.append(new File(JavacFileManager.nullCheck(string)));
        }
        return this.getJavaFileObjectsFromFiles(listBuffer.toList());
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(String ... stringArray) {
        return this.getJavaFileObjectsFromStrings(Arrays.asList((Object[])JavacFileManager.nullCheck(stringArray)));
    }

    private static boolean isValidName(String string) {
        for (String string2 : string.split("\\.", -1)) {
            if (SourceVersion.isIdentifier(string2)) continue;
            return false;
        }
        return true;
    }

    private static void validateClassName(String string) {
        if (!JavacFileManager.isValidName(string)) {
            throw new IllegalArgumentException("Invalid class name: " + string);
        }
    }

    private static void validatePackageName(String string) {
        if (string.length() > 0 && !JavacFileManager.isValidName(string)) {
            throw new IllegalArgumentException("Invalid packageName name: " + string);
        }
    }

    public static void testName(String string, boolean bl, boolean bl2) {
        try {
            JavacFileManager.validatePackageName(string);
            if (!bl) {
                throw new AssertionError((Object)("Invalid package name accepted: " + string));
            }
            JavacFileManager.printAscii("Valid package name: \"%s\"", string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (bl) {
                throw new AssertionError((Object)("Valid package name rejected: " + string));
            }
            JavacFileManager.printAscii("Invalid package name: \"%s\"", string);
        }
        try {
            JavacFileManager.validateClassName(string);
            if (!bl2) {
                throw new AssertionError((Object)("Invalid class name accepted: " + string));
            }
            JavacFileManager.printAscii("Valid class name: \"%s\"", string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (bl2) {
                throw new AssertionError((Object)("Valid class name rejected: " + string));
            }
            JavacFileManager.printAscii("Invalid class name: \"%s\"", string);
        }
    }

    private static void printAscii(String string, Object ... objectArray) {
        String string2;
        try {
            string2 = new String(String.format(null, string, objectArray).getBytes("US-ASCII"), "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
        System.out.println(string2);
    }

    private void listDirectory(File file, RelativePath.RelativeDirectory relativeDirectory, Set<JavaFileObject.Kind> set, boolean bl, ListBuffer<JavaFileObject> listBuffer) {
        File file2 = relativeDirectory.getFile(file);
        if (!this.caseMapCheck(file2, relativeDirectory)) {
            return;
        }
        File[] fileArray = file2.listFiles();
        if (fileArray == null) {
            return;
        }
        if (this.sortFiles != null) {
            Arrays.sort(fileArray, this.sortFiles);
        }
        for (File file3 : fileArray) {
            String string = file3.getName();
            if (file3.isDirectory()) {
                if (!bl || !SourceVersion.isIdentifier(string)) continue;
                this.listDirectory(file, new RelativePath.RelativeDirectory(relativeDirectory, string), set, bl, listBuffer);
                continue;
            }
            if (!this.isValidFile(string, set)) continue;
            RegularFileObject regularFileObject = new RegularFileObject(this, string, new File(file2, string));
            listBuffer.append(regularFileObject);
        }
    }

    private void listArchive(Archive archive, RelativePath.RelativeDirectory relativeDirectory, Set<JavaFileObject.Kind> set, boolean bl, ListBuffer<JavaFileObject> listBuffer) {
        List<String> list = archive.getFiles(relativeDirectory);
        if (list != null) {
            while (!list.isEmpty()) {
                String string = (String)list.head;
                if (this.isValidFile(string, set)) {
                    listBuffer.append(archive.getFileObject(relativeDirectory, string));
                }
                list = list.tail;
            }
        }
        if (bl) {
            for (RelativePath.RelativeDirectory relativeDirectory2 : archive.getSubdirectories()) {
                if (!relativeDirectory.contains(relativeDirectory2)) continue;
                this.listArchive(archive, relativeDirectory2, set, false, listBuffer);
            }
        }
    }

    private void listContainer(File file, RelativePath.RelativeDirectory relativeDirectory, Set<JavaFileObject.Kind> set, boolean bl, ListBuffer<JavaFileObject> listBuffer) {
        Archive archive = this.archives.get(file);
        if (archive == null) {
            if (this.fsInfo.isDirectory(file)) {
                this.listDirectory(file, relativeDirectory, set, bl, listBuffer);
                return;
            }
            try {
                archive = this.openArchive(file);
            }
            catch (IOException iOException) {
                this.log.error("error.reading.file", file, JavacFileManager.getMessage(iOException));
                return;
            }
        }
        this.listArchive(archive, relativeDirectory, set, bl, listBuffer);
    }

    private boolean isValidFile(String string, Set<JavaFileObject.Kind> set) {
        JavaFileObject.Kind kind = JavacFileManager.getKind(string);
        return set.contains((Object)kind);
    }

    private boolean caseMapCheck(File file, RelativePath relativePath) {
        String string;
        if (fileSystemIsCaseSensitive) {
            return true;
        }
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return false;
        }
        char[] cArray = string.toCharArray();
        char[] cArray2 = relativePath.path.toCharArray();
        int n = cArray.length - 1;
        int n2 = cArray2.length - 1;
        while (n >= 0 && n2 >= 0) {
            while (n >= 0 && cArray[n] == File.separatorChar) {
                --n;
            }
            while (n2 >= 0 && cArray2[n2] == '/') {
                --n2;
            }
            if (n < 0 || n2 < 0) continue;
            if (cArray[n] != cArray2[n2]) {
                return false;
            }
            --n;
            --n2;
        }
        return n2 < 0;
    }

    protected Archive openArchive(File file) throws IOException {
        try {
            return this.openArchive(file, this.contextUseOptimizedZip);
        }
        catch (IOException iOException) {
            if (iOException instanceof ZipFileIndex.ZipFormatException) {
                return this.openArchive(file, false);
            }
            throw iOException;
        }
    }

    private Archive openArchive(File object, boolean bl) throws IOException {
        Object object2;
        File file = object;
        if (this.symbolFileEnabled && this.locations.isDefaultBootClassPathRtJar((File)object)) {
            object2 = ((File)object).getParentFile().getParentFile();
            if (new File(((File)object2).getName()).equals(new File("jre"))) {
                object2 = ((File)object2).getParentFile();
            }
            for (String string2 : symbolFileLocation) {
                object2 = new File((File)object2, string2);
            }
            if (((File)object2).exists()) {
                object = object2;
            }
        }
        try {
            String[] stringArray = null;
            int n = 0;
            String string = null;
            if (!bl) {
                stringArray = new ZipFile((File)object);
            } else {
                String string2;
                n = this.options.isSet("usezipindex");
                string = this.options.get("java.io.tmpdir");
                string2 = this.options.get("cachezipindexdir");
                if (string2 != null && string2.length() != 0) {
                    File file2;
                    if (string2.startsWith("\"")) {
                        string2 = string2.endsWith("\"") ? string2.substring(1, string2.length() - 1) : string2.substring(1);
                    }
                    if ((file2 = new File(string2)).exists() && file2.canWrite() && !(string = string2).endsWith("/") && !string.endsWith(File.separator)) {
                        string = string + File.separator;
                    }
                }
            }
            object2 = file == object ? (!bl ? new ZipArchive(this, (ZipFile)stringArray) : new ZipFileIndexArchive(this, this.zipFileIndexCache.getZipFileIndex((File)object, null, n != 0, string, this.options.isSet("writezipindexfiles")))) : (!bl ? new SymbolArchive(this, file, (ZipFile)stringArray, symbolFilePrefix) : new ZipFileIndexArchive(this, this.zipFileIndexCache.getZipFileIndex((File)object, symbolFilePrefix, n != 0, string, this.options.isSet("writezipindexfiles"))));
        }
        catch (FileNotFoundException fileNotFoundException) {
            object2 = new MissingArchive((File)object);
        }
        catch (ZipFileIndex.ZipFormatException zipFormatException) {
            throw zipFormatException;
        }
        catch (IOException iOException) {
            if (((File)object).exists()) {
                this.log.error("error.reading.file", object, JavacFileManager.getMessage(iOException));
            }
            object2 = new MissingArchive((File)object);
        }
        this.archives.put(file, (Archive)object2);
        return object2;
    }

    @Override
    public void flush() {
        this.contentCache.clear();
    }

    @Override
    public void close() {
        Iterator<Archive> iterator = this.archives.values().iterator();
        while (iterator.hasNext()) {
            Archive archive = iterator.next();
            iterator.remove();
            try {
                archive.close();
            }
            catch (IOException iOException) {}
        }
    }

    private String getDefaultEncodingName() {
        if (this.defaultEncodingName == null) {
            this.defaultEncodingName = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
        }
        return this.defaultEncodingName;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        JavacFileManager.nullCheck(location);
        Iterable<? extends File> iterable = this.getLocation(location);
        if (iterable == null) {
            return null;
        }
        ListBuffer<URL> listBuffer = new ListBuffer<URL>();
        for (File file : iterable) {
            try {
                listBuffer.append(file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                throw new AssertionError((Object)malformedURLException);
            }
        }
        return this.getClassLoader(listBuffer.toArray(new URL[listBuffer.size()]));
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String string, Set<JavaFileObject.Kind> set, boolean bl) throws IOException {
        JavacFileManager.nullCheck(string);
        JavacFileManager.nullCheck(set);
        Iterable<? extends File> iterable = this.getLocation(location);
        if (iterable == null) {
            return List.nil();
        }
        RelativePath.RelativeDirectory relativeDirectory = RelativePath.RelativeDirectory.forPackage(string);
        ListBuffer<JavaFileObject> listBuffer = new ListBuffer<JavaFileObject>();
        for (File file : iterable) {
            this.listContainer(file, relativeDirectory, set, bl, listBuffer);
        }
        return listBuffer.toList();
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject javaFileObject) {
        javaFileObject.getClass();
        location.getClass();
        Iterable<? extends File> iterable = this.getLocation(location);
        if (iterable == null) {
            return null;
        }
        if (javaFileObject instanceof BaseFileObject) {
            return ((BaseFileObject)javaFileObject).inferBinaryName(iterable);
        }
        throw new IllegalArgumentException(javaFileObject.getClass().getName());
    }

    @Override
    public boolean isSameFile(FileObject fileObject, FileObject fileObject2) {
        JavacFileManager.nullCheck(fileObject);
        JavacFileManager.nullCheck(fileObject2);
        if (!(fileObject instanceof BaseFileObject)) {
            throw new IllegalArgumentException("Not supported: " + fileObject);
        }
        if (!(fileObject2 instanceof BaseFileObject)) {
            throw new IllegalArgumentException("Not supported: " + fileObject2);
        }
        return fileObject.equals(fileObject2);
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return this.getLocation(location) != null;
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind) throws IOException {
        JavacFileManager.nullCheck(location);
        JavacFileManager.nullCheck(string);
        JavacFileManager.nullCheck(kind);
        if (!this.sourceOrClass.contains((Object)kind)) {
            throw new IllegalArgumentException("Invalid kind: " + (Object)((Object)kind));
        }
        return this.getFileForInput(location, RelativePath.RelativeFile.forClass(string, kind));
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String string, String string2) throws IOException {
        JavacFileManager.nullCheck(location);
        JavacFileManager.nullCheck(string);
        if (!JavacFileManager.isRelativeUri(string2)) {
            throw new IllegalArgumentException("Invalid relative name: " + string2);
        }
        RelativePath.RelativeFile relativeFile = string.length() == 0 ? new RelativePath.RelativeFile(string2) : new RelativePath.RelativeFile(RelativePath.RelativeDirectory.forPackage(string), string2);
        return this.getFileForInput(location, relativeFile);
    }

    private JavaFileObject getFileForInput(JavaFileManager.Location location, RelativePath.RelativeFile relativeFile) throws IOException {
        Iterable<? extends File> iterable = this.getLocation(location);
        if (iterable == null) {
            return null;
        }
        for (File file : iterable) {
            Archive archive = this.archives.get(file);
            if (archive == null) {
                if (this.fsInfo.isDirectory(file)) {
                    File file2 = relativeFile.getFile(file);
                    if (!file2.exists()) continue;
                    return new RegularFileObject(this, file2);
                }
                archive = this.openArchive(file);
            }
            if (!archive.contains(relativeFile)) continue;
            return archive.getFileObject(relativeFile.dirname(), relativeFile.basename());
        }
        return null;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind, FileObject fileObject) throws IOException {
        JavacFileManager.nullCheck(location);
        JavacFileManager.nullCheck(string);
        JavacFileManager.nullCheck(kind);
        if (!this.sourceOrClass.contains((Object)kind)) {
            throw new IllegalArgumentException("Invalid kind: " + (Object)((Object)kind));
        }
        return this.getFileForOutput(location, RelativePath.RelativeFile.forClass(string, kind), fileObject);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String string, String string2, FileObject fileObject) throws IOException {
        JavacFileManager.nullCheck(location);
        JavacFileManager.nullCheck(string);
        if (!JavacFileManager.isRelativeUri(string2)) {
            throw new IllegalArgumentException("Invalid relative name: " + string2);
        }
        RelativePath.RelativeFile relativeFile = string.length() == 0 ? new RelativePath.RelativeFile(string2) : new RelativePath.RelativeFile(RelativePath.RelativeDirectory.forPackage(string), string2);
        return this.getFileForOutput(location, relativeFile, fileObject);
    }

    /*
     * Enabled aggressive block sorting
     */
    private JavaFileObject getFileForOutput(JavaFileManager.Location location, RelativePath.RelativeFile relativeFile, FileObject fileObject) throws IOException {
        Object object;
        File file;
        block7: {
            if (location == StandardLocation.CLASS_OUTPUT) {
                if (this.getClassOutDir() != null) {
                    file = this.getClassOutDir();
                    break block7;
                } else {
                    File file2 = null;
                    if (fileObject != null && fileObject instanceof RegularFileObject) {
                        file2 = ((RegularFileObject)fileObject).file.getParentFile();
                    }
                    return new RegularFileObject(this, new File(file2, relativeFile.basename()));
                }
            }
            if (location == StandardLocation.SOURCE_OUTPUT) {
                file = this.getSourceOutDir() != null ? this.getSourceOutDir() : this.getClassOutDir();
            } else {
                object = this.locations.getLocation(location);
                file = null;
                Iterator iterator = object.iterator();
                if (iterator.hasNext()) {
                    File file3;
                    file = file3 = (File)iterator.next();
                }
            }
        }
        object = relativeFile.getFile(file);
        return new RegularFileObject(this, (File)object);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromFiles(Iterable<? extends File> iterable) {
        ArrayList<RegularFileObject> arrayList = iterable instanceof Collection ? new ArrayList(((Collection)iterable).size()) : new ArrayList<RegularFileObject>();
        for (File file : iterable) {
            arrayList.add(new RegularFileObject(this, JavacFileManager.nullCheck(file)));
        }
        return arrayList;
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(File ... fileArray) {
        return this.getJavaFileObjectsFromFiles(Arrays.asList((Object[])JavacFileManager.nullCheck(fileArray)));
    }

    @Override
    public void setLocation(JavaFileManager.Location location, Iterable<? extends File> iterable) throws IOException {
        JavacFileManager.nullCheck(location);
        this.locations.setLocation(location, iterable);
    }

    @Override
    public Iterable<? extends File> getLocation(JavaFileManager.Location location) {
        JavacFileManager.nullCheck(location);
        return this.locations.getLocation(location);
    }

    private File getClassOutDir() {
        return this.locations.getOutputLocation(StandardLocation.CLASS_OUTPUT);
    }

    private File getSourceOutDir() {
        return this.locations.getOutputLocation(StandardLocation.SOURCE_OUTPUT);
    }

    protected static boolean isRelativeUri(URI uRI) {
        if (uRI.isAbsolute()) {
            return false;
        }
        String string = uRI.normalize().getPath();
        if (string.length() == 0) {
            return false;
        }
        if (!string.equals(uRI.getPath())) {
            return false;
        }
        return !string.startsWith("/") && !string.startsWith("./") && !string.startsWith("../");
    }

    protected static boolean isRelativeUri(String string) {
        try {
            return JavacFileManager.isRelativeUri(new URI(string));
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    public static String getRelativeName(File file) {
        String string;
        if (!file.isAbsolute() && JavacFileManager.isRelativeUri(string = file.getPath().replace(File.separatorChar, '/'))) {
            return string;
        }
        throw new IllegalArgumentException("Invalid relative path: " + file);
    }

    public static String getMessage(IOException iOException) {
        String string = iOException.getLocalizedMessage();
        if (string != null) {
            return string;
        }
        string = iOException.getMessage();
        if (string != null) {
            return string;
        }
        return iOException.toString();
    }

    public class MissingArchive
    implements Archive {
        final File zipFileName;

        public MissingArchive(File file) {
            this.zipFileName = file;
        }

        @Override
        public boolean contains(RelativePath relativePath) {
            return false;
        }

        @Override
        public void close() {
        }

        @Override
        public JavaFileObject getFileObject(RelativePath.RelativeDirectory relativeDirectory, String string) {
            return null;
        }

        @Override
        public List<String> getFiles(RelativePath.RelativeDirectory relativeDirectory) {
            return List.nil();
        }

        @Override
        public Set<RelativePath.RelativeDirectory> getSubdirectories() {
            return Collections.emptySet();
        }

        public String toString() {
            return "MissingArchive[" + this.zipFileName + "]";
        }
    }

    public static interface Archive {
        public void close() throws IOException;

        public boolean contains(RelativePath var1);

        public JavaFileObject getFileObject(RelativePath.RelativeDirectory var1, String var2);

        public List<String> getFiles(RelativePath.RelativeDirectory var1);

        public Set<RelativePath.RelativeDirectory> getSubdirectories();
    }

    protected static enum SortFiles implements Comparator<File>
    {
        FORWARD{

            @Override
            public int compare(File file, File file2) {
                return file.getName().compareTo(file2.getName());
            }
        }
        ,
        REVERSE{

            @Override
            public int compare(File file, File file2) {
                return -file.getName().compareTo(file2.getName());
            }
        };

    }
}

