/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Filter;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.Iterator;

public class Scope {
    private int shared;
    public Scope next;
    public Symbol owner;
    Entry[] table;
    int hashMask;
    public Entry elems;
    int nelems = 0;
    List<ScopeListener> listeners = List.nil();
    private static final Entry sentinel = new Entry(null, null, null, null);
    private static final int INITIAL_SIZE = 16;
    public static final Scope emptyScope = new Scope(null, null, new Entry[0]);
    static final Filter<Symbol> noFilter = new Filter<Symbol>(){

        @Override
        public boolean accepts(Symbol symbol) {
            return true;
        }
    };

    private Scope(Scope scope, Symbol symbol, Entry[] entryArray) {
        this.next = scope;
        Assert.check(emptyScope == null || symbol != null);
        this.owner = symbol;
        this.table = entryArray;
        this.hashMask = entryArray.length - 1;
    }

    private Scope(Scope scope, Symbol symbol, Entry[] entryArray, int n) {
        this(scope, symbol, entryArray);
        this.nelems = n;
    }

    public Scope(Symbol symbol) {
        this(null, symbol, new Entry[16]);
    }

    public Scope dup() {
        return this.dup(this.owner);
    }

    public Scope dup(Symbol symbol) {
        Scope scope = new Scope(this, symbol, this.table, this.nelems);
        ++this.shared;
        return scope;
    }

    public Scope dupUnshared() {
        return new Scope(this, this.owner, (Entry[])this.table.clone(), this.nelems);
    }

    public Scope leave() {
        Assert.check(this.shared == 0);
        if (this.table != this.next.table) {
            return this.next;
        }
        while (this.elems != null) {
            int n = this.getIndex(this.elems.sym.name);
            Entry entry = this.table[n];
            Assert.check(entry == this.elems, this.elems.sym);
            this.table[n] = this.elems.shadowed;
            this.elems = this.elems.sibling;
        }
        Assert.check(this.next.shared > 0);
        --this.next.shared;
        this.next.nelems = this.nelems;
        return this.next;
    }

    private void dble() {
        Assert.check(this.shared == 0);
        Entry[] entryArray = this.table;
        Entry[] entryArray2 = new Entry[entryArray.length * 2];
        Scope scope = this;
        while (scope != null) {
            if (scope.table == entryArray) {
                Assert.check(scope == this || scope.shared != 0);
                scope.table = entryArray2;
                scope.hashMask = entryArray2.length - 1;
            }
            scope = scope.next;
        }
        int n = 0;
        int n2 = entryArray.length;
        while (--n2 >= 0) {
            Entry entry = entryArray[n2];
            if (entry == null || entry == sentinel) continue;
            this.table[this.getIndex((Name)entry.sym.name)] = entry;
            ++n;
        }
        this.nelems = n;
    }

    public void enter(Symbol symbol) {
        Assert.check(this.shared == 0);
        this.enter(symbol, this);
    }

    public void enter(Symbol symbol, Scope scope) {
        this.enter(symbol, scope, scope, false);
    }

    public void enter(Symbol symbol, Scope scope, Scope scope2, boolean bl) {
        Entry entry;
        int n;
        Entry entry2;
        Assert.check(this.shared == 0);
        if (this.nelems * 3 >= this.hashMask * 2) {
            this.dble();
        }
        if ((entry2 = this.table[n = this.getIndex(symbol.name)]) == null) {
            entry2 = sentinel;
            ++this.nelems;
        }
        this.table[n] = entry = this.makeEntry(symbol, entry2, this.elems, scope, scope2, bl);
        this.elems = entry;
        List<ScopeListener> list = this.listeners;
        while (list.nonEmpty()) {
            ((ScopeListener)list.head).symbolAdded(symbol, this);
            list = list.tail;
        }
    }

    Entry makeEntry(Symbol symbol, Entry entry, Entry entry2, Scope scope, Scope scope2, boolean bl) {
        return new Entry(symbol, entry, entry2, scope);
    }

    public void addScopeListener(ScopeListener scopeListener) {
        this.listeners = this.listeners.prepend(scopeListener);
    }

    public void remove(final Symbol symbol) {
        Assert.check(this.shared == 0);
        Entry entry = this.lookup(symbol.name, new Filter<Symbol>(){

            @Override
            public boolean accepts(Symbol symbol2) {
                return symbol2 == symbol;
            }
        });
        if (entry.scope == null) {
            return;
        }
        int n = this.getIndex(symbol.name);
        Entry entry2 = this.table[n];
        if (entry2 == entry) {
            this.table[n] = entry.shadowed;
        } else {
            while (true) {
                if (entry2.shadowed == entry) {
                    entry2.shadowed = entry.shadowed;
                    break;
                }
                entry2 = entry2.shadowed;
            }
        }
        entry2 = this.elems;
        if (entry2 == entry) {
            this.elems = entry.sibling;
        } else {
            while (true) {
                if (entry2.sibling == entry) {
                    entry2.sibling = entry.sibling;
                    break;
                }
                entry2 = entry2.sibling;
            }
        }
        List<ScopeListener> list = this.listeners;
        while (list.nonEmpty()) {
            ((ScopeListener)list.head).symbolRemoved(symbol, this);
            list = list.tail;
        }
    }

    public void enterIfAbsent(Symbol symbol) {
        Assert.check(this.shared == 0);
        Entry entry = this.lookup(symbol.name);
        while (entry.scope == this && entry.sym.kind != symbol.kind) {
            entry = entry.next();
        }
        if (entry.scope != this) {
            this.enter(symbol);
        }
    }

    public boolean includes(Symbol symbol) {
        Entry entry = this.lookup(symbol.name);
        while (entry.scope == this) {
            if (entry.sym == symbol) {
                return true;
            }
            entry = entry.next();
        }
        return false;
    }

    public Entry lookup(Name name) {
        return this.lookup(name, noFilter);
    }

    public Entry lookup(Name name, Filter<Symbol> filter) {
        Entry entry = this.table[this.getIndex(name)];
        if (entry == null || entry == sentinel) {
            return sentinel;
        }
        while (!(entry.scope == null || entry.sym.name == name && filter.accepts(entry.sym))) {
            entry = entry.shadowed;
        }
        return entry;
    }

    int getIndex(Name name) {
        int n = name.hashCode();
        int n2 = n & this.hashMask;
        int n3 = this.hashMask - (n + (n >> 16) << 1);
        int n4 = -1;
        Entry entry;
        while ((entry = this.table[n2]) != null) {
            if (entry == sentinel) {
                if (n4 < 0) {
                    n4 = n2;
                }
            } else if (entry.sym.name == name) {
                return n2;
            }
            n2 = n2 + n3 & this.hashMask;
        }
        return n4 >= 0 ? n4 : n2;
    }

    public boolean anyMatch(Filter<Symbol> filter) {
        return this.getElements(filter).iterator().hasNext();
    }

    public Iterable<Symbol> getElements() {
        return this.getElements(noFilter);
    }

    public Iterable<Symbol> getElements(final Filter<Symbol> filter) {
        return new Iterable<Symbol>(){

            @Override
            public Iterator<Symbol> iterator() {
                return new Iterator<Symbol>(){
                    private Scope currScope;
                    private Entry currEntry;
                    {
                        this.currScope = Scope.this;
                        this.currEntry = Scope.this.elems;
                        this.update();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.currEntry != null;
                    }

                    @Override
                    public Symbol next() {
                        Symbol symbol;
                        Symbol symbol2 = symbol = this.currEntry == null ? null : this.currEntry.sym;
                        if (this.currEntry != null) {
                            this.currEntry = this.currEntry.sibling;
                        }
                        this.update();
                        return symbol;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    private void update() {
                        this.skipToNextMatchingEntry();
                        while (this.currEntry == null && this.currScope.next != null) {
                            this.currScope = this.currScope.next;
                            this.currEntry = this.currScope.elems;
                            this.skipToNextMatchingEntry();
                        }
                    }

                    void skipToNextMatchingEntry() {
                        while (this.currEntry != null && !filter.accepts(this.currEntry.sym)) {
                            this.currEntry = this.currEntry.sibling;
                        }
                    }
                };
            }
        };
    }

    public Iterable<Symbol> getElementsByName(Name name) {
        return this.getElementsByName(name, noFilter);
    }

    public Iterable<Symbol> getElementsByName(final Name name, final Filter<Symbol> filter) {
        return new Iterable<Symbol>(){

            @Override
            public Iterator<Symbol> iterator() {
                return new Iterator<Symbol>(){
                    Entry currentEntry;
                    {
                        this.currentEntry = Scope.this.lookup(name, filter);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.currentEntry.scope != null;
                    }

                    @Override
                    public Symbol next() {
                        Entry entry = this.currentEntry;
                        this.currentEntry = this.currentEntry.next(filter);
                        return entry.sym;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Scope[");
        Scope scope = this;
        while (scope != null) {
            if (scope != this) {
                stringBuilder.append(" | ");
            }
            Entry entry = scope.elems;
            while (entry != null) {
                if (entry != scope.elems) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(entry.sym);
                entry = entry.sibling;
            }
            scope = scope.next;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static class ErrorScope
    extends Scope {
        ErrorScope(Scope scope, Symbol symbol, Entry[] entryArray) {
            super(scope, symbol, entryArray);
        }

        public ErrorScope(Symbol symbol) {
            super(symbol);
        }

        @Override
        public Scope dup() {
            return new ErrorScope(this, this.owner, this.table);
        }

        @Override
        public Scope dupUnshared() {
            return new ErrorScope(this, this.owner, (Entry[])this.table.clone());
        }

        @Override
        public Entry lookup(Name name) {
            Entry entry = super.lookup(name);
            if (entry.scope == null) {
                return new Entry(this.owner, null, null, null);
            }
            return entry;
        }
    }

    public static class CompoundScope
    extends Scope
    implements ScopeListener {
        public static final Entry[] emptyTable = new Entry[0];
        private List<Scope> subScopes = List.nil();
        private int mark = 0;

        public CompoundScope(Symbol symbol) {
            super(null, symbol, emptyTable);
        }

        public void addSubScope(Scope scope) {
            if (scope != null) {
                this.subScopes = this.subScopes.prepend(scope);
                scope.addScopeListener(this);
                ++this.mark;
                for (ScopeListener scopeListener : this.listeners) {
                    scopeListener.symbolAdded(null, this);
                }
            }
        }

        @Override
        public void symbolAdded(Symbol symbol, Scope scope) {
            ++this.mark;
            for (ScopeListener scopeListener : this.listeners) {
                scopeListener.symbolAdded(symbol, scope);
            }
        }

        @Override
        public void symbolRemoved(Symbol symbol, Scope scope) {
            ++this.mark;
            for (ScopeListener scopeListener : this.listeners) {
                scopeListener.symbolRemoved(symbol, scope);
            }
        }

        public int getMark() {
            return this.mark;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("CompoundScope{");
            String string = "";
            for (Scope scope : this.subScopes) {
                stringBuilder.append(string);
                stringBuilder.append(scope);
                string = ",";
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }

        @Override
        public Iterable<Symbol> getElements(final Filter<Symbol> filter) {
            return new Iterable<Symbol>(){

                @Override
                public Iterator<Symbol> iterator() {
                    return new CompoundScopeIterator(subScopes){

                        @Override
                        Iterator<Symbol> nextIterator(Scope scope) {
                            return scope.getElements(filter).iterator();
                        }
                    };
                }
            };
        }

        @Override
        public Iterable<Symbol> getElementsByName(final Name name, final Filter<Symbol> filter) {
            return new Iterable<Symbol>(){

                @Override
                public Iterator<Symbol> iterator() {
                    return new CompoundScopeIterator(subScopes){

                        @Override
                        Iterator<Symbol> nextIterator(Scope scope) {
                            return scope.getElementsByName(name, filter).iterator();
                        }
                    };
                }
            };
        }

        @Override
        public Entry lookup(Name name, Filter<Symbol> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Scope dup(Symbol symbol) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void enter(Symbol symbol, Scope scope, Scope scope2, boolean bl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove(Symbol symbol) {
            throw new UnsupportedOperationException();
        }

        abstract class CompoundScopeIterator
        implements Iterator<Symbol> {
            private Iterator<Symbol> currentIterator;
            private List<Scope> scopesToScan;

            public CompoundScopeIterator(List<Scope> list) {
                this.scopesToScan = list;
                this.update();
            }

            abstract Iterator<Symbol> nextIterator(Scope var1);

            @Override
            public boolean hasNext() {
                return this.currentIterator != null;
            }

            @Override
            public Symbol next() {
                Symbol symbol = this.currentIterator.next();
                if (!this.currentIterator.hasNext()) {
                    this.update();
                }
                return symbol;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void update() {
                while (this.scopesToScan.nonEmpty()) {
                    this.currentIterator = this.nextIterator((Scope)this.scopesToScan.head);
                    this.scopesToScan = this.scopesToScan.tail;
                    if (!this.currentIterator.hasNext()) continue;
                    return;
                }
                this.currentIterator = null;
            }
        }
    }

    public static class DelegatedScope
    extends Scope {
        Scope delegatee;
        public static final Entry[] emptyTable = new Entry[0];

        public DelegatedScope(Scope scope) {
            super(scope, scope.owner, emptyTable);
            this.delegatee = scope;
        }

        @Override
        public Scope dup() {
            return new DelegatedScope(this.next);
        }

        @Override
        public Scope dupUnshared() {
            return new DelegatedScope(this.next);
        }

        @Override
        public Scope leave() {
            return this.next;
        }

        @Override
        public void enter(Symbol symbol) {
        }

        @Override
        public void enter(Symbol symbol, Scope scope) {
        }

        @Override
        public void remove(Symbol symbol) {
            throw new AssertionError(symbol);
        }

        @Override
        public Entry lookup(Name name) {
            return this.delegatee.lookup(name);
        }
    }

    public static class StarImportScope
    extends ImportScope
    implements ScopeListener {
        public StarImportScope(Symbol symbol) {
            super(symbol);
        }

        public void importAll(Scope scope) {
            Entry entry = scope.elems;
            while (entry != null) {
                if (entry.sym.kind == 2 && !this.includes(entry.sym)) {
                    this.enter(entry.sym, scope);
                }
                entry = entry.sibling;
            }
            scope.addScopeListener(this);
        }

        @Override
        public void symbolRemoved(Symbol symbol, Scope scope) {
            this.remove(symbol);
        }

        @Override
        public void symbolAdded(Symbol symbol, Scope scope) {
        }
    }

    public static class ImportScope
    extends Scope {
        public ImportScope(Symbol symbol) {
            super(symbol);
        }

        @Override
        Entry makeEntry(Symbol symbol, Entry entry, Entry entry2, Scope scope, final Scope scope2, final boolean bl) {
            return new Entry(symbol, entry, entry2, scope){

                @Override
                public Scope getOrigin() {
                    return scope2;
                }

                @Override
                public boolean isStaticallyImported() {
                    return bl;
                }
            };
        }
    }

    public static class Entry {
        public Symbol sym;
        private Entry shadowed;
        public Entry sibling;
        public Scope scope;

        public Entry(Symbol symbol, Entry entry, Entry entry2, Scope scope) {
            this.sym = symbol;
            this.shadowed = entry;
            this.sibling = entry2;
            this.scope = scope;
        }

        public Entry next() {
            return this.shadowed;
        }

        public Entry next(Filter<Symbol> filter) {
            if (this.shadowed.sym == null || filter.accepts(this.shadowed.sym)) {
                return this.shadowed;
            }
            return this.shadowed.next(filter);
        }

        public boolean isStaticallyImported() {
            return false;
        }

        public Scope getOrigin() {
            return this.scope;
        }
    }

    public static interface ScopeListener {
        public void symbolAdded(Symbol var1, Scope var2);

        public void symbolRemoved(Symbol var1, Scope var2);
    }
}

