/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.util;

import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.AnnotationTypeElementDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Tag;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class VisibleMemberMap {
    private boolean noVisibleMembers = true;
    public static final int INNERCLASSES = 0;
    public static final int ENUM_CONSTANTS = 1;
    public static final int FIELDS = 2;
    public static final int CONSTRUCTORS = 3;
    public static final int METHODS = 4;
    public static final int ANNOTATION_TYPE_FIELDS = 5;
    public static final int ANNOTATION_TYPE_MEMBER_OPTIONAL = 6;
    public static final int ANNOTATION_TYPE_MEMBER_REQUIRED = 7;
    public static final int PROPERTIES = 8;
    public static final int NUM_MEMBER_TYPES = 9;
    public static final String STARTLEVEL = "start";
    private final List<ClassDoc> visibleClasses = new ArrayList<ClassDoc>();
    private final Map<Object, Map<ProgramElementDoc, String>> memberNameMap = new HashMap<Object, Map<ProgramElementDoc, String>>();
    private final Map<ClassDoc, ClassMembers> classMap = new HashMap<ClassDoc, ClassMembers>();
    private final ClassDoc classdoc;
    private final int kind;
    private final Configuration configuration;
    private static final Map<ClassDoc, ProgramElementDoc[]> propertiesCache = new HashMap<ClassDoc, ProgramElementDoc[]>();
    private static final Map<ProgramElementDoc, ProgramElementDoc> classPropertiesMap = new HashMap<ProgramElementDoc, ProgramElementDoc>();
    private static final Map<ProgramElementDoc, GetterSetter> getterSetterMap = new HashMap<ProgramElementDoc, GetterSetter>();

    public VisibleMemberMap(ClassDoc classDoc, int n, Configuration configuration) {
        this.classdoc = classDoc;
        this.kind = n;
        this.configuration = configuration;
        new ClassMembers(classDoc, STARTLEVEL).build();
    }

    public List<ClassDoc> getVisibleClassesList() {
        this.sort(this.visibleClasses);
        return this.visibleClasses;
    }

    public ProgramElementDoc getPropertyMemberDoc(ProgramElementDoc programElementDoc) {
        return classPropertiesMap.get(programElementDoc);
    }

    public ProgramElementDoc getGetterForProperty(ProgramElementDoc programElementDoc) {
        return getterSetterMap.get(programElementDoc).getGetter();
    }

    public ProgramElementDoc getSetterForProperty(ProgramElementDoc programElementDoc) {
        return getterSetterMap.get(programElementDoc).getSetter();
    }

    private List<ProgramElementDoc> getInheritedPackagePrivateMethods(Configuration configuration) {
        ArrayList<ProgramElementDoc> arrayList = new ArrayList<ProgramElementDoc>();
        for (ClassDoc classDoc : this.visibleClasses) {
            if (classDoc == this.classdoc || !classDoc.isPackagePrivate() || Util.isLinkable(classDoc, configuration)) continue;
            arrayList.addAll(this.getMembersFor(classDoc));
        }
        return arrayList;
    }

    public List<ProgramElementDoc> getLeafClassMembers(Configuration configuration) {
        List<ProgramElementDoc> list = this.getMembersFor(this.classdoc);
        list.addAll(this.getInheritedPackagePrivateMethods(configuration));
        return list;
    }

    public List<ProgramElementDoc> getMembersFor(ClassDoc classDoc) {
        ClassMembers classMembers = this.classMap.get(classDoc);
        if (classMembers == null) {
            return new ArrayList<ProgramElementDoc>();
        }
        return classMembers.getMembers();
    }

    private void sort(List<ClassDoc> list) {
        ArrayList<ClassDoc> arrayList = new ArrayList<ClassDoc>();
        ArrayList<ClassDoc> arrayList2 = new ArrayList<ClassDoc>();
        for (int i = 0; i < list.size(); ++i) {
            ClassDoc classDoc = list.get(i);
            if (classDoc.isClass()) {
                arrayList.add(classDoc);
                continue;
            }
            arrayList2.add(classDoc);
        }
        list.clear();
        list.addAll(arrayList);
        list.addAll(arrayList2);
    }

    private void fillMemberLevelMap(List<ProgramElementDoc> list, String string) {
        for (int i = 0; i < list.size(); ++i) {
            Object object = this.getMemberKey(list.get(i));
            Map<ProgramElementDoc, String> map = this.memberNameMap.get(object);
            if (map == null) {
                map = new HashMap<ProgramElementDoc, String>();
                this.memberNameMap.put(object, map);
            }
            map.put(list.get(i), string);
        }
    }

    private void purgeMemberLevelMap(List<ProgramElementDoc> list, String string) {
        for (int i = 0; i < list.size(); ++i) {
            Object object = this.getMemberKey(list.get(i));
            Map<ProgramElementDoc, String> map = this.memberNameMap.get(object);
            if (map == null || !string.equals(map.get(list.get(i)))) continue;
            map.remove(list.get(i));
        }
    }

    public boolean noVisibleMembers() {
        return this.noVisibleMembers;
    }

    private ClassMember getClassMember(MethodDoc methodDoc) {
        for (Object object : this.memberNameMap.keySet()) {
            if (object instanceof String || !((ClassMember)object).isEqual(methodDoc)) continue;
            return (ClassMember)object;
        }
        return new ClassMember(methodDoc);
    }

    private Object getMemberKey(ProgramElementDoc programElementDoc) {
        if (programElementDoc.isConstructor()) {
            return programElementDoc.name() + ((ExecutableMemberDoc)programElementDoc).signature();
        }
        if (programElementDoc.isMethod()) {
            return this.getClassMember((MethodDoc)programElementDoc);
        }
        if (programElementDoc.isField() || programElementDoc.isEnumConstant() || programElementDoc.isAnnotationTypeElement()) {
            return programElementDoc.name();
        }
        String string = programElementDoc.name();
        string = string.indexOf(46) != 0 ? string.substring(string.lastIndexOf(46), string.length()) : string;
        return "clint" + string;
    }

    private class GetterSetter {
        private final ProgramElementDoc getter;
        private final ProgramElementDoc setter;

        public GetterSetter(ProgramElementDoc programElementDoc, ProgramElementDoc programElementDoc2) {
            this.getter = programElementDoc;
            this.setter = programElementDoc2;
        }

        public ProgramElementDoc getGetter() {
            return this.getter;
        }

        public ProgramElementDoc getSetter() {
            return this.setter;
        }
    }

    private class ClassMembers {
        private ClassDoc mappingClass;
        private List<ProgramElementDoc> members = new ArrayList<ProgramElementDoc>();
        private String level;
        private final Pattern pattern = Pattern.compile("[sg]et\\p{Upper}.*");

        public List<ProgramElementDoc> getMembers() {
            return this.members;
        }

        private ClassMembers(ClassDoc classDoc, String string) {
            this.mappingClass = classDoc;
            this.level = string;
            if (VisibleMemberMap.this.classMap.containsKey(classDoc) && string.startsWith(((ClassMembers)((VisibleMemberMap)VisibleMemberMap.this).classMap.get((Object)classDoc)).level)) {
                VisibleMemberMap.this.purgeMemberLevelMap(this.getClassMembers(classDoc, false), ((ClassMembers)((VisibleMemberMap)VisibleMemberMap.this).classMap.get((Object)classDoc)).level);
                VisibleMemberMap.this.classMap.remove(classDoc);
                VisibleMemberMap.this.visibleClasses.remove(classDoc);
            }
            if (!VisibleMemberMap.this.classMap.containsKey(classDoc)) {
                VisibleMemberMap.this.classMap.put(classDoc, this);
                VisibleMemberMap.this.visibleClasses.add(classDoc);
            }
        }

        private void build() {
            if (VisibleMemberMap.this.kind == 3) {
                this.addMembers(this.mappingClass);
            } else {
                this.mapClass();
            }
        }

        private void mapClass() {
            ClassDoc classDoc;
            Object object;
            this.addMembers(this.mappingClass);
            ClassDoc[] classDocArray = this.mappingClass.interfaces();
            for (int i = 0; i < classDocArray.length; ++i) {
                object = this.level + 1;
                ClassMembers classMembers = new ClassMembers(classDocArray[i], (String)object);
                classMembers.mapClass();
            }
            if (this.mappingClass.isClass() && (classDoc = this.mappingClass.superclass()) != null && !this.mappingClass.equals(classDoc)) {
                object = new ClassMembers(classDoc, this.level + "c");
                super.mapClass();
            }
        }

        private void addMembers(ClassDoc classDoc) {
            List<ProgramElementDoc> list = this.getClassMembers(classDoc, true);
            ArrayList<ProgramElementDoc> arrayList = new ArrayList<ProgramElementDoc>();
            for (int i = 0; i < list.size(); ++i) {
                ProgramElementDoc programElementDoc = list.get(i);
                if (this.found(this.members, programElementDoc) || !this.memberIsVisible(programElementDoc) || this.isOverridden(programElementDoc, this.level) || this.isTreatedAsPrivate(programElementDoc)) continue;
                arrayList.add(programElementDoc);
            }
            if (arrayList.size() > 0) {
                VisibleMemberMap.this.noVisibleMembers = false;
            }
            this.members.addAll(arrayList);
            VisibleMemberMap.this.fillMemberLevelMap(this.getClassMembers(classDoc, false), this.level);
        }

        private boolean isTreatedAsPrivate(ProgramElementDoc programElementDoc) {
            if (!((VisibleMemberMap)VisibleMemberMap.this).configuration.javafx) {
                return false;
            }
            Tag[] tagArray = programElementDoc.tags("@treatAsPrivate");
            boolean bl = tagArray != null && tagArray.length > 0;
            return bl;
        }

        private boolean memberIsVisible(ProgramElementDoc programElementDoc) {
            if (programElementDoc.containingClass().equals(VisibleMemberMap.this.classdoc)) {
                return true;
            }
            if (programElementDoc.isPrivate()) {
                return false;
            }
            if (programElementDoc.isPackagePrivate()) {
                return programElementDoc.containingClass().containingPackage().equals(VisibleMemberMap.this.classdoc.containingPackage());
            }
            return true;
        }

        private List<ProgramElementDoc> getClassMembers(ClassDoc classDoc, boolean bl) {
            if (classDoc.isEnum() && VisibleMemberMap.this.kind == 3) {
                return Arrays.asList(new ProgramElementDoc[0]);
            }
            ProgramElementDoc[] programElementDocArray = null;
            switch (VisibleMemberMap.this.kind) {
                case 5: {
                    programElementDocArray = classDoc.fields(bl);
                    break;
                }
                case 6: {
                    programElementDocArray = classDoc.isAnnotationType() ? this.filter((AnnotationTypeDoc)classDoc, false) : new AnnotationTypeElementDoc[]{};
                    break;
                }
                case 7: {
                    programElementDocArray = classDoc.isAnnotationType() ? this.filter((AnnotationTypeDoc)classDoc, true) : new AnnotationTypeElementDoc[]{};
                    break;
                }
                case 0: {
                    programElementDocArray = classDoc.innerClasses(bl);
                    break;
                }
                case 1: {
                    programElementDocArray = classDoc.enumConstants();
                    break;
                }
                case 2: {
                    programElementDocArray = classDoc.fields(bl);
                    break;
                }
                case 3: {
                    programElementDocArray = classDoc.constructors();
                    break;
                }
                case 4: {
                    programElementDocArray = classDoc.methods(bl);
                    this.checkOnPropertiesTags((MethodDoc[])programElementDocArray);
                    break;
                }
                case 8: {
                    programElementDocArray = this.properties(classDoc, bl);
                    break;
                }
                default: {
                    programElementDocArray = new ProgramElementDoc[]{};
                }
            }
            if (((VisibleMemberMap)VisibleMemberMap.this).configuration.nodeprecated) {
                return Util.excludeDeprecatedMembersAsList(programElementDocArray);
            }
            return Arrays.asList(programElementDocArray);
        }

        private AnnotationTypeElementDoc[] filter(AnnotationTypeDoc annotationTypeDoc, boolean bl) {
            AnnotationTypeElementDoc[] annotationTypeElementDocArray = annotationTypeDoc.elements();
            ArrayList<AnnotationTypeElementDoc> arrayList = new ArrayList<AnnotationTypeElementDoc>();
            for (int i = 0; i < annotationTypeElementDocArray.length; ++i) {
                if ((!bl || annotationTypeElementDocArray[i].defaultValue() != null) && (bl || annotationTypeElementDocArray[i].defaultValue() == null)) continue;
                arrayList.add(annotationTypeElementDocArray[i]);
            }
            return arrayList.toArray(new AnnotationTypeElementDoc[0]);
        }

        private boolean found(List<ProgramElementDoc> list, ProgramElementDoc programElementDoc) {
            for (int i = 0; i < list.size(); ++i) {
                ProgramElementDoc programElementDoc2 = list.get(i);
                if (!Util.matches(programElementDoc2, programElementDoc)) continue;
                return true;
            }
            return false;
        }

        private boolean isOverridden(ProgramElementDoc programElementDoc, String string) {
            Map map = (Map)VisibleMemberMap.this.memberNameMap.get(VisibleMemberMap.this.getMemberKey(programElementDoc));
            if (map == null) {
                return false;
            }
            String string22 = null;
            for (String string22 : map.values()) {
                if (!string22.equals(VisibleMemberMap.STARTLEVEL) && (!string.startsWith(string22) || string.equals(string22))) continue;
                return true;
            }
            return false;
        }

        private ProgramElementDoc[] properties(ClassDoc classDoc, boolean bl) {
            MethodDoc[] methodDocArray = classDoc.methods(bl);
            FieldDoc[] fieldDocArray = classDoc.fields(false);
            if (propertiesCache.containsKey(classDoc)) {
                return (ProgramElementDoc[])propertiesCache.get(classDoc);
            }
            ArrayList<MethodDoc> arrayList = new ArrayList<MethodDoc>();
            for (MethodDoc methodDoc : methodDocArray) {
                if (!this.isPropertyMethod(methodDoc)) continue;
                MethodDoc methodDoc2 = this.getterForField(methodDocArray, methodDoc);
                MethodDoc methodDoc3 = this.setterForField(methodDocArray, methodDoc);
                FieldDoc fieldDoc = this.fieldForProperty(fieldDocArray, methodDoc);
                this.addToPropertiesMap(methodDoc3, methodDoc2, methodDoc, fieldDoc);
                getterSetterMap.put(methodDoc, new GetterSetter(methodDoc2, methodDoc3));
                arrayList.add(methodDoc);
            }
            ProgramElementDoc[] programElementDocArray = arrayList.toArray(new ProgramElementDoc[arrayList.size()]);
            propertiesCache.put(classDoc, programElementDocArray);
            return programElementDocArray;
        }

        private void addToPropertiesMap(MethodDoc methodDoc, MethodDoc methodDoc2, MethodDoc methodDoc3, FieldDoc fieldDoc) {
            if (fieldDoc == null || fieldDoc.getRawCommentText() == null || fieldDoc.getRawCommentText().length() == 0) {
                this.addToPropertiesMap(methodDoc, methodDoc3);
                this.addToPropertiesMap(methodDoc2, methodDoc3);
                this.addToPropertiesMap(methodDoc3, methodDoc3);
            } else {
                this.addToPropertiesMap(methodDoc2, fieldDoc);
                this.addToPropertiesMap(methodDoc, fieldDoc);
                this.addToPropertiesMap(methodDoc3, fieldDoc);
            }
        }

        private void addToPropertiesMap(ProgramElementDoc programElementDoc, ProgramElementDoc programElementDoc2) {
            if (null == programElementDoc || null == programElementDoc2) {
                return;
            }
            String string = programElementDoc.getRawCommentText();
            if (null == string || 0 == string.length() || programElementDoc.equals(programElementDoc2)) {
                classPropertiesMap.put(programElementDoc, programElementDoc2);
            }
        }

        private MethodDoc getterForField(MethodDoc[] methodDocArray, MethodDoc methodDoc) {
            String string = methodDoc.name();
            String string2 = string.substring(0, string.lastIndexOf("Property"));
            String string3 = "" + Character.toUpperCase(string2.charAt(0)) + string2.substring(1);
            String string4 = methodDoc.returnType().toString();
            String string5 = "boolean".equals(string4) || string4.endsWith("BooleanProperty") ? "(is|get)" + string3 : "get" + string3;
            for (MethodDoc methodDoc2 : methodDocArray) {
                if (!Pattern.matches(string5, methodDoc2.name()) || 0 != methodDoc2.parameters().length || !methodDoc2.isPublic() && !methodDoc2.isProtected()) continue;
                return methodDoc2;
            }
            return null;
        }

        private MethodDoc setterForField(MethodDoc[] methodDocArray, MethodDoc methodDoc) {
            String string = methodDoc.name();
            String string2 = string.substring(0, string.lastIndexOf("Property"));
            String string3 = "" + Character.toUpperCase(string2.charAt(0)) + string2.substring(1);
            String string4 = "set" + string3;
            for (MethodDoc methodDoc2 : methodDocArray) {
                if (!string4.equals(methodDoc2.name()) || 1 != methodDoc2.parameters().length || !"void".equals(methodDoc2.returnType().simpleTypeName()) || !methodDoc2.isPublic() && !methodDoc2.isProtected()) continue;
                return methodDoc2;
            }
            return null;
        }

        private FieldDoc fieldForProperty(FieldDoc[] fieldDocArray, MethodDoc methodDoc) {
            for (FieldDoc fieldDoc : fieldDocArray) {
                String string = fieldDoc.name();
                String string2 = string + "Property";
                if (!string2.equals(methodDoc.name())) continue;
                return fieldDoc;
            }
            return null;
        }

        private boolean isPropertyMethod(MethodDoc methodDoc) {
            if (!((VisibleMemberMap)VisibleMemberMap.this).configuration.javafx) {
                return false;
            }
            if (!methodDoc.name().endsWith("Property")) {
                return false;
            }
            if (!this.memberIsVisible(methodDoc)) {
                return false;
            }
            if (this.pattern.matcher(methodDoc.name()).matches()) {
                return false;
            }
            if (methodDoc.typeParameters().length > 0) {
                return false;
            }
            return 0 == methodDoc.parameters().length && !"void".equals(methodDoc.returnType().simpleTypeName());
        }

        private void checkOnPropertiesTags(MethodDoc[] methodDocArray) {
            block0: for (MethodDoc methodDoc : methodDocArray) {
                if (!methodDoc.isIncluded()) continue;
                for (Tag tag : methodDoc.tags()) {
                    String string = tag.name();
                    if (!string.equals("@propertySetter") && !string.equals("@propertyGetter") && !string.equals("@propertyDescription")) continue;
                    if (this.isPropertyGetterOrSetter(methodDocArray, methodDoc)) continue block0;
                    ((VisibleMemberMap)VisibleMemberMap.this).configuration.message.warning(tag.position(), "doclet.javafx_tag_misuse", new Object[0]);
                    continue block0;
                }
            }
        }

        private boolean isPropertyGetterOrSetter(MethodDoc[] methodDocArray, MethodDoc methodDoc) {
            boolean bl = false;
            String string = Util.propertyNameFromMethodName(VisibleMemberMap.this.configuration, methodDoc.name());
            if (!string.isEmpty()) {
                String string2 = string + "Property";
                for (MethodDoc methodDoc2 : methodDocArray) {
                    if (!methodDoc2.name().equals(string2)) continue;
                    bl = true;
                    break;
                }
            }
            return bl;
        }
    }

    private class ClassMember {
        private Set<ProgramElementDoc> members = new HashSet<ProgramElementDoc>();

        public ClassMember(ProgramElementDoc programElementDoc) {
            this.members.add(programElementDoc);
        }

        public void addMember(ProgramElementDoc programElementDoc) {
            this.members.add(programElementDoc);
        }

        public boolean isEqual(MethodDoc methodDoc) {
            for (MethodDoc methodDoc2 : this.members) {
                if (!Util.executableMembersEqual(methodDoc, methodDoc2)) continue;
                this.members.add(methodDoc);
                return true;
            }
            return false;
        }
    }
}

