/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.util;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IndexBuilder {
    private Map<Character, List<Doc>> indexmap = new HashMap<Character, List<Doc>>();
    private boolean noDeprecated;
    private boolean classesOnly;
    private boolean javafx;
    protected final Object[] elements;

    public IndexBuilder(Configuration configuration, boolean bl) {
        this(configuration, bl, false);
    }

    public IndexBuilder(Configuration configuration, boolean bl, boolean bl2) {
        if (bl2) {
            configuration.message.notice("doclet.Building_Index_For_All_Classes", new Object[0]);
        } else {
            configuration.message.notice("doclet.Building_Index", new Object[0]);
        }
        this.noDeprecated = bl;
        this.classesOnly = bl2;
        this.javafx = configuration.javafx;
        this.buildIndexMap(configuration.root);
        Set<Character> set = this.indexmap.keySet();
        this.elements = set.toArray();
        Arrays.sort(this.elements);
    }

    protected void sortIndexMap() {
        Iterator<List<Doc>> iterator = this.indexmap.values().iterator();
        while (iterator.hasNext()) {
            Collections.sort(iterator.next(), new DocComparator());
        }
    }

    protected void buildIndexMap(RootDoc rootDoc) {
        Doc[] docArray = rootDoc.specifiedPackages();
        Doc[] docArray2 = rootDoc.classes();
        if (!this.classesOnly) {
            if (docArray.length == 0) {
                HashSet<PackageDoc> hashSet = new HashSet<PackageDoc>();
                for (int i = 0; i < docArray2.length; ++i) {
                    PackageDoc packageDoc = docArray2[i].containingPackage();
                    if (packageDoc == null || packageDoc.name().length() <= 0) continue;
                    hashSet.add(packageDoc);
                }
                this.adjustIndexMap(hashSet.toArray(docArray));
            } else {
                this.adjustIndexMap(docArray);
            }
        }
        this.adjustIndexMap(docArray2);
        if (!this.classesOnly) {
            for (int i = 0; i < docArray2.length; ++i) {
                if (!this.shouldAddToIndexMap(docArray2[i])) continue;
                this.putMembersInIndexMap((ClassDoc)docArray2[i]);
            }
        }
        this.sortIndexMap();
    }

    protected void putMembersInIndexMap(ClassDoc classDoc) {
        this.adjustIndexMap(classDoc.fields());
        this.adjustIndexMap(classDoc.methods());
        this.adjustIndexMap(classDoc.constructors());
    }

    protected void adjustIndexMap(Doc[] docArray) {
        for (int i = 0; i < docArray.length; ++i) {
            if (!this.shouldAddToIndexMap(docArray[i])) continue;
            String string = docArray[i].name();
            char c = string.length() == 0 ? (char)'*' : (char)Character.toUpperCase(string.charAt(0));
            Character c2 = new Character(c);
            List<Doc> list = this.indexmap.get(c2);
            if (list == null) {
                list = new ArrayList<Doc>();
                this.indexmap.put(c2, list);
            }
            list.add(docArray[i]);
        }
    }

    protected boolean shouldAddToIndexMap(Doc doc) {
        if (this.javafx && doc.tags("treatAsPrivate").length > 0) {
            return false;
        }
        if (doc instanceof PackageDoc) {
            return !this.noDeprecated || !Util.isDeprecated(doc);
        }
        return !this.noDeprecated || !Util.isDeprecated(doc) && !Util.isDeprecated(((ProgramElementDoc)doc).containingPackage());
    }

    public Map<Character, List<Doc>> getIndexMap() {
        return this.indexmap;
    }

    public List<Doc> getMemberList(Character c) {
        return this.indexmap.get(c);
    }

    public Object[] elements() {
        return this.elements;
    }

    private class DocComparator
    implements Comparator<Doc> {
        private DocComparator() {
        }

        @Override
        public int compare(Doc doc, Doc doc2) {
            String string;
            String string2 = doc.name();
            int n = string2.compareToIgnoreCase(string = doc2.name());
            if (n != 0) {
                return n;
            }
            if (doc instanceof ProgramElementDoc && doc2 instanceof ProgramElementDoc) {
                string2 = ((ProgramElementDoc)doc).qualifiedName();
                string = ((ProgramElementDoc)doc2).qualifiedName();
                return string2.compareToIgnoreCase(string);
            }
            return 0;
        }
    }
}

