/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.util;

import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.util.DocFile;
import com.sun.tools.doclets.internal.toolkit.util.DocLink;
import com.sun.tools.doclets.internal.toolkit.util.DocPath;
import com.sun.tools.doclets.internal.toolkit.util.DocPaths;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.tools.DocumentationTool;

public class Extern {
    private Map<String, Item> packageToItemMap;
    private final Configuration configuration;
    private boolean linkoffline = false;

    public Extern(Configuration configuration) {
        this.configuration = configuration;
    }

    public boolean isExternal(ProgramElementDoc programElementDoc) {
        if (this.packageToItemMap == null) {
            return false;
        }
        return this.packageToItemMap.get(programElementDoc.containingPackage().name()) != null;
    }

    public DocLink getExternalLink(String string, DocPath docPath, String string2) {
        return this.getExternalLink(string, docPath, string2, null);
    }

    public DocLink getExternalLink(String string, DocPath docPath, String string2, String string3) {
        Item item = this.findPackageItem(string);
        if (item == null) {
            return null;
        }
        DocPath docPath2 = item.relative ? docPath.resolve(item.path).resolve(string2) : DocPath.create(item.path).resolve(string2);
        return new DocLink(docPath2, "is-external=true", string3);
    }

    public boolean link(String string, String string2, DocErrorReporter docErrorReporter, boolean bl) {
        this.linkoffline = bl;
        try {
            string = this.adjustEndFileSeparator(string);
            if (this.isUrl(string2)) {
                this.readPackageListFromURL(string, this.toURL(this.adjustEndFileSeparator(string2)));
            } else {
                this.readPackageListFromFile(string, DocFile.createFileForInput(this.configuration, string2));
            }
            return true;
        }
        catch (Fault fault) {
            docErrorReporter.printWarning(fault.getMessage());
            return false;
        }
    }

    private URL toURL(String string) throws Fault {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new Fault(this.configuration.getText("doclet.MalformedURL", string), malformedURLException);
        }
    }

    private Item findPackageItem(String string) {
        if (this.packageToItemMap == null) {
            return null;
        }
        return this.packageToItemMap.get(string);
    }

    private String adjustEndFileSeparator(String string) {
        return string.endsWith("/") ? string : string + '/';
    }

    private void readPackageListFromURL(String string, URL uRL) throws Fault {
        try {
            URL uRL2 = uRL.toURI().resolve(DocPaths.PACKAGE_LIST.getPath()).toURL();
            this.readPackageList(uRL2.openStream(), string, false);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new Fault(this.configuration.getText("doclet.MalformedURL", uRL.toString()), uRISyntaxException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new Fault(this.configuration.getText("doclet.MalformedURL", uRL.toString()), malformedURLException);
        }
        catch (IOException iOException) {
            throw new Fault(this.configuration.getText("doclet.URL_error", uRL.toString()), iOException);
        }
    }

    private void readPackageListFromFile(String string, DocFile docFile) throws Fault {
        DocFile docFile2 = docFile.resolve(DocPaths.PACKAGE_LIST);
        if (!docFile2.isAbsolute() && !this.linkoffline) {
            docFile2 = docFile2.resolveAgainst(DocumentationTool.Location.DOCUMENTATION_OUTPUT);
        }
        try {
            if (!docFile2.exists() || !docFile2.canRead()) {
                throw new Fault(this.configuration.getText("doclet.File_error", docFile2.getPath()), null);
            }
            boolean bl = !DocFile.createFileForInput(this.configuration, string).isAbsolute() && !this.isUrl(string);
            this.readPackageList(docFile2.openInputStream(), string, bl);
        }
        catch (IOException iOException) {
            throw new Fault(this.configuration.getText("doclet.File_error", docFile2.getPath()), iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPackageList(InputStream inputStream, String string, boolean bl) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = bufferedReader.read()) >= 0) {
                char c = (char)n;
                if (c == '\n' || c == '\r') {
                    if (stringBuilder.length() <= 0) continue;
                    String string2 = stringBuilder.toString();
                    String string3 = string + string2.replace('.', '/') + '/';
                    new Item(string2, string3, bl);
                    stringBuilder.setLength(0);
                    continue;
                }
                stringBuilder.append(c);
            }
        }
        finally {
            inputStream.close();
        }
    }

    public boolean isUrl(String string) {
        try {
            new URL(string);
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    private class Fault
    extends Exception {
        private static final long serialVersionUID = 0L;

        Fault(String string, Exception exception) {
            super(string, exception);
        }
    }

    private class Item {
        final String packageName;
        final String path;
        final boolean relative;

        Item(String string, String string2, boolean bl) {
            this.packageName = string;
            this.path = string2;
            this.relative = bl;
            if (Extern.this.packageToItemMap == null) {
                Extern.this.packageToItemMap = new HashMap();
            }
            if (!Extern.this.packageToItemMap.containsKey(string)) {
                Extern.this.packageToItemMap.put(string, this);
            }
        }

        public String toString() {
            return this.packageName + (this.relative ? " -> " : " => ") + this.path;
        }
    }
}

