/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.util;

import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.util.DocFileFactory;
import com.sun.tools.doclets.internal.toolkit.util.DocPath;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.doclets.internal.toolkit.util.DocletConstants;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.tools.JavaFileManager;

public abstract class DocFile {
    private final Configuration configuration;
    protected final JavaFileManager.Location location;
    protected final DocPath path;

    public static DocFile createFileForDirectory(Configuration configuration, String string) {
        return DocFileFactory.getFactory(configuration).createFileForDirectory(string);
    }

    public static DocFile createFileForInput(Configuration configuration, String string) {
        return DocFileFactory.getFactory(configuration).createFileForInput(string);
    }

    public static DocFile createFileForOutput(Configuration configuration, DocPath docPath) {
        return DocFileFactory.getFactory(configuration).createFileForOutput(docPath);
    }

    public static Iterable<DocFile> list(Configuration configuration, JavaFileManager.Location location, DocPath docPath) {
        return DocFileFactory.getFactory(configuration).list(location, docPath);
    }

    protected DocFile(Configuration configuration) {
        this.configuration = configuration;
        this.location = null;
        this.path = null;
    }

    protected DocFile(Configuration configuration, JavaFileManager.Location location, DocPath docPath) {
        this.configuration = configuration;
        this.location = location;
        this.path = docPath;
    }

    public abstract InputStream openInputStream() throws IOException;

    public abstract OutputStream openOutputStream() throws IOException, UnsupportedEncodingException;

    public abstract Writer openWriter() throws IOException, UnsupportedEncodingException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFile(DocFile docFile) throws IOException {
        InputStream inputStream = docFile.openInputStream();
        OutputStream outputStream = this.openOutputStream();
        try {
            int n;
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        finally {
            inputStream.close();
            outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyResource(DocPath docPath, boolean bl, boolean bl2) {
        block13: {
            if (this.exists() && !bl) {
                return;
            }
            try {
                InputStream inputStream = Configuration.class.getResourceAsStream(docPath.getPath());
                if (inputStream == null) {
                    return;
                }
                OutputStream outputStream = this.openOutputStream();
                try {
                    if (!bl2) {
                        int n;
                        byte[] byArray = new byte[2048];
                        while ((n = inputStream.read(byArray)) > 0) {
                            outputStream.write(byArray, 0, n);
                        }
                        break block13;
                    }
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    BufferedWriter bufferedWriter = this.configuration.docencoding == null ? new BufferedWriter(new OutputStreamWriter(outputStream)) : new BufferedWriter(new OutputStreamWriter(outputStream, this.configuration.docencoding));
                    try {
                        String string;
                        while ((string = bufferedReader.readLine()) != null) {
                            bufferedWriter.write(string);
                            bufferedWriter.write(DocletConstants.NL);
                        }
                    }
                    finally {
                        bufferedReader.close();
                        bufferedWriter.close();
                    }
                }
                finally {
                    inputStream.close();
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
                throw new DocletAbortException(iOException);
            }
        }
    }

    public abstract boolean canRead();

    public abstract boolean canWrite();

    public abstract boolean exists();

    public abstract String getName();

    public abstract String getPath();

    public abstract boolean isAbsolute();

    public abstract boolean isDirectory();

    public abstract boolean isFile();

    public abstract boolean isSameFile(DocFile var1);

    public abstract Iterable<DocFile> list() throws IOException;

    public abstract boolean mkdirs();

    public abstract DocFile resolve(DocPath var1);

    public abstract DocFile resolve(String var1);

    public abstract DocFile resolveAgainst(JavaFileManager.Location var1);
}

