/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.util;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ParameterizedType;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Type;
import com.sun.javadoc.TypeVariable;
import com.sun.javadoc.WildcardType;
import com.sun.tools.doclets.internal.toolkit.util.ClassTree;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ClassUseMapper {
    private final ClassTree classtree;
    public Map<String, Set<PackageDoc>> classToPackage = new HashMap<String, Set<PackageDoc>>();
    public Map<String, List<PackageDoc>> classToPackageAnnotations = new HashMap<String, List<PackageDoc>>();
    public Map<String, Set<ClassDoc>> classToClass = new HashMap<String, Set<ClassDoc>>();
    public Map<String, List<ClassDoc>> classToSubclass = new HashMap<String, List<ClassDoc>>();
    public Map<String, List<ClassDoc>> classToSubinterface = new HashMap<String, List<ClassDoc>>();
    public Map<String, List<ClassDoc>> classToImplementingClass = new HashMap<String, List<ClassDoc>>();
    public Map<String, List<FieldDoc>> classToField = new HashMap<String, List<FieldDoc>>();
    public Map<String, List<MethodDoc>> classToMethodReturn = new HashMap<String, List<MethodDoc>>();
    public Map<String, List<ExecutableMemberDoc>> classToMethodArgs = new HashMap<String, List<ExecutableMemberDoc>>();
    public Map<String, List<ExecutableMemberDoc>> classToMethodThrows = new HashMap<String, List<ExecutableMemberDoc>>();
    public Map<String, List<ExecutableMemberDoc>> classToConstructorArgs = new HashMap<String, List<ExecutableMemberDoc>>();
    public Map<String, List<ExecutableMemberDoc>> classToConstructorThrows = new HashMap<String, List<ExecutableMemberDoc>>();
    public Map<String, List<ConstructorDoc>> classToConstructorAnnotations = new HashMap<String, List<ConstructorDoc>>();
    public Map<String, List<ExecutableMemberDoc>> classToConstructorParamAnnotation = new HashMap<String, List<ExecutableMemberDoc>>();
    public Map<String, List<ExecutableMemberDoc>> classToConstructorDocArgTypeParam = new HashMap<String, List<ExecutableMemberDoc>>();
    public Map<String, List<ClassDoc>> classToClassTypeParam = new HashMap<String, List<ClassDoc>>();
    public Map<String, List<ClassDoc>> classToClassAnnotations = new HashMap<String, List<ClassDoc>>();
    public Map<String, List<MethodDoc>> classToExecMemberDocTypeParam = new HashMap<String, List<MethodDoc>>();
    public Map<String, List<ExecutableMemberDoc>> classToExecMemberDocArgTypeParam = new HashMap<String, List<ExecutableMemberDoc>>();
    public Map<String, List<MethodDoc>> classToExecMemberDocAnnotations = new HashMap<String, List<MethodDoc>>();
    public Map<String, List<MethodDoc>> classToExecMemberDocReturnTypeParam = new HashMap<String, List<MethodDoc>>();
    public Map<String, List<ExecutableMemberDoc>> classToExecMemberDocParamAnnotation = new HashMap<String, List<ExecutableMemberDoc>>();
    public Map<String, List<FieldDoc>> classToFieldDocTypeParam = new HashMap<String, List<FieldDoc>>();
    public Map<String, List<FieldDoc>> annotationToFieldDoc = new HashMap<String, List<FieldDoc>>();

    public ClassUseMapper(RootDoc rootDoc, ClassTree classTree) {
        this.classtree = classTree;
        ClassDoc[] classDocArray = classTree.baseclasses().iterator();
        while (classDocArray.hasNext()) {
            this.subclasses(classDocArray.next());
        }
        classDocArray = classTree.baseinterfaces().iterator();
        while (classDocArray.hasNext()) {
            this.implementingClasses(classDocArray.next());
        }
        classDocArray = rootDoc.classes();
        for (int i = 0; i < classDocArray.length; ++i) {
            MethodDoc[] methodDocArray;
            PackageDoc packageDoc = classDocArray[i].containingPackage();
            this.mapAnnotations(this.classToPackageAnnotations, packageDoc, packageDoc);
            ClassDoc classDoc = classDocArray[i];
            this.mapTypeParameters(this.classToClassTypeParam, classDoc, classDoc);
            this.mapAnnotations(this.classToClassAnnotations, classDoc, classDoc);
            FieldDoc[] fieldDocArray = classDoc.fields();
            for (int j = 0; j < fieldDocArray.length; ++j) {
                methodDocArray = fieldDocArray[j];
                this.mapTypeParameters(this.classToFieldDocTypeParam, methodDocArray, methodDocArray);
                this.mapAnnotations(this.annotationToFieldDoc, methodDocArray, methodDocArray);
                if (methodDocArray.type().isPrimitive()) continue;
                this.add(this.classToField, methodDocArray.type().asClassDoc(), methodDocArray);
            }
            ConstructorDoc[] constructorDocArray = classDoc.constructors();
            for (int j = 0; j < constructorDocArray.length; ++j) {
                this.mapAnnotations(this.classToConstructorAnnotations, constructorDocArray[j], constructorDocArray[j]);
                this.mapExecutable(constructorDocArray[j]);
            }
            methodDocArray = classDoc.methods();
            for (int j = 0; j < methodDocArray.length; ++j) {
                MethodDoc methodDoc = methodDocArray[j];
                this.mapExecutable(methodDoc);
                this.mapTypeParameters(this.classToExecMemberDocTypeParam, methodDoc, methodDoc);
                this.mapAnnotations(this.classToExecMemberDocAnnotations, methodDoc, methodDoc);
                if (methodDoc.returnType().isPrimitive() || methodDoc.returnType() instanceof TypeVariable) continue;
                this.mapTypeParameters(this.classToExecMemberDocReturnTypeParam, methodDoc.returnType(), methodDoc);
                this.add(this.classToMethodReturn, methodDoc.returnType().asClassDoc(), methodDoc);
            }
        }
    }

    private Collection<ClassDoc> subclasses(ClassDoc classDoc) {
        TreeSet<ClassDoc> treeSet = (TreeSet<ClassDoc>)((Object)this.classToSubclass.get(classDoc.qualifiedName()));
        if (treeSet == null) {
            treeSet = new TreeSet<ClassDoc>();
            List<ClassDoc> list = this.classtree.subclasses(classDoc);
            if (list != null) {
                treeSet.addAll(list);
                Iterator<ClassDoc> iterator = list.iterator();
                while (iterator.hasNext()) {
                    treeSet.addAll(this.subclasses(iterator.next()));
                }
            }
            this.addAll(this.classToSubclass, classDoc, treeSet);
        }
        return treeSet;
    }

    private Collection<ClassDoc> subinterfaces(ClassDoc classDoc) {
        TreeSet<ClassDoc> treeSet = (TreeSet<ClassDoc>)((Object)this.classToSubinterface.get(classDoc.qualifiedName()));
        if (treeSet == null) {
            treeSet = new TreeSet<ClassDoc>();
            List<ClassDoc> list = this.classtree.subinterfaces(classDoc);
            if (list != null) {
                treeSet.addAll(list);
                Iterator<ClassDoc> iterator = list.iterator();
                while (iterator.hasNext()) {
                    treeSet.addAll(this.subinterfaces(iterator.next()));
                }
            }
            this.addAll(this.classToSubinterface, classDoc, treeSet);
        }
        return treeSet;
    }

    private Collection<ClassDoc> implementingClasses(ClassDoc classDoc) {
        TreeSet<ClassDoc> treeSet = (TreeSet<ClassDoc>)((Object)this.classToImplementingClass.get(classDoc.qualifiedName()));
        if (treeSet == null) {
            Iterator<ClassDoc> iterator;
            treeSet = new TreeSet<ClassDoc>();
            List<ClassDoc> list = this.classtree.implementingclasses(classDoc);
            if (list != null) {
                treeSet.addAll(list);
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    treeSet.addAll(this.subclasses(iterator.next()));
                }
            }
            iterator = this.subinterfaces(classDoc).iterator();
            while (iterator.hasNext()) {
                treeSet.addAll(this.implementingClasses(iterator.next()));
            }
            this.addAll(this.classToImplementingClass, classDoc, treeSet);
        }
        return treeSet;
    }

    private void mapExecutable(ExecutableMemberDoc executableMemberDoc) {
        Parameter[] parameterArray = executableMemberDoc.parameters();
        boolean bl = executableMemberDoc.isConstructor();
        ArrayList<Type> arrayList = new ArrayList<Type>();
        for (int i = 0; i < parameterArray.length; ++i) {
            Type type = parameterArray[i].type();
            if (!(parameterArray[i].type().isPrimitive() || arrayList.contains(type) || type instanceof TypeVariable)) {
                this.add(bl ? this.classToConstructorArgs : this.classToMethodArgs, type.asClassDoc(), executableMemberDoc);
                arrayList.add(type);
                this.mapTypeParameters(bl ? this.classToConstructorDocArgTypeParam : this.classToExecMemberDocArgTypeParam, type, executableMemberDoc);
            }
            this.mapAnnotations(bl ? this.classToConstructorParamAnnotation : this.classToExecMemberDocParamAnnotation, parameterArray[i], executableMemberDoc);
        }
        ClassDoc[] classDocArray = executableMemberDoc.thrownExceptions();
        for (int i = 0; i < classDocArray.length; ++i) {
            this.add(bl ? this.classToConstructorThrows : this.classToMethodThrows, classDocArray[i], executableMemberDoc);
        }
    }

    private <T> List<T> refList(Map<String, List<T>> map, ClassDoc classDoc) {
        List<T> list = map.get(classDoc.qualifiedName());
        if (list == null) {
            ArrayList<T> arrayList = new ArrayList<T>();
            list = arrayList;
            map.put(classDoc.qualifiedName(), list);
        }
        return list;
    }

    private Set<PackageDoc> packageSet(ClassDoc classDoc) {
        Set<PackageDoc> set = this.classToPackage.get(classDoc.qualifiedName());
        if (set == null) {
            set = new TreeSet<PackageDoc>();
            this.classToPackage.put(classDoc.qualifiedName(), set);
        }
        return set;
    }

    private Set<ClassDoc> classSet(ClassDoc classDoc) {
        Set<ClassDoc> set = this.classToClass.get(classDoc.qualifiedName());
        if (set == null) {
            TreeSet<ClassDoc> treeSet = new TreeSet<ClassDoc>();
            set = treeSet;
            this.classToClass.put(classDoc.qualifiedName(), set);
        }
        return set;
    }

    private <T extends ProgramElementDoc> void add(Map<String, List<T>> map, ClassDoc classDoc, T t) {
        this.refList(map, classDoc).add(t);
        this.packageSet(classDoc).add(t.containingPackage());
        this.classSet(classDoc).add(t instanceof MemberDoc ? ((MemberDoc)t).containingClass() : (ClassDoc)t);
    }

    private void addAll(Map<String, List<ClassDoc>> map, ClassDoc classDoc, Collection<ClassDoc> collection) {
        if (collection == null) {
            return;
        }
        this.refList(map, classDoc).addAll(collection);
        Set<PackageDoc> set = this.packageSet(classDoc);
        Set<ClassDoc> set2 = this.classSet(classDoc);
        for (ClassDoc classDoc2 : collection) {
            set.add(classDoc2.containingPackage());
            set2.add(classDoc2);
        }
    }

    private <T extends ProgramElementDoc> void mapTypeParameters(Map<String, List<T>> map, Object object, T t) {
        TypeVariable[] typeVariableArray;
        if (object instanceof ClassDoc) {
            typeVariableArray = ((ClassDoc)object).typeParameters();
        } else {
            if (object instanceof WildcardType) {
                Type[] typeArray = ((WildcardType)object).extendsBounds();
                for (int i = 0; i < typeArray.length; ++i) {
                    this.addTypeParameterToMap(map, typeArray[i], t);
                }
                Type[] typeArray2 = ((WildcardType)object).superBounds();
                for (int i = 0; i < typeArray2.length; ++i) {
                    this.addTypeParameterToMap(map, typeArray2[i], t);
                }
                return;
            }
            if (object instanceof ParameterizedType) {
                Type[] typeArray = ((ParameterizedType)object).typeArguments();
                for (int i = 0; i < typeArray.length; ++i) {
                    this.addTypeParameterToMap(map, typeArray[i], t);
                }
                return;
            }
            if (object instanceof ExecutableMemberDoc) {
                typeVariableArray = ((ExecutableMemberDoc)object).typeParameters();
            } else {
                if (object instanceof FieldDoc) {
                    Type type = ((FieldDoc)object).type();
                    this.mapTypeParameters(map, type, t);
                    return;
                }
                return;
            }
        }
        for (int i = 0; i < typeVariableArray.length; ++i) {
            Type[] typeArray = typeVariableArray[i].bounds();
            for (int j = 0; j < typeArray.length; ++j) {
                this.addTypeParameterToMap(map, typeArray[j], t);
            }
        }
    }

    private <T extends ProgramElementDoc> void mapAnnotations(Map<String, List<T>> map, Object object, T t) {
        AnnotationDesc[] annotationDescArray;
        boolean bl = false;
        if (object instanceof ProgramElementDoc) {
            annotationDescArray = ((ProgramElementDoc)object).annotations();
        } else if (object instanceof PackageDoc) {
            annotationDescArray = ((PackageDoc)object).annotations();
            bl = true;
        } else if (object instanceof Parameter) {
            annotationDescArray = ((Parameter)object).annotations();
        } else {
            throw new DocletAbortException("should not happen");
        }
        for (int i = 0; i < annotationDescArray.length; ++i) {
            AnnotationTypeDoc annotationTypeDoc = annotationDescArray[i].annotationType();
            if (bl) {
                this.refList(map, annotationTypeDoc).add(t);
                continue;
            }
            this.add(map, annotationTypeDoc, t);
        }
    }

    private <T extends PackageDoc> void mapAnnotations(Map<String, List<T>> map, PackageDoc packageDoc, T t) {
        AnnotationDesc[] annotationDescArray = packageDoc.annotations();
        for (int i = 0; i < annotationDescArray.length; ++i) {
            AnnotationTypeDoc annotationTypeDoc = annotationDescArray[i].annotationType();
            this.refList(map, annotationTypeDoc).add(t);
        }
    }

    private <T extends ProgramElementDoc> void addTypeParameterToMap(Map<String, List<T>> map, Type type, T t) {
        if (type instanceof ClassDoc) {
            this.add(map, (ClassDoc)type, t);
        } else if (type instanceof ParameterizedType) {
            this.add(map, ((ParameterizedType)type).asClassDoc(), t);
        }
        this.mapTypeParameters(map, type, t);
    }
}

