/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.util;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Type;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class ClassTree {
    private List<ClassDoc> baseclasses = new ArrayList<ClassDoc>();
    private Map<ClassDoc, List<ClassDoc>> subclasses = new HashMap<ClassDoc, List<ClassDoc>>();
    private List<ClassDoc> baseinterfaces = new ArrayList<ClassDoc>();
    private Map<ClassDoc, List<ClassDoc>> subinterfaces = new HashMap<ClassDoc, List<ClassDoc>>();
    private List<ClassDoc> baseEnums = new ArrayList<ClassDoc>();
    private Map<ClassDoc, List<ClassDoc>> subEnums = new HashMap<ClassDoc, List<ClassDoc>>();
    private List<ClassDoc> baseAnnotationTypes = new ArrayList<ClassDoc>();
    private Map<ClassDoc, List<ClassDoc>> subAnnotationTypes = new HashMap<ClassDoc, List<ClassDoc>>();
    private Map<ClassDoc, List<ClassDoc>> implementingclasses = new HashMap<ClassDoc, List<ClassDoc>>();

    public ClassTree(Configuration configuration, boolean bl) {
        configuration.message.notice("doclet.Building_Tree", new Object[0]);
        this.buildTree(configuration.root.classes(), configuration);
    }

    public ClassTree(RootDoc rootDoc, Configuration configuration) {
        this.buildTree(rootDoc.classes(), configuration);
    }

    public ClassTree(ClassDoc[] classDocArray, Configuration configuration) {
        this.buildTree(classDocArray, configuration);
    }

    private void buildTree(ClassDoc[] classDocArray, Configuration configuration) {
        for (int i = 0; i < classDocArray.length; ++i) {
            if (configuration.nodeprecated && (Util.isDeprecated(classDocArray[i]) || Util.isDeprecated(classDocArray[i].containingPackage())) || configuration.javafx && classDocArray[i].tags("treatAsPrivate").length > 0) continue;
            if (classDocArray[i].isEnum()) {
                this.processType(classDocArray[i], configuration, this.baseEnums, this.subEnums);
                continue;
            }
            if (classDocArray[i].isClass()) {
                this.processType(classDocArray[i], configuration, this.baseclasses, this.subclasses);
                continue;
            }
            if (classDocArray[i].isInterface()) {
                this.processInterface(classDocArray[i]);
                List<ClassDoc> list = this.implementingclasses.get(classDocArray[i]);
                if (list == null) continue;
                Collections.sort(list);
                continue;
            }
            if (!classDocArray[i].isAnnotationType()) continue;
            this.processType(classDocArray[i], configuration, this.baseAnnotationTypes, this.subAnnotationTypes);
        }
        Collections.sort(this.baseinterfaces);
        Iterator<List<ClassDoc>> iterator = this.subinterfaces.values().iterator();
        while (iterator.hasNext()) {
            Collections.sort(iterator.next());
        }
        iterator = this.subclasses.values().iterator();
        while (iterator.hasNext()) {
            Collections.sort(iterator.next());
        }
    }

    private void processType(ClassDoc classDoc, Configuration configuration, List<ClassDoc> list, Map<ClassDoc, List<ClassDoc>> map) {
        ClassDoc classDoc2 = Util.getFirstVisibleSuperClassCD(classDoc, configuration);
        if (classDoc2 != null) {
            if (!this.add(map, classDoc2, classDoc)) {
                return;
            }
            this.processType(classDoc2, configuration, list, map);
        } else if (!list.contains(classDoc)) {
            list.add(classDoc);
        }
        List<Type> list2 = Util.getAllInterfaces(classDoc, configuration);
        Iterator<Type> iterator = list2.iterator();
        while (iterator.hasNext()) {
            this.add(this.implementingclasses, iterator.next().asClassDoc(), classDoc);
        }
    }

    private void processInterface(ClassDoc classDoc) {
        ClassDoc[] classDocArray = classDoc.interfaces();
        if (classDocArray.length > 0) {
            for (int i = 0; i < classDocArray.length; ++i) {
                if (!this.add(this.subinterfaces, classDocArray[i], classDoc)) {
                    return;
                }
                this.processInterface(classDocArray[i]);
            }
        } else if (!this.baseinterfaces.contains(classDoc)) {
            this.baseinterfaces.add(classDoc);
        }
    }

    private boolean add(Map<ClassDoc, List<ClassDoc>> map, ClassDoc classDoc, ClassDoc classDoc2) {
        List<ClassDoc> list = map.get(classDoc);
        if (list == null) {
            list = new ArrayList<ClassDoc>();
            map.put(classDoc, list);
        }
        if (list.contains(classDoc2)) {
            return false;
        }
        list.add(classDoc2);
        return true;
    }

    private List<ClassDoc> get(Map<ClassDoc, List<ClassDoc>> map, ClassDoc classDoc) {
        List<ClassDoc> list = map.get(classDoc);
        if (list == null) {
            return new ArrayList<ClassDoc>();
        }
        return list;
    }

    public List<ClassDoc> subclasses(ClassDoc classDoc) {
        return this.get(this.subclasses, classDoc);
    }

    public List<ClassDoc> subinterfaces(ClassDoc classDoc) {
        return this.get(this.subinterfaces, classDoc);
    }

    public List<ClassDoc> implementingclasses(ClassDoc classDoc) {
        List<ClassDoc> list = this.get(this.implementingclasses, classDoc);
        List<ClassDoc> list2 = this.allSubs(classDoc, false);
        ListIterator<ClassDoc> listIterator = list2.listIterator();
        while (listIterator.hasNext()) {
            ListIterator<ClassDoc> listIterator2 = this.implementingclasses((ClassDoc)listIterator.next()).listIterator();
            while (listIterator2.hasNext()) {
                ClassDoc classDoc2 = (ClassDoc)listIterator2.next();
                if (list.contains(classDoc2)) continue;
                list.add(classDoc2);
            }
        }
        Collections.sort(list);
        return list;
    }

    public List<ClassDoc> subs(ClassDoc classDoc, boolean bl) {
        if (bl) {
            return this.get(this.subEnums, classDoc);
        }
        if (classDoc.isAnnotationType()) {
            return this.get(this.subAnnotationTypes, classDoc);
        }
        if (classDoc.isInterface()) {
            return this.get(this.subinterfaces, classDoc);
        }
        if (classDoc.isClass()) {
            return this.get(this.subclasses, classDoc);
        }
        return null;
    }

    public List<ClassDoc> allSubs(ClassDoc classDoc, boolean bl) {
        List<ClassDoc> list = this.subs(classDoc, bl);
        for (int i = 0; i < list.size(); ++i) {
            classDoc = list.get(i);
            List<ClassDoc> list2 = this.subs(classDoc, bl);
            for (int j = 0; j < list2.size(); ++j) {
                ClassDoc classDoc2 = list2.get(j);
                if (list.contains(classDoc2)) continue;
                list.add(classDoc2);
            }
        }
        Collections.sort(list);
        return list;
    }

    public List<ClassDoc> baseclasses() {
        return this.baseclasses;
    }

    public List<ClassDoc> baseinterfaces() {
        return this.baseinterfaces;
    }

    public List<ClassDoc> baseEnums() {
        return this.baseEnums;
    }

    public List<ClassDoc> baseAnnotationTypes() {
        return this.baseAnnotationTypes;
    }
}

