/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.builders;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.SerialFieldTag;
import com.sun.javadoc.Tag;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.SerializedFormWriter;
import com.sun.tools.doclets.internal.toolkit.builders.AbstractBuilder;
import com.sun.tools.doclets.internal.toolkit.builders.XMLNode;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import com.sun.tools.javac.util.StringUtils;
import java.io.IOException;
import java.util.Arrays;

public class SerializedFormBuilder
extends AbstractBuilder {
    public static final String NAME = "SerializedForm";
    private SerializedFormWriter writer;
    private SerializedFormWriter.SerialFieldWriter fieldWriter;
    private SerializedFormWriter.SerialMethodWriter methodWriter;
    private static final String SERIAL_VERSION_UID_HEADER = "serialVersionUID:";
    private PackageDoc currentPackage;
    private ClassDoc currentClass;
    protected MemberDoc currentMember;
    private Content contentTree;

    private SerializedFormBuilder(AbstractBuilder.Context context) {
        super(context);
    }

    public static SerializedFormBuilder getInstance(AbstractBuilder.Context context) {
        return new SerializedFormBuilder(context);
    }

    @Override
    public void build() throws IOException {
        if (!this.serialClassFoundToDocument(this.configuration.root.classes())) {
            return;
        }
        try {
            this.writer = this.configuration.getWriterFactory().getSerializedFormWriter();
            if (this.writer == null) {
                return;
            }
        }
        catch (Exception exception) {
            throw new DocletAbortException(exception);
        }
        this.build(this.layoutParser.parseXML(NAME), this.contentTree);
        this.writer.close();
    }

    @Override
    public String getName() {
        return NAME;
    }

    public void buildSerializedForm(XMLNode xMLNode, Content content) throws Exception {
        content = this.writer.getHeader(this.configuration.getText("doclet.Serialized_Form"));
        this.buildChildren(xMLNode, content);
        this.writer.addFooter(content);
        this.writer.printDocument(content);
        this.writer.close();
    }

    public void buildSerializedFormSummaries(XMLNode xMLNode, Content content) {
        Content content2 = this.writer.getSerializedSummariesHeader();
        PackageDoc[] packageDocArray = this.configuration.packages;
        for (int i = 0; i < packageDocArray.length; ++i) {
            this.currentPackage = packageDocArray[i];
            this.buildChildren(xMLNode, content2);
        }
        content.addContent(this.writer.getSerializedContent(content2));
    }

    public void buildPackageSerializedForm(XMLNode xMLNode, Content content) {
        Content content2 = this.writer.getPackageSerializedHeader();
        String string = this.currentPackage.name();
        ClassDoc[] classDocArray = this.currentPackage.allClasses(false);
        if (classDocArray == null || classDocArray.length == 0) {
            return;
        }
        if (!SerializedFormBuilder.serialInclude(this.currentPackage)) {
            return;
        }
        if (!this.serialClassFoundToDocument(classDocArray)) {
            return;
        }
        this.buildChildren(xMLNode, content2);
        content.addContent(content2);
    }

    public void buildPackageHeader(XMLNode xMLNode, Content content) {
        content.addContent(this.writer.getPackageHeader(Util.getPackageName(this.currentPackage)));
    }

    public void buildClassSerializedForm(XMLNode xMLNode, Content content) {
        Content content2 = this.writer.getClassSerializedHeader();
        Object[] objectArray = this.currentPackage.allClasses(false);
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            this.currentClass = objectArray[i];
            this.fieldWriter = this.writer.getSerialFieldWriter(this.currentClass);
            this.methodWriter = this.writer.getSerialMethodWriter(this.currentClass);
            if (!this.currentClass.isClass() || !this.currentClass.isSerializable() || !SerializedFormBuilder.serialClassInclude(this.currentClass)) continue;
            Content content3 = this.writer.getClassHeader(this.currentClass);
            this.buildChildren(xMLNode, content3);
            content2.addContent(content3);
        }
        content.addContent(content2);
    }

    public void buildSerialUIDInfo(XMLNode xMLNode, Content content) {
        Content content2 = this.writer.getSerialUIDInfoHeader();
        FieldDoc[] fieldDocArray = this.currentClass.fields(false);
        for (int i = 0; i < fieldDocArray.length; ++i) {
            if (!fieldDocArray[i].name().equals("serialVersionUID") || fieldDocArray[i].constantValueExpression() == null) continue;
            this.writer.addSerialUIDInfo(SERIAL_VERSION_UID_HEADER, fieldDocArray[i].constantValueExpression(), content2);
            break;
        }
        content.addContent(content2);
    }

    public void buildClassContent(XMLNode xMLNode, Content content) {
        Content content2 = this.writer.getClassContentHeader();
        this.buildChildren(xMLNode, content2);
        content.addContent(content2);
    }

    public void buildSerializableMethods(XMLNode xMLNode, Content content) {
        Content content2 = this.methodWriter.getSerializableMethodsHeader();
        MethodDoc[] methodDocArray = this.currentClass.serializationMethods();
        int n = methodDocArray.length;
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                this.currentMember = methodDocArray[i];
                Content content3 = this.methodWriter.getMethodsContentHeader(i == n - 1);
                this.buildChildren(xMLNode, content3);
                content2.addContent(content3);
            }
        }
        if (this.currentClass.serializationMethods().length > 0) {
            content.addContent(this.methodWriter.getSerializableMethods(this.configuration.getText("doclet.Serialized_Form_methods"), content2));
            if (this.currentClass.isSerializable() && !this.currentClass.isExternalizable() && this.currentClass.serializationMethods().length == 0) {
                Content content4 = this.methodWriter.getNoCustomizationMsg(this.configuration.getText("doclet.Serializable_no_customization"));
                content.addContent(this.methodWriter.getSerializableMethods(this.configuration.getText("doclet.Serialized_Form_methods"), content4));
            }
        }
    }

    public void buildMethodSubHeader(XMLNode xMLNode, Content content) {
        this.methodWriter.addMemberHeader((MethodDoc)this.currentMember, content);
    }

    public void buildDeprecatedMethodInfo(XMLNode xMLNode, Content content) {
        this.methodWriter.addDeprecatedMemberInfo((MethodDoc)this.currentMember, content);
    }

    public void buildMethodInfo(XMLNode xMLNode, Content content) {
        if (this.configuration.nocomment) {
            return;
        }
        this.buildChildren(xMLNode, content);
    }

    public void buildMethodDescription(XMLNode xMLNode, Content content) {
        this.methodWriter.addMemberDescription((MethodDoc)this.currentMember, content);
    }

    public void buildMethodTags(XMLNode xMLNode, Content content) {
        this.methodWriter.addMemberTags((MethodDoc)this.currentMember, content);
        MethodDoc methodDoc = (MethodDoc)this.currentMember;
        if (methodDoc.name().compareTo("writeExternal") == 0 && methodDoc.tags("serialData").length == 0 && this.configuration.serialwarn) {
            this.configuration.getDocletSpecificMsg().warning(this.currentMember.position(), "doclet.MissingSerialDataTag", methodDoc.containingClass().qualifiedName(), methodDoc.name());
        }
    }

    public void buildFieldHeader(XMLNode xMLNode, Content content) {
        if (this.currentClass.serializableFields().length > 0) {
            this.buildFieldSerializationOverview(this.currentClass, content);
        }
    }

    public void buildFieldSerializationOverview(ClassDoc classDoc, Content content) {
        FieldDoc fieldDoc;
        if (classDoc.definesSerializableFields() && this.fieldWriter.shouldPrintOverview(fieldDoc = classDoc.serializableFields()[0])) {
            Content content2 = this.fieldWriter.getSerializableFieldsHeader();
            Content content3 = this.fieldWriter.getFieldsContentHeader(true);
            this.fieldWriter.addMemberDeprecatedInfo(fieldDoc, content3);
            if (!this.configuration.nocomment) {
                this.fieldWriter.addMemberDescription(fieldDoc, content3);
                this.fieldWriter.addMemberTags(fieldDoc, content3);
            }
            content2.addContent(content3);
            content.addContent(this.fieldWriter.getSerializableFields(this.configuration.getText("doclet.Serialized_Form_class"), content2));
        }
    }

    public void buildSerializableFields(XMLNode xMLNode, Content content) {
        FieldDoc[] fieldDocArray = this.currentClass.serializableFields();
        int n = fieldDocArray.length;
        if (n > 0) {
            Content content2 = this.fieldWriter.getSerializableFieldsHeader();
            for (int i = 0; i < n; ++i) {
                this.currentMember = fieldDocArray[i];
                if (!this.currentClass.definesSerializableFields()) {
                    Content content3 = this.fieldWriter.getFieldsContentHeader(i == n - 1);
                    this.buildChildren(xMLNode, content3);
                    content2.addContent(content3);
                    continue;
                }
                this.buildSerialFieldTagsInfo(content2);
            }
            content.addContent(this.fieldWriter.getSerializableFields(this.configuration.getText("doclet.Serialized_Form_fields"), content2));
        }
    }

    public void buildFieldSubHeader(XMLNode xMLNode, Content content) {
        if (!this.currentClass.definesSerializableFields()) {
            FieldDoc fieldDoc = (FieldDoc)this.currentMember;
            this.fieldWriter.addMemberHeader(fieldDoc.type().asClassDoc(), fieldDoc.type().typeName(), fieldDoc.type().dimension(), fieldDoc.name(), content);
        }
    }

    public void buildFieldDeprecationInfo(XMLNode xMLNode, Content content) {
        if (!this.currentClass.definesSerializableFields()) {
            FieldDoc fieldDoc = (FieldDoc)this.currentMember;
            this.fieldWriter.addMemberDeprecatedInfo(fieldDoc, content);
        }
    }

    public void buildSerialFieldTagsInfo(Content content) {
        if (this.configuration.nocomment) {
            return;
        }
        FieldDoc fieldDoc = (FieldDoc)this.currentMember;
        Object[] objectArray = fieldDoc.serialFieldTags();
        Arrays.sort(objectArray);
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            if (objectArray[i].fieldName() == null || objectArray[i].fieldType() == null) continue;
            Content content2 = this.fieldWriter.getFieldsContentHeader(i == n - 1);
            this.fieldWriter.addMemberHeader(objectArray[i].fieldTypeDoc(), objectArray[i].fieldType(), "", objectArray[i].fieldName(), content2);
            this.fieldWriter.addMemberDescription((SerialFieldTag)objectArray[i], content2);
            content.addContent(content2);
        }
    }

    public void buildFieldInfo(XMLNode xMLNode, Content content) {
        if (this.configuration.nocomment) {
            return;
        }
        FieldDoc fieldDoc = (FieldDoc)this.currentMember;
        ClassDoc classDoc = fieldDoc.containingClass();
        if (fieldDoc.tags("serial").length == 0 && !fieldDoc.isSynthetic() && this.configuration.serialwarn) {
            this.configuration.message.warning(fieldDoc.position(), "doclet.MissingSerialTag", classDoc.qualifiedName(), fieldDoc.name());
        }
        this.fieldWriter.addMemberDescription(fieldDoc, content);
        this.fieldWriter.addMemberTags(fieldDoc, content);
    }

    public static boolean serialInclude(Doc doc) {
        if (doc == null) {
            return false;
        }
        return doc.isClass() ? SerializedFormBuilder.serialClassInclude((ClassDoc)doc) : SerializedFormBuilder.serialDocInclude(doc);
    }

    private static boolean serialClassInclude(ClassDoc classDoc) {
        if (classDoc.isEnum()) {
            return false;
        }
        try {
            classDoc.superclassType();
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        if (classDoc.isSerializable()) {
            if (classDoc.tags("serial").length > 0) {
                return SerializedFormBuilder.serialDocInclude(classDoc);
            }
            return classDoc.isPublic() || classDoc.isProtected();
        }
        return false;
    }

    private static boolean serialDocInclude(Doc doc) {
        if (doc.isEnum()) {
            return false;
        }
        Tag[] tagArray = doc.tags("serial");
        if (tagArray.length > 0) {
            String string = StringUtils.toLowerCase(tagArray[0].text());
            if (string.indexOf("exclude") >= 0) {
                return false;
            }
            if (string.indexOf("include") >= 0) {
                return true;
            }
        }
        return true;
    }

    private boolean serialClassFoundToDocument(ClassDoc[] classDocArray) {
        for (int i = 0; i < classDocArray.length; ++i) {
            if (!SerializedFormBuilder.serialClassInclude(classDocArray[i])) continue;
            return true;
        }
        return false;
    }
}

