/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html.markup;

import com.sun.tools.doclets.formats.html.markup.HtmlAttr;
import com.sun.tools.doclets.formats.html.markup.HtmlStyle;
import com.sun.tools.doclets.formats.html.markup.HtmlTag;
import com.sun.tools.doclets.formats.html.markup.HtmlTree;
import com.sun.tools.doclets.formats.html.markup.RawHtml;
import com.sun.tools.doclets.formats.html.markup.StringContent;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.util.DocFile;
import com.sun.tools.doclets.internal.toolkit.util.DocPath;
import com.sun.tools.doclets.internal.toolkit.util.DocletConstants;
import com.sun.tools.doclets.internal.toolkit.util.MethodTypes;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Map;
import java.util.Set;

public class HtmlWriter {
    protected String winTitle;
    protected Configuration configuration;
    protected boolean memberDetailsListPrinted;
    protected final String[] profileTableHeader;
    protected final String[] packageTableHeader;
    protected final String useTableSummary;
    protected final String modifierTypeHeader;
    public final Content overviewLabel;
    public final Content defaultPackageLabel;
    public final Content packageLabel;
    public final Content profileLabel;
    public final Content useLabel;
    public final Content prevLabel;
    public final Content nextLabel;
    public final Content prevclassLabel;
    public final Content nextclassLabel;
    public final Content summaryLabel;
    public final Content detailLabel;
    public final Content framesLabel;
    public final Content noframesLabel;
    public final Content treeLabel;
    public final Content classLabel;
    public final Content deprecatedLabel;
    public final Content deprecatedPhrase;
    public final Content allclassesLabel;
    public final Content allpackagesLabel;
    public final Content allprofilesLabel;
    public final Content indexLabel;
    public final Content helpLabel;
    public final Content seeLabel;
    public final Content descriptionLabel;
    public final Content prevpackageLabel;
    public final Content nextpackageLabel;
    public final Content prevprofileLabel;
    public final Content nextprofileLabel;
    public final Content packagesLabel;
    public final Content profilesLabel;
    public final Content methodDetailsLabel;
    public final Content annotationTypeDetailsLabel;
    public final Content fieldDetailsLabel;
    public final Content propertyDetailsLabel;
    public final Content constructorDetailsLabel;
    public final Content enumConstantsDetailsLabel;
    public final Content specifiedByLabel;
    public final Content overridesLabel;
    public final Content descfrmClassLabel;
    public final Content descfrmInterfaceLabel;
    private final DocFile file;
    private Writer writer;
    private Content script;

    public HtmlWriter(Configuration configuration, DocPath docPath) throws IOException, UnsupportedEncodingException {
        this.file = DocFile.createFileForOutput(configuration, docPath);
        this.configuration = configuration;
        this.memberDetailsListPrinted = false;
        this.profileTableHeader = new String[]{configuration.getText("doclet.Profile"), configuration.getText("doclet.Description")};
        this.packageTableHeader = new String[]{configuration.getText("doclet.Package"), configuration.getText("doclet.Description")};
        this.useTableSummary = configuration.getText("doclet.Use_Table_Summary", configuration.getText("doclet.packages"));
        this.modifierTypeHeader = configuration.getText("doclet.0_and_1", configuration.getText("doclet.Modifier"), configuration.getText("doclet.Type"));
        this.overviewLabel = this.getResource("doclet.Overview");
        this.defaultPackageLabel = new StringContent("<Unnamed>");
        this.packageLabel = this.getResource("doclet.Package");
        this.profileLabel = this.getResource("doclet.Profile");
        this.useLabel = this.getResource("doclet.navClassUse");
        this.prevLabel = this.getResource("doclet.Prev");
        this.nextLabel = this.getResource("doclet.Next");
        this.prevclassLabel = this.getNonBreakResource("doclet.Prev_Class");
        this.nextclassLabel = this.getNonBreakResource("doclet.Next_Class");
        this.summaryLabel = this.getResource("doclet.Summary");
        this.detailLabel = this.getResource("doclet.Detail");
        this.framesLabel = this.getResource("doclet.Frames");
        this.noframesLabel = this.getNonBreakResource("doclet.No_Frames");
        this.treeLabel = this.getResource("doclet.Tree");
        this.classLabel = this.getResource("doclet.Class");
        this.deprecatedLabel = this.getResource("doclet.navDeprecated");
        this.deprecatedPhrase = this.getResource("doclet.Deprecated");
        this.allclassesLabel = this.getNonBreakResource("doclet.All_Classes");
        this.allpackagesLabel = this.getNonBreakResource("doclet.All_Packages");
        this.allprofilesLabel = this.getNonBreakResource("doclet.All_Profiles");
        this.indexLabel = this.getResource("doclet.Index");
        this.helpLabel = this.getResource("doclet.Help");
        this.seeLabel = this.getResource("doclet.See");
        this.descriptionLabel = this.getResource("doclet.Description");
        this.prevpackageLabel = this.getNonBreakResource("doclet.Prev_Package");
        this.nextpackageLabel = this.getNonBreakResource("doclet.Next_Package");
        this.prevprofileLabel = this.getNonBreakResource("doclet.Prev_Profile");
        this.nextprofileLabel = this.getNonBreakResource("doclet.Next_Profile");
        this.packagesLabel = this.getResource("doclet.Packages");
        this.profilesLabel = this.getResource("doclet.Profiles");
        this.methodDetailsLabel = this.getResource("doclet.Method_Detail");
        this.annotationTypeDetailsLabel = this.getResource("doclet.Annotation_Type_Member_Detail");
        this.fieldDetailsLabel = this.getResource("doclet.Field_Detail");
        this.propertyDetailsLabel = this.getResource("doclet.Property_Detail");
        this.constructorDetailsLabel = this.getResource("doclet.Constructor_Detail");
        this.enumConstantsDetailsLabel = this.getResource("doclet.Enum_Constant_Detail");
        this.specifiedByLabel = this.getResource("doclet.Specified_By");
        this.overridesLabel = this.getResource("doclet.Overrides");
        this.descfrmClassLabel = this.getResource("doclet.Description_From_Class");
        this.descfrmInterfaceLabel = this.getResource("doclet.Description_From_Interface");
    }

    public void write(Content content) throws IOException {
        this.writer = this.file.openWriter();
        content.write(this.writer, true);
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public Content getResource(String string) {
        return this.configuration.getResource(string);
    }

    public Content getNonBreakResource(String string) {
        int n;
        String string2 = this.configuration.getText(string);
        Content content = this.configuration.newContent();
        int n2 = 0;
        while ((n = string2.indexOf(" ", n2)) != -1) {
            content.addContent(string2.substring(n2, n));
            content.addContent(RawHtml.nbsp);
            n2 = n + 1;
        }
        content.addContent(string2.substring(n2));
        return content;
    }

    public Content getResource(String string, Object object) {
        return this.configuration.getResource(string, object);
    }

    public Content getResource(String string, Object object, Object object2) {
        return this.configuration.getResource(string, object, object2);
    }

    protected HtmlTree getWinTitleScript() {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.SCRIPT);
        if (this.winTitle != null && this.winTitle.length() > 0) {
            htmlTree.addAttr(HtmlAttr.TYPE, "text/javascript");
            String string = "<!--" + DocletConstants.NL + "    try {" + DocletConstants.NL + "        if (location.href.indexOf('is-external=true') == -1) {" + DocletConstants.NL + "            parent.document.title=\"" + HtmlWriter.escapeJavaScriptChars(this.winTitle) + "\";" + DocletConstants.NL + "        }" + DocletConstants.NL + "    }" + DocletConstants.NL + "    catch(err) {" + DocletConstants.NL + "    }" + DocletConstants.NL + "//-->" + DocletConstants.NL;
            RawHtml rawHtml = new RawHtml(string);
            htmlTree.addContent(rawHtml);
        }
        return htmlTree;
    }

    private static String escapeJavaScriptChars(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block10: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\b': {
                    stringBuilder.append("\\b");
                    continue block10;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block10;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block10;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block10;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block10;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    stringBuilder.append("\\'");
                    continue block10;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block10;
                }
                default: {
                    if (c < ' ' || c >= '\u007f') {
                        stringBuilder.append(String.format("\\u%04X", c));
                        continue block10;
                    }
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    protected Content getFramesetJavaScript() {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.SCRIPT);
        htmlTree.addAttr(HtmlAttr.TYPE, "text/javascript");
        String string = DocletConstants.NL + "    tmpTargetPage = \"\" + window.location.search;" + DocletConstants.NL + "    if (tmpTargetPage != \"\" && tmpTargetPage != \"undefined\")" + DocletConstants.NL + "        tmpTargetPage = tmpTargetPage.substring(1);" + DocletConstants.NL + "    if (tmpTargetPage.indexOf(\":\") != -1 || (tmpTargetPage != \"\" && !validURL(tmpTargetPage)))" + DocletConstants.NL + "        tmpTargetPage = \"undefined\";" + DocletConstants.NL + "    targetPage = tmpTargetPage;" + DocletConstants.NL + "    function validURL(url) {" + DocletConstants.NL + "        try {" + DocletConstants.NL + "            url = decodeURIComponent(url);" + DocletConstants.NL + "        }" + DocletConstants.NL + "        catch (error) {" + DocletConstants.NL + "            return false;" + DocletConstants.NL + "        }" + DocletConstants.NL + "        var pos = url.indexOf(\".html\");" + DocletConstants.NL + "        if (pos == -1 || pos != url.length - 5)" + DocletConstants.NL + "            return false;" + DocletConstants.NL + "        var allowNumber = false;" + DocletConstants.NL + "        var allowSep = false;" + DocletConstants.NL + "        var seenDot = false;" + DocletConstants.NL + "        for (var i = 0; i < url.length - 5; i++) {" + DocletConstants.NL + "            var ch = url.charAt(i);" + DocletConstants.NL + "            if ('a' <= ch && ch <= 'z' ||" + DocletConstants.NL + "                    'A' <= ch && ch <= 'Z' ||" + DocletConstants.NL + "                    ch == '$' ||" + DocletConstants.NL + "                    ch == '_' ||" + DocletConstants.NL + "                    ch.charCodeAt(0) > 127) {" + DocletConstants.NL + "                allowNumber = true;" + DocletConstants.NL + "                allowSep = true;" + DocletConstants.NL + "            } else if ('0' <= ch && ch <= '9'" + DocletConstants.NL + "                    || ch == '-') {" + DocletConstants.NL + "                if (!allowNumber)" + DocletConstants.NL + "                     return false;" + DocletConstants.NL + "            } else if (ch == '/' || ch == '.') {" + DocletConstants.NL + "                if (!allowSep)" + DocletConstants.NL + "                    return false;" + DocletConstants.NL + "                allowNumber = false;" + DocletConstants.NL + "                allowSep = false;" + DocletConstants.NL + "                if (ch == '.')" + DocletConstants.NL + "                     seenDot = true;" + DocletConstants.NL + "                if (ch == '/' && seenDot)" + DocletConstants.NL + "                     return false;" + DocletConstants.NL + "            } else {" + DocletConstants.NL + "                return false;" + DocletConstants.NL + "            }" + DocletConstants.NL + "        }" + DocletConstants.NL + "        return true;" + DocletConstants.NL + "    }" + DocletConstants.NL + "    function loadFrames() {" + DocletConstants.NL + "        if (targetPage != \"\" && targetPage != \"undefined\")" + DocletConstants.NL + "             top.classFrame.location = top.targetPage;" + DocletConstants.NL + "    }" + DocletConstants.NL;
        RawHtml rawHtml = new RawHtml(string);
        htmlTree.addContent(rawHtml);
        return htmlTree;
    }

    public HtmlTree getBody(boolean bl, String string) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.BODY);
        this.winTitle = string;
        if (bl) {
            this.script = this.getWinTitleScript();
            htmlTree.addContent(this.script);
            HtmlTree htmlTree2 = HtmlTree.NOSCRIPT(HtmlTree.DIV(this.getResource("doclet.No_Script_Message")));
            htmlTree.addContent(htmlTree2);
        }
        return htmlTree;
    }

    public void generateMethodTypesScript(Map<String, Integer> map, Set<MethodTypes> set) {
        String string = "";
        StringBuilder stringBuilder = new StringBuilder("var methods = {");
        for (Map.Entry<String, Integer> object : map.entrySet()) {
            stringBuilder.append(string);
            string = ",";
            stringBuilder.append("\"").append(object.getKey()).append("\":").append(object.getValue());
        }
        stringBuilder.append("};").append(DocletConstants.NL);
        string = "";
        stringBuilder.append("var tabs = {");
        for (MethodTypes methodTypes : set) {
            stringBuilder.append(string);
            string = ",";
            stringBuilder.append(methodTypes.value()).append(":").append("[").append("\"").append(methodTypes.tabId()).append("\"").append(string).append("\"").append(this.configuration.getText(methodTypes.resourceKey())).append("\"]");
        }
        stringBuilder.append("};").append(DocletConstants.NL);
        this.addStyles(HtmlStyle.altColor, stringBuilder);
        this.addStyles(HtmlStyle.rowColor, stringBuilder);
        this.addStyles(HtmlStyle.tableTab, stringBuilder);
        this.addStyles(HtmlStyle.activeTableTab, stringBuilder);
        this.script.addContent(new RawHtml(stringBuilder.toString()));
    }

    public void addStyles(HtmlStyle htmlStyle, StringBuilder stringBuilder) {
        stringBuilder.append("var ").append((Object)htmlStyle).append(" = \"").append((Object)htmlStyle).append("\";").append(DocletConstants.NL);
    }

    public HtmlTree getTitle() {
        HtmlTree htmlTree = HtmlTree.TITLE(new StringContent(this.winTitle));
        return htmlTree;
    }

    public String codeText(String string) {
        return "<code>" + string + "</code>";
    }

    public Content getSpace() {
        return RawHtml.nbsp;
    }

    public String getModifierTypeHeader() {
        return this.modifierTypeHeader;
    }
}

