/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Tag;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.HtmlDocletWriter;
import com.sun.tools.doclets.formats.html.SectionName;
import com.sun.tools.doclets.formats.html.markup.HtmlConstants;
import com.sun.tools.doclets.formats.html.markup.HtmlStyle;
import com.sun.tools.doclets.formats.html.markup.HtmlTag;
import com.sun.tools.doclets.formats.html.markup.HtmlTree;
import com.sun.tools.doclets.formats.html.markup.RawHtml;
import com.sun.tools.doclets.formats.html.markup.StringContent;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.ProfilePackageSummaryWriter;
import com.sun.tools.doclets.internal.toolkit.util.DocPath;
import com.sun.tools.doclets.internal.toolkit.util.DocPaths;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import com.sun.tools.javac.jvm.Profile;
import java.io.IOException;

public class ProfilePackageWriterImpl
extends HtmlDocletWriter
implements ProfilePackageSummaryWriter {
    protected PackageDoc prev;
    protected PackageDoc next;
    protected PackageDoc packageDoc;
    protected String profileName;
    protected int profileValue;

    public ProfilePackageWriterImpl(ConfigurationImpl configurationImpl, PackageDoc packageDoc, PackageDoc packageDoc2, PackageDoc packageDoc3, Profile profile) throws IOException {
        super(configurationImpl, DocPath.forPackage(packageDoc).resolve(DocPaths.profilePackageSummary(profile.name)));
        this.prev = packageDoc2;
        this.next = packageDoc3;
        this.packageDoc = packageDoc;
        this.profileName = profile.name;
        this.profileValue = profile.value;
    }

    @Override
    public Content getPackageHeader(String string) {
        String string2 = this.packageDoc.name();
        HtmlTree htmlTree = this.getBody(true, this.getWindowTitle(string2));
        this.addTop(htmlTree);
        this.addNavLinks(true, htmlTree);
        HtmlTree htmlTree2 = new HtmlTree(HtmlTag.DIV);
        htmlTree2.addStyle(HtmlStyle.header);
        StringContent stringContent = new StringContent(this.profileName);
        HtmlTree htmlTree3 = HtmlTree.DIV(HtmlStyle.subTitle, stringContent);
        htmlTree2.addContent(htmlTree3);
        HtmlTree htmlTree4 = new HtmlTree(HtmlTag.P);
        this.addAnnotationInfo(this.packageDoc, (Content)htmlTree4);
        htmlTree2.addContent(htmlTree4);
        HtmlTree htmlTree5 = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, true, HtmlStyle.title, this.packageLabel);
        ((Content)htmlTree5).addContent(this.getSpace());
        RawHtml rawHtml = new RawHtml(string);
        ((Content)htmlTree5).addContent(rawHtml);
        htmlTree2.addContent(htmlTree5);
        this.addDeprecationInfo(htmlTree2);
        if (this.packageDoc.inlineTags().length > 0 && !this.configuration.nocomment) {
            HtmlTree htmlTree6 = new HtmlTree(HtmlTag.DIV);
            htmlTree6.addStyle(HtmlStyle.docSummary);
            this.addSummaryComment(this.packageDoc, htmlTree6);
            htmlTree2.addContent(htmlTree6);
            Content content = this.getSpace();
            Content content2 = this.getHyperLink(this.getDocLink(SectionName.PACKAGE_DESCRIPTION), this.descriptionLabel, "", "");
            HtmlTree htmlTree7 = new HtmlTree(HtmlTag.P, this.seeLabel, content, content2);
            htmlTree2.addContent(htmlTree7);
        }
        ((Content)htmlTree).addContent(htmlTree2);
        return htmlTree;
    }

    @Override
    public Content getContentHeader() {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.DIV);
        htmlTree.addStyle(HtmlStyle.contentContainer);
        return htmlTree;
    }

    public void addDeprecationInfo(Content content) {
        Tag[] tagArray = this.packageDoc.tags("deprecated");
        if (Util.isDeprecated(this.packageDoc)) {
            Tag[] tagArray2;
            HtmlTree htmlTree = new HtmlTree(HtmlTag.DIV);
            htmlTree.addStyle(HtmlStyle.deprecatedContent);
            HtmlTree htmlTree2 = HtmlTree.SPAN(HtmlStyle.deprecatedLabel, this.deprecatedPhrase);
            htmlTree.addContent(htmlTree2);
            if (tagArray.length > 0 && (tagArray2 = tagArray[0].inlineTags()).length > 0) {
                this.addInlineDeprecatedComment(this.packageDoc, tagArray[0], htmlTree);
            }
            content.addContent(htmlTree);
        }
    }

    @Override
    public void addClassesSummary(ClassDoc[] classDocArray, String string, String string2, String[] stringArray, Content content) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.LI);
        htmlTree.addStyle(HtmlStyle.blockList);
        this.addClassesSummary(classDocArray, string, string2, stringArray, htmlTree, this.profileValue);
        content.addContent(htmlTree);
    }

    @Override
    public Content getSummaryHeader() {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.UL);
        htmlTree.addStyle(HtmlStyle.blockList);
        return htmlTree;
    }

    @Override
    public void addPackageDescription(Content content) {
        if (this.packageDoc.inlineTags().length > 0) {
            content.addContent(this.getMarkerAnchor(SectionName.PACKAGE_DESCRIPTION));
            StringContent stringContent = new StringContent(this.configuration.getText("doclet.Package_Description", this.packageDoc.name()));
            content.addContent(HtmlTree.HEADING(HtmlConstants.PACKAGE_HEADING, true, (Content)stringContent));
            this.addInlineComment(this.packageDoc, content);
        }
    }

    @Override
    public void addPackageTags(Content content) {
        this.addTagsInfo(this.packageDoc, content);
    }

    @Override
    public void addPackageFooter(Content content) {
        this.addNavLinks(false, content);
        this.addBottom(content);
    }

    @Override
    public void printDocument(Content content) throws IOException {
        this.printHtmlDocument(this.configuration.metakeywords.getMetaKeywords(this.packageDoc), true, content);
    }

    @Override
    protected Content getNavLinkClassUse() {
        Content content = this.getHyperLink(DocPaths.PACKAGE_USE, this.useLabel, "", "");
        HtmlTree htmlTree = HtmlTree.LI(content);
        return htmlTree;
    }

    @Override
    public Content getNavLinkPrevious() {
        HtmlTree htmlTree;
        if (this.prev == null) {
            htmlTree = HtmlTree.LI(this.prevpackageLabel);
        } else {
            DocPath docPath = DocPath.relativePath(this.packageDoc, this.prev);
            htmlTree = HtmlTree.LI(this.getHyperLink(docPath.resolve(DocPaths.profilePackageSummary(this.profileName)), this.prevpackageLabel, "", ""));
        }
        return htmlTree;
    }

    @Override
    public Content getNavLinkNext() {
        HtmlTree htmlTree;
        if (this.next == null) {
            htmlTree = HtmlTree.LI(this.nextpackageLabel);
        } else {
            DocPath docPath = DocPath.relativePath(this.packageDoc, this.next);
            htmlTree = HtmlTree.LI(this.getHyperLink(docPath.resolve(DocPaths.profilePackageSummary(this.profileName)), this.nextpackageLabel, "", ""));
        }
        return htmlTree;
    }

    @Override
    protected Content getNavLinkTree() {
        Content content = this.getHyperLink(DocPaths.PACKAGE_TREE, this.treeLabel, "", "");
        HtmlTree htmlTree = HtmlTree.LI(content);
        return htmlTree;
    }

    @Override
    protected Content getNavLinkPackage() {
        HtmlTree htmlTree = HtmlTree.LI(HtmlStyle.navBarCell1Rev, this.packageLabel);
        return htmlTree;
    }
}

