/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Tag;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.HtmlDocletWriter;
import com.sun.tools.doclets.formats.html.LinkInfoImpl;
import com.sun.tools.doclets.formats.html.SectionName;
import com.sun.tools.doclets.formats.html.markup.HtmlConstants;
import com.sun.tools.doclets.formats.html.markup.HtmlStyle;
import com.sun.tools.doclets.formats.html.markup.HtmlTag;
import com.sun.tools.doclets.formats.html.markup.HtmlTree;
import com.sun.tools.doclets.formats.html.markup.RawHtml;
import com.sun.tools.doclets.formats.html.markup.StringContent;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.PackageSummaryWriter;
import com.sun.tools.doclets.internal.toolkit.util.DocPath;
import com.sun.tools.doclets.internal.toolkit.util.DocPaths;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.IOException;
import java.util.Arrays;

public class PackageWriterImpl
extends HtmlDocletWriter
implements PackageSummaryWriter {
    protected PackageDoc prev;
    protected PackageDoc next;
    protected PackageDoc packageDoc;

    public PackageWriterImpl(ConfigurationImpl configurationImpl, PackageDoc packageDoc, PackageDoc packageDoc2, PackageDoc packageDoc3) throws IOException {
        super(configurationImpl, DocPath.forPackage(packageDoc).resolve(DocPaths.PACKAGE_SUMMARY));
        this.prev = packageDoc2;
        this.next = packageDoc3;
        this.packageDoc = packageDoc;
    }

    @Override
    public Content getPackageHeader(String string) {
        String string2 = this.packageDoc.name();
        HtmlTree htmlTree = this.getBody(true, this.getWindowTitle(string2));
        this.addTop(htmlTree);
        this.addNavLinks(true, htmlTree);
        HtmlTree htmlTree2 = new HtmlTree(HtmlTag.DIV);
        htmlTree2.addStyle(HtmlStyle.header);
        HtmlTree htmlTree3 = new HtmlTree(HtmlTag.P);
        this.addAnnotationInfo(this.packageDoc, (Content)htmlTree3);
        htmlTree2.addContent(htmlTree3);
        HtmlTree htmlTree4 = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, true, HtmlStyle.title, this.packageLabel);
        ((Content)htmlTree4).addContent(this.getSpace());
        StringContent stringContent = new StringContent(string);
        ((Content)htmlTree4).addContent(stringContent);
        htmlTree2.addContent(htmlTree4);
        this.addDeprecationInfo(htmlTree2);
        if (this.packageDoc.inlineTags().length > 0 && !this.configuration.nocomment) {
            HtmlTree htmlTree5 = new HtmlTree(HtmlTag.DIV);
            htmlTree5.addStyle(HtmlStyle.docSummary);
            this.addSummaryComment(this.packageDoc, htmlTree5);
            htmlTree2.addContent(htmlTree5);
            Content content = this.getSpace();
            Content content2 = this.getHyperLink(this.getDocLink(SectionName.PACKAGE_DESCRIPTION), this.descriptionLabel, "", "");
            HtmlTree htmlTree6 = new HtmlTree(HtmlTag.P, this.seeLabel, content, content2);
            htmlTree2.addContent(htmlTree6);
        }
        ((Content)htmlTree).addContent(htmlTree2);
        return htmlTree;
    }

    @Override
    public Content getContentHeader() {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.DIV);
        htmlTree.addStyle(HtmlStyle.contentContainer);
        return htmlTree;
    }

    public void addDeprecationInfo(Content content) {
        Tag[] tagArray = this.packageDoc.tags("deprecated");
        if (Util.isDeprecated(this.packageDoc)) {
            Tag[] tagArray2;
            HtmlTree htmlTree = new HtmlTree(HtmlTag.DIV);
            htmlTree.addStyle(HtmlStyle.deprecatedContent);
            HtmlTree htmlTree2 = HtmlTree.SPAN(HtmlStyle.deprecatedLabel, this.deprecatedPhrase);
            htmlTree.addContent(htmlTree2);
            if (tagArray.length > 0 && (tagArray2 = tagArray[0].inlineTags()).length > 0) {
                this.addInlineDeprecatedComment(this.packageDoc, tagArray[0], htmlTree);
            }
            content.addContent(htmlTree);
        }
    }

    @Override
    public Content getSummaryHeader() {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.UL);
        htmlTree.addStyle(HtmlStyle.blockList);
        return htmlTree;
    }

    @Override
    public void addClassesSummary(ClassDoc[] classDocArray, String string, String string2, String[] stringArray, Content content) {
        if (classDocArray.length > 0) {
            Arrays.sort(classDocArray);
            Content content2 = this.getTableCaption(new RawHtml(string));
            HtmlTree htmlTree = HtmlTree.TABLE(HtmlStyle.typeSummary, 0, 3, 0, string2, content2);
            ((Content)htmlTree).addContent(this.getSummaryTableHeader(stringArray, "col"));
            HtmlTree htmlTree2 = new HtmlTree(HtmlTag.TBODY);
            for (int i = 0; i < classDocArray.length; ++i) {
                if (!Util.isCoreClass(classDocArray[i]) || !this.configuration.isGeneratedDoc(classDocArray[i])) continue;
                Content content3 = this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.PACKAGE, classDocArray[i]));
                HtmlTree htmlTree3 = HtmlTree.TD(HtmlStyle.colFirst, content3);
                HtmlTree htmlTree4 = HtmlTree.TR(htmlTree3);
                if (i % 2 == 0) {
                    htmlTree4.addStyle(HtmlStyle.altColor);
                } else {
                    htmlTree4.addStyle(HtmlStyle.rowColor);
                }
                HtmlTree htmlTree5 = new HtmlTree(HtmlTag.TD);
                htmlTree5.addStyle(HtmlStyle.colLast);
                if (Util.isDeprecated(classDocArray[i])) {
                    htmlTree5.addContent(this.deprecatedLabel);
                    if (classDocArray[i].tags("deprecated").length > 0) {
                        this.addSummaryDeprecatedComment(classDocArray[i], classDocArray[i].tags("deprecated")[0], htmlTree5);
                    }
                } else {
                    this.addSummaryComment(classDocArray[i], htmlTree5);
                }
                htmlTree4.addContent(htmlTree5);
                ((Content)htmlTree2).addContent(htmlTree4);
            }
            ((Content)htmlTree).addContent(htmlTree2);
            HtmlTree htmlTree6 = HtmlTree.LI(HtmlStyle.blockList, htmlTree);
            content.addContent(htmlTree6);
        }
    }

    @Override
    public void addPackageDescription(Content content) {
        if (this.packageDoc.inlineTags().length > 0) {
            content.addContent(this.getMarkerAnchor(SectionName.PACKAGE_DESCRIPTION));
            StringContent stringContent = new StringContent(this.configuration.getText("doclet.Package_Description", this.packageDoc.name()));
            content.addContent(HtmlTree.HEADING(HtmlConstants.PACKAGE_HEADING, true, (Content)stringContent));
            this.addInlineComment(this.packageDoc, content);
        }
    }

    @Override
    public void addPackageTags(Content content) {
        this.addTagsInfo(this.packageDoc, content);
    }

    @Override
    public void addPackageFooter(Content content) {
        this.addNavLinks(false, content);
        this.addBottom(content);
    }

    @Override
    public void printDocument(Content content) throws IOException {
        this.printHtmlDocument(this.configuration.metakeywords.getMetaKeywords(this.packageDoc), true, content);
    }

    @Override
    protected Content getNavLinkClassUse() {
        Content content = this.getHyperLink(DocPaths.PACKAGE_USE, this.useLabel, "", "");
        HtmlTree htmlTree = HtmlTree.LI(content);
        return htmlTree;
    }

    @Override
    public Content getNavLinkPrevious() {
        HtmlTree htmlTree;
        if (this.prev == null) {
            htmlTree = HtmlTree.LI(this.prevpackageLabel);
        } else {
            DocPath docPath = DocPath.relativePath(this.packageDoc, this.prev);
            htmlTree = HtmlTree.LI(this.getHyperLink(docPath.resolve(DocPaths.PACKAGE_SUMMARY), this.prevpackageLabel, "", ""));
        }
        return htmlTree;
    }

    @Override
    public Content getNavLinkNext() {
        HtmlTree htmlTree;
        if (this.next == null) {
            htmlTree = HtmlTree.LI(this.nextpackageLabel);
        } else {
            DocPath docPath = DocPath.relativePath(this.packageDoc, this.next);
            htmlTree = HtmlTree.LI(this.getHyperLink(docPath.resolve(DocPaths.PACKAGE_SUMMARY), this.nextpackageLabel, "", ""));
        }
        return htmlTree;
    }

    @Override
    protected Content getNavLinkTree() {
        Content content = this.getHyperLink(DocPaths.PACKAGE_TREE, this.treeLabel, "", "");
        HtmlTree htmlTree = HtmlTree.LI(content);
        return htmlTree;
    }

    @Override
    protected Content getNavLinkPackage() {
        HtmlTree htmlTree = HtmlTree.LI(HtmlStyle.navBarCell1Rev, this.packageLabel);
        return htmlTree;
    }
}

