/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Tag;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.HtmlDocletWriter;
import com.sun.tools.doclets.formats.html.LinkInfoImpl;
import com.sun.tools.doclets.formats.html.markup.HtmlConstants;
import com.sun.tools.doclets.formats.html.markup.HtmlStyle;
import com.sun.tools.doclets.formats.html.markup.HtmlTag;
import com.sun.tools.doclets.formats.html.markup.HtmlTree;
import com.sun.tools.doclets.formats.html.markup.StringContent;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.util.DocPath;
import com.sun.tools.doclets.internal.toolkit.util.IndexBuilder;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.IOException;
import java.util.List;

public class AbstractIndexWriter
extends HtmlDocletWriter {
    protected IndexBuilder indexbuilder;

    protected AbstractIndexWriter(ConfigurationImpl configurationImpl, DocPath docPath, IndexBuilder indexBuilder) throws IOException {
        super(configurationImpl, docPath);
        this.indexbuilder = indexBuilder;
    }

    @Override
    protected Content getNavLinkIndex() {
        HtmlTree htmlTree = HtmlTree.LI(HtmlStyle.navBarCell1Rev, this.indexLabel);
        return htmlTree;
    }

    protected void addContents(Character c, List<? extends Doc> list, Content content) {
        String string = c.toString();
        content.addContent(this.getMarkerAnchorForIndex(string));
        StringContent stringContent = new StringContent(string);
        HtmlTree htmlTree = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, false, HtmlStyle.title, stringContent);
        content.addContent(htmlTree);
        int n = list.size();
        if (n > 0) {
            HtmlTree htmlTree2 = new HtmlTree(HtmlTag.DL);
            for (int i = 0; i < n; ++i) {
                Doc doc = list.get(i);
                if (doc instanceof MemberDoc) {
                    this.addDescription((MemberDoc)doc, (Content)htmlTree2);
                    continue;
                }
                if (doc instanceof ClassDoc) {
                    this.addDescription((ClassDoc)doc, (Content)htmlTree2);
                    continue;
                }
                if (!(doc instanceof PackageDoc)) continue;
                this.addDescription((PackageDoc)doc, (Content)htmlTree2);
            }
            content.addContent(htmlTree2);
        }
    }

    protected void addDescription(PackageDoc packageDoc, Content content) {
        Content content2 = this.getPackageLink(packageDoc, new StringContent(Util.getPackageName(packageDoc)));
        HtmlTree htmlTree = HtmlTree.DT(content2);
        ((Content)htmlTree).addContent(" - ");
        ((Content)htmlTree).addContent(this.getResource("doclet.package"));
        ((Content)htmlTree).addContent(" " + packageDoc.name());
        content.addContent(htmlTree);
        HtmlTree htmlTree2 = new HtmlTree(HtmlTag.DD);
        this.addSummaryComment(packageDoc, htmlTree2);
        content.addContent(htmlTree2);
    }

    protected void addDescription(ClassDoc classDoc, Content content) {
        Content content2 = this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.INDEX, classDoc).strong(true));
        HtmlTree htmlTree = HtmlTree.DT(content2);
        ((Content)htmlTree).addContent(" - ");
        this.addClassInfo(classDoc, htmlTree);
        content.addContent(htmlTree);
        HtmlTree htmlTree2 = new HtmlTree(HtmlTag.DD);
        this.addComment(classDoc, htmlTree2);
        content.addContent(htmlTree2);
    }

    protected void addClassInfo(ClassDoc classDoc, Content content) {
        content.addContent(this.getResource("doclet.in", Util.getTypeName(this.configuration, classDoc, false), this.getPackageLink(classDoc.containingPackage(), Util.getPackageName(classDoc.containingPackage()))));
    }

    protected void addDescription(MemberDoc memberDoc, Content content) {
        String string = memberDoc instanceof ExecutableMemberDoc ? memberDoc.name() + ((ExecutableMemberDoc)memberDoc).flatSignature() : memberDoc.name();
        HtmlTree htmlTree = HtmlTree.SPAN(HtmlStyle.memberNameLink, this.getDocLink(LinkInfoImpl.Kind.INDEX, memberDoc, string));
        HtmlTree htmlTree2 = HtmlTree.DT(htmlTree);
        ((Content)htmlTree2).addContent(" - ");
        this.addMemberDesc(memberDoc, htmlTree2);
        content.addContent(htmlTree2);
        HtmlTree htmlTree3 = new HtmlTree(HtmlTag.DD);
        this.addComment(memberDoc, htmlTree3);
        content.addContent(htmlTree3);
    }

    protected void addComment(ProgramElementDoc programElementDoc, Content content) {
        HtmlTree htmlTree = HtmlTree.SPAN(HtmlStyle.deprecatedLabel, this.deprecatedPhrase);
        HtmlTree htmlTree2 = new HtmlTree(HtmlTag.DIV);
        htmlTree2.addStyle(HtmlStyle.block);
        if (Util.isDeprecated(programElementDoc)) {
            htmlTree2.addContent(htmlTree);
            Tag[] tagArray = programElementDoc.tags("deprecated");
            if (tagArray.length > 0) {
                this.addInlineDeprecatedComment(programElementDoc, tagArray[0], htmlTree2);
            }
            content.addContent(htmlTree2);
        } else {
            for (ClassDoc classDoc = programElementDoc.containingClass(); classDoc != null; classDoc = classDoc.containingClass()) {
                if (!Util.isDeprecated(classDoc)) continue;
                htmlTree2.addContent(htmlTree);
                content.addContent(htmlTree2);
                break;
            }
            this.addSummaryComment(programElementDoc, content);
        }
    }

    protected void addMemberDesc(MemberDoc memberDoc, Content content) {
        ClassDoc classDoc = memberDoc.containingClass();
        String string = Util.getTypeName(this.configuration, classDoc, true) + " ";
        if (memberDoc.isField()) {
            if (memberDoc.isStatic()) {
                content.addContent(this.getResource("doclet.Static_variable_in", string));
            } else {
                content.addContent(this.getResource("doclet.Variable_in", string));
            }
        } else if (memberDoc.isConstructor()) {
            content.addContent(this.getResource("doclet.Constructor_for", string));
        } else if (memberDoc.isMethod()) {
            if (memberDoc.isStatic()) {
                content.addContent(this.getResource("doclet.Static_method_in", string));
            } else {
                content.addContent(this.getResource("doclet.Method_in", string));
            }
        }
        this.addPreQualifiedClassLink(LinkInfoImpl.Kind.INDEX, classDoc, false, content);
    }

    public Content getMarkerAnchorForIndex(String string) {
        return this.getMarkerAnchor(this.getNameForIndex(string), null);
    }

    public String getNameForIndex(String string) {
        return "I:" + this.getName(string);
    }
}

