/*
 * Decompiled with CFR 0.152.
 */
package bence.sipka.cmd.runtime;

import bence.sipka.cmd.runtime.ArgumentsIterator;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;

public class CommandFileArgumentsIterator
extends ArgumentsIterator {
    private Iterator<String> fileIt;

    CommandFileArgumentsIterator(Iterator<? extends String> args) {
        super(args);
    }

    @Override
    protected boolean setNext(String next) {
        if (next.startsWith("@")) {
            Path path = Paths.get(next.substring(1), new String[0]);
            try {
                this.fileIt = Files.readAllLines(path).iterator();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to read command file: " + path, e);
            }
            if (this.fileIt.hasNext()) {
                return super.setNext(this.fileIt.next());
            }
            return false;
        }
        if (next.startsWith("\\@")) {
            return super.setNext(next.substring(1));
        }
        return super.setNext(next);
    }
}

