/*
 * Decompiled with CFR 0.152.
 */
package bence.sipka.cmd.model;

import bence.sipka.cmd.CommandLineProcessor;
import bence.sipka.cmd.api.SubCommand;
import bence.sipka.cmd.model.AbstractModelCommand;
import bence.sipka.cmd.model.ModelCommand;
import java.util.LinkedHashSet;
import java.util.Set;

public class ModelSubCommand
extends AbstractModelCommand {
    private ModelCommand parentCommand;
    private SubCommand annotation;
    private Set<String> names;
    private boolean defaultCommand;

    public ModelSubCommand(ModelCommand parentCommand, CommandLineProcessor processor, SubCommand annot) {
        super(processor, processor.getTypeElement(annot::type));
        this.parentCommand = parentCommand;
        this.annotation = annot;
        this.names = new LinkedHashSet<String>();
        for (String n : annot.name()) {
            this.names.add(n);
        }
        if (this.names.isEmpty()) {
            throw new IllegalArgumentException("No names specified for sub command: " + annot);
        }
        this.defaultCommand = annot.defaultCommand();
    }

    public SubCommand getAnnotation() {
        return this.annotation;
    }

    public Set<String> getNames() {
        return this.names;
    }

    public boolean isDefaultCommand() {
        return this.defaultCommand;
    }

    @Override
    public ModelCommand getParentCommand() {
        return this.parentCommand;
    }

    @Override
    public String getCommandClassQualifiedName() {
        return this.getTypeElement().getQualifiedName().toString();
    }
}

