/*
 * Decompiled with CFR 0.152.
 */
package bence.sipka.cmd.model;

import bence.sipka.cmd.CommandLineProcessor;
import bence.sipka.cmd.api.Converter;
import bence.sipka.cmd.api.Flag;
import bence.sipka.cmd.api.MultiParameter;
import bence.sipka.cmd.api.Parameter;
import bence.sipka.cmd.api.PositionalParameter;
import bence.sipka.cmd.model.ModelCommand;
import bence.sipka.cmd.model.ModelCommonConverter;
import bence.sipka.cmd.model.ModelConverter;
import bence.sipka.cmd.model.ModelMultiParameter;
import bence.sipka.cmd.model.ParameterLocation;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

public class ModelParameter {
    private static final String DOC_TAG_HELP_META = "cmd-help-meta";
    private static final String DOC_TAG_PARAMETER_FORMAT = "cmd-format";
    private final TypeMirror parameterType;
    private final Element element;
    private Set<String> names = new LinkedHashSet<String>();
    private Set<String> helpMetaNames = new LinkedHashSet<String>();
    private ParameterLocation location;
    private boolean required;
    private ModelConverter converter;
    private PositionalParameter positional;
    private Flag flag;
    private ModelMultiParameter multiParameter;
    private boolean deprecated;
    private boolean mapParameter;
    private Parameter anotation;
    private String docComment;
    private String docCommentFormat;
    private ModelCommand parentCommand;

    public ModelParameter(CommandLineProcessor processor, VariableElement element, Parameter parameter, ParameterLocation location, ModelCommand parent) {
        MultiParameter multiparam;
        Converter converterannot;
        this.element = element;
        this.anotation = parameter;
        this.location = location;
        this.parentCommand = parent;
        this.positional = element.getAnnotation(PositionalParameter.class);
        this.deprecated = processor.getElements().isDeprecated(element);
        this.docComment = processor.getElements().getDocComment(element);
        String[] names = parameter.value();
        if (names.length == 0) {
            names = this.positional == null ? new String[]{"-" + element.getSimpleName().toString()} : new String[]{element.getSimpleName().toString()};
        }
        this.helpMetaNames = ModelParameter.getDocCommentHelpMetaNames(this.docComment);
        for (String n : names) {
            this.names.add(n);
        }
        if (this.positional != null && this.names.size() > 1) {
            throw new IllegalArgumentException("Cannot specify multiple names for positional parameter: " + element);
        }
        this.parameterType = element.asType();
        this.mapParameter = processor.getTypes().isAssignable(this.parameterType, processor.getErasedMapType());
        this.required = parameter.required();
        this.flag = element.getAnnotation(Flag.class);
        if (this.deprecated) {
            if (this.required) {
                throw new IllegalArgumentException("A required parameter cannot be deprecated: " + element);
            }
            if (this.positional != null) {
                throw new IllegalArgumentException("A positional parameter cannot be deprecated as there is no way to make it optional: " + element);
            }
        }
        if ((converterannot = element.getAnnotation(Converter.class)) != null) {
            TypeElement methoddeclaringtype = processor.getTypeElement(converterannot::converter);
            String methodname = converterannot.method();
            this.converter = new ModelConverter(methoddeclaringtype.equals(processor.getConverterAnnot()) ? (TypeElement)element.getEnclosingElement() : methoddeclaringtype, methodname);
        }
        if (this.flag != null) {
            if (this.parameterType.getKind() != TypeKind.BOOLEAN && !processor.getTypes().isSameType(this.parameterType, processor.getJavaLangBoolean().asType())) {
                throw new IllegalArgumentException(Flag.class.getSimpleName() + " annotation is only available for boolean types: " + element);
            }
            if (this.required) {
                throw new IllegalArgumentException("Flag annotated parameter cannot be required: " + element);
            }
        }
        if ((multiparam = element.getAnnotation(MultiParameter.class)) != null) {
            if (this.positional != null) {
                throw new IllegalArgumentException("Conflicting annotations " + this.positional + " and " + multiparam + " on " + element);
            }
            if (this.flag != null) {
                throw new IllegalArgumentException("Conflicting annotations " + this.flag + " and " + multiparam + " on " + element);
            }
            TypeMirror multielemtype = processor.getTypeMirror(multiparam::value);
            String multimethod = multiparam.method();
            if (multimethod.isEmpty()) {
                if (processor.getTypes().isAssignable(this.parameterType, processor.getErasedCollectionType())) {
                    multimethod = "add";
                } else {
                    throw new IllegalArgumentException("Unknown method name for multi parameter on field: " + element);
                }
            }
            this.multiParameter = new ModelMultiParameter(multielemtype, multimethod);
        }
        if (this.mapParameter && this.positional != null) {
            throw new IllegalArgumentException("Map parameter cannot be positional: " + element);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ModelParameter(CommandLineProcessor processor, ExecutableElement element, Parameter parameter, ParameterLocation location, ModelCommand parent) {
        Converter converterannot;
        this.element = element;
        this.anotation = parameter;
        this.location = location;
        this.parentCommand = parent;
        this.positional = element.getAnnotation(PositionalParameter.class);
        this.deprecated = processor.getElements().isDeprecated(element);
        this.docComment = processor.getElements().getDocComment(element);
        String[] names = parameter.value();
        if (names.length == 0) {
            names = this.positional == null ? new String[]{"-" + element.getSimpleName().toString()} : new String[]{element.getSimpleName().toString()};
        }
        this.helpMetaNames = ModelParameter.getDocCommentHelpMetaNames(this.docComment);
        for (String n : names) {
            this.names.add(n);
        }
        if (this.positional != null && this.names.size() > 1) {
            throw new IllegalArgumentException("Cannot specify multiple names for positional parameter: " + element);
        }
        List<? extends VariableElement> methodparams = element.getParameters();
        Types types = processor.getTypes();
        if (methodparams.size() == 1) {
            this.parameterType = methodparams.get(0).asType();
        } else {
            if (methodparams.size() != 2) throw new IllegalArgumentException("Invalid parameter method, expected single or dual string parameters: " + element);
            if (!types.isAssignable(processor.getJavaLangString().asType(), methodparams.get(0).asType()) || !types.isAssignable(processor.getJavaLangString().asType(), methodparams.get(1).asType())) throw new IllegalArgumentException("Invalid parameter method, expected dual string assignable parameters: " + element);
            this.mapParameter = true;
            this.parameterType = null;
        }
        this.required = parameter.required();
        this.flag = element.getAnnotation(Flag.class);
        if (this.deprecated) {
            if (this.required) {
                throw new IllegalArgumentException("A required parameter cannot be deprecated: " + element);
            }
            if (this.positional != null) {
                throw new IllegalArgumentException("A positional parameter cannot be deprecated as there is no way to make it optional: " + element);
            }
        }
        if ((converterannot = element.getAnnotation(Converter.class)) != null) {
            TypeElement methoddeclaringtype = processor.getTypeElement(converterannot::converter);
            String methodname = converterannot.method();
            this.converter = new ModelConverter(methoddeclaringtype.equals(processor.getConverterAnnot()) ? (TypeElement)element.getEnclosingElement() : methoddeclaringtype, methodname);
        }
        if (this.flag != null) {
            if (this.parameterType.getKind() != TypeKind.BOOLEAN && !types.isSameType(this.parameterType, processor.getJavaLangBoolean().asType())) {
                throw new IllegalArgumentException(Flag.class.getSimpleName() + " annotation is only available for boolean types: " + element);
            }
            if (this.required) {
                throw new IllegalArgumentException("Flag annotated parameter cannot be required: " + element);
            }
        }
        if (!this.mapParameter || this.positional == null) return;
        throw new IllegalArgumentException("Map parameter cannot be positional: " + element);
    }

    public void resolve(CommandLineProcessor processor) {
        TypeMirror targettype = this.parameterType;
        if (this.converter == null) {
            TypeElement fieldte;
            ModelCommonConverter commonconverter;
            if (this.multiParameter != null) {
                targettype = this.multiParameter.getElementType();
            }
            if ((commonconverter = processor.getCommonConverterForType(this.parentCommand, targettype)) != null) {
                this.converter = new ModelConverter(commonconverter);
            } else if (targettype != null && targettype.getKind() == TypeKind.DECLARED && (fieldte = (TypeElement)((DeclaredType)targettype).asElement()) != null) {
                try {
                    Converter elemconverter = fieldte.getAnnotation(Converter.class);
                    if (elemconverter != null) {
                        TypeElement methoddeclaringtype = processor.getTypeElement(elemconverter::converter);
                        if (methoddeclaringtype.equals(processor.getConverterAnnot())) {
                            methoddeclaringtype = fieldte;
                        }
                        String methodname = elemconverter.method();
                        this.converter = new ModelConverter(methoddeclaringtype, methodname);
                    }
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
        }
        this.docCommentFormat = CommandLineProcessor.getDocCommentTag(this.docComment, DOC_TAG_PARAMETER_FORMAT);
        if (this.docCommentFormat != null) {
            this.docCommentFormat = this.docCommentFormat.trim();
            if (this.docCommentFormat.isEmpty()) {
                this.docCommentFormat = null;
            }
        } else {
            this.docCommentFormat = this.findDocCommentFormat(processor, targettype, this.parentCommand);
        }
        if (this.docCommentFormat != null) {
            if (!CommandLineProcessor.isSingleLine(this.docCommentFormat)) {
                throw new IllegalArgumentException("Parameter format doc comment must be single line: " + this.docCommentFormat + " on " + this.element);
            }
            if (this.mapParameter) {
                throw new IllegalArgumentException("Parameter doc comment format cannot be defined for map parameters: " + this.element);
            }
            this.docCommentFormat = CommandLineProcessor.unescapeDocComment(this.docCommentFormat);
        }
    }

    public String getDocCommentFormat() {
        return this.docCommentFormat;
    }

    public String getDocComment() {
        return this.docComment;
    }

    public Parameter getAnotation() {
        return this.anotation;
    }

    public Element getElement() {
        return this.element;
    }

    public ParameterLocation getLocation() {
        return this.location;
    }

    public boolean isMapParameter() {
        return this.mapParameter;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public Set<String> getNames() {
        return this.names;
    }

    public void setNames(Set<String> names) {
        this.names = names;
    }

    public TypeMirror getParameterType() {
        return this.parameterType;
    }

    public boolean isRequired() {
        return this.required;
    }

    public ModelConverter getConverter() {
        return this.converter;
    }

    public PositionalParameter getPositional() {
        return this.positional;
    }

    public Flag getFlag() {
        return this.flag;
    }

    public ModelMultiParameter getMultiParameter() {
        return this.multiParameter;
    }

    public boolean isMultiParameter() {
        return this.multiParameter != null || this.element.getKind() == ElementKind.METHOD;
    }

    public Set<String> getHelpMetaNames() {
        return this.helpMetaNames;
    }

    private static Set<String> getDocCommentHelpMetaNames(String doccomment) {
        if (doccomment == null) {
            return Collections.emptySet();
        }
        Iterator<String> it = CommandLineProcessor.getDocCommentTagIterator(doccomment, DOC_TAG_HELP_META);
        if (!it.hasNext()) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        do {
            String n;
            if ((n = it.next().trim()).isEmpty()) continue;
            result.add(n);
        } while (it.hasNext());
        return result;
    }

    private String findDocCommentFormat(CommandLineProcessor processor, TypeMirror targettype, ModelCommand parent) {
        List<ExecutableElement> methods;
        String found;
        if (this.converter != null && (found = ModelParameter.findDocCommentFormatInMethods(processor, methods = processor.getMethodsWithName(this.converter.getMethodDeclaringType(), this.converter.getMethodName()))) != null) {
            return found;
        }
        if (targettype == null) {
            return null;
        }
        switch (targettype.getKind()) {
            case BYTE: {
                return "<byte>";
            }
            case SHORT: {
                return "<short>";
            }
            case INT: {
                return "<int>";
            }
            case LONG: {
                return "<long>";
            }
            case CHAR: {
                return "<char>";
            }
            case BOOLEAN: {
                if (this.flag == null) {
                    return "<boolean>";
                }
                return null;
            }
            case FLOAT: {
                return "<float>";
            }
            case DOUBLE: {
                return "<double>";
            }
            case DECLARED: {
                DeclaredType dt = (DeclaredType)targettype;
                TypeElement elem = (TypeElement)dt.asElement();
                if (elem == null) break;
                if (processor.getJavaLangBoolean().equals(elem)) {
                    if (this.flag == null) {
                        return "<boolean>";
                    }
                    return null;
                }
                if (processor.getJavaLangByte().equals(elem)) {
                    return "<byte>";
                }
                if (processor.getJavaLangShort().equals(elem)) {
                    return "<short>";
                }
                if (processor.getJavaLangInteger().equals(elem)) {
                    return "<int>";
                }
                if (processor.getJavaLangLong().equals(elem)) {
                    return "<long>";
                }
                if (processor.getJavaLangFloat().equals(elem)) {
                    return "<float>";
                }
                if (processor.getJavaLangDouble().equals(elem)) {
                    return "<double>";
                }
                if (processor.getJavaLangCharacter().equals(elem)) {
                    return "<char>";
                }
                if (processor.getJavaLangString().equals(elem)) {
                    return "<string>";
                }
                if (elem.getKind() != ElementKind.ENUM) break;
                return "<enum>";
            }
        }
        return null;
    }

    private static String findDocCommentFormatInMethods(CommandLineProcessor processor, List<ExecutableElement> methods) {
        for (ExecutableElement ee : methods) {
            String methodformattag;
            List<? extends VariableElement> methodparams = ee.getParameters();
            if (methodparams.size() != 1 || !processor.getTypes().isAssignable(processor.getParsingIteratorType().asType(), methodparams.get(0).asType()) || (methodformattag = CommandLineProcessor.getDocCommentTag(processor.getElements().getDocComment(ee), DOC_TAG_PARAMETER_FORMAT)) == null) continue;
            return methodformattag.trim();
        }
        return null;
    }
}

