/*
 * Decompiled with CFR 0.152.
 */
package bence.sipka.cmd.model;

import bence.sipka.cmd.CommandLineProcessor;
import bence.sipka.cmd.api.Command;
import bence.sipka.cmd.model.AbstractModelCommand;
import bence.sipka.cmd.model.ModelCommand;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.element.TypeElement;

public class ModelBaseCommand
extends AbstractModelCommand {
    private Command annotation;
    private String genClassName;
    private String genPackage;
    private String genSimpleClassName;
    private Set<String> helpCommandName = new LinkedHashSet<String>();

    public ModelBaseCommand(CommandLineProcessor processor, Command annotation, TypeElement typeElem) {
        super(processor, typeElem);
        String[] hcname;
        this.annotation = annotation;
        this.genClassName = annotation.className();
        if (this.genClassName.isEmpty()) {
            this.genPackage = processor.getElements().getPackageOf(typeElem).getQualifiedName().toString();
            this.genSimpleClassName = typeElem.getSimpleName() + "ModelImpl";
            this.genClassName = this.genPackage + "." + this.genSimpleClassName;
        } else if (this.genClassName.startsWith(".")) {
            if (this.genClassName.length() == 1) {
                throw new IllegalArgumentException("Invalid class name: " + this.genClassName);
            }
            this.genPackage = processor.getElements().getPackageOf(typeElem).getQualifiedName().toString();
            this.genSimpleClassName = this.genClassName.substring(1);
            this.genClassName = this.genPackage + "." + this.genSimpleClassName;
        } else {
            this.genPackage = CommandLineProcessor.getPackageNameFromQualified(this.genClassName);
            this.genSimpleClassName = CommandLineProcessor.getSimpleClassNameFromQualified(this.genClassName);
        }
        for (String hcn : hcname = annotation.helpCommand()) {
            this.helpCommandName.add(hcn);
        }
    }

    public Set<String> getHelpCommandName() {
        return this.helpCommandName;
    }

    public Command getAnnotation() {
        return this.annotation;
    }

    public String getGeneratedClassQualifiedName() {
        return this.genClassName;
    }

    public boolean createMainMethod() {
        return this.annotation.main();
    }

    @Override
    public ModelCommand getParentCommand() {
        return null;
    }

    public String getGeneratedPackageName() {
        return this.genPackage;
    }

    public String getGeneratedSimpleClassName() {
        return this.genSimpleClassName;
    }

    @Override
    public String getCommandClassQualifiedName() {
        return this.genClassName;
    }
}

