/*
 * Decompiled with CFR 0.152.
 */
package bence.sipka.cmd.model;

import bence.sipka.cmd.CommandLineProcessor;
import bence.sipka.cmd.api.CommonConverter;
import bence.sipka.cmd.api.IncludeCommonConverters;
import bence.sipka.cmd.api.NameSubstitution;
import bence.sipka.cmd.api.Parameter;
import bence.sipka.cmd.api.ParameterContext;
import bence.sipka.cmd.api.PositionalParameter;
import bence.sipka.cmd.api.SubCommand;
import bence.sipka.cmd.model.ModelCommand;
import bence.sipka.cmd.model.ModelCommonConverter;
import bence.sipka.cmd.model.ModelNameSubstitution;
import bence.sipka.cmd.model.ModelParameter;
import bence.sipka.cmd.model.ModelSubCommand;
import bence.sipka.cmd.model.ParameterLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public abstract class AbstractModelCommand
implements ModelCommand {
    private TypeElement typeElem;
    private Collection<ModelSubCommand> subCommands = new ArrayList<ModelSubCommand>();
    private ModelSubCommand defaultSubCommand;
    private Collection<ModelCommonConverter> commonConverters;
    private List<ModelParameter> parameters;
    private String docComment;
    private boolean deprecated;
    private List<ModelParameter> positionalParameters = new ArrayList<ModelParameter>();
    private NavigableMap<String, ModelParameter> mapParameters = new TreeMap(Collections.reverseOrder());
    private List<ModelParameter> requiredParameters = new ArrayList<ModelParameter>();

    public AbstractModelCommand(CommandLineProcessor processor, TypeElement typeElem) {
        this.typeElem = typeElem;
        this.commonConverters = AbstractModelCommand.getCommonConverters(processor, typeElem);
        this.docComment = processor.getElements().getDocComment(typeElem);
        this.deprecated = processor.getElements().isDeprecated(typeElem);
        SubCommand[] subs = (SubCommand[])typeElem.getAnnotationsByType(SubCommand.class);
        TreeMap<String, ModelSubCommand> commandnames = new TreeMap<String, ModelSubCommand>();
        for (SubCommand s : subs) {
            ModelSubCommand subc = new ModelSubCommand(this, processor, s);
            if (subc.isDefaultCommand()) {
                if (this.defaultSubCommand != null) {
                    throw new IllegalArgumentException("Multiple default commands: " + this.defaultSubCommand.getTypeElement().getQualifiedName() + " and " + subc.getTypeElement().getQualifiedName());
                }
                this.defaultSubCommand = subc;
            }
            for (String n : subc.getNames()) {
                ModelSubCommand prev = commandnames.put(n, subc);
                if (prev == null) continue;
                throw new IllegalArgumentException("Command with name: " + n + " defined multiple times: " + subc.getAnnotation() + " and " + prev.getAnnotation());
            }
            this.subCommands.add(subc);
        }
        this.parameters = this.getParameters(processor, typeElem);
        for (ModelParameter param : this.parameters) {
            if (param.isMapParameter()) {
                for (String n : param.getNames()) {
                    ModelParameter prev = this.mapParameters.put(n, param);
                    if (prev == null) continue;
                    throw new IllegalArgumentException("Multiple Map parameters defined with same prefix: " + n + " - " + param.getElement() + " and " + prev.getElement());
                }
            } else {
                PositionalParameter positional = param.getPositional();
                if (positional != null) {
                    this.positionalParameters.add(param);
                }
                for (String n : param.getNames()) {
                    if (!commandnames.containsKey(n)) continue;
                    throw new IllegalArgumentException("Both parameter (" + param.getElement() + ") and command (" + ((ModelSubCommand)commandnames.get(n)).getAnnotation() + ") defined with name: " + n);
                }
            }
            if (!param.isRequired()) continue;
            this.requiredParameters.add(param);
        }
        this.positionalParameters.sort((l, r) -> {
            int rsig;
            int lval = l.getPositional().value();
            int rval = r.getPositional().value();
            int lsig = Integer.signum(lval);
            int sigcmp = Integer.compare(lsig, rsig = Integer.signum(rval));
            if (sigcmp != 0) {
                return -sigcmp;
            }
            if (lval < 0) {
                return -Integer.compare(lval, rval);
            }
            int valcmp = Integer.compare(lval, rval);
            if (valcmp != 0) {
                return valcmp;
            }
            return -Boolean.compare(l.isRequired(), r.isRequired());
        });
        if (this.positionalParameters.size() > 0 && this.positionalParameters.get(this.positionalParameters.size() - 1).getPositional().value() < 0 && this.defaultSubCommand != null) {
            throw new IllegalArgumentException("Cannot have default command and end positional parameters.");
        }
        if (!this.positionalParameters.isEmpty()) {
            Iterator<ModelParameter> it = this.positionalParameters.iterator();
            boolean prevreq = it.next().isRequired();
            while (it.hasNext()) {
                ModelParameter posparam = it.next();
                if (posparam.isRequired() == prevreq) continue;
                if (!prevreq) {
                    throw new IllegalArgumentException("Required positional parameters must occur before not required ones. Invalid order for: " + posparam.getElement());
                }
                prevreq = posparam.isRequired();
            }
        }
    }

    public void resolve(CommandLineProcessor processor) {
        for (ModelSubCommand sc : this.subCommands) {
            sc.resolve(processor);
        }
        for (ModelParameter p : this.parameters) {
            p.resolve(processor);
        }
    }

    @Override
    public List<ModelParameter> getPositionalParameters() {
        return this.positionalParameters;
    }

    @Override
    public NavigableMap<String, ModelParameter> getMapParameters() {
        return this.mapParameters;
    }

    @Override
    public List<ModelParameter> getRequiredParameters() {
        return this.requiredParameters;
    }

    @Override
    public String getDocComment() {
        return this.docComment;
    }

    @Override
    public boolean isDeprecated() {
        return this.deprecated;
    }

    @Override
    public List<ModelParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public Collection<ModelCommonConverter> getCommonConverters() {
        return this.commonConverters;
    }

    @Override
    public TypeElement getTypeElement() {
        return this.typeElem;
    }

    @Override
    public Collection<ModelSubCommand> getSubCommands() {
        return this.subCommands;
    }

    @Override
    public ModelSubCommand getDefaultSubCommand() {
        return this.defaultSubCommand;
    }

    public List<ModelParameter> getParameters(CommandLineProcessor processor, TypeElement type) {
        ArrayList<ModelParameter> result = new ArrayList<ModelParameter>();
        this.collectParameters(processor, type, new LinkedList<Element>(), result::add);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectParameters(CommandLineProcessor processor, TypeElement type, LinkedList<Element> locationstack, Consumer<ModelParameter> result) {
        block11: for (Element element : type.getEnclosedElements()) {
            ElementKind enclosedkind = element.getKind();
            switch (enclosedkind) {
                case FIELD: {
                    Parameter paramannot;
                    VariableElement field = (VariableElement)element;
                    locationstack.addLast(field);
                    try {
                        paramannot = element.getAnnotation(Parameter.class);
                        ParameterContext paramcontextannot = element.getAnnotation(ParameterContext.class);
                        if (paramannot != null) {
                            if (paramcontextannot != null) {
                                throw new IllegalArgumentException(Parameter.class.getSimpleName() + " and " + ParameterContext.class.getSimpleName() + " both present on field: " + element);
                            }
                            result.accept(new ModelParameter(processor, field, paramannot, new ParameterLocation(new ArrayList<Element>(locationstack)), (ModelCommand)this));
                            continue block11;
                        }
                        if (paramcontextannot == null) break;
                        TypeElement fieldtype = CommandLineProcessor.getTypeElementOf(field);
                        if (fieldtype == null) {
                            throw new IllegalArgumentException("Field cannot be a parameter context: " + field);
                        }
                        ArrayList<ModelNameSubstitution> substitutions = new ArrayList<ModelNameSubstitution>();
                        for (NameSubstitution subst : paramcontextannot.substitutions()) {
                            substitutions.add(new ModelNameSubstitution(subst));
                        }
                        this.collectParameters(processor, fieldtype, locationstack, pr -> {
                            pr.setNames(AbstractModelCommand.applySubstitutions(pr.getNames(), substitutions));
                            result.accept((ModelParameter)pr);
                        });
                        break;
                    }
                    finally {
                        locationstack.removeLast();
                        continue block11;
                    }
                }
                case METHOD: {
                    ExecutableElement method = (ExecutableElement)element;
                    Parameter paramannot = element.getAnnotation(Parameter.class);
                    if (paramannot == null) continue block11;
                    locationstack.addLast(element);
                    try {
                        ModelParameter modelparam = new ModelParameter(processor, method, paramannot, new ParameterLocation(new ArrayList<Element>(locationstack)), (ModelCommand)this);
                        result.accept(modelparam);
                        break;
                    }
                    finally {
                        locationstack.removeLast();
                    }
                }
                default: {
                    continue block11;
                }
            }
            if (enclosedkind == ElementKind.FIELD) continue;
        }
        TypeMirror sc = type.getSuperclass();
        if (sc.getKind() == TypeKind.DECLARED) {
            this.collectParameters(processor, (TypeElement)((DeclaredType)sc).asElement(), locationstack, result);
        }
    }

    private static Set<String> applySubstitutions(Set<String> names, List<ModelNameSubstitution> substitutions) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String n : names) {
            for (ModelNameSubstitution subst : substitutions) {
                n = subst.substitute(n);
            }
            result.add(n);
        }
        return result;
    }

    public static Collection<ModelCommonConverter> getCommonConverters(CommandLineProcessor processor, TypeElement annotatedelem) {
        ArrayList<ModelCommonConverter> commonConverters = new ArrayList<ModelCommonConverter>();
        AbstractModelCommand.collectCommonConverters(processor, annotatedelem, commonConverters);
        return commonConverters;
    }

    /*
     * WARNING - void declaration
     */
    private static void collectCommonConverters(CommandLineProcessor processor, TypeElement annotatedelem, Collection<ModelCommonConverter> result) {
        void var5_7;
        CommonConverter[] commonConverterArray = (CommonConverter[])annotatedelem.getAnnotationsByType(CommonConverter.class);
        int n = commonConverterArray.length;
        boolean bl = false;
        while (var5_7 < n) {
            CommonConverter cc = commonConverterArray[var5_7];
            TypeMirror targettype = processor.getTypeMirror(cc::type);
            TypeElement methoddeclaringtype = processor.getTypeElement(cc::converter);
            String methodname = cc.method();
            result.add(new ModelCommonConverter(targettype, methoddeclaringtype.equals(processor.getCommonConverterAnnot()) ? annotatedelem : methoddeclaringtype, methodname));
            ++var5_7;
        }
        IncludeCommonConverters includes = annotatedelem.getAnnotation(IncludeCommonConverters.class);
        if (includes != null) {
            for (TypeElement typeElement : processor.getTypeElements(includes::value)) {
                AbstractModelCommand.collectCommonConverters(processor, typeElement, result);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + (this.typeElem != null ? "typeElem=" + this.typeElem.getQualifiedName() : "") + "]";
    }
}

